/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.remote;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.api.SwAuthority;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwSchema;
import com.intellij.swagger.core.model.remote.RemoteSpecificationFile;
import com.intellij.swagger.core.model.remote.openapi.v3.Openapi3RemoteServer;
import com.intellij.swagger.core.model.remote.openapi.v3.Openapi3RemoteSpecificationFile;
import com.intellij.swagger.core.model.remote.swagger.v2.Swagger2RemoteSpecificationFile;
import com.intellij.util.Url;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\u0005*\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/swagger/core/remote/RemoteSpecificationEnricher;", "", "<init>", "()V", "withExternalUrl", "Lcom/intellij/swagger/core/model/remote/RemoteSpecificationFile;", "url", "Lcom/intellij/util/Url;", "withVirtualFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "reformatAndWriteToTheDisk", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "enrichServerObjects", "", "specification", "Lcom/intellij/swagger/core/model/remote/openapi/v3/Openapi3RemoteSpecificationFile;", "enrichSchemaAndHost", "Lcom/intellij/swagger/core/model/remote/swagger/v2/Swagger2RemoteSpecificationFile;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nRemoteSpecificationEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteSpecificationEnricher.kt\ncom/intellij/swagger/core/remote/RemoteSpecificationEnricher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,85:1\n13#2:86\n13#2:87\n1869#3,2:88\n1563#3:90\n1634#3,3:91\n37#4,2:94\n18#4:96\n*S KotlinDebug\n*F\n+ 1 RemoteSpecificationEnricher.kt\ncom/intellij/swagger/core/remote/RemoteSpecificationEnricher\n*L\n49#1:86\n53#1:87\n63#1:88,2\n80#1:90\n80#1:91,3\n82#1:94,2\n82#1:96\n*E\n"})
public final class RemoteSpecificationEnricher {
    @NotNull
    public static final RemoteSpecificationEnricher INSTANCE = new RemoteSpecificationEnricher();

    private RemoteSpecificationEnricher() {
    }

    @NotNull
    public final RemoteSpecificationFile withExternalUrl(@NotNull RemoteSpecificationFile $this$withExternalUrl, @NotNull Url url2) {
        RemoteSpecificationFile remoteSpecificationFile;
        Intrinsics.checkNotNullParameter((Object)$this$withExternalUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        RemoteSpecificationFile it = remoteSpecificationFile = $this$withExternalUrl;
        boolean bl = false;
        RemoteSpecificationFile remoteSpecificationFile2 = $this$withExternalUrl;
        if (remoteSpecificationFile2 instanceof Openapi3RemoteSpecificationFile) {
            INSTANCE.enrichServerObjects((Openapi3RemoteSpecificationFile)$this$withExternalUrl, url2);
        } else if (remoteSpecificationFile2 instanceof Swagger2RemoteSpecificationFile) {
            INSTANCE.enrichSchemaAndHost((Swagger2RemoteSpecificationFile)$this$withExternalUrl, url2);
        } else {
            Logger.getInstance(RemoteSpecificationEnricher.class).warn("Unknown specification type received, nothing to enrich: " + $this$withExternalUrl.getClass());
        }
        return remoteSpecificationFile;
    }

    @NotNull
    public final RemoteSpecificationFile withVirtualFile(@NotNull RemoteSpecificationFile $this$withVirtualFile, @NotNull VirtualFile virtualFile) {
        RemoteSpecificationFile remoteSpecificationFile;
        Intrinsics.checkNotNullParameter((Object)$this$withVirtualFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        RemoteSpecificationFile it = remoteSpecificationFile = $this$withVirtualFile;
        boolean bl = false;
        $this$withVirtualFile.setVirtualFile(virtualFile);
        return remoteSpecificationFile;
    }

    @NotNull
    public final RemoteSpecificationFile reformatAndWriteToTheDisk(@NotNull RemoteSpecificationFile $this$reformatAndWriteToTheDisk, @Nullable ObjectMapper objectMapper) {
        Object object;
        RemoteSpecificationFile remoteSpecificationFile;
        Intrinsics.checkNotNullParameter((Object)$this$reformatAndWriteToTheDisk, (String)"<this>");
        RemoteSpecificationFile it = remoteSpecificationFile = $this$reformatAndWriteToTheDisk;
        boolean bl = false;
        if (objectMapper != null && !ApplicationManager.getApplication().isUnitTestMode() && (object = it.getVirtualFile()) != null && (object = object.toNioPath()) != null && (object = object.toFile()) != null) {
            Object specificationFile = object;
            try {
                JsonNode rootSpecificationNode = objectMapper.readTree((File)specificationFile);
                String reformattedSpecification = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootSpecificationNode);
                FileUtil.writeToFile((File)specificationFile, (String)reformattedSpecification);
            }
            catch (JsonProcessingException ex) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(RemoteSpecificationEnricher.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unable to reformat downloaded specification. Raw specification text will be used", (Throwable)ex);
            }
            catch (IOException ex) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(RemoteSpecificationEnricher.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unable to write reformatted specification text to the disk. Raw specification text will be used", (Throwable)ex);
            }
        }
        return remoteSpecificationFile;
    }

    private final void enrichServerObjects(Openapi3RemoteSpecificationFile specification, Url url2) {
        List existingServers;
        String schemeAndAuthority = url2.getScheme() + "://" + url2.getAuthority() + "/";
        List list = specification.get_servers();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if (!((Collection)(existingServers = list)).isEmpty()) {
            Iterable $this$forEach$iv = existingServers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Openapi3RemoteServer it = (Openapi3RemoteServer)element$iv;
                boolean bl = false;
                if (it.getProtocolSchema() != null || it.getAuthority() != null) continue;
                String[] stringArray = new String[2];
                stringArray[0] = schemeAndAuthority;
                String string = it.get_url();
                if (string == null) {
                    string = "";
                }
                stringArray[1] = string;
                it.set_url(SwaggerUtilsKt.buildUrlFromSegments(stringArray));
            }
        } else {
            specification.set_servers(CollectionsKt.listOf((Object)new Openapi3RemoteServer(schemeAndAuthority)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void enrichSchemaAndHost(Swagger2RemoteSpecificationFile specification, Url url2) {
        boolean hasSchemaFromRemoteUrl;
        List<SwSchema> existingSchemes;
        SwModelElement swModelElement;
        CharSequence charSequence;
        if (specification.get_host() == null || (charSequence = (CharSequence)((swModelElement = specification.get_host()) != null && (swModelElement = ((SwAuthority)swModelElement).getAuthorityValue()) != null ? (String)swModelElement.getValue() : null)) == null || charSequence.length() == 0) {
            specification.set_host(new SwAuthority(url2.getAuthority()));
        }
        List<SwSchema> list = existingSchemes = specification.get_schemes();
        if (list != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SwSchema swSchema = (SwSchema)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSchemaValue().getValue());
            }
            v2 = CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)url2.getScheme());
        } else {
            v2 = hasSchemaFromRemoteUrl = false;
        }
        if (!hasSchemaFromRemoteUrl) {
            SwSchema[] swSchemaArray;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)new SwSchema(url2.getScheme()));
            List<SwSchema> list2 = existingSchemes;
            if (list2 != null) {
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                swSchemaArray = thisCollection$iv.toArray(new SwSchema[0]);
            } else {
                swSchemaArray = null;
            }
            SwSchema[] $this$orEmpty$iv = swSchemaArray;
            boolean $i$f$orEmpty = false;
            SwSchema[] swSchemaArray2 = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                swSchemaArray2 = new SwSchema[]{};
            }
            spreadBuilder.addSpread(swSchemaArray2);
            specification.set_schemes(CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new SwSchema[spreadBuilder.size()])));
        }
    }
}

