/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 24207840338463L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1404677190 - -17623, 1404677190 - (char)-23808, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1404677190 - -17622, 1404677190 - 31521, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 88131228336991L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.l();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1500620430 - (char)-21317, -1500620430 - -((char)-9905), (int)l2) + string + WindowsNamedPipeAgentIpc.b(1500620430 - (char)-21316, -1500489360 + -((char)-6701), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1500620430 - (char)-21319, 1500489360 + (char)-5184, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 102908846307315L;
                Object object = this.lock;
                int[] nArray = SshAgentIpcService.l();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1429842630 + -((char)-14398), -1429842630 + -27334, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1429842630 + -((char)-14401), -1429842630 + -26685, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1429842630 + -((char)-14400), -1429842630 + -22959, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1429842630 + -((char)-14395), -1429842630 + -((char)-13610), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1429842630 + -((char)-14394), 1429842630 + 32287, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1429842630 + -((char)-14397), 1429842630 + 28393, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1429842630 + -((char)-14395), -1429842630 + -((char)-13610), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1429842630 + -((char)-14396), -1429842630 + -((char)-21416), (int)l2));
            if (ActionTimestamp.c() == 0) {
                SshAgentIpcService.l(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 91608423635441L;
                    nArray = SshAgentIpcService.l();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 101661143706064L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                nArray = SshAgentIpcService.l();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray != null) break block23;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(732157020 + 32502, 732157020 + (char)-31471, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(732157020 + 32506, 732157020 + 32747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(732157020 + 32503, 732157020 + (char)-24798, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(732157020 + 32506, 732157020 + 32747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(732157020 + 32500, -732157020 + -29847, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(732157020 + 32502, 732157020 + (char)-31471, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(732157020 + 32506, 732157020 + 32747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(732157020 + 32501, 732157020 + 30308, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(732157020 + 32502, 732157020 + (char)-31471, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(732157020 + 32506, 732157020 + 32747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(732157020 + 32498, 732157020 + 31775, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(732157020 + 32506, 732157020 + 32747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(732157020 + 32499, -732157020 + -((char)-22370), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block27: {
                block28: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray != null) break block27;
                    try {
                        block29: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block28;
                            break block29;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(732157020 + 32506, 732157020 + 32747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(732157020 + 32500, -732157020 + -29847, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(732157020 + 32502, 732157020 + (char)-31471, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(732157020 + 32506, 732157020 + 32747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(732157020 + 32496, 732157020 + 18191, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        SshAgentIpc.Streams streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            private static final String[] a;
            private static final String[] b;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                long l2 = 15608656195990L;
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-745001880 + -23914, -745001880 + -((char)-32421), (int)l2));
                return inputStream;
            }

            public OutputStream getOutputStream() {
                long l2 = 14478218181921L;
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(116521230 + (char)-30406, -116521230 + -((char)-28437), (int)l2));
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[2];
                    var3_1 = 0;
                    var2_2 = "\u00b0\u00e6\u008aoD\u0018'?\u00a3!\fY9\u00f6t\u00ff\u00c5\t\u0098\u0014NzU\u00fa\u00a4hF\u00b4\rV\u001cc\u00f9H\u00ad\u00a3\u0013DE\u00af";
                    var4_3 = "\u00b0\u00e6\u008aoD\u0018'?\u00a3!\fY9\u00f6t\u00ff\u00c5\t\u0098\u0014NzU\u00fa\u00a4hF\u00b4\rV\u001cc\u00f9H\u00ad\u00a3\u0013DE\u00af".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 20;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 102;
                                    break;
                                }
                                case 1: {
                                    v11 = 124;
                                    break;
                                }
                                case 2: {
                                    v11 = 18;
                                    break;
                                }
                                case 3: {
                                    v11 = 42;
                                    break;
                                }
                                case 4: {
                                    v11 = 54;
                                    break;
                                }
                                case 5: {
                                    v11 = 54;
                                    break;
                                }
                                default: {
                                    v11 = 41;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                accept.3.a = var5;
                accept.3.b = new String[2];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0xFFFFBF68) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 152;
                        case 1 -> 173;
                        case 2 -> 237;
                        case 3 -> 146;
                        case 4 -> 67;
                        case 5 -> 134;
                        case 6 -> 106;
                        case 7 -> 236;
                        case 8 -> 233;
                        case 9 -> 81;
                        case 10 -> 157;
                        case 11 -> 99;
                        case 12 -> 252;
                        case 13 -> 62;
                        case 14 -> 108;
                        case 15 -> 147;
                        case 16 -> 155;
                        case 17 -> 79;
                        case 18 -> 16;
                        case 19 -> 178;
                        case 20 -> 63;
                        case 21 -> 181;
                        case 22 -> 116;
                        case 23 -> 141;
                        case 24 -> 159;
                        case 25 -> 148;
                        case 26 -> 86;
                        case 27 -> 40;
                        case 28 -> 49;
                        case 29 -> 18;
                        case 30 -> 95;
                        case 31 -> 192;
                        case 32 -> 39;
                        case 33 -> 44;
                        case 34 -> 3;
                        case 35 -> 131;
                        case 36 -> 243;
                        case 37 -> 120;
                        case 38 -> 52;
                        case 39 -> 23;
                        case 40 -> 96;
                        case 41 -> 74;
                        case 42 -> 125;
                        case 43 -> 183;
                        case 44 -> 156;
                        case 45 -> 13;
                        case 46 -> 136;
                        case 47 -> 102;
                        case 48 -> 59;
                        case 49 -> 30;
                        case 50 -> 158;
                        case 51 -> 28;
                        case 52 -> 203;
                        case 53 -> 153;
                        case 54 -> 83;
                        case 55 -> 142;
                        case 56 -> 170;
                        case 57 -> 254;
                        case 58 -> 78;
                        case 59 -> 41;
                        case 60 -> 212;
                        case 61 -> 51;
                        case 62 -> 60;
                        case 63 -> 46;
                        case 64 -> 58;
                        case 65 -> 111;
                        case 66 -> 92;
                        case 67 -> 130;
                        case 68 -> 149;
                        case 69 -> 91;
                        case 70 -> 180;
                        case 71 -> 234;
                        case 72 -> 33;
                        case 73 -> 121;
                        case 74 -> 169;
                        case 75 -> 174;
                        case 76 -> 19;
                        case 77 -> 232;
                        case 78 -> 196;
                        case 79 -> 47;
                        case 80 -> 15;
                        case 81 -> 247;
                        case 82 -> 221;
                        case 83 -> 224;
                        case 84 -> 32;
                        case 85 -> 115;
                        case 86 -> 197;
                        case 87 -> 215;
                        case 88 -> 104;
                        case 89 -> 228;
                        case 90 -> 45;
                        case 91 -> 87;
                        case 92 -> 186;
                        case 93 -> 103;
                        case 94 -> 73;
                        case 95 -> 117;
                        case 96 -> 204;
                        case 97 -> 88;
                        case 98 -> 70;
                        case 99 -> 48;
                        case 100 -> 37;
                        case 101 -> 200;
                        case 102 -> 195;
                        case 103 -> 132;
                        case 104 -> 217;
                        case 105 -> 128;
                        case 106 -> 165;
                        case 107 -> 72;
                        case 108 -> 205;
                        case 109 -> 214;
                        case 110 -> 53;
                        case 111 -> 161;
                        case 112 -> 206;
                        case 113 -> 229;
                        case 114 -> 4;
                        case 115 -> 25;
                        case 116 -> 137;
                        case 117 -> 139;
                        case 118 -> 182;
                        case 119 -> 162;
                        case 120 -> 231;
                        case 121 -> 26;
                        case 122 -> 123;
                        case 123 -> 177;
                        case 124 -> 69;
                        case 125 -> 213;
                        case 126 -> 56;
                        case 127 -> 42;
                        case 128 -> 24;
                        case 129 -> 167;
                        case 130 -> 43;
                        case 131 -> 175;
                        case 132 -> 21;
                        case 133 -> 50;
                        case 134 -> 245;
                        case 135 -> 89;
                        case 136 -> 201;
                        case 137 -> 101;
                        case 138 -> 198;
                        case 139 -> 190;
                        case 140 -> 220;
                        case 141 -> 65;
                        case 142 -> 114;
                        case 143 -> 6;
                        case 144 -> 127;
                        case 145 -> 38;
                        case 146 -> 129;
                        case 147 -> 126;
                        case 148 -> 211;
                        case 149 -> 210;
                        case 150 -> 209;
                        case 151 -> 154;
                        case 152 -> 135;
                        case 153 -> 31;
                        case 154 -> 75;
                        case 155 -> 66;
                        case 156 -> 208;
                        case 157 -> 160;
                        case 158 -> 218;
                        case 159 -> 29;
                        case 160 -> 93;
                        case 161 -> 82;
                        case 162 -> 55;
                        case 163 -> 1;
                        case 164 -> 61;
                        case 165 -> 57;
                        case 166 -> 80;
                        case 167 -> 11;
                        case 168 -> 84;
                        case 169 -> 124;
                        case 170 -> 109;
                        case 171 -> 94;
                        case 172 -> 194;
                        case 173 -> 246;
                        case 174 -> 226;
                        case 175 -> 202;
                        case 176 -> 133;
                        case 177 -> 71;
                        case 178 -> 164;
                        case 179 -> 168;
                        case 180 -> 171;
                        case 181 -> 20;
                        case 182 -> 35;
                        case 183 -> 122;
                        case 184 -> 188;
                        case 185 -> 113;
                        case 186 -> 2;
                        case 187 -> 77;
                        case 188 -> 172;
                        case 189 -> 248;
                        case 190 -> 54;
                        case 191 -> 98;
                        case 192 -> 249;
                        case 193 -> 36;
                        case 194 -> 239;
                        case 195 -> 17;
                        case 196 -> 90;
                        case 197 -> 7;
                        case 198 -> 150;
                        case 199 -> 191;
                        case 200 -> 187;
                        case 201 -> 223;
                        case 202 -> 119;
                        case 203 -> 242;
                        case 204 -> 100;
                        case 205 -> 10;
                        case 206 -> 251;
                        case 207 -> 255;
                        case 208 -> 22;
                        case 209 -> 219;
                        case 210 -> 9;
                        case 211 -> 97;
                        case 212 -> 85;
                        case 213 -> 216;
                        case 214 -> 244;
                        case 215 -> 193;
                        case 216 -> 14;
                        case 217 -> 105;
                        case 218 -> 5;
                        case 219 -> 238;
                        case 220 -> 176;
                        case 221 -> 230;
                        case 222 -> 138;
                        case 223 -> 143;
                        case 224 -> 166;
                        case 225 -> 118;
                        case 226 -> 112;
                        case 227 -> 241;
                        case 228 -> 184;
                        case 229 -> 235;
                        case 230 -> 189;
                        case 231 -> 0;
                        case 232 -> 8;
                        case 233 -> 207;
                        case 234 -> 27;
                        case 235 -> 34;
                        case 236 -> 227;
                        case 237 -> 107;
                        case 238 -> 68;
                        case 239 -> 222;
                        case 240 -> 179;
                        case 241 -> 64;
                        case 242 -> 250;
                        case 243 -> 151;
                        case 244 -> 185;
                        case 245 -> 76;
                        case 246 -> 199;
                        case 247 -> 140;
                        case 248 -> 12;
                        case 249 -> 145;
                        case 250 -> 253;
                        case 251 -> 225;
                        case 252 -> 163;
                        case 253 -> 240;
                        case 254 -> 110;
                        default -> 144;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    accept.3.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        };
        if (nArray != null) {
            int n3 = ActionTimestamp.c();
            ActionTimestamp.l(++n3);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 39964680726747L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.l();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-10092390 - -((char)-11841), -10092390 - -((char)-10292), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-10092390 - -((char)-11837), -10092390 - -((char)-11086), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-10092390 - -((char)-11860), 0x99FF66 - (char)-23198, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-10092390 - -((char)-11841), -10092390 - -((char)-10292), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-10092390 - -((char)-11837), -10092390 - -((char)-11086), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-10092390 - -((char)-11865), -10092390 - -((char)-19486), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 98228984188324L;
                        int[] nArray2 = SshAgentIpcService.l();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1212790710 + (char)-16503, 1212790710 + 29109, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1212790710 + (char)-16506, -1212790710 + -30883, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 20895131294238L;
                int[] nArray2 = SshAgentIpcService.l();
                this.assertConnectionThread();
                Object object2 = this.lock;
                nArray = nArray2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6588), -115341600 + -((char)-9155), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6584), -115341600 + -((char)-8361), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6567), 115341600 + (char)-7484, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6584), -115341600 + -((char)-8361), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6590), 115341600 + (char)-13405, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6588), -115341600 + -((char)-9155), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6584), -115341600 + -((char)-8361), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6568), -115341600 + -((char)-826), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6588), -115341600 + -((char)-9155), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6584), -115341600 + -((char)-8361), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6569), -115341600 + -((char)-24366), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6588), -115341600 + -((char)-9155), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6584), -115341600 + -((char)-8361), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-115341600 + -((char)-6570), -115341600 + -((char)-14914), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 16193607610173L;
                    Object object = this.lock;
                    nArray = SshAgentIpcService.l();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2173), -1580835270 + -((char)-326), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2177), -1580966340 - -((char)-2962), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2196), 1580835270 + (char)-171, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2189), 1580966340 - (char)-5591, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2173), -1580835270 + -((char)-326), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2177), -1580966340 - -((char)-2962), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2190), -1580966340 - -((char)-6555), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2173), -1580835270 + -((char)-326), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2177), -1580966340 - -((char)-2962), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2191), 1580835270 + (char)-5800, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2173), -1580835270 + -((char)-326), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2177), -1580966340 - -((char)-2962), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2192), -1580966340 - -((char)-12233), (int)l2));
                    if (nArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2173), -1580835270 + -((char)-326), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2177), -1580966340 - -((char)-2962), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2217), 1580835270 + (char)-728, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1580966340 - -((char)-2218), -1580966340 - -((char)-11582), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "[\u0099\u0007\u00ff\u008c0\u00ac\u0017\u0014\u00ca\u00d9\r\u00103E\u00f4\u00a3)\u00e3\u00c7\u0013T\u00f8$\u0097\u0013\u00cf\u001c\u001e\u0006\u00c9nU\u0001\u00ac\u00ae\u0018f\u00ce\u00f8\u00c2\u000f\u00daq\u0090Q\u00f8\u00c7\u00002e\u00ba\u00a6i\u0080}j\u0001\u0013\u008d\u00f4\t\u0013\u00ac\u00c8?b\u00fa\u00c4\u00dc\u00db\u0005\u0091\u00d3^\u00b6\u00d7\b+\u0091\t\u008f\u001f\u0018\u00d8\u00f0\u0014\u00dc\u00ec\u00b7-\t\u00ea\u0086\u00c1\trh\u0095\u00eb\u008bh\u0014\u0088l\u0096(\u0005\"|(C\u0019\u001e\u0081oIE\u00a8\u00ee'l>sa\u00f6\u00aa\u009b\u000b\u001d\u00befUB\u00a89\u00b4|#E\u009c\u00e8\u00e9\u0091\u0010\u0001P\u00bdga\u0098\u00e8[\u00ba'|\u0081\u000f \u0010\u00f5\tJ\u00b35\u00cd\u008e\u0083\u007flB\u0010\u0007}}\u00c2y,\u00eb\u00cd\u00da\u00f5p\u00db\u008ek \u009c?\u00b1ZG\u00e3d3;\u00bb\u00ccXzhv\u00be\u00ad\u0080\u00af\u00b0\n]\u00cd\u0088c,\u00c9\u00a7\u00cc\u0000\u00d4\u00da\u007f\u00e0\u000f$\u00ba\u00d0\u00f6\u0093@\u0013\u00e0\u00da\u00e2-_ke\u00dd\u001d\u0014\u00d7\u00ce}\u00e4u\u00df@P:\u009b\u008b<\u00a5\b\u00ee\u009a\u00b1\u00ee\b4:u\f\u008d\u00e5\u00cd\u001a\u009a\u00c8\u0086\u00ed^\u00b9\u00b2VF@%t\u0002\u00ad\u00cb`\u008d\u0082\u00b9#\u0092\u00cb\u00e9\u0005LFN7-x\u00d4\u00d6\u0095I\u00bb/\u0088\u0017\u00e2=\u00db{\u00f5\u00f6\u00cb\u00a5\u00bd\u0081\u0012K\u00ef\u001cp^E\u0011et\u00fb\u009c\u0099\u00fb\u0098\u00b3K\u0007\u00b6D\u00fbwYf\u00f5\u00d7x\u008e\u00cc\u009c\u00ab\u001f\u00a9JL\u00e1\bz3\u00fe\u00bc!1\u00bc\u00a0\u00cfA&\u008c\u00e9ny\u0004\u00de\u00f6+\n\u007f\u00aec\u00b2\u0011\u008b\u000b\u0004:\u00fc\u00e1\u00bc\u00b7B\u0002\u00c6H\u00ab\u0015(\u008ay\u00f4\u000b}X&\u00bb,\u00cc\u00d6\u00a1.|L\u00d008;\u00f8)\u00c1\u00c3A\u00d0\u00a9\\\u0007::\u00b9\u00e1\u00af\u00be\u00a7\u001c.x`+\u00ef\\t;f\u00dc\u009f\u00a3\u0007<i\u00d8\u00949\u00b9\u00d8\u00cf~ q\b\u00f6\u0007\u00b9cD\u00de-\u00c0\f\u0007<R\u0090\u0094Pf\u00b5(\u00b8\u00c5\"1u\nj\u00d7\u00e7\u00d3p\u00d4\u00afI|ps\u0006\u00e4`\u00c4\u00bbGT\u00c3e\u00f6#\u00a1\u008d\u00b0\u0011\u00cfb\u0098\u0019\u00cc\u0087\u00b4\u000f\u000f\u00b8\u00c3l\u00d8T[\u00eb>\u00a2cy\u0093.\u00f5\u00d2\"Y\u0082R\u00f8\u00cbYK\u009a\u00b3\u00ad\u00d0-\u009b\u00fb\u00dck\u008b\u00e1\u00df\u009d(:\u0015\u00ff\u008a\u00f8\u00a45\u00f8\u001d\u00e2\u001dP{\u000e<\u00ea\u00fc\u00fdF\u00ff\u00a9\u00aa\u00ea\u00f1p\u00c1\u0003\u00b5\u001bDK\u00f4\u00cc\u00bclc\u0084\u00e4\u00b3<\u0088\u00da\u00aa\u00d2W\u00e2\u00ccO\u00a4\u0001)C;\u000b\r\u00c1\n&\u0091|\u0090\u00b9\u0003\u0010C!)\u0018\u00e4\u0082\u00e0\u00f8?V2\u009d\u00d0YxJ\u00eb\u00a1\b\u0017\u00ce\u00c5\u001d\u00fc3i^`)\u0010 {\u00ac\u00ee\u00d3\u00ef\u00cb'\u0087Bh\u00ceV\u008dk4\u00bd}\u0091\u00ac\u00abl\u0091C\u00f3\u00cdf\u00a2\u0019\u00b0\u000b\u0011\u0094\b\u00fe\u00ba\"\u00e9H\u00e5\t\u009cv\u00efk\u00df\u0098\u0003Tp";
                var4_3 = "[\u0099\u0007\u00ff\u008c0\u00ac\u0017\u0014\u00ca\u00d9\r\u00103E\u00f4\u00a3)\u00e3\u00c7\u0013T\u00f8$\u0097\u0013\u00cf\u001c\u001e\u0006\u00c9nU\u0001\u00ac\u00ae\u0018f\u00ce\u00f8\u00c2\u000f\u00daq\u0090Q\u00f8\u00c7\u00002e\u00ba\u00a6i\u0080}j\u0001\u0013\u008d\u00f4\t\u0013\u00ac\u00c8?b\u00fa\u00c4\u00dc\u00db\u0005\u0091\u00d3^\u00b6\u00d7\b+\u0091\t\u008f\u001f\u0018\u00d8\u00f0\u0014\u00dc\u00ec\u00b7-\t\u00ea\u0086\u00c1\trh\u0095\u00eb\u008bh\u0014\u0088l\u0096(\u0005\"|(C\u0019\u001e\u0081oIE\u00a8\u00ee'l>sa\u00f6\u00aa\u009b\u000b\u001d\u00befUB\u00a89\u00b4|#E\u009c\u00e8\u00e9\u0091\u0010\u0001P\u00bdga\u0098\u00e8[\u00ba'|\u0081\u000f \u0010\u00f5\tJ\u00b35\u00cd\u008e\u0083\u007flB\u0010\u0007}}\u00c2y,\u00eb\u00cd\u00da\u00f5p\u00db\u008ek \u009c?\u00b1ZG\u00e3d3;\u00bb\u00ccXzhv\u00be\u00ad\u0080\u00af\u00b0\n]\u00cd\u0088c,\u00c9\u00a7\u00cc\u0000\u00d4\u00da\u007f\u00e0\u000f$\u00ba\u00d0\u00f6\u0093@\u0013\u00e0\u00da\u00e2-_ke\u00dd\u001d\u0014\u00d7\u00ce}\u00e4u\u00df@P:\u009b\u008b<\u00a5\b\u00ee\u009a\u00b1\u00ee\b4:u\f\u008d\u00e5\u00cd\u001a\u009a\u00c8\u0086\u00ed^\u00b9\u00b2VF@%t\u0002\u00ad\u00cb`\u008d\u0082\u00b9#\u0092\u00cb\u00e9\u0005LFN7-x\u00d4\u00d6\u0095I\u00bb/\u0088\u0017\u00e2=\u00db{\u00f5\u00f6\u00cb\u00a5\u00bd\u0081\u0012K\u00ef\u001cp^E\u0011et\u00fb\u009c\u0099\u00fb\u0098\u00b3K\u0007\u00b6D\u00fbwYf\u00f5\u00d7x\u008e\u00cc\u009c\u00ab\u001f\u00a9JL\u00e1\bz3\u00fe\u00bc!1\u00bc\u00a0\u00cfA&\u008c\u00e9ny\u0004\u00de\u00f6+\n\u007f\u00aec\u00b2\u0011\u008b\u000b\u0004:\u00fc\u00e1\u00bc\u00b7B\u0002\u00c6H\u00ab\u0015(\u008ay\u00f4\u000b}X&\u00bb,\u00cc\u00d6\u00a1.|L\u00d008;\u00f8)\u00c1\u00c3A\u00d0\u00a9\\\u0007::\u00b9\u00e1\u00af\u00be\u00a7\u001c.x`+\u00ef\\t;f\u00dc\u009f\u00a3\u0007<i\u00d8\u00949\u00b9\u00d8\u00cf~ q\b\u00f6\u0007\u00b9cD\u00de-\u00c0\f\u0007<R\u0090\u0094Pf\u00b5(\u00b8\u00c5\"1u\nj\u00d7\u00e7\u00d3p\u00d4\u00afI|ps\u0006\u00e4`\u00c4\u00bbGT\u00c3e\u00f6#\u00a1\u008d\u00b0\u0011\u00cfb\u0098\u0019\u00cc\u0087\u00b4\u000f\u000f\u00b8\u00c3l\u00d8T[\u00eb>\u00a2cy\u0093.\u00f5\u00d2\"Y\u0082R\u00f8\u00cbYK\u009a\u00b3\u00ad\u00d0-\u009b\u00fb\u00dck\u008b\u00e1\u00df\u009d(:\u0015\u00ff\u008a\u00f8\u00a45\u00f8\u001d\u00e2\u001dP{\u000e<\u00ea\u00fc\u00fdF\u00ff\u00a9\u00aa\u00ea\u00f1p\u00c1\u0003\u00b5\u001bDK\u00f4\u00cc\u00bclc\u0084\u00e4\u00b3<\u0088\u00da\u00aa\u00d2W\u00e2\u00ccO\u00a4\u0001)C;\u000b\r\u00c1\n&\u0091|\u0090\u00b9\u0003\u0010C!)\u0018\u00e4\u0082\u00e0\u00f8?V2\u009d\u00d0YxJ\u00eb\u00a1\b\u0017\u00ce\u00c5\u001d\u00fc3i^`)\u0010 {\u00ac\u00ee\u00d3\u00ef\u00cb'\u0087Bh\u00ceV\u008dk4\u00bd}\u0091\u00ac\u00abl\u0091C\u00f3\u00cdf\u00a2\u0019\u00b0\u000b\u0011\u0094\b\u00fe\u00ba\"\u00e9H\u00e5\t\u009cv\u00efk\u00df\u0098\u0003Tp".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 60;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "^\u008b+@}\u00d7\u0004\u00d2\u00c3=G\u00a6\u00f7\u00163\u00faz\u001a}x`0\u009f\u00a5\u000f\u00f0L\u00da\u009b\u0014`\u00ae\u00c1g32m\u00d4\u0083\u0094\u000bdT\u008f\u00bd\u00e0\u00b9\u00b8\u00d0i";
                    var4_3 = "^\u008b+@}\u00d7\u0004\u00d2\u00c3=G\u00a6\u00f7\u00163\u00faz\u001a}x`0\u009f\u00a5\u000f\u00f0L\u00da\u009b\u0014`\u00ae\u00c1g32m\u00d4\u0083\u0094\u000bdT\u008f\u00bd\u00e0\u00b9\u00b8\u00d0i".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 75;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 109;
                            break;
                        }
                        case 1: {
                            v15 = 64;
                            break;
                        }
                        case 2: {
                            v15 = 116;
                            break;
                        }
                        case 3: {
                            v15 = 94;
                            break;
                        }
                        case 4: {
                            v15 = 119;
                            break;
                        }
                        case 5: {
                            v15 = 23;
                            break;
                        }
                        default: {
                            v15 = 70;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFFA8E) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 65;
                case 1 -> 32;
                case 2 -> 119;
                case 3 -> 158;
                case 4 -> 12;
                case 5 -> 226;
                case 6 -> 0;
                case 7 -> 40;
                case 8 -> 222;
                case 9 -> 178;
                case 10 -> 223;
                case 11 -> 208;
                case 12 -> 64;
                case 13 -> 169;
                case 14 -> 36;
                case 15 -> 205;
                case 16 -> 47;
                case 17 -> 128;
                case 18 -> 210;
                case 19 -> 241;
                case 20 -> 167;
                case 21 -> 247;
                case 22 -> 5;
                case 23 -> 164;
                case 24 -> 138;
                case 25 -> 239;
                case 26 -> 56;
                case 27 -> 240;
                case 28 -> 25;
                case 29 -> 61;
                case 30 -> 41;
                case 31 -> 57;
                case 32 -> 103;
                case 33 -> 141;
                case 34 -> 48;
                case 35 -> 109;
                case 36 -> 102;
                case 37 -> 63;
                case 38 -> 242;
                case 39 -> 157;
                case 40 -> 188;
                case 41 -> 227;
                case 42 -> 83;
                case 43 -> 1;
                case 44 -> 166;
                case 45 -> 147;
                case 46 -> 132;
                case 47 -> 203;
                case 48 -> 202;
                case 49 -> 35;
                case 50 -> 146;
                case 51 -> 125;
                case 52 -> 198;
                case 53 -> 6;
                case 54 -> 45;
                case 55 -> 171;
                case 56 -> 183;
                case 57 -> 248;
                case 58 -> 217;
                case 59 -> 95;
                case 60 -> 93;
                case 61 -> 28;
                case 62 -> 80;
                case 63 -> 155;
                case 64 -> 122;
                case 65 -> 168;
                case 66 -> 161;
                case 67 -> 39;
                case 68 -> 184;
                case 69 -> 96;
                case 70 -> 180;
                case 71 -> 209;
                case 72 -> 136;
                case 73 -> 21;
                case 74 -> 24;
                case 75 -> 53;
                case 76 -> 99;
                case 77 -> 235;
                case 78 -> 16;
                case 79 -> 154;
                case 80 -> 37;
                case 81 -> 221;
                case 82 -> 127;
                case 83 -> 112;
                case 84 -> 199;
                case 85 -> 76;
                case 86 -> 140;
                case 87 -> 233;
                case 88 -> 111;
                case 89 -> 72;
                case 90 -> 29;
                case 91 -> 196;
                case 92 -> 58;
                case 93 -> 185;
                case 94 -> 228;
                case 95 -> 204;
                case 96 -> 237;
                case 97 -> 163;
                case 98 -> 70;
                case 99 -> 31;
                case 100 -> 194;
                case 101 -> 249;
                case 102 -> 114;
                case 103 -> 105;
                case 104 -> 52;
                case 105 -> 186;
                case 106 -> 174;
                case 107 -> 234;
                case 108 -> 244;
                case 109 -> 229;
                case 110 -> 179;
                case 111 -> 225;
                case 112 -> 254;
                case 113 -> 38;
                case 114 -> 149;
                case 115 -> 148;
                case 116 -> 195;
                case 117 -> 176;
                case 118 -> 238;
                case 119 -> 75;
                case 120 -> 145;
                case 121 -> 156;
                case 122 -> 206;
                case 123 -> 100;
                case 124 -> 144;
                case 125 -> 107;
                case 126 -> 113;
                case 127 -> 165;
                case 128 -> 68;
                case 129 -> 77;
                case 130 -> 50;
                case 131 -> 175;
                case 132 -> 89;
                case 133 -> 51;
                case 134 -> 78;
                case 135 -> 255;
                case 136 -> 152;
                case 137 -> 250;
                case 138 -> 92;
                case 139 -> 133;
                case 140 -> 85;
                case 141 -> 170;
                case 142 -> 213;
                case 143 -> 230;
                case 144 -> 253;
                case 145 -> 153;
                case 146 -> 17;
                case 147 -> 10;
                case 148 -> 214;
                case 149 -> 23;
                case 150 -> 151;
                case 151 -> 115;
                case 152 -> 182;
                case 153 -> 71;
                case 154 -> 9;
                case 155 -> 104;
                case 156 -> 30;
                case 157 -> 177;
                case 158 -> 232;
                case 159 -> 142;
                case 160 -> 126;
                case 161 -> 135;
                case 162 -> 197;
                case 163 -> 79;
                case 164 -> 66;
                case 165 -> 134;
                case 166 -> 8;
                case 167 -> 201;
                case 168 -> 94;
                case 169 -> 34;
                case 170 -> 60;
                case 171 -> 2;
                case 172 -> 22;
                case 173 -> 192;
                case 174 -> 245;
                case 175 -> 187;
                case 176 -> 121;
                case 177 -> 218;
                case 178 -> 101;
                case 179 -> 129;
                case 180 -> 120;
                case 181 -> 13;
                case 182 -> 143;
                case 183 -> 54;
                case 184 -> 162;
                case 185 -> 19;
                case 186 -> 26;
                case 187 -> 81;
                case 188 -> 33;
                case 189 -> 67;
                case 190 -> 84;
                case 191 -> 88;
                case 192 -> 215;
                case 193 -> 150;
                case 194 -> 131;
                case 195 -> 159;
                case 196 -> 11;
                case 197 -> 181;
                case 198 -> 62;
                case 199 -> 207;
                case 200 -> 224;
                case 201 -> 246;
                case 202 -> 110;
                case 203 -> 73;
                case 204 -> 160;
                case 205 -> 87;
                case 206 -> 124;
                case 207 -> 106;
                case 208 -> 44;
                case 209 -> 116;
                case 210 -> 7;
                case 211 -> 18;
                case 212 -> 108;
                case 213 -> 43;
                case 214 -> 59;
                case 215 -> 243;
                case 216 -> 137;
                case 217 -> 216;
                case 218 -> 236;
                case 219 -> 117;
                case 220 -> 42;
                case 221 -> 97;
                case 222 -> 69;
                case 223 -> 172;
                case 224 -> 212;
                case 225 -> 200;
                case 226 -> 4;
                case 227 -> 15;
                case 228 -> 86;
                case 229 -> 14;
                case 230 -> 139;
                case 231 -> 123;
                case 232 -> 55;
                case 233 -> 49;
                case 234 -> 251;
                case 235 -> 98;
                case 236 -> 82;
                case 237 -> 193;
                case 238 -> 3;
                case 239 -> 211;
                case 240 -> 231;
                case 241 -> 27;
                case 242 -> 189;
                case 243 -> 191;
                case 244 -> 190;
                case 245 -> 118;
                case 246 -> 46;
                case 247 -> 219;
                case 248 -> 20;
                case 249 -> 91;
                case 250 -> 74;
                case 251 -> 252;
                case 252 -> 90;
                case 253 -> 173;
                case 254 -> 130;
                default -> 220;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 138628182171580L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(477225870 + 8793, 477225870 + 25967, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 114669239240656L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.l();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2092532550 + (char)-9660, 2092532550 + (char)-22903, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2092532550 + (char)-9661, 2092532550 + (char)-12069, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2092532550 + (char)-9662, -2092532550 + -((char)-1942), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00e3\u00e7X\u00d5%\u00d1\u00dep\u0010\u00ef\u0017(j\u0091\u009d\u00b1\u00a0e\u0010b%h\u00f3\u00a7{";
                    var4_3 = "\u00e3\u00e7X\u00d5%\u00d1\u00dep\u0010\u00ef\u0017(j\u0091\u009d\u00b1\u00a0e\u0010b%h\u00f3\u00a7{".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 105;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "&r#\u00a4\u00f95f\u0094<\u0014\u00c8\u00a8An\u00cf\u00b1f\u0012\u00dc<\u00f7\u00cbq6\u00c7{\u00ecQ\u00dc\u00c8y\u0015\u00a2\u00f8\u0011\u00c2\u009d\u0082.\u00b3\u001e\u00fb\u0090W\u00eea\u00e2?\u00adNh\u00ca\u00f0\u001c\u009fB\u00a3\u00aa\u0090";
                        var4_3 = "&r#\u00a4\u00f95f\u0094<\u0014\u00c8\u00a8An\u00cf\u00b1f\u0012\u00dc<\u00f7\u00cbq6\u00c7{\u00ecQ\u00dc\u00c8y\u0015\u00a2\u00f8\u0011\u00c2\u009d\u0082.\u00b3\u001e\u00fb\u0090W\u00eea\u00e2?\u00adNh\u00ca\u00f0\u001c\u009fB\u00a3\u00aa\u0090".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 78;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 106;
                                break;
                            }
                            case 1: {
                                v15 = 1;
                                break;
                            }
                            case 2: {
                                v15 = 35;
                                break;
                            }
                            case 3: {
                                v15 = 108;
                                break;
                            }
                            case 4: {
                                v15 = 32;
                                break;
                            }
                            case 5: {
                                v15 = 10;
                                break;
                            }
                            default: {
                                v15 = 20;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFDA5B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 203;
                    case 1 -> 20;
                    case 2 -> 127;
                    case 3 -> 42;
                    case 4 -> 255;
                    case 5 -> 154;
                    case 6 -> 246;
                    case 7 -> 222;
                    case 8 -> 138;
                    case 9 -> 135;
                    case 10 -> 202;
                    case 11 -> 237;
                    case 12 -> 89;
                    case 13 -> 96;
                    case 14 -> 160;
                    case 15 -> 11;
                    case 16 -> 142;
                    case 17 -> 68;
                    case 18 -> 150;
                    case 19 -> 74;
                    case 20 -> 103;
                    case 21 -> 209;
                    case 22 -> 37;
                    case 23 -> 4;
                    case 24 -> 205;
                    case 25 -> 186;
                    case 26 -> 199;
                    case 27 -> 25;
                    case 28 -> 252;
                    case 29 -> 7;
                    case 30 -> 248;
                    case 31 -> 191;
                    case 32 -> 81;
                    case 33 -> 170;
                    case 34 -> 221;
                    case 35 -> 45;
                    case 36 -> 155;
                    case 37 -> 208;
                    case 38 -> 39;
                    case 39 -> 229;
                    case 40 -> 210;
                    case 41 -> 0;
                    case 42 -> 134;
                    case 43 -> 251;
                    case 44 -> 183;
                    case 45 -> 18;
                    case 46 -> 227;
                    case 47 -> 147;
                    case 48 -> 51;
                    case 49 -> 187;
                    case 50 -> 117;
                    case 51 -> 63;
                    case 52 -> 236;
                    case 53 -> 211;
                    case 54 -> 230;
                    case 55 -> 185;
                    case 56 -> 73;
                    case 57 -> 201;
                    case 58 -> 190;
                    case 59 -> 139;
                    case 60 -> 61;
                    case 61 -> 162;
                    case 62 -> 113;
                    case 63 -> 112;
                    case 64 -> 83;
                    case 65 -> 243;
                    case 66 -> 8;
                    case 67 -> 225;
                    case 68 -> 111;
                    case 69 -> 167;
                    case 70 -> 13;
                    case 71 -> 178;
                    case 72 -> 197;
                    case 73 -> 56;
                    case 74 -> 182;
                    case 75 -> 140;
                    case 76 -> 207;
                    case 77 -> 28;
                    case 78 -> 131;
                    case 79 -> 65;
                    case 80 -> 59;
                    case 81 -> 250;
                    case 82 -> 188;
                    case 83 -> 118;
                    case 84 -> 149;
                    case 85 -> 245;
                    case 86 -> 19;
                    case 87 -> 115;
                    case 88 -> 189;
                    case 89 -> 99;
                    case 90 -> 9;
                    case 91 -> 49;
                    case 92 -> 180;
                    case 93 -> 3;
                    case 94 -> 35;
                    case 95 -> 107;
                    case 96 -> 216;
                    case 97 -> 193;
                    case 98 -> 108;
                    case 99 -> 254;
                    case 100 -> 57;
                    case 101 -> 82;
                    case 102 -> 119;
                    case 103 -> 75;
                    case 104 -> 214;
                    case 105 -> 218;
                    case 106 -> 2;
                    case 107 -> 70;
                    case 108 -> 95;
                    case 109 -> 53;
                    case 110 -> 76;
                    case 111 -> 168;
                    case 112 -> 239;
                    case 113 -> 206;
                    case 114 -> 125;
                    case 115 -> 114;
                    case 116 -> 192;
                    case 117 -> 129;
                    case 118 -> 137;
                    case 119 -> 163;
                    case 120 -> 41;
                    case 121 -> 233;
                    case 122 -> 62;
                    case 123 -> 232;
                    case 124 -> 249;
                    case 125 -> 60;
                    case 126 -> 133;
                    case 127 -> 98;
                    case 128 -> 97;
                    case 129 -> 69;
                    case 130 -> 172;
                    case 131 -> 217;
                    case 132 -> 235;
                    case 133 -> 181;
                    case 134 -> 12;
                    case 135 -> 93;
                    case 136 -> 195;
                    case 137 -> 128;
                    case 138 -> 238;
                    case 139 -> 141;
                    case 140 -> 38;
                    case 141 -> 179;
                    case 142 -> 94;
                    case 143 -> 50;
                    case 144 -> 145;
                    case 145 -> 159;
                    case 146 -> 231;
                    case 147 -> 200;
                    case 148 -> 158;
                    case 149 -> 244;
                    case 150 -> 153;
                    case 151 -> 166;
                    case 152 -> 176;
                    case 153 -> 46;
                    case 154 -> 15;
                    case 155 -> 196;
                    case 156 -> 17;
                    case 157 -> 223;
                    case 158 -> 40;
                    case 159 -> 84;
                    case 160 -> 72;
                    case 161 -> 106;
                    case 162 -> 6;
                    case 163 -> 219;
                    case 164 -> 171;
                    case 165 -> 169;
                    case 166 -> 122;
                    case 167 -> 26;
                    case 168 -> 234;
                    case 169 -> 16;
                    case 170 -> 91;
                    case 171 -> 241;
                    case 172 -> 220;
                    case 173 -> 132;
                    case 174 -> 116;
                    case 175 -> 174;
                    case 176 -> 224;
                    case 177 -> 204;
                    case 178 -> 33;
                    case 179 -> 55;
                    case 180 -> 22;
                    case 181 -> 90;
                    case 182 -> 100;
                    case 183 -> 126;
                    case 184 -> 110;
                    case 185 -> 1;
                    case 186 -> 31;
                    case 187 -> 130;
                    case 188 -> 36;
                    case 189 -> 66;
                    case 190 -> 80;
                    case 191 -> 32;
                    case 192 -> 143;
                    case 193 -> 124;
                    case 194 -> 184;
                    case 195 -> 215;
                    case 196 -> 30;
                    case 197 -> 48;
                    case 198 -> 165;
                    case 199 -> 71;
                    case 200 -> 151;
                    case 201 -> 121;
                    case 202 -> 5;
                    case 203 -> 77;
                    case 204 -> 226;
                    case 205 -> 144;
                    case 206 -> 157;
                    case 207 -> 29;
                    case 208 -> 194;
                    case 209 -> 47;
                    case 210 -> 64;
                    case 211 -> 43;
                    case 212 -> 173;
                    case 213 -> 102;
                    case 214 -> 164;
                    case 215 -> 87;
                    case 216 -> 242;
                    case 217 -> 152;
                    case 218 -> 23;
                    case 219 -> 24;
                    case 220 -> 175;
                    case 221 -> 88;
                    case 222 -> 212;
                    case 223 -> 21;
                    case 224 -> 177;
                    case 225 -> 240;
                    case 226 -> 79;
                    case 227 -> 52;
                    case 228 -> 67;
                    case 229 -> 104;
                    case 230 -> 253;
                    case 231 -> 120;
                    case 232 -> 34;
                    case 233 -> 14;
                    case 234 -> 44;
                    case 235 -> 105;
                    case 236 -> 148;
                    case 237 -> 136;
                    case 238 -> 123;
                    case 239 -> 10;
                    case 240 -> 213;
                    case 241 -> 161;
                    case 242 -> 101;
                    case 243 -> 156;
                    case 244 -> 228;
                    case 245 -> 247;
                    case 246 -> 198;
                    case 247 -> 58;
                    case 248 -> 78;
                    case 249 -> 54;
                    case 250 -> 109;
                    case 251 -> 86;
                    case 252 -> 92;
                    case 253 -> 27;
                    case 254 -> 146;
                    default -> 85;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 37282143869748L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0019\u0014\u0019xg\u0019u@\t\u001e\u001e\nr*[h\\X";
                    var5_4 = "\u0019\u0014\u0019xg\u0019u@\t\u001e\u001e\nr*[h\\X".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 10;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 120;
                                    break;
                                }
                                case 1: {
                                    v11 = 123;
                                    break;
                                }
                                case 2: {
                                    v11 = 97;
                                    break;
                                }
                                case 3: {
                                    v11 = 28;
                                    break;
                                }
                                case 4: {
                                    v11 = 8;
                                    break;
                                }
                                case 5: {
                                    v11 = 127;
                                    break;
                                }
                                default: {
                                    v11 = 76;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 12914784862286L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "[EAG\u001er\u0006\u0004][M]\nQDF]\u0012p\u001e{EO\tQDF]\u0012p\u001ewO\rVB[P\u0018}\u0004wH\\Z\u0019t";
                    var5_4 = "[EAG\u001er\u0006\u0004][M]\nQDF]\u0012p\u001e{EO\tQDF]\u0012p\u001ewO\rVB[P\u0018}\u0004wH\\Z\u0019t".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 100;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "BTTS\rn\u001e\u0006BTTS\u0001d";
                        var5_4 = "BTTS\rn\u001e\u0006BTTS\u0001d".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 119;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 118;
                                break;
                            }
                            case 1: {
                                v15 = 79;
                                break;
                            }
                            case 2: {
                                v15 = 76;
                                break;
                            }
                            case 3: {
                                v15 = 87;
                                break;
                            }
                            case 4: {
                                v15 = 19;
                                break;
                            }
                            case 5: {
                                v15 = 119;
                                break;
                            }
                            default: {
                                v15 = 14;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 94741053309504L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1630248660 + 16013, 1630248660 + 15993, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 13842939127629L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00cb\u00f5p\u00fd\u00c5\u0003\u00daG\u00e6\u0005\u00e6\u00b2\u00f3\u00d1V\r~\u00e9\u00d6\u00f0\u00078\u00c36\u00ddM8\u00b5\u00a6\u0010\u00bb\"\u00a9b\u00d7\u00ff\u00f2\u00f32q&\u007f\u00833\u00c5\\\u0005\u00b9\u00c7\u0018\u007f+3\u000f%\u00dfT\u00cc}\u00a1\u00b7%\u0004O\u00f8h\u0092\u0094w\u00e5\u00d7\u0097\u00e7\t\u0018\u00fa\u00a1\u001b\u0012\u00a7\u0006\u00d3U2@\u00af\u00ed\u0086\u0087\u0085R\u0091~0\u00ce:\u00be#\u00cbB\u00b6\b\u00fb]";
                    var4_3 = "\u00cb\u00f5p\u00fd\u00c5\u0003\u00daG\u00e6\u0005\u00e6\u00b2\u00f3\u00d1V\r~\u00e9\u00d6\u00f0\u00078\u00c36\u00ddM8\u00b5\u00a6\u0010\u00bb\"\u00a9b\u00d7\u00ff\u00f2\u00f32q&\u007f\u00833\u00c5\\\u0005\u00b9\u00c7\u0018\u007f+3\u000f%\u00dfT\u00cc}\u00a1\u00b7%\u0004O\u00f8h\u0092\u0094w\u00e5\u00d7\u0097\u00e7\t\u0018\u00fa\u00a1\u001b\u0012\u00a7\u0006\u00d3U2@\u00af\u00ed\u0086\u0087\u0085R\u0091~0\u00ce:\u00be#\u00cbB\u00b6\b\u00fb]".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 80;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "c\u0010P\u00c6\n\u0089\u00ab\u00df\u00fb\u0016\u00fdq\u001a\u0010\u0014\u00daL\u00cd\u00b8r\u0019d\u00ba\b\u00d7\u0006\u0084\u00ee\u009av\u00e3\n\u00dd\u00d1\u00b1\f?\u00f0\u0085\rR$e\u0087\u00cc\u00cf\u00a7\u00bc\u0093\u008c\u009bq\u00b7\u00abh\u008c\u00bdG\u00a9\u00f9\u00cd\u00ac\u0099\u009a&\u0003?6\u00bb\u00c7E\u00f87S\u00b06\u0017\u00e8\u00f0O\u0013\u00ae\u0005\u00f2\u00d4\u009f\u00d1aKS\\Q\u0015";
                        var4_3 = "c\u0010P\u00c6\n\u0089\u00ab\u00df\u00fb\u0016\u00fdq\u001a\u0010\u0014\u00daL\u00cd\u00b8r\u0019d\u00ba\b\u00d7\u0006\u0084\u00ee\u009av\u00e3\n\u00dd\u00d1\u00b1\f?\u00f0\u0085\rR$e\u0087\u00cc\u00cf\u00a7\u00bc\u0093\u008c\u009bq\u00b7\u00abh\u008c\u00bdG\u00a9\u00f9\u00cd\u00ac\u0099\u009a&\u0003?6\u00bb\u00c7E\u00f87S\u00b06\u0017\u00e8\u00f0O\u0013\u00ae\u0005\u00f2\u00d4\u009f\u00d1aKS\\Q\u0015".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 118;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 1;
                                break;
                            }
                            case 1: {
                                v15 = 15;
                                break;
                            }
                            case 2: {
                                v15 = 91;
                                break;
                            }
                            case 3: {
                                v15 = 29;
                                break;
                            }
                            case 4: {
                                v15 = 71;
                                break;
                            }
                            case 5: {
                                v15 = 89;
                                break;
                            }
                            default: {
                                v15 = 109;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFDF21) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 120;
                    case 1 -> 26;
                    case 2 -> 113;
                    case 3 -> 192;
                    case 4 -> 241;
                    case 5 -> 222;
                    case 6 -> 206;
                    case 7 -> 237;
                    case 8 -> 194;
                    case 9 -> 145;
                    case 10 -> 20;
                    case 11 -> 45;
                    case 12 -> 248;
                    case 13 -> 15;
                    case 14 -> 21;
                    case 15 -> 116;
                    case 16 -> 25;
                    case 17 -> 180;
                    case 18 -> 55;
                    case 19 -> 228;
                    case 20 -> 134;
                    case 21 -> 129;
                    case 22 -> 24;
                    case 23 -> 229;
                    case 24 -> 251;
                    case 25 -> 226;
                    case 26 -> 183;
                    case 27 -> 17;
                    case 28 -> 48;
                    case 29 -> 219;
                    case 30 -> 14;
                    case 31 -> 67;
                    case 32 -> 16;
                    case 33 -> 181;
                    case 34 -> 252;
                    case 35 -> 0;
                    case 36 -> 179;
                    case 37 -> 232;
                    case 38 -> 221;
                    case 39 -> 31;
                    case 40 -> 224;
                    case 41 -> 23;
                    case 42 -> 68;
                    case 43 -> 142;
                    case 44 -> 255;
                    case 45 -> 247;
                    case 46 -> 176;
                    case 47 -> 97;
                    case 48 -> 139;
                    case 49 -> 112;
                    case 50 -> 218;
                    case 51 -> 203;
                    case 52 -> 159;
                    case 53 -> 177;
                    case 54 -> 11;
                    case 55 -> 147;
                    case 56 -> 187;
                    case 57 -> 1;
                    case 58 -> 103;
                    case 59 -> 70;
                    case 60 -> 4;
                    case 61 -> 191;
                    case 62 -> 98;
                    case 63 -> 130;
                    case 64 -> 76;
                    case 65 -> 38;
                    case 66 -> 136;
                    case 67 -> 167;
                    case 68 -> 43;
                    case 69 -> 107;
                    case 70 -> 189;
                    case 71 -> 100;
                    case 72 -> 101;
                    case 73 -> 88;
                    case 74 -> 200;
                    case 75 -> 123;
                    case 76 -> 253;
                    case 77 -> 56;
                    case 78 -> 173;
                    case 79 -> 216;
                    case 80 -> 208;
                    case 81 -> 40;
                    case 82 -> 233;
                    case 83 -> 50;
                    case 84 -> 10;
                    case 85 -> 160;
                    case 86 -> 93;
                    case 87 -> 223;
                    case 88 -> 245;
                    case 89 -> 243;
                    case 90 -> 81;
                    case 91 -> 175;
                    case 92 -> 13;
                    case 93 -> 238;
                    case 94 -> 236;
                    case 95 -> 156;
                    case 96 -> 82;
                    case 97 -> 6;
                    case 98 -> 163;
                    case 99 -> 174;
                    case 100 -> 121;
                    case 101 -> 29;
                    case 102 -> 185;
                    case 103 -> 90;
                    case 104 -> 37;
                    case 105 -> 213;
                    case 106 -> 34;
                    case 107 -> 108;
                    case 108 -> 27;
                    case 109 -> 157;
                    case 110 -> 132;
                    case 111 -> 178;
                    case 112 -> 197;
                    case 113 -> 146;
                    case 114 -> 137;
                    case 115 -> 169;
                    case 116 -> 71;
                    case 117 -> 207;
                    case 118 -> 153;
                    case 119 -> 47;
                    case 120 -> 126;
                    case 121 -> 249;
                    case 122 -> 168;
                    case 123 -> 54;
                    case 124 -> 41;
                    case 125 -> 7;
                    case 126 -> 148;
                    case 127 -> 74;
                    case 128 -> 111;
                    case 129 -> 211;
                    case 130 -> 215;
                    case 131 -> 60;
                    case 132 -> 32;
                    case 133 -> 69;
                    case 134 -> 225;
                    case 135 -> 154;
                    case 136 -> 235;
                    case 137 -> 190;
                    case 138 -> 201;
                    case 139 -> 214;
                    case 140 -> 86;
                    case 141 -> 220;
                    case 142 -> 118;
                    case 143 -> 240;
                    case 144 -> 96;
                    case 145 -> 63;
                    case 146 -> 164;
                    case 147 -> 234;
                    case 148 -> 205;
                    case 149 -> 75;
                    case 150 -> 104;
                    case 151 -> 89;
                    case 152 -> 49;
                    case 153 -> 246;
                    case 154 -> 18;
                    case 155 -> 30;
                    case 156 -> 162;
                    case 157 -> 231;
                    case 158 -> 109;
                    case 159 -> 87;
                    case 160 -> 125;
                    case 161 -> 95;
                    case 162 -> 143;
                    case 163 -> 73;
                    case 164 -> 102;
                    case 165 -> 35;
                    case 166 -> 22;
                    case 167 -> 182;
                    case 168 -> 204;
                    case 169 -> 80;
                    case 170 -> 105;
                    case 171 -> 196;
                    case 172 -> 79;
                    case 173 -> 131;
                    case 174 -> 122;
                    case 175 -> 152;
                    case 176 -> 44;
                    case 177 -> 94;
                    case 178 -> 3;
                    case 179 -> 46;
                    case 180 -> 91;
                    case 181 -> 72;
                    case 182 -> 9;
                    case 183 -> 127;
                    case 184 -> 19;
                    case 185 -> 242;
                    case 186 -> 166;
                    case 187 -> 239;
                    case 188 -> 188;
                    case 189 -> 2;
                    case 190 -> 199;
                    case 191 -> 115;
                    case 192 -> 83;
                    case 193 -> 165;
                    case 194 -> 28;
                    case 195 -> 8;
                    case 196 -> 42;
                    case 197 -> 58;
                    case 198 -> 66;
                    case 199 -> 106;
                    case 200 -> 57;
                    case 201 -> 227;
                    case 202 -> 212;
                    case 203 -> 144;
                    case 204 -> 64;
                    case 205 -> 62;
                    case 206 -> 99;
                    case 207 -> 117;
                    case 208 -> 53;
                    case 209 -> 138;
                    case 210 -> 195;
                    case 211 -> 198;
                    case 212 -> 171;
                    case 213 -> 52;
                    case 214 -> 141;
                    case 215 -> 151;
                    case 216 -> 170;
                    case 217 -> 51;
                    case 218 -> 149;
                    case 219 -> 114;
                    case 220 -> 128;
                    case 221 -> 184;
                    case 222 -> 110;
                    case 223 -> 140;
                    case 224 -> 217;
                    case 225 -> 193;
                    case 226 -> 155;
                    case 227 -> 161;
                    case 228 -> 36;
                    case 229 -> 254;
                    case 230 -> 65;
                    case 231 -> 59;
                    case 232 -> 77;
                    case 233 -> 210;
                    case 234 -> 158;
                    case 235 -> 39;
                    case 236 -> 150;
                    case 237 -> 135;
                    case 238 -> 186;
                    case 239 -> 85;
                    case 240 -> 244;
                    case 241 -> 84;
                    case 242 -> 78;
                    case 243 -> 61;
                    case 244 -> 230;
                    case 245 -> 209;
                    case 246 -> 202;
                    case 247 -> 12;
                    case 248 -> 33;
                    case 249 -> 92;
                    case 250 -> 124;
                    case 251 -> 133;
                    case 252 -> 119;
                    case 253 -> 172;
                    case 254 -> 250;
                    default -> 5;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 74933589556989L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(704894460 - (char)-22251, -704894460 - -((char)-17856), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 62338171229381L;
                    int[] nArray = SshAgentIpcService.l();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1015923570 - -((char)-30128), -1015923570 - -((char)-30755), (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 29931843209491L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "#^\u00abC\u00dc\u0003\u0096\u00e1K";
                var4_3 = "#^\u00abC\u00dc\u0003\u0096\u00e1K".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 38;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 19;
                                break;
                            }
                            case 1: {
                                v11 = 7;
                                break;
                            }
                            case 2: {
                                v11 = 103;
                                break;
                            }
                            case 3: {
                                v11 = 111;
                                break;
                            }
                            case 4: {
                                v11 = 26;
                                break;
                            }
                            case 5: {
                                v11 = 36;
                                break;
                            }
                            default: {
                                v11 = 105;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF921A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 6;
                    case 1 -> 70;
                    case 2 -> 189;
                    case 3 -> 210;
                    case 4 -> 56;
                    case 5 -> 132;
                    case 6 -> 255;
                    case 7 -> 146;
                    case 8 -> 97;
                    case 9 -> 26;
                    case 10 -> 21;
                    case 11 -> 169;
                    case 12 -> 61;
                    case 13 -> 138;
                    case 14 -> 35;
                    case 15 -> 55;
                    case 16 -> 74;
                    case 17 -> 126;
                    case 18 -> 3;
                    case 19 -> 94;
                    case 20 -> 116;
                    case 21 -> 233;
                    case 22 -> 66;
                    case 23 -> 65;
                    case 24 -> 212;
                    case 25 -> 108;
                    case 26 -> 150;
                    case 27 -> 117;
                    case 28 -> 193;
                    case 29 -> 187;
                    case 30 -> 82;
                    case 31 -> 58;
                    case 32 -> 128;
                    case 33 -> 50;
                    case 34 -> 154;
                    case 35 -> 230;
                    case 36 -> 57;
                    case 37 -> 100;
                    case 38 -> 196;
                    case 39 -> 227;
                    case 40 -> 241;
                    case 41 -> 93;
                    case 42 -> 179;
                    case 43 -> 232;
                    case 44 -> 239;
                    case 45 -> 163;
                    case 46 -> 237;
                    case 47 -> 157;
                    case 48 -> 180;
                    case 49 -> 8;
                    case 50 -> 249;
                    case 51 -> 194;
                    case 52 -> 211;
                    case 53 -> 184;
                    case 54 -> 25;
                    case 55 -> 14;
                    case 56 -> 246;
                    case 57 -> 251;
                    case 58 -> 220;
                    case 59 -> 208;
                    case 60 -> 174;
                    case 61 -> 10;
                    case 62 -> 139;
                    case 63 -> 54;
                    case 64 -> 201;
                    case 65 -> 135;
                    case 66 -> 88;
                    case 67 -> 125;
                    case 68 -> 63;
                    case 69 -> 175;
                    case 70 -> 17;
                    case 71 -> 69;
                    case 72 -> 156;
                    case 73 -> 223;
                    case 74 -> 168;
                    case 75 -> 30;
                    case 76 -> 48;
                    case 77 -> 122;
                    case 78 -> 160;
                    case 79 -> 43;
                    case 80 -> 225;
                    case 81 -> 39;
                    case 82 -> 41;
                    case 83 -> 214;
                    case 84 -> 15;
                    case 85 -> 161;
                    case 86 -> 121;
                    case 87 -> 133;
                    case 88 -> 20;
                    case 89 -> 213;
                    case 90 -> 83;
                    case 91 -> 197;
                    case 92 -> 12;
                    case 93 -> 103;
                    case 94 -> 159;
                    case 95 -> 99;
                    case 96 -> 104;
                    case 97 -> 27;
                    case 98 -> 217;
                    case 99 -> 105;
                    case 100 -> 31;
                    case 101 -> 9;
                    case 102 -> 234;
                    case 103 -> 147;
                    case 104 -> 62;
                    case 105 -> 59;
                    case 106 -> 87;
                    case 107 -> 101;
                    case 108 -> 13;
                    case 109 -> 140;
                    case 110 -> 178;
                    case 111 -> 183;
                    case 112 -> 73;
                    case 113 -> 102;
                    case 114 -> 224;
                    case 115 -> 92;
                    case 116 -> 7;
                    case 117 -> 129;
                    case 118 -> 98;
                    case 119 -> 191;
                    case 120 -> 111;
                    case 121 -> 22;
                    case 122 -> 45;
                    case 123 -> 185;
                    case 124 -> 75;
                    case 125 -> 206;
                    case 126 -> 44;
                    case 127 -> 53;
                    case 128 -> 80;
                    case 129 -> 81;
                    case 130 -> 28;
                    case 131 -> 112;
                    case 132 -> 190;
                    case 133 -> 250;
                    case 134 -> 64;
                    case 135 -> 238;
                    case 136 -> 127;
                    case 137 -> 118;
                    case 138 -> 23;
                    case 139 -> 49;
                    case 140 -> 152;
                    case 141 -> 172;
                    case 142 -> 24;
                    case 143 -> 77;
                    case 144 -> 124;
                    case 145 -> 79;
                    case 146 -> 33;
                    case 147 -> 181;
                    case 148 -> 215;
                    case 149 -> 244;
                    case 150 -> 1;
                    case 151 -> 37;
                    case 152 -> 32;
                    case 153 -> 148;
                    case 154 -> 42;
                    case 155 -> 158;
                    case 156 -> 151;
                    case 157 -> 162;
                    case 158 -> 107;
                    case 159 -> 243;
                    case 160 -> 78;
                    case 161 -> 200;
                    case 162 -> 221;
                    case 163 -> 222;
                    case 164 -> 219;
                    case 165 -> 192;
                    case 166 -> 46;
                    case 167 -> 2;
                    case 168 -> 95;
                    case 169 -> 144;
                    case 170 -> 252;
                    case 171 -> 143;
                    case 172 -> 52;
                    case 173 -> 188;
                    case 174 -> 90;
                    case 175 -> 202;
                    case 176 -> 207;
                    case 177 -> 149;
                    case 178 -> 131;
                    case 179 -> 72;
                    case 180 -> 110;
                    case 181 -> 229;
                    case 182 -> 0;
                    case 183 -> 34;
                    case 184 -> 96;
                    case 185 -> 166;
                    case 186 -> 218;
                    case 187 -> 89;
                    case 188 -> 216;
                    case 189 -> 231;
                    case 190 -> 91;
                    case 191 -> 165;
                    case 192 -> 51;
                    case 193 -> 203;
                    case 194 -> 205;
                    case 195 -> 176;
                    case 196 -> 204;
                    case 197 -> 182;
                    case 198 -> 137;
                    case 199 -> 36;
                    case 200 -> 60;
                    case 201 -> 209;
                    case 202 -> 167;
                    case 203 -> 11;
                    case 204 -> 84;
                    case 205 -> 4;
                    case 206 -> 173;
                    case 207 -> 76;
                    case 208 -> 170;
                    case 209 -> 245;
                    case 210 -> 86;
                    case 211 -> 240;
                    case 212 -> 67;
                    case 213 -> 141;
                    case 214 -> 47;
                    case 215 -> 5;
                    case 216 -> 130;
                    case 217 -> 68;
                    case 218 -> 226;
                    case 219 -> 248;
                    case 220 -> 123;
                    case 221 -> 106;
                    case 222 -> 177;
                    case 223 -> 235;
                    case 224 -> 228;
                    case 225 -> 242;
                    case 226 -> 198;
                    case 227 -> 115;
                    case 228 -> 38;
                    case 229 -> 236;
                    case 230 -> 136;
                    case 231 -> 254;
                    case 232 -> 114;
                    case 233 -> 71;
                    case 234 -> 247;
                    case 235 -> 113;
                    case 236 -> 18;
                    case 237 -> 29;
                    case 238 -> 120;
                    case 239 -> 153;
                    case 240 -> 40;
                    case 241 -> 142;
                    case 242 -> 199;
                    case 243 -> 164;
                    case 244 -> 134;
                    case 245 -> 109;
                    case 246 -> 195;
                    case 247 -> 171;
                    case 248 -> 253;
                    case 249 -> 119;
                    case 250 -> 145;
                    case 251 -> 16;
                    case 252 -> 186;
                    case 253 -> 155;
                    case 254 -> 19;
                    default -> 85;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

