/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.actions;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.listeners.JupyterConfigChangeListener;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterSwitchServerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "targetConfig", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "currentConfig", "text", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;Ljava/lang/String;)V", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isSelected", "", "()Z", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getUserConfirmation", "intellij.jupyter.py"})
public final class JupyterSwitchServerAction
extends DumbAwareAction {
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private final JupyterServerConfig targetConfig;
    @NotNull
    private final JupyterServerConfig currentConfig;
    @NotNull
    private final String text;
    @NotNull
    private final VirtualFile virtualFile;

    public JupyterSwitchServerAction(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile, @NotNull JupyterServerConfig targetConfig, @NotNull JupyterServerConfig currentConfig, @NlsActions.ActionText @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)targetConfig, (String)"targetConfig");
        Intrinsics.checkNotNullParameter((Object)currentConfig, (String)"currentConfig");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text);
        this.project = project;
        this.notebookFile = notebookFile;
        this.targetConfig = targetConfig;
        this.currentConfig = currentConfig;
        this.text = text;
        this.virtualFile = this.notebookFile.getFile();
    }

    public final boolean isSelected() {
        return Intrinsics.areEqual((Object)this.targetConfig, (Object)this.currentConfig);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setIcon(this.isSelected() ? AllIcons.Actions.Checked : null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = JupyterAnActionEventExtensionsKt.getEditor((AnActionEvent)e);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        if (!this.getUserConfirmation()) {
            return;
        }
        JupyterConnectionSettingsManager.Companion.getInstance().setConfigForFile(this.virtualFile, this.targetConfig);
        ((JupyterConfigChangeListener)this.project.getMessageBus().syncPublisher(JupyterConfigChangeListener.Companion.getJUPYTER_SELECTED_CONFIG_CHANGE_TOPIC())).activeConfigChanged(this.project, editor2, this.notebookFile, this.targetConfig);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final boolean getUserConfirmation() {
        JupyterNotebookSession jupyterNotebookSession = JupyterExecutionManager.Companion.getInstance(this.project, this.virtualFile).getSession();
        if (jupyterNotebookSession == null) {
            return true;
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        JupyterServerConfig jupyterServerConfig = session.getConnectionParameters().getConfig();
        if (jupyterServerConfig == null) {
            return true;
        }
        JupyterServerConfig existingConnectionConfig = jupyterServerConfig;
        if (Intrinsics.areEqual((Object)this.targetConfig, (Object)existingConnectionConfig)) {
            return true;
        }
        Object[] objectArray = new Object[]{existingConnectionConfig.getName()};
        boolean decision = Messages.showOkCancelDialog((Project)this.project, (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.message", (Object[])objectArray), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.title", (Object[])new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon()) == 0;
        return decision;
    }
}

