/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.HashUtil;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.Preconditions;
import com.dynatrace.hash4j.internal.UnsignedMultiplyUtil;

final class Rapidhash3
implements AbstractHasher64 {
    private static final long SEC0 = 3257665815644502181L;
    private static final long SEC1 = -8378864009470890807L;
    private static final long SEC2 = 5418857496715711651L;
    private static final long SEC3 = 5573817676018592327L;
    private static final long SEC4 = -6884282663029611473L;
    private static final long SEC5 = -1800455987208640293L;
    private static final long SEC6 = -8003715239535429492L;
    private static final long SEC7 = -6148914691236517206L;
    private final long seed;
    private static final Hasher64 DEFAULT_HASHER_INSTANCE = Rapidhash3.create(0L);

    private Rapidhash3(long seed) {
        this.seed = seed ^ HashUtil.mix(seed ^ 0x4B33A62ED433D4A3L, -8378864009470890807L);
    }

    static Hasher64 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    static Hasher64 create(long seed) {
        return new Rapidhash3(seed);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        if (len <= 16) {
            if (len >= 4) {
                long b;
                long a;
                if (len >= 8) {
                    a = ByteArrayUtil.getLong(input, off);
                    b = ByteArrayUtil.getLong(input, off + len - 8);
                } else {
                    b = (long)ByteArrayUtil.getInt(input, off) & 0xFFFFFFFFL;
                    a = (long)ByteArrayUtil.getInt(input, off + len - 4) & 0xFFFFFFFFL;
                }
                return Rapidhash3.finish(a ^ (long)len, b, this.seed ^ (long)len, len);
            }
            if (len > 0) {
                long a = ((long)input[off] & 0xFFL) << 45 ^ (long)input[off + len - 1] & 0xFFL;
                long b = (long)input[off + (len >> 1)] & 0xFFL;
                return Rapidhash3.finish(a ^ (long)len, b, this.seed, len);
            }
            return Rapidhash3.finish(0L, 0L, this.seed, len);
        }
        long see0 = this.seed;
        long see1 = this.seed;
        long see2 = this.seed;
        long see3 = this.seed;
        long see4 = this.seed;
        long see5 = this.seed;
        long see6 = this.seed;
        if (len > 112) {
            do {
                see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off) ^ 0x2D358DCCAA6C78A5L, ByteArrayUtil.getLong(input, off + 8) ^ see0);
                see1 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 16) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(input, off + 24) ^ see1);
                see2 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 32) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(input, off + 40) ^ see2);
                see3 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 48) ^ 0x4D5A2DA51DE1AA47L, ByteArrayUtil.getLong(input, off + 56) ^ see3);
                see4 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 64) ^ 0xA0761D6478BD642FL, ByteArrayUtil.getLong(input, off + 72) ^ see4);
                see5 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 80) ^ 0xE7037ED1A0B428DBL, ByteArrayUtil.getLong(input, off + 88) ^ see5);
                see6 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 96) ^ 0x90ED1765281C388CL, ByteArrayUtil.getLong(input, off + 104) ^ see6);
                off += 112;
            } while ((len -= 112) > 112);
            see0 ^= see1;
            see2 ^= see3;
            see0 ^= see6;
            see0 ^= (see2 ^= (see4 ^= see5));
        }
        if (len > 16) {
            see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(input, off + 8) ^ see0);
            if (len > 32) {
                see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 16) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(input, off + 24) ^ see0);
                if (len > 48) {
                    see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 32) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(input, off + 40) ^ see0);
                    if (len > 64) {
                        see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 48) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(input, off + 56) ^ see0);
                        if (len > 80) {
                            see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 64) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(input, off + 72) ^ see0);
                            if (len > 96) {
                                see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 80) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(input, off + 88) ^ see0);
                            }
                        }
                    }
                }
            }
        }
        long a = ByteArrayUtil.getLong(input, off + len - 16);
        long b = ByteArrayUtil.getLong(input, off + len - 8);
        return Rapidhash3.finish(a, b, see0, len);
    }

    @Override
    public <T> long hashBytesToLong(T input, long off, long len, ByteAccess<T> access) {
        if (len <= 16L) {
            if (len >= 4L) {
                long b;
                long a;
                if (len >= 8L) {
                    a = access.getLong(input, off);
                    b = access.getLong(input, off + len - 8L);
                } else {
                    b = access.getIntAsUnsignedLong(input, off);
                    a = access.getIntAsUnsignedLong(input, off + len - 4L);
                }
                return Rapidhash3.finish(a ^ len, b, this.seed ^ len, len);
            }
            if (len > 0L) {
                long a = access.getByteAsUnsignedLong(input, off) << 45 ^ access.getByteAsUnsignedLong(input, off + len - 1L);
                long b = access.getByteAsUnsignedLong(input, off + (len >> 1));
                return Rapidhash3.finish(a ^ len, b, this.seed, len);
            }
            return Rapidhash3.finish(0L, 0L, this.seed, len);
        }
        long see0 = this.seed;
        long see1 = this.seed;
        long see2 = this.seed;
        long see3 = this.seed;
        long see4 = this.seed;
        long see5 = this.seed;
        long see6 = this.seed;
        if (len > 112L) {
            do {
                see0 = HashUtil.mix(access.getLong(input, off) ^ 0x2D358DCCAA6C78A5L, access.getLong(input, off + 8L) ^ see0);
                see1 = HashUtil.mix(access.getLong(input, off + 16L) ^ 0x8BB84B93962EACC9L, access.getLong(input, off + 24L) ^ see1);
                see2 = HashUtil.mix(access.getLong(input, off + 32L) ^ 0x4B33A62ED433D4A3L, access.getLong(input, off + 40L) ^ see2);
                see3 = HashUtil.mix(access.getLong(input, off + 48L) ^ 0x4D5A2DA51DE1AA47L, access.getLong(input, off + 56L) ^ see3);
                see4 = HashUtil.mix(access.getLong(input, off + 64L) ^ 0xA0761D6478BD642FL, access.getLong(input, off + 72L) ^ see4);
                see5 = HashUtil.mix(access.getLong(input, off + 80L) ^ 0xE7037ED1A0B428DBL, access.getLong(input, off + 88L) ^ see5);
                see6 = HashUtil.mix(access.getLong(input, off + 96L) ^ 0x90ED1765281C388CL, access.getLong(input, off + 104L) ^ see6);
                off += 112L;
            } while ((len -= 112L) > 112L);
            see0 ^= see1;
            see2 ^= see3;
            see0 ^= see6;
            see0 ^= (see2 ^= (see4 ^= see5));
        }
        if (len > 16L) {
            see0 = HashUtil.mix(access.getLong(input, off) ^ 0x4B33A62ED433D4A3L, access.getLong(input, off + 8L) ^ see0);
            if (len > 32L) {
                see0 = HashUtil.mix(access.getLong(input, off + 16L) ^ 0x4B33A62ED433D4A3L, access.getLong(input, off + 24L) ^ see0);
                if (len > 48L) {
                    see0 = HashUtil.mix(access.getLong(input, off + 32L) ^ 0x8BB84B93962EACC9L, access.getLong(input, off + 40L) ^ see0);
                    if (len > 64L) {
                        see0 = HashUtil.mix(access.getLong(input, off + 48L) ^ 0x8BB84B93962EACC9L, access.getLong(input, off + 56L) ^ see0);
                        if (len > 80L) {
                            see0 = HashUtil.mix(access.getLong(input, off + 64L) ^ 0x4B33A62ED433D4A3L, access.getLong(input, off + 72L) ^ see0);
                            if (len > 96L) {
                                see0 = HashUtil.mix(access.getLong(input, off + 80L) ^ 0x8BB84B93962EACC9L, access.getLong(input, off + 88L) ^ see0);
                            }
                        }
                    }
                }
            }
        }
        long a = access.getLong(input, off + len - 16L);
        long b = access.getLong(input, off + len - 8L);
        return Rapidhash3.finish(a, b, see0, len);
    }

    private static long finish(long a, long b, long seed, long len) {
        return HashUtil.mix((a ^= (len ^= 0x8BB84B93962EACC9L)) * (b ^= seed) ^ 0xAAAAAAAAAAAAAAAAL, UnsignedMultiplyUtil.unsignedMultiplyHigh(a, b) ^ len);
    }

    @Override
    public long hashCharsToLong(CharSequence input) {
        int len = input.length();
        int off = 0;
        if (len <= 8) {
            if (len >= 2) {
                long b;
                long a;
                if (len >= 4) {
                    a = ByteArrayUtil.getLong(input, 0);
                    b = ByteArrayUtil.getLong(input, len - 4);
                } else {
                    b = (long)ByteArrayUtil.getInt(input, 0) & 0xFFFFFFFFL;
                    a = (long)ByteArrayUtil.getInt(input, len - 2) & 0xFFFFFFFFL;
                }
                return Rapidhash3.finish(a ^ (long)(len << 1), b, this.seed ^ (long)(len << 1), len << 1);
            }
            if (len > 0) {
                char c = input.charAt(0);
                long b = (long)c >>> 8;
                long a = ((long)c & 0xFFL) << 45 ^ b ^ 2L;
                return Rapidhash3.finish(a, b, this.seed, len << 1);
            }
            return Rapidhash3.finish(0L, 0L, this.seed, 0L);
        }
        long see0 = this.seed;
        long see1 = this.seed;
        long see2 = this.seed;
        long see3 = this.seed;
        long see4 = this.seed;
        long see5 = this.seed;
        long see6 = this.seed;
        if (len > 56) {
            do {
                see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off) ^ 0x2D358DCCAA6C78A5L, ByteArrayUtil.getLong(input, off + 4) ^ see0);
                see1 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 8) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(input, off + 12) ^ see1);
                see2 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 16) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(input, off + 20) ^ see2);
                see3 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 24) ^ 0x4D5A2DA51DE1AA47L, ByteArrayUtil.getLong(input, off + 28) ^ see3);
                see4 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 32) ^ 0xA0761D6478BD642FL, ByteArrayUtil.getLong(input, off + 36) ^ see4);
                see5 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 40) ^ 0xE7037ED1A0B428DBL, ByteArrayUtil.getLong(input, off + 44) ^ see5);
                see6 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 48) ^ 0x90ED1765281C388CL, ByteArrayUtil.getLong(input, off + 52) ^ see6);
                off += 56;
            } while ((len -= 56) > 56);
            see0 ^= see1;
            see2 ^= see3;
            see0 ^= see6;
            see0 ^= (see2 ^= (see4 ^= see5));
        }
        if (len > 8) {
            see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(input, off + 4) ^ see0);
            if (len > 16) {
                see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 8) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(input, off + 12) ^ see0);
                if (len > 24) {
                    see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 16) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(input, off + 20) ^ see0);
                    if (len > 32) {
                        see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 24) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(input, off + 28) ^ see0);
                        if (len > 40) {
                            see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 32) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(input, off + 36) ^ see0);
                            if (len > 48) {
                                see0 = HashUtil.mix(ByteArrayUtil.getLong(input, off + 40) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(input, off + 44) ^ see0);
                            }
                        }
                    }
                }
            }
        }
        long a = ByteArrayUtil.getLong(input, off + len - 8);
        long b = ByteArrayUtil.getLong(input, off + len - 4);
        return Rapidhash3.finish(a, b, see0, (long)len << 1);
    }

    @Override
    public long hashIntToLong(int v) {
        long b = (long)v & 0xFFFFFFFFL ^ (this.seed ^ 4L);
        long a = (long)v & 0xFFFFFFFFL ^ 0x8BB84B93962EACC9L;
        return HashUtil.mix(a * b ^ 0xAAAAAAAAAAAAAAAAL, UnsignedMultiplyUtil.unsignedMultiplyHigh(a, b) ^ 0x8BB84B93962EACCDL);
    }

    @Override
    public long hashIntIntToLong(int v1, int v2) {
        long v = (long)v1 & 0xFFFFFFFFL ^ (long)v2 << 32;
        long a = v ^ 0x8BB84B93962EACC9L;
        long b = v ^ (this.seed ^ 8L);
        return HashUtil.mix(a * b ^ 0xAAAAAAAAAAAAAAAAL, UnsignedMultiplyUtil.unsignedMultiplyHigh(a, b) ^ 0x8BB84B93962EACC1L);
    }

    @Override
    public long hashIntIntIntToLong(int v1, int v2, int v3) {
        return Rapidhash3.finish((long)v2 << 32 ^ (long)v1 & 0xFFFFFFFFL ^ 0xCL, (long)v3 << 32 ^ (long)v2 & 0xFFFFFFFFL, this.seed ^ 0xCL, 12L);
    }

    @Override
    public long hashIntLongToLong(int v1, long v2) {
        return Rapidhash3.finish(v2 << 32 ^ (long)v1 & 0xFFFFFFFFL ^ 0xCL, v2, this.seed ^ 0xCL, 12L);
    }

    @Override
    public long hashLongToLong(long v) {
        long a = v ^ 0x8BB84B93962EACC9L;
        long b = v ^ (this.seed ^ 8L);
        return HashUtil.mix(a * b ^ 0xAAAAAAAAAAAAAAAAL, UnsignedMultiplyUtil.unsignedMultiplyHigh(a, b) ^ 0x8BB84B93962EACC1L);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        return Rapidhash3.finish(v1 ^ 0x10L, v2, this.seed ^ 0x10L, 16L);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        return Rapidhash3.finish(v2, v3, HashUtil.mix(v1 ^ 0x4B33A62ED433D4A3L, v2 ^ this.seed), 24L);
    }

    @Override
    public long hashLongIntToLong(long v1, int v2) {
        return Rapidhash3.finish(v1 ^ 0xCL, (long)v2 << 32 ^ v1 >>> 32, this.seed ^ 0xCL, 12L);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rapidhash3)) {
            return false;
        }
        Rapidhash3 that = (Rapidhash3)obj;
        return this.seed == that.seed;
    }

    public int hashCode() {
        return Long.hashCode(this.seed);
    }

    private class HashStreamImpl
    implements AbstractHashStream64 {
        private final byte[] buffer = new byte[120];
        private long byteCount = 0L;
        private int offset = 0;
        private long see0;
        private long see1;
        private long see2;
        private long see3;
        private long see4;
        private long see5;
        private long see6;
        private static final byte SERIAL_VERSION_V0 = 0;

        private HashStreamImpl() {
            this.see0 = Rapidhash3.this.seed;
            this.see1 = Rapidhash3.this.seed;
            this.see2 = Rapidhash3.this.seed;
            this.see3 = Rapidhash3.this.seed;
            this.see4 = Rapidhash3.this.seed;
            this.see5 = Rapidhash3.this.seed;
            this.see6 = Rapidhash3.this.seed;
        }

        public int hashCode() {
            return this.getAsInt();
        }

        public boolean equals(Object obj) {
            return HashUtil.equalsHelper(this, obj);
        }

        @Override
        public HashStream64 reset() {
            this.byteCount = 0L;
            this.offset = 0;
            this.see0 = Rapidhash3.this.seed;
            this.see1 = Rapidhash3.this.seed;
            this.see2 = Rapidhash3.this.seed;
            this.see3 = Rapidhash3.this.seed;
            this.see4 = Rapidhash3.this.seed;
            this.see5 = Rapidhash3.this.seed;
            this.see6 = Rapidhash3.this.seed;
            return this;
        }

        @Override
        public Hasher64 getHasher() {
            return Rapidhash3.this;
        }

        @Override
        public byte[] getState() {
            int numBufferBytes = this.offset < 16 && (this.byteCount >= 16L || this.byteCount < 0L) ? 16 : this.offset;
            byte[] state = new byte[9 + (this.byteCount > 112L || this.byteCount < 0L ? 56 : 0) + numBufferBytes];
            int off = 0;
            state[off++] = 0;
            ByteArrayUtil.setLong(state, off, this.byteCount);
            off += 8;
            if (this.byteCount > 112L || this.byteCount < 0L) {
                ByteArrayUtil.setLong(state, off, this.see0);
                ByteArrayUtil.setLong(state, off += 8, this.see1);
                ByteArrayUtil.setLong(state, off += 8, this.see2);
                ByteArrayUtil.setLong(state, off += 8, this.see3);
                ByteArrayUtil.setLong(state, off += 8, this.see4);
                ByteArrayUtil.setLong(state, off += 8, this.see5);
                ByteArrayUtil.setLong(state, off += 8, this.see6);
                off += 8;
            }
            if (this.offset < 16 && (this.byteCount >= 16L || this.byteCount < 0L)) {
                System.arraycopy(this.buffer, 96 + this.offset, state, off, 16 - this.offset);
                off += 16 - this.offset;
            }
            System.arraycopy(this.buffer, 0, state, off, this.offset);
            return state;
        }

        @Override
        public HashStream64 setState(byte[] state) {
            Preconditions.checkArgument(state != null);
            Preconditions.checkArgument(state.length >= 9);
            Preconditions.checkArgument(state[0] == 0);
            int off = 1;
            this.byteCount = ByteArrayUtil.getLong(state, off);
            off += 8;
            this.offset = this.byteCount == 0L ? 0 : (int)Long.remainderUnsigned(this.byteCount - 1L, 112L) + 1;
            int numBufferBytes = this.offset < 16 && (this.byteCount >= 16L || this.byteCount < 0L) ? 16 : this.offset;
            Preconditions.checkArgument(state.length == 9 + (this.byteCount > 112L || this.byteCount < 0L ? 56 : 0) + numBufferBytes);
            if (this.byteCount > 112L || this.byteCount < 0L) {
                this.see0 = ByteArrayUtil.getLong(state, off);
                this.see1 = ByteArrayUtil.getLong(state, off += 8);
                this.see2 = ByteArrayUtil.getLong(state, off += 8);
                this.see3 = ByteArrayUtil.getLong(state, off += 8);
                this.see4 = ByteArrayUtil.getLong(state, off += 8);
                this.see5 = ByteArrayUtil.getLong(state, off += 8);
                this.see6 = ByteArrayUtil.getLong(state, off += 8);
                off += 8;
            } else {
                this.see0 = Rapidhash3.this.seed;
                this.see1 = Rapidhash3.this.seed;
                this.see2 = Rapidhash3.this.seed;
                this.see3 = Rapidhash3.this.seed;
                this.see4 = Rapidhash3.this.seed;
                this.see5 = Rapidhash3.this.seed;
                this.see6 = Rapidhash3.this.seed;
            }
            if (this.offset < 16 && (this.byteCount >= 16L || this.byteCount < 0L)) {
                System.arraycopy(state, off, this.buffer, 96 + this.offset, 16 - this.offset);
                off += 16 - this.offset;
            }
            System.arraycopy(state, off, this.buffer, 0, this.offset);
            return this;
        }

        @Override
        public HashStream64 putByte(byte v) {
            if (this.offset >= 112) {
                this.offset -= 112;
                this.processBuffer();
            }
            this.buffer[this.offset] = v;
            ++this.offset;
            ++this.byteCount;
            return this;
        }

        @Override
        public HashStream64 putShort(short v) {
            ByteArrayUtil.setShort(this.buffer, this.offset, v);
            this.offset += 2;
            this.byteCount += 2L;
            if (this.offset > 112) {
                this.offset -= 112;
                this.processBuffer();
                ByteArrayUtil.setShort(this.buffer, 0, (short)(v << (this.offset << 3) >>> 16));
            }
            return this;
        }

        @Override
        public HashStream64 putChar(char v) {
            ByteArrayUtil.setChar(this.buffer, this.offset, v);
            this.offset += 2;
            this.byteCount += 2L;
            if (this.offset > 112) {
                this.offset -= 112;
                this.processBuffer();
                ByteArrayUtil.setChar(this.buffer, 0, (char)(v << (this.offset << 3) >>> 16));
            }
            return this;
        }

        @Override
        public HashStream64 putInt(int v) {
            ByteArrayUtil.setInt(this.buffer, this.offset, v);
            this.offset += 4;
            this.byteCount += 4L;
            if (this.offset > 112) {
                this.offset -= 112;
                this.processBuffer();
                ByteArrayUtil.setInt(this.buffer, 0, v >>> -(this.offset << 3));
            }
            return this;
        }

        @Override
        public HashStream64 putLong(long v) {
            ByteArrayUtil.setLong(this.buffer, this.offset, v);
            this.offset += 8;
            this.byteCount += 8L;
            if (this.offset > 112) {
                this.offset -= 112;
                this.processBuffer();
                ByteArrayUtil.setLong(this.buffer, 0, v >>> -(this.offset << 3));
            }
            return this;
        }

        @Override
        public HashStream64 putBytes(byte[] b, int off, int len) {
            this.byteCount += (long)len;
            int x = 112 - this.offset;
            if (len > x) {
                System.arraycopy(b, off, this.buffer, this.offset, x);
                this.processBuffer();
                off += x;
                if ((len -= x) > 112) {
                    do {
                        long b0 = ByteArrayUtil.getLong(b, off);
                        long b1 = ByteArrayUtil.getLong(b, off + 8);
                        long b2 = ByteArrayUtil.getLong(b, off + 16);
                        long b3 = ByteArrayUtil.getLong(b, off + 24);
                        long b4 = ByteArrayUtil.getLong(b, off + 32);
                        long b5 = ByteArrayUtil.getLong(b, off + 40);
                        long b6 = ByteArrayUtil.getLong(b, off + 48);
                        long b7 = ByteArrayUtil.getLong(b, off + 56);
                        long b8 = ByteArrayUtil.getLong(b, off + 64);
                        long b9 = ByteArrayUtil.getLong(b, off + 72);
                        long b10 = ByteArrayUtil.getLong(b, off + 80);
                        long b11 = ByteArrayUtil.getLong(b, off + 88);
                        long b12 = ByteArrayUtil.getLong(b, off + 96);
                        long b13 = ByteArrayUtil.getLong(b, off + 104);
                        this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13);
                        off += 112;
                    } while ((len -= 112) > 112);
                    if (len < 16) {
                        int y = 16 - len;
                        System.arraycopy(b, off - y, this.buffer, 96 + len, y);
                    }
                }
                this.offset = 0;
            }
            System.arraycopy(b, off, this.buffer, this.offset, len);
            this.offset += len;
            return this;
        }

        @Override
        public <T> HashStream64 putBytes(T b, long off, long len, ByteAccess<T> access) {
            this.byteCount += len;
            int x = 112 - this.offset;
            if (len > (long)x) {
                access.copyToByteArray(b, off, this.buffer, this.offset, x);
                this.processBuffer();
                off += (long)x;
                if ((len -= (long)x) > 112L) {
                    do {
                        long b0 = access.getLong(b, off);
                        long b1 = access.getLong(b, off + 8L);
                        long b2 = access.getLong(b, off + 16L);
                        long b3 = access.getLong(b, off + 24L);
                        long b4 = access.getLong(b, off + 32L);
                        long b5 = access.getLong(b, off + 40L);
                        long b6 = access.getLong(b, off + 48L);
                        long b7 = access.getLong(b, off + 56L);
                        long b8 = access.getLong(b, off + 64L);
                        long b9 = access.getLong(b, off + 72L);
                        long b10 = access.getLong(b, off + 80L);
                        long b11 = access.getLong(b, off + 88L);
                        long b12 = access.getLong(b, off + 96L);
                        long b13 = access.getLong(b, off + 104L);
                        this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13);
                        off += 112L;
                    } while ((len -= 112L) > 112L);
                    if (len < 16L) {
                        int y = 16 - (int)len;
                        access.copyToByteArray(b, off - (long)y, this.buffer, 96 + (int)len, y);
                    }
                }
                this.offset = 0;
            }
            access.copyToByteArray(b, off, this.buffer, this.offset, (int)len);
            this.offset += (int)len;
            return this;
        }

        @Override
        public HashStream64 putChars(CharSequence s) {
            int remainingChars = s.length();
            this.byteCount += (long)remainingChars << 1;
            int off = 0;
            if (remainingChars > 112 - this.offset >>> 1) {
                if (this.offset > 1) {
                    off = 113 - this.offset >>> 1;
                    ByteArrayUtil.copyCharsToByteArray(s, 0, this.buffer, this.offset, off);
                    remainingChars -= off;
                    this.processBuffer();
                    this.offset &= 1;
                }
                if (this.offset == 0) {
                    if (remainingChars > 56) {
                        long b13;
                        long b12;
                        do {
                            long b0 = ByteArrayUtil.getLong(s, off);
                            long b1 = ByteArrayUtil.getLong(s, off + 4);
                            long b2 = ByteArrayUtil.getLong(s, off + 8);
                            long b3 = ByteArrayUtil.getLong(s, off + 12);
                            long b4 = ByteArrayUtil.getLong(s, off + 16);
                            long b5 = ByteArrayUtil.getLong(s, off + 20);
                            long b6 = ByteArrayUtil.getLong(s, off + 24);
                            long b7 = ByteArrayUtil.getLong(s, off + 28);
                            long b8 = ByteArrayUtil.getLong(s, off + 32);
                            long b9 = ByteArrayUtil.getLong(s, off + 36);
                            long b10 = ByteArrayUtil.getLong(s, off + 40);
                            long b11 = ByteArrayUtil.getLong(s, off + 44);
                            b12 = ByteArrayUtil.getLong(s, off + 48);
                            b13 = ByteArrayUtil.getLong(s, off + 52);
                            this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13);
                            off += 56;
                        } while ((remainingChars -= 56) > 56);
                        ByteArrayUtil.setLong(this.buffer, 96, b12);
                        ByteArrayUtil.setLong(this.buffer, 104, b13);
                    }
                } else {
                    long z = (long)this.buffer[off == 0 ? 0 : 112] & 0xFFL;
                    if (remainingChars >= 56) {
                        long b13;
                        long b12;
                        do {
                            long b0 = ByteArrayUtil.getLong(s, off);
                            long b1 = ByteArrayUtil.getLong(s, off + 4);
                            long b2 = ByteArrayUtil.getLong(s, off + 8);
                            long b3 = ByteArrayUtil.getLong(s, off + 12);
                            long b4 = ByteArrayUtil.getLong(s, off + 16);
                            long b5 = ByteArrayUtil.getLong(s, off + 20);
                            long b6 = ByteArrayUtil.getLong(s, off + 24);
                            long b7 = ByteArrayUtil.getLong(s, off + 28);
                            long b8 = ByteArrayUtil.getLong(s, off + 32);
                            long b9 = ByteArrayUtil.getLong(s, off + 36);
                            long b10 = ByteArrayUtil.getLong(s, off + 40);
                            long b11 = ByteArrayUtil.getLong(s, off + 44);
                            b12 = ByteArrayUtil.getLong(s, off + 48);
                            b13 = ByteArrayUtil.getLong(s, off + 52);
                            long y = b13 >>> 56;
                            b13 = b12 >>> 56 | b13 << 8;
                            b12 = b11 >>> 56 | b12 << 8;
                            b11 = b10 >>> 56 | b11 << 8;
                            b10 = b9 >>> 56 | b10 << 8;
                            b9 = b8 >>> 56 | b9 << 8;
                            b8 = b7 >>> 56 | b8 << 8;
                            b7 = b6 >>> 56 | b7 << 8;
                            b6 = b5 >>> 56 | b6 << 8;
                            b5 = b4 >>> 56 | b5 << 8;
                            b4 = b3 >>> 56 | b4 << 8;
                            b3 = b2 >>> 56 | b3 << 8;
                            b2 = b1 >>> 56 | b2 << 8;
                            b1 = b0 >>> 56 | b1 << 8;
                            b0 = z | b0 << 8;
                            z = y;
                            this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13);
                            off += 56;
                        } while ((remainingChars -= 56) >= 56);
                        ByteArrayUtil.setLong(this.buffer, 96, b12);
                        ByteArrayUtil.setLong(this.buffer, 104, b13);
                    }
                    this.buffer[0] = (byte)z;
                }
            }
            ByteArrayUtil.copyCharsToByteArray(s, off, this.buffer, this.offset, remainingChars);
            this.offset += remainingChars << 1;
            return this;
        }

        private void processBuffer() {
            long b0 = ByteArrayUtil.getLong(this.buffer, 0);
            long b1 = ByteArrayUtil.getLong(this.buffer, 8);
            long b2 = ByteArrayUtil.getLong(this.buffer, 16);
            long b3 = ByteArrayUtil.getLong(this.buffer, 24);
            long b4 = ByteArrayUtil.getLong(this.buffer, 32);
            long b5 = ByteArrayUtil.getLong(this.buffer, 40);
            long b6 = ByteArrayUtil.getLong(this.buffer, 48);
            long b7 = ByteArrayUtil.getLong(this.buffer, 56);
            long b8 = ByteArrayUtil.getLong(this.buffer, 64);
            long b9 = ByteArrayUtil.getLong(this.buffer, 72);
            long b10 = ByteArrayUtil.getLong(this.buffer, 80);
            long b11 = ByteArrayUtil.getLong(this.buffer, 88);
            long b12 = ByteArrayUtil.getLong(this.buffer, 96);
            long b13 = ByteArrayUtil.getLong(this.buffer, 104);
            this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13);
        }

        private void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7, long b8, long b9, long b10, long b11, long b12, long b13) {
            this.see0 = HashUtil.mix(b0 ^ 0x2D358DCCAA6C78A5L, b1 ^ this.see0);
            this.see1 = HashUtil.mix(b2 ^ 0x8BB84B93962EACC9L, b3 ^ this.see1);
            this.see2 = HashUtil.mix(b4 ^ 0x4B33A62ED433D4A3L, b5 ^ this.see2);
            this.see3 = HashUtil.mix(b6 ^ 0x4D5A2DA51DE1AA47L, b7 ^ this.see3);
            this.see4 = HashUtil.mix(b8 ^ 0xA0761D6478BD642FL, b9 ^ this.see4);
            this.see5 = HashUtil.mix(b10 ^ 0xE7037ED1A0B428DBL, b11 ^ this.see5);
            this.see6 = HashUtil.mix(b12 ^ 0x90ED1765281C388CL, b13 ^ this.see6);
        }

        @Override
        public long getAsLong() {
            long b;
            long a;
            long see0 = this.see0;
            if (this.byteCount <= 16L) {
                if (this.byteCount >= 4L) {
                    if (this.byteCount >= 8L) {
                        a = ByteArrayUtil.getLong(this.buffer, 0);
                        b = ByteArrayUtil.getLong(this.buffer, (int)(this.byteCount - 8L));
                    } else {
                        b = (long)ByteArrayUtil.getInt(this.buffer, 0) & 0xFFFFFFFFL;
                        a = (long)ByteArrayUtil.getInt(this.buffer, (int)(this.byteCount - 4L)) & 0xFFFFFFFFL;
                    }
                    a ^= this.byteCount;
                    see0 ^= this.byteCount;
                } else if (this.byteCount > 0L) {
                    a = ((long)this.buffer[0] & 0xFFL) << 45 ^ (long)this.buffer[(int)(this.byteCount - 1L)] & 0xFFL ^ this.byteCount;
                    b = (long)this.buffer[(int)(this.byteCount >> 1)] & 0xFFL;
                } else {
                    a = 0L;
                    b = 0L;
                }
            } else {
                long see2 = this.see2;
                long see4 = this.see4;
                if (this.byteCount > 112L) {
                    see0 ^= this.see1;
                    see2 ^= this.see3;
                    see0 ^= this.see6;
                    see0 ^= (see2 ^= (see4 ^= this.see5));
                }
                if (this.offset > 16) {
                    see0 = HashUtil.mix(ByteArrayUtil.getLong(this.buffer, 0) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(this.buffer, 8) ^ see0);
                    if (this.offset > 32) {
                        see0 = HashUtil.mix(ByteArrayUtil.getLong(this.buffer, 16) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(this.buffer, 24) ^ see0);
                        if (this.offset > 48) {
                            see0 = HashUtil.mix(ByteArrayUtil.getLong(this.buffer, 32) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(this.buffer, 40) ^ see0);
                            if (this.offset > 64) {
                                see0 = HashUtil.mix(ByteArrayUtil.getLong(this.buffer, 48) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(this.buffer, 56) ^ see0);
                                if (this.offset > 80) {
                                    see0 = HashUtil.mix(ByteArrayUtil.getLong(this.buffer, 64) ^ 0x4B33A62ED433D4A3L, ByteArrayUtil.getLong(this.buffer, 72) ^ see0);
                                    if (this.offset > 96) {
                                        see0 = HashUtil.mix(ByteArrayUtil.getLong(this.buffer, 80) ^ 0x8BB84B93962EACC9L, ByteArrayUtil.getLong(this.buffer, 88) ^ see0);
                                    }
                                }
                            }
                        }
                    }
                }
                if (this.offset >= 16) {
                    a = ByteArrayUtil.getLong(this.buffer, this.offset - 16);
                    b = ByteArrayUtil.getLong(this.buffer, this.offset - 8);
                } else {
                    b = ByteArrayUtil.getLong(this.buffer, 0);
                    a = ByteArrayUtil.getLong(this.buffer, 104);
                    int shift = this.offset << 3;
                    if (this.offset > 8) {
                        a = a >>> shift | b << -shift;
                        b = ByteArrayUtil.getLong(this.buffer, this.offset - 8);
                    } else if (this.offset < 8) {
                        b = a >>> shift | b << -shift;
                        a = ByteArrayUtil.getLong(this.buffer, this.offset + 96);
                    }
                }
            }
            return Rapidhash3.finish(a, b, see0, this.offset);
        }
    }
}

