/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.kubernetes.config.HelmParameters;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.EffectiveHelmParameters;
import com.intellij.kubernetes.ui.HelmCommandParametersDialog;
import com.intellij.kubernetes.ui.actions.HelmChartActionBase;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmCliActionBase;", "Lcom/intellij/kubernetes/ui/actions/HelmChartActionBase;", "taskTitle", "", "dependsOnManualConfiguration", "", "<init>", "(Ljava/lang/String;Z)V", "getTaskTitle", "()Ljava/lang/String;", "helmCommand", "", "getHelmCommand", "()Ljava/util/List;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "context", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "createExecutionRequest", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "performInBackground", "executionManager", "Lcom/intellij/kubernetes/helm/HelmExecutionManager;", "request", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmCliActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmCliActionBase.kt\ncom/intellij/kubernetes/ui/actions/HelmCliActionBase\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,54:1\n133#2:55\n*S KotlinDebug\n*F\n+ 1 HelmCliActionBase.kt\ncom/intellij/kubernetes/ui/actions/HelmCliActionBase\n*L\n37#1:55\n*E\n"})
public abstract class HelmCliActionBase
extends HelmChartActionBase {
    @NotNull
    private final String taskTitle;
    private final boolean dependsOnManualConfiguration;

    public HelmCliActionBase(@Nls @NotNull String taskTitle, boolean dependsOnManualConfiguration) {
        Intrinsics.checkNotNullParameter((Object)taskTitle, (String)"taskTitle");
        this.taskTitle = taskTitle;
        this.dependsOnManualConfiguration = dependsOnManualConfiguration;
    }

    @NotNull
    public final String getTaskTitle() {
        return this.taskTitle;
    }

    @NotNull
    public abstract List<String> getHelmCommand();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesActionBase.ActionContext actionContext = this.getContext(e);
        if (actionContext == null) {
            return;
        }
        KubernetesActionBase.ActionContext context2 = actionContext;
        HelmExecutionManager.ExecutionRequest executionRequest = this.createExecutionRequest(context2);
        if (executionRequest == null) {
            return;
        }
        HelmExecutionManager.ExecutionRequest request = executionRequest;
        FileDocumentManager.getInstance().saveAllDocuments();
        Object object = context2.getProject().getService(HelmExecutionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.performInBackground(context2, (HelmExecutionManager)object, request);
    }

    @Override
    protected boolean isEnabled(@NotNull KubernetesActionBase.ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !((HelmExecutionManager)context2.getProject().getService(HelmExecutionManager.class)).isBusy();
    }

    @Nullable
    protected HelmExecutionManager.ExecutionRequest createExecutionRequest(@NotNull KubernetesActionBase.ActionContext context2) {
        HelmExecutionManager.ExecutionRequest executionRequest;
        EffectiveHelmParameters effectiveHelmParameters;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Chart chart = this.getChart(context2);
        if (chart == null) {
            return null;
        }
        Chart chart2 = chart;
        if (this.dependsOnManualConfiguration) {
            HelmParameters helmParameters = KubernetesProjectSettings.Companion.getInstance(context2.getProject()).getHelmParameters(chart2.getBaseDir());
            if (!(helmParameters != null ? !helmParameters.getShowConfigDialog() : false)) {
                EffectiveHelmParameters effectiveHelmParameters2;
                HelmCommandParametersDialog it = new HelmCommandParametersDialog(context2.getProject(), chart2, this.taskTitle);
                boolean bl = false;
                boolean condition$iv = it.showAndGet();
                boolean $i$f$doIf = false;
                if (condition$iv) {
                    boolean bl2 = false;
                    effectiveHelmParameters2 = it.getHelmParameters();
                } else {
                    effectiveHelmParameters2 = effectiveHelmParameters = null;
                }
                if (effectiveHelmParameters2 == null) {
                    return null;
                }
            } else {
                effectiveHelmParameters = chart2.getEffectiveHelmParameters();
            }
        } else {
            effectiveHelmParameters = EffectiveHelmParameters.Companion.getEMPTY_PARAMETERS$intellij_clouds_kubernetes_backend();
        }
        EffectiveHelmParameters helmParameters = effectiveHelmParameters;
        VirtualFile virtualFile = chart2.getBaseDir().getParent();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            executionRequest = new HelmExecutionManager.ExecutionRequest(this.taskTitle, this.getHelmCommand(), helmParameters, it, chart2.getBaseDir().getName(), null, null, 96, null);
        } else {
            executionRequest = null;
        }
        return executionRequest;
    }

    protected abstract void performInBackground(@NotNull KubernetesActionBase.ActionContext var1, @NotNull HelmExecutionManager var2, @NotNull HelmExecutionManager.ExecutionRequest var3);
}

