/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.CellColors;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.diff.DiffSupport;
import com.intellij.database.diff.SpinnerAction;
import com.intellij.database.diff.TableDiffAdapter;
import com.intellij.database.diff.TableDiffBuilder;
import com.intellij.database.diff.TableDiffDividerDrawUtil;
import com.intellij.database.diff.TableDiffEditor;
import com.intellij.database.diff.TableDiffSettingsHolder;
import com.intellij.database.diff.TableDiffSupport;
import com.intellij.database.diff.TableEditorHolder;
import com.intellij.database.diff.TableSyncScrollSupport;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.table.TableScrollPane;
import com.intellij.database.util.DbUIUtil;
import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TableDiffViewer
extends TwosideDiffViewer<TableEditorHolder> {
    private final TableDiffSettingsHolder.Settings mySettings;
    private List<TableDiffBuilder.RowDiffRange> myFuzzyRowDifferences = Collections.emptyList();
    private List<TableDiffBuilder.CellDiff> myCellDifferences = Collections.emptyList();
    private VisibleAreaListener myScrollListener;
    private final TableSyncScrollSupport.TableViewerSyncScrollSupport mySyncScrollListener;
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    private final Alarm myAlarm = new Alarm((Disposable)this);

    TableDiffViewer(DiffContext context, DiffRequest request) {
        super(context, (ContentDiffRequest)request, (EditorHolderFactory)TableEditorHolder.TableEditorHolderFactory.INSTANCE);
        TableDiffSettingsHolder service = context.getProject() == null ? null : (TableDiffSettingsHolder)context.getProject().getService(TableDiffSettingsHolder.class);
        this.mySettings = service == null ? new TableDiffSettingsHolder.Settings() : service.getState();
        this.myStatusPanel = new StatusPanel();
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        MySyncScrollable scrollable = new MySyncScrollable();
        this.mySyncScrollListener = new TableSyncScrollSupport.TableViewerSyncScrollSupport(this.getEditor1(), this.getEditor2(), (SyncScrollSupport.SyncScrollable)scrollable);
        this.myContentPanel.repaint();
    }

    @NotNull
    TableDiffEditor getEditor2() {
        TableDiffEditor tableDiffEditor = ((TableEditorHolder)((Object)this.getEditorHolders().get(1))).getEditor();
        if (tableDiffEditor == null) {
            TableDiffViewer.$$$reportNull$$$0(0);
        }
        return tableDiffEditor;
    }

    @NotNull
    TableDiffEditor getEditor1() {
        TableDiffEditor tableDiffEditor = ((TableEditorHolder)((Object)this.getEditorHolders().get(0))).getEditor();
        if (tableDiffEditor == null) {
            TableDiffViewer.$$$reportNull$$$0(1);
        }
        return tableDiffEditor;
    }

    @Nullable
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> actions = super.createToolbarActions();
        if (actions == null) {
            actions = new ArrayList<AnAction>();
        }
        actions.add((AnAction)new CheckboxAction(DatabaseBundle.messagePointer((String)"checkbox.detect.column.insertion", (Object[])new Object[0]), DatabaseBundle.messagePointer((String)"tooltip.detect.column.insertion", (Object[])new Object[0]), null){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                return TableDiffViewer.this.mySettings.detectColumnInsertion;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                TableDiffViewer.this.mySettings.detectColumnInsertion = state;
                TableDiffViewer.this.rediff();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/diff/TableDiffViewer$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/diff/TableDiffViewer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        });
        actions.add((AnAction)new SpinnerAction(new SpinnerNumberModel(this.mySettings.columnMismatchThreshold, 0, Integer.MAX_VALUE, 1), DatabaseBundle.message((String)"TableDiffViewer.action.tolerance.text", (Object[])new Object[0]), DatabaseBundle.message((String)"TableDiffViewer.action.number.allowed.column.mismatches.description", (Object[])new Object[0]), null){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                int columns = Math.min(TableDiffViewer.this.getEditor1().getDataGrid().getVisibleColumnCount(), TableDiffViewer.this.getEditor2().getDataGrid().getVisibleColumnCount());
                SpinnerNumberModel model = (SpinnerNumberModel)this.myField.getModel();
                if (!model.getMaximum().equals(columns)) {
                    if (((Number)model.getValue()).intValue() > columns) {
                        model.setValue(columns);
                    }
                    model.setMaximum(Integer.valueOf(columns));
                }
                super.update(e);
            }

            @Override
            public Object getValue() {
                return TableDiffViewer.this.mySettings.columnMismatchThreshold;
            }

            @Override
            public void setValue(Object value) {
                Number val = (Number)value;
                TableDiffViewer.this.mySettings.columnMismatchThreshold = val.intValue();
                TableDiffViewer.this.rediff();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/diff/TableDiffViewer$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/diff/TableDiffViewer$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        });
        actions.add(ActionManager.getInstance().getAction("Diff.Binary.Settings"));
        return actions;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            TableDiffViewer.$$$reportNull$$$0(2);
        }
        if (request == null) {
            TableDiffViewer.$$$reportNull$$$0(3);
        }
        return TwosideDiffViewer.canShowRequest((DiffContext)context, (DiffRequest)request, (EditorHolderFactory)TableEditorHolder.TableEditorHolderFactory.INSTANCE);
    }

    protected void onInit() {
        super.onInit();
        TableScrollPane scrollPane = (TableScrollPane)ObjectUtils.tryCast((Object)this.getEditor1().getDataGrid().getMainResultViewComponent(), TableScrollPane.class);
        if (scrollPane != null) {
            scrollPane.setFlipControls(true);
        }
        MyDividerPainter painter = new MyDividerPainter();
        this.myContentPanel.setPainter((DiffSplitter.Painter)painter);
        this.myScrollListener = new VisibleAreaListener(){

            public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                TableDiffViewer.this.mySyncScrollListener.visibleAreaChanged(e);
                TableDiffViewer.this.myContentPanel.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/diff/TableDiffViewer$3", "visibleAreaChanged"));
            }
        };
        this.getEditor1().getScrollingModel().addVisibleAreaListener(this.myScrollListener);
        this.getEditor2().getScrollingModel().addVisibleAreaListener(this.myScrollListener);
        this.getEditor1().getDataGrid().addDataGridListener(new MyDataGridListener(), (Disposable)this.getEditor1());
        this.getEditor2().getDataGrid().addDataGridListener(new MyDataGridListener(), (Disposable)this.getEditor2());
    }

    public void onDispose() {
        this.getEditor1().getScrollingModel().removeVisibleAreaListener(this.myScrollListener);
        this.getEditor2().getScrollingModel().removeVisibleAreaListener(this.myScrollListener);
        super.onDispose();
    }

    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        if (indicator == null) {
            TableDiffViewer.$$$reportNull$$$0(4);
        }
        try {
            indicator.checkCanceled();
            TableDiffEditor.DiffTablePanel g1 = this.getEditor1().getDataGrid();
            TableDiffEditor.DiffTablePanel g2 = this.getEditor2().getDataGrid();
            TableDiffBuilder.TableDiffResult diffResult = TableDiffAdapter.process(g1, g1.getInactiveRows(), g1.getInactiveCols(), g2, g2.getInactiveRows(), g2.getInactiveCols(), this.mySettings, indicator);
            runnable = () -> {
                this.clearDiffPresentation();
                if (diffResult.isEqual()) {
                    this.myPanel.addNotification((JComponent)DiffNotifications.createEqualContents());
                }
                this.myFuzzyRowDifferences = diffResult.rowDiff;
                this.myCellDifferences = diffResult.cellDiff;
                TableDiffEditor.DiffTablePanel g11 = this.getEditor1().getDataGrid();
                TableDiffEditor.DiffTablePanel g21 = this.getEditor2().getDataGrid();
                for (TableDiffBuilder.RowDiffRange rowDiffRange : this.myFuzzyRowDifferences) {
                    Couple<TextRange> ranges = rowDiffRange.getRanges();
                    CellAttributesKey attributes1 = rowDiffRange.getFuzzy() ? CellColors.FM_MATCHED : TableDiffViewer.getAttributeKeys(rowDiffRange.getType(), ((TextRange)ranges.first).isEmpty());
                    CellAttributesKey attributes2 = rowDiffRange.getFuzzy() ? CellColors.FM_MATCHED : TableDiffViewer.getAttributeKeys(rowDiffRange.getType(), ((TextRange)ranges.second).isEmpty());
                    g11.highlightRowOrCol(((TextRange)ranges.first).getStartOffset(), ((TextRange)ranges.first).getEndOffset(), attributes1, true);
                    g21.highlightRowOrCol(((TextRange)ranges.second).getStartOffset(), ((TextRange)ranges.second).getEndOffset(), attributes2, true);
                }
                for (TableDiffBuilder.CellDiff cellDiff : this.myCellDifferences) {
                    g11.highlightCell(cellDiff.row1, cellDiff.col1, CellColors.FM_MISMATCHED);
                    g21.highlightCell(cellDiff.row2, cellDiff.col2, CellColors.FM_MISMATCHED);
                }
                g11.highlightRowsOrCols((List)diffResult.getSkippedCols().first, CellColors.EXCLUDE_COLUMN, false);
                g21.highlightRowsOrCols((List)diffResult.getSkippedCols().second, CellColors.EXCLUDE_COLUMN, false);
                g11.highlightRowsOrCols((List)diffResult.getSkippedRows().first, CellColors.EXCLUDE_COLUMN, true);
                g21.highlightRowsOrCols((List)diffResult.getSkippedRows().second, CellColors.EXCLUDE_COLUMN, true);
                this.getComponent().repaint();
            };
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable2 = () -> {
                this.clearDiffPresentation();
                this.myPanel.addNotification((JComponent)DiffNotifications.createError());
            };
            if (runnable2 == null) {
                TableDiffViewer.$$$reportNull$$$0(6);
            }
            return runnable2;
        }
        if (runnable == null) {
            TableDiffViewer.$$$reportNull$$$0(5);
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.myFuzzyRowDifferences = Collections.emptyList();
        this.myCellDifferences = Collections.emptyList();
        this.getEditor1().getDataGrid().clearHighlighting();
        this.getEditor2().getDataGrid().clearHighlighting();
    }

    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            TableDiffViewer.$$$reportNull$$$0(7);
        }
        return statusPanel;
    }

    @Nullable
    TableDiffEditor getCurrentEditor() {
        return ((TableEditorHolder)this.getCurrentEditorHolder()).getEditor();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            TableDiffViewer.$$$reportNull$$$0(8);
        }
        super.uiDataSnapshot(sink);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)"reference.dialogs.diff.table");
    }

    @Nullable
    public PrevNextDifferenceIterable getDifferenceIterable() {
        return this.myPrevNextDifferenceIterable;
    }

    @NotNull
    public static CellAttributesKey getAttributeKeys(TableDiffBuilder.DiffType type, boolean underlined) {
        if (type == TableDiffBuilder.DiffType.INSERT) {
            CellAttributesKey cellAttributesKey = underlined ? CellColors.INSERT_UNDERLINED : CellColors.INSERT;
            if (cellAttributesKey == null) {
                TableDiffViewer.$$$reportNull$$$0(9);
            }
            return cellAttributesKey;
        }
        if (type == TableDiffBuilder.DiffType.REMOVE) {
            CellAttributesKey cellAttributesKey = underlined ? CellColors.REMOVE_UNDERLINED : CellColors.REMOVE;
            if (cellAttributesKey == null) {
                TableDiffViewer.$$$reportNull$$$0(10);
            }
            return cellAttributesKey;
        }
        CellAttributesKey cellAttributesKey = underlined ? CellColors.REPLACE_UNDERLINED : CellColors.REPLACE;
        if (cellAttributesKey == null) {
            TableDiffViewer.$$$reportNull$$$0(11);
        }
        return cellAttributesKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/TableDiffViewer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor2";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor1";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/TableDiffViewer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 8 -> new IllegalArgumentException(string);
        };
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        private int getCurrentRow() {
            TableDiffEditor editor2 = TableDiffViewer.this.getCurrentEditor();
            if (editor2 == null) {
                return -1;
            }
            ViewIndex row = editor2.getDataGrid().getSelectionModel().getSelectedRow().toView((CoreGrid)editor2.getDataGrid());
            return row.isValid((CoreGrid)editor2.getDataGrid()) ? row.asInteger() : 0;
        }

        private void setCurrentRow(int row) {
            TableDiffEditor editor2 = TableDiffViewer.this.getCurrentEditor();
            if (editor2 == null) {
                return;
            }
            row = Math.min(row, editor2.getDataGrid().getVisibleRows().size() - 1);
            editor2.getDataGrid().getSelectionModel().setRowSelection(ViewIndex.forRow((CoreGrid)editor2.getDataGrid(), (int)row).toModel((CoreGrid)editor2.getDataGrid()), true);
            editor2.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }

        private int getNumberOfRows() {
            TableDiffEditor editor2 = TableDiffViewer.this.getCurrentEditor();
            if (editor2 == null) {
                return 0;
            }
            return editor2.getDataGrid().getVisibleRows().size();
        }

        public boolean canGoNext() {
            int row = this.getCurrentRow();
            if (row == -1 || row >= this.getNumberOfRows() - 1) {
                return false;
            }
            Couple<TextRange> diff = this.getLastMismatch();
            return diff != null && TableDiffViewer.this.getCurrentSide().select(((TextRange)diff.first).getStartOffset(), ((TextRange)diff.second).getEndOffset()) > row;
        }

        public void goNext() {
            int row = this.getCurrentRow();
            int nextRow = -1;
            for (TableDiffBuilder.RowDiffRange diff : TableDiffViewer.this.myFuzzyRowDifferences) {
                if (diff.getFuzzy()) continue;
                Couple<TextRange> ranges = diff.getRanges();
                int currentRow = TableDiffViewer.this.getCurrentSide().select(((TextRange)ranges.first).getStartOffset(), ((TextRange)ranges.getSecond()).getStartOffset());
                if (currentRow <= row) continue;
                nextRow = currentRow;
                break;
            }
            if (nextRow != -1) {
                this.setCurrentRow(nextRow);
            }
        }

        @Nullable
        private Couple<TextRange> getLastMismatch() {
            for (int i = TableDiffViewer.this.myFuzzyRowDifferences.size() - 1; i >= 0; --i) {
                TableDiffBuilder.RowDiffRange diff = TableDiffViewer.this.myFuzzyRowDifferences.get(i);
                if (diff.getFuzzy()) continue;
                return diff.getRanges();
            }
            return null;
        }

        public boolean canGoPrev() {
            if (TableDiffViewer.this.myFuzzyRowDifferences.isEmpty()) {
                return false;
            }
            int row = this.getCurrentRow();
            if (row == -1) {
                return false;
            }
            @Nullable Couple<TextRange> diff = this.getLastMismatch();
            return diff != null && TableDiffViewer.this.getCurrentSide().select(((TextRange)diff.first).getEndOffset(), ((TextRange)diff.second).getEndOffset()) < row;
        }

        public void goPrev() {
            int row = this.getCurrentRow();
            int prevRow = -1;
            boolean found = false;
            for (TableDiffBuilder.RowDiffRange diff : TableDiffViewer.this.myFuzzyRowDifferences) {
                if (diff.getFuzzy()) continue;
                Couple<TextRange> ranges = diff.getRanges();
                int currentRowEnd = TableDiffViewer.this.getCurrentSide().select(((TextRange)ranges.first).getEndOffset(), ((TextRange)ranges.getSecond()).getEndOffset());
                if (currentRowEnd > row) {
                    found = true;
                    break;
                }
                prevRow = TableDiffViewer.this.getCurrentSide().select(((TextRange)ranges.first).getStartOffset(), ((TextRange)ranges.second).getStartOffset());
            }
            if (found) {
                this.setCurrentRow(prevRow);
            }
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        private MySyncScrollable() {
        }

        public boolean isSyncScrollEnabled() {
            return true;
        }

        @NotNull
        public Range getRange(@NotNull Side baseSide, int line) {
            if (baseSide == null) {
                MySyncScrollable.$$$reportNull$$$0(0);
            }
            if (TableDiffViewer.this.myFuzzyRowDifferences.isEmpty()) {
                Range range = MySyncScrollable.idRange((int)line);
                if (range == null) {
                    MySyncScrollable.$$$reportNull$$$0(1);
                }
                return range;
            }
            Range range = super.getRange(baseSide, line);
            if (range == null) {
                MySyncScrollable.$$$reportNull$$$0(2);
            }
            return range;
        }

        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                MySyncScrollable.$$$reportNull$$$0(3);
            }
            if (!helper.process(0, 0)) {
                return;
            }
            for (TableDiffBuilder.RowDiffRange diff : TableDiffViewer.this.myFuzzyRowDifferences) {
                if (diff.getFuzzy()) continue;
                Couple<TextRange> ranges = diff.getRanges();
                if (!helper.process(((TextRange)ranges.first).getStartOffset(), ((TextRange)ranges.second).getStartOffset())) {
                    return;
                }
                if (helper.process(((TextRange)ranges.first).getEndOffset(), ((TextRange)ranges.second).getEndOffset())) continue;
                return;
            }
            GridModel model1 = TableDiffViewer.this.getEditor1().getDataGrid().getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            GridModel model2 = TableDiffViewer.this.getEditor2().getDataGrid().getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            helper.process(model1.getRowCount(), model2.getRowCount());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseSide";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/diff/TableDiffViewer$MySyncScrollable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/diff/TableDiffViewer$MySyncScrollable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRange";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processHelper";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    TableDiffDividerDrawUtil.DividerPaintable {
        private final DiffSupport[] myDiffSupports;

        MyDividerPainter() {
            this.myDiffSupports = new DiffSupport[]{new TableDiffSupport(TableDiffViewer.this.getEditor1()), new TableDiffSupport(TableDiffViewer.this.getEditor2())};
        }

        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                MyDividerPainter.$$$reportNull$$$0(0);
            }
            if (divider == null) {
                MyDividerPainter.$$$reportNull$$$0(1);
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics((Graphics)g, (Component)divider, (Component)TableDiffViewer.this.getEditor1().getComponent());
            gg.setColor(DiffDrawUtil.getDividerColorFromScheme((EditorColorsScheme)this.myDiffSupports[0].getEditorColorsScheme()));
            gg.fill(gg.getClipBounds());
            TableDiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), this.myDiffSupports[0], this.myDiffSupports[1], this);
            gg.dispose();
        }

        @Override
        public void process(@NotNull TableDiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                MyDividerPainter.$$$reportNull$$$0(2);
            }
            GridColorsScheme scheme = TableDiffViewer.this.getEditor1().getDataGrid().getColorsScheme();
            for (TableDiffBuilder.RowDiffRange rg : TableDiffViewer.this.myFuzzyRowDifferences) {
                Couple<TextRange> ranges = rg.getRanges();
                CellAttributes attrs = scheme.getAttributes(rg.getFuzzy() ? CellColors.FM_MATCHED : TableDiffViewer.getAttributeKeys(rg.getType(), false));
                Color bg = (Color)ObjectUtils.chooseNotNull((Object)attrs.getBackgroundColor(), (Object)JBColor.WHITE);
                if (handler2.process(((TextRange)ranges.first).getStartOffset(), ((TextRange)ranges.first).getEndOffset(), ((TextRange)ranges.second).getStartOffset(), ((TextRange)ranges.second).getEndOffset(), bg)) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/diff/TableDiffViewer$MyDividerPainter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDataGridListener
    implements DataGridListener {
        private boolean myUpdating;

        private MyDataGridListener() {
        }

        public void onContentChanged(DataGrid dataGrid, @Nullable GridRequestSource.RequestPlace place) {
            if (this.myUpdating) {
                return;
            }
            DbUIUtil.invokeLater(() -> {
                try {
                    this.myUpdating = true;
                    ((TableDiffEditor.DiffTablePanel)dataGrid).updateStates();
                }
                finally {
                    this.myUpdating = false;
                }
                TableDiffViewer.this.myAlarm.addRequest(() -> TableDiffViewer.this.rediff(), 500);
            });
        }
    }
}

