/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.mapping;

import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.xml.util.PsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface UrlMappingElement {
    @Deprecated
    public String getURL();

    @NotNull
    public UrlPath getUrlPath();

    @Deprecated
    default public PsiElementPointer getDefinition() {
        return () -> {
            PsiElement navigationTarget;
            PomNamedTarget pomTarget = this.getPomTarget();
            if (pomTarget == null && this instanceof PomTarget) {
                pomTarget = (PomTarget)this;
            }
            if ((navigationTarget = this.getNavigationTarget()) == null) {
                return null;
            }
            if (pomTarget != null) {
                Project project = navigationTarget.getProject();
                return PomService.convertToPsi((Project)project, (PomTarget)pomTarget);
            }
            return navigationTarget;
        };
    }

    @Nullable
    public PomNamedTarget getPomTarget();

    @Nullable
    public PsiElement getNavigationTarget();

    public String getPresentation();

    public RequestMethod[] getMethod();

    @Nullable
    default public PsiElement getDocumentationPsiElement() {
        return this.getNavigationTarget();
    }

    public boolean isDefinedInBean(SpringBeanPointer<? extends CommonSpringBean> var1);

    @NlsSafe
    public static String getPathPresentation(UrlMappingElement item) {
        String presentation = item.getPresentation();
        return StringUtil.startsWithChar((CharSequence)presentation, (char)'/') ? presentation : "/" + presentation;
    }

    @Nullable
    @NlsSafe
    public static String getContainingFileName(UrlMappingElement item) {
        PsiElement psiElement = item.getNavigationTarget();
        if (psiElement == null) {
            return null;
        }
        VirtualFile file = psiElement.getContainingFile().getVirtualFile();
        return file == null ? null : file.getName();
    }

    @Nullable
    @NlsSafe
    public static String getRequestMethodPresentation(UrlMappingElement item) {
        if (item.getMethod().length == 0) {
            return null;
        }
        return RequestMethod.getDisplay(item.getMethod());
    }
}

