/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.el.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.el.impl.ElBundle;
import com.intellij.javaee.el.inspections.ELValidationInspection;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELParameterList;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.references.ELReference;
import com.intellij.micronaut.el.psi.MnELExpression;
import com.intellij.micronaut.el.psi.MnELLiteralExpression;
import com.intellij.micronaut.el.psi.MnELMethodCallExpression;
import com.intellij.micronaut.el.psi.MnELParameterList;
import com.intellij.micronaut.el.psi.MnELQualifiedType;
import com.intellij.micronaut.el.psi.MnELVariable;
import com.intellij.micronaut.el.psi.MnELVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import org.jetbrains.annotations.NotNull;

public final class MnELInspection
extends ELValidationInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            MnELInspection.$$$reportNull$$$0(0);
        }
        return new MnELVisitor(){

            @Override
            public void visitELVariable(@NotNull MnELVariable o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                MnELInspection.this.visitVariable(o, isOnTheFly, holder);
            }

            @Override
            public void visitELLiteralExpression(@NotNull MnELLiteralExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                MnELInspection.this.visitLiteral(o, holder);
            }

            @Override
            public void visitELQualifiedType(@NotNull MnELQualifiedType o) {
                PsiReference[] references;
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (PsiReference reference : references = o.getReferences()) {
                    if (reference.resolve() != null) continue;
                    holder.registerProblem(reference);
                }
            }

            @Override
            public void visitELExpression(@NotNull MnELExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.visitOuterLanguageElement((OuterLanguageElement)o);
            }

            @Override
            public void visitELParameterList(@NotNull MnELParameterList o) {
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.visitOuterLanguageElement((OuterLanguageElement)o);
            }

            @Override
            public void visitELMethodCallExpression(@NotNull MnELMethodCallExpression methodCallExpression) {
                if (methodCallExpression == null) {
                    1.$$$reportNull$$$0(5);
                }
                super.visitELMethodCallExpression(methodCallExpression);
                ELVariable elVariable = methodCallExpression.getMethod();
                if (elVariable == null) {
                    return;
                }
                PsiReference[] references = elVariable.getReferences();
                if (references.length == 0) {
                    return;
                }
                PsiElement element = references[0].resolve();
                if (element instanceof PsiMethod) {
                    boolean vararg;
                    PsiParameter[] psiParameters = ((PsiMethod)element).getParameterList().getParameters();
                    ELParameterList parameterList = methodCallExpression.getParameterList();
                    ELExpression[] parameters = parameterList.getParameters();
                    boolean bl = vararg = psiParameters.length > 0 && psiParameters[psiParameters.length - 1].isVarArgs();
                    if (parameters != null && (!vararg && parameters.length != psiParameters.length || vararg && parameters.length < psiParameters.length - 1)) {
                        holder.registerProblem((PsiElement)parameterList, ElBundle.message((String)"el.mismatched.parameters.count", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodCallExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/micronaut/el/inspection/MnELInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELLiteralExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELQualifiedType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELParameterList";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELMethodCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void checkVariableReference(ELVariable variable, PsiReference reference, boolean isOnTheFly, ProblemsHolder holder) {
        super.checkVariableReference(variable, reference, isOnTheFly, holder);
        if (!(reference instanceof ELReference) && reference.resolve() == null && !variable.getTextRange().isEmpty()) {
            holder.registerProblem(reference);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/micronaut/el/inspection/MnELInspection", "buildVisitor"));
    }
}

