/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "markupContent", "Lorg/eclipse/lsp4j/MarkupContent;", "TextRangeAndMarkupContent", "(Lcom/intellij/openapi/util/TextRange;Lorg/eclipse/lsp4j/MarkupContent;)V", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "getMarkupContent", "()Lorg/eclipse/lsp4j/MarkupContent;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "intellij.platform.lsp.impl"})
public final class TextRangeAndMarkupContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final MarkupContent markupContent;

    public TextRangeAndMarkupContent(@NotNull TextRange textRange, @NotNull MarkupContent markupContent) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)markupContent, (String)"markupContent");
        this.textRange = textRange;
        this.markupContent = markupContent;
    }

    @NotNull
    public final TextRange getTextRange() {
        return this.textRange;
    }

    @NotNull
    public final MarkupContent getMarkupContent() {
        return this.markupContent;
    }

    @NotNull
    public final TextRange component1() {
        return this.textRange;
    }

    @NotNull
    public final MarkupContent component2() {
        return this.markupContent;
    }

    @NotNull
    public final TextRangeAndMarkupContent copy(@NotNull TextRange textRange, @NotNull MarkupContent markupContent) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)markupContent, (String)"markupContent");
        return new TextRangeAndMarkupContent(textRange, markupContent);
    }

    public static /* synthetic */ TextRangeAndMarkupContent copy$default(TextRangeAndMarkupContent textRangeAndMarkupContent, TextRange textRange, MarkupContent markupContent, int n2, Object object) {
        if ((n2 & 1) != 0) {
            textRange = textRangeAndMarkupContent.textRange;
        }
        if ((n2 & 2) != 0) {
            markupContent = textRangeAndMarkupContent.markupContent;
        }
        return textRangeAndMarkupContent.copy(textRange, markupContent);
    }

    @NotNull
    public String toString() {
        return "TextRangeAndMarkupContent(textRange=" + this.textRange + ", markupContent=" + this.markupContent + ")";
    }

    public int hashCode() {
        int n2 = this.textRange.hashCode();
        n2 = n2 * 31 + this.markupContent.hashCode();
        return n2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextRangeAndMarkupContent)) {
            return false;
        }
        TextRangeAndMarkupContent textRangeAndMarkupContent = (TextRangeAndMarkupContent)other;
        if (!Intrinsics.areEqual((Object)this.textRange, (Object)textRangeAndMarkupContent.textRange)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.markupContent, (Object)textRangeAndMarkupContent.markupContent);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent$Companion;", "", "TextRangeAndMarkupContent$Companion", "()V", "fromHover", "Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "hover", "Lorg/eclipse/lsp4j/Hover;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "", "fromHover$intellij_platform_lsp_impl", "intellij.platform.lsp.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final TextRangeAndMarkupContent fromHover$intellij_platform_lsp_impl(@NotNull Hover hover, @NotNull VirtualFile file, int offset) {
            TextRange textRange;
            Intrinsics.checkNotNullParameter((Object)hover, (String)"hover");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document != null && hover.getRange() != null) {
                Range range = hover.getRange();
                Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
                v1 = Lsp4jUtilKt.getRangeInDocument(document, range);
                if (v1 == null) {
                    v1 = new TextRange(offset, offset);
                }
            } else {
                v1 = textRange = new TextRange(offset, offset);
            }
            if (hover.getContents().isRight()) {
                CharSequence charSequence = ((MarkupContent)hover.getContents().getRight()).getValue();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    return null;
                }
                Object object = hover.getContents().getRight();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRight(...)");
                return new TextRangeAndMarkupContent(textRange, (MarkupContent)object);
            }
            Object object = hover.getContents().getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n\n", null, null, (int)0, null, Companion::A, (int)30, null);
            if (StringsKt.isBlank((CharSequence)string)) {
                return null;
            }
            return new TextRangeAndMarkupContent(textRange, new MarkupContent("markdown", string));
        }

        private static final CharSequence A(Either either) {
            CharSequence charSequence;
            if (either.isLeft()) {
                Object object = either.getLeft();
                Intrinsics.checkNotNull((Object)object);
                charSequence = (CharSequence)object;
            } else {
                MarkedString markedString = (MarkedString)either.getRight();
                String string = markedString.getValue();
                String string2 = markedString.getLanguage();
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                charSequence = "```" + string3 + "\n" + string + "\n```";
            }
            return charSequence;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

