/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.documentSymbol;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspRequestExecutorImpl;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.documentSymbol.LspDocumentSymbolTreeElement;
import com.intellij.platform.lsp.impl.documentSymbol.LspStructureViewRoot;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J-\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!2\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/lsp/impl/documentSymbol/LspStructureViewModel;", "Lcom/intellij/ide/structureView/TextEditorBasedStructureViewModel;", "Lcom/intellij/ide/structureView/StructureViewModel$ElementInfoProvider;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "LspStructureViewModel", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "getLspServer", "()Lcom/intellij/platform/lsp/impl/LspServerImpl;", "root", "Lcom/intellij/platform/lsp/impl/documentSymbol/LspStructureViewRoot;", "lastPsiModificationCount", "", "getRoot", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "isValid", "", "initRoot", "", "isAlwaysShowsPlus", "element", "isAlwaysLeaf", "getCurrentEditorElement", "Lorg/eclipse/lsp4j/DocumentSymbol;", "A", "Lcom/intellij/platform/lsp/impl/documentSymbol/LspDocumentSymbolTreeElement;", "document", "Lcom/intellij/openapi/editor/Document;", "documentSymbols", "", "offset", "", "(Lcom/intellij/openapi/editor/Document;[Lcom/intellij/platform/lsp/impl/documentSymbol/LspDocumentSymbolTreeElement;I)Lcom/intellij/platform/lsp/impl/documentSymbol/LspDocumentSymbolTreeElement;", "intellij.platform.lsp.impl"})
public final class LspStructureViewModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider {
    @NotNull
    private final LspServerImpl lspServer;
    private LspStructureViewRoot root;
    private long lastPsiModificationCount;

    public LspStructureViewModel(@NotNull LspServerImpl lspServer, @NotNull PsiFile psiFile, @Nullable Editor editor) {
        long l2;
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        super(editor, psiFile);
        this.lspServer = lspServer;
        this.lastPsiModificationCount = -1L;
        this.lastPsiModificationCount = l2 = psiFile.getManager().getModificationTracker().getModificationCount();
        this.initRoot();
    }

    @NotNull
    public final LspServerImpl getLspServer() {
        return this.lspServer;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        LspStructureViewRoot lspStructureViewRoot = this.root;
        if (lspStructureViewRoot == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"root");
            lspStructureViewRoot = null;
        }
        return lspStructureViewRoot;
    }

    public boolean isValid() {
        return this.getPsiFile().getManager().getModificationTracker().getModificationCount() == this.lastPsiModificationCount && super.isValid();
    }

    public final void initRoot() {
        VirtualFile virtualFile = this.getPsiFile().getVirtualFile();
        LspRequestExecutorImpl lspRequestExecutorImpl = this.lspServer.getRequestExecutor();
        Intrinsics.checkNotNull((Object)virtualFile);
        List list = lspRequestExecutorImpl.getDocumentSymbolsCaching$intellij_platform_lsp_impl(virtualFile);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List list2 = list;
        PsiFile psiFile = this.getPsiFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getPsiFile(...)");
        this.root = new LspStructureViewRoot(this.lspServer, psiFile, list2);
    }

    public boolean isAlwaysShowsPlus(@Nullable StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(@Nullable StructureViewTreeElement element) {
        return false;
    }

    @Nullable
    public DocumentSymbol getCurrentEditorElement() {
        if (this.getEditor() == null) {
            return null;
        }
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null || !psiFile.isValid()) {
            return null;
        }
        int n2 = this.getEditor().getCaretModel().getOffset();
        Document document = psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        LspStructureViewRoot lspStructureViewRoot = this.root;
        if (lspStructureViewRoot == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"root");
            lspStructureViewRoot = null;
        }
        LspDocumentSymbolTreeElement lspDocumentSymbolTreeElement = this.A(document, lspStructureViewRoot.getChildren(), n2);
        return lspDocumentSymbolTreeElement != null ? lspDocumentSymbolTreeElement.getValue() : null;
    }

    private final LspDocumentSymbolTreeElement A(Document document, LspDocumentSymbolTreeElement[] lspDocumentSymbolTreeElementArray, int n2) {
        LspDocumentSymbolTreeElement[] lspDocumentSymbolTreeElementArray2 = lspDocumentSymbolTreeElementArray;
        LspDocumentSymbolTreeElement lspDocumentSymbolTreeElement = null;
        while (lspDocumentSymbolTreeElementArray2 != null) {
            LspDocumentSymbolTreeElement lspDocumentSymbolTreeElement2;
            block3: {
                LspDocumentSymbolTreeElement lspDocumentSymbolTreeElement3;
                LspDocumentSymbolTreeElement[] lspDocumentSymbolTreeElementArray3 = lspDocumentSymbolTreeElementArray2;
                int n3 = lspDocumentSymbolTreeElementArray3.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    LspDocumentSymbolTreeElement lspDocumentSymbolTreeElement4;
                    LspDocumentSymbolTreeElement lspDocumentSymbolTreeElement5 = lspDocumentSymbolTreeElement4 = lspDocumentSymbolTreeElementArray3[i2];
                    boolean bl = false;
                    Position position = lspDocumentSymbolTreeElement5.getValue().getRange().getStart();
                    Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
                    Integer n4 = Lsp4jUtilKt.getOffsetInDocument(document, position);
                    Position position2 = lspDocumentSymbolTreeElement5.getValue().getRange().getEnd();
                    Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
                    Integer n5 = Lsp4jUtilKt.getOffsetInDocument(document, position2);
                    if (!(n4 != null && n2 >= n4 && n5 != null && n2 <= n5)) continue;
                    lspDocumentSymbolTreeElement3 = lspDocumentSymbolTreeElement4;
                    break block3;
                }
                lspDocumentSymbolTreeElement3 = lspDocumentSymbolTreeElement2 = null;
            }
            if (lspDocumentSymbolTreeElement2 != null) {
                lspDocumentSymbolTreeElement = lspDocumentSymbolTreeElement2;
                lspDocumentSymbolTreeElementArray2 = lspDocumentSymbolTreeElement2.getChildren();
                continue;
            }
            lspDocumentSymbolTreeElementArray2 = null;
        }
        return lspDocumentSymbolTreeElement;
    }
}

