/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.findUsagesMl;

import com.intellij.findUsagesMl.FileRankerMlServiceImplKt;
import com.intellij.findUsagesMl.FindUsagesFileRankerAnalysisProvider;
import com.intellij.findUsagesMl.FindUsagesFileRankerFeatureCollector;
import com.intellij.findUsagesMl.FindUsagesFileRankerFeatureProvider;
import com.intellij.findUsagesMl.FindUsagesFileRankingAnalysisInfo;
import com.intellij.findUsagesMl.FindUsagesRankingFileInfo;
import com.intellij.findUsagesMl.SearchSessionData;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileRankerMlService;
import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureProvider;
import com.jetbrains.mlapi.logs.MLLogsTree;
import com.jetbrains.mlapi.logs.MLTreeLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000e\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0099\u0001\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0006\u0010&\u001a\u00020\u001d2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001d2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010,2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010,2\u0006\u0010/\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u001fH\u0002J2\u00103\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190!2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00190!H\u0002J8\u00105\u001a\b\u0012\u0004\u0012\u00020\u00190!2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190!2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00190!H\u0016J\b\u00106\u001a\u00020\u001dH\u0016J\b\u00107\u001a\u00020\u001dH\u0016J\u0018\u00108\u001a\b\u0012\u0004\u0012\u00020\u00190!2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/findUsagesMl/FileRankerMlServiceImpl;", "Lcom/intellij/psi/search/FileRankerMlService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "featureProvider", "Lcom/intellij/findUsagesMl/FindUsagesFileRankerFeatureProvider;", "analysisProvider", "Lcom/intellij/findUsagesMl/FindUsagesFileRankerAnalysisProvider;", "logger", "Lcom/jetbrains/mlapi/logs/MLTreeLogger;", "activeSessionCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "finishedSessionCounter", "sessionData", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/findUsagesMl/SearchSessionData;", "clear", "", "onSessionFinished", "project", "Lcom/intellij/openapi/project/Project;", "foundUsageFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "callSource", "Lcom/intellij/psi/search/FileRankerMlService$CallSource;", "isSessionCorrupted", "", "sessionId", "", "queryNames", "", "", "logFeatures", "file", "queryFiles", "isUsage", "recentFilesList", "timeStamp", "isSearchValid", "activeSessionId", "numberOfUsageFiles", "", "numberOfCandidates", "indexInOriginalOrder", "projectPath", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Ljava/util/List;ZLjava/util/List;JJZLjava/lang/Long;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)V", "logInvalid", "finishedSessionId", "setFiles", "candidateFiles", "getFileOrder", "isEnabled", "shouldUseOldImplementation", "getRecentFilesList", "Companion", "intellij.findUsagesMl"})
public final class FileRankerMlServiceImpl
implements FileRankerMlService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final FindUsagesFileRankerFeatureProvider featureProvider;
    @NotNull
    private final FindUsagesFileRankerAnalysisProvider analysisProvider;
    @NotNull
    private final MLTreeLogger logger;
    @NotNull
    private final AtomicLong activeSessionCounter;
    @NotNull
    private final AtomicLong finishedSessionCounter;
    @NotNull
    private final AtomicReference<SearchSessionData> sessionData;
    @NotNull
    private static final String IS_ENABLED_REGISTRY_KEY = "find.usages.ml.ranker.isEnabled";
    @NotNull
    private static final String USE_OLD_IMPL_REGISTRY_KEY = "find.usages.ml.ranker.useOldImplementation";

    public FileRankerMlServiceImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.featureProvider = new FindUsagesFileRankerFeatureProvider();
        this.analysisProvider = new FindUsagesFileRankerAnalysisProvider();
        this.logger = FindUsagesFileRankerFeatureCollector.INSTANCE.getMlLogger();
        this.activeSessionCounter = new AtomicLong(0L);
        this.finishedSessionCounter = new AtomicLong(0L);
        this.sessionData = new AtomicReference<SearchSessionData>(new SearchSessionData(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList()));
    }

    private final void clear() {
        this.sessionData.set(new SearchSessionData(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList()));
    }

    public void onSessionFinished(@Nullable Project project, @NotNull Set<? extends VirtualFile> foundUsageFiles, @NotNull FileRankerMlService.CallSource callSource) {
        Intrinsics.checkNotNullParameter(foundUsageFiles, (String)"foundUsageFiles");
        Intrinsics.checkNotNullParameter((Object)callSource, (String)"callSource");
        SearchSessionData finishedSessionData = this.sessionData.get();
        this.clear();
        long timeStamp = System.currentTimeMillis();
        List<VirtualFile> recentFilesList = this.getRecentFilesList(project);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, finishedSessionData, foundUsageFiles, recentFilesList, timeStamp, project, null){
            int label;
            final /* synthetic */ FileRankerMlServiceImpl this$0;
            final /* synthetic */ SearchSessionData $finishedSessionData;
            final /* synthetic */ Set<VirtualFile> $foundUsageFiles;
            final /* synthetic */ List<VirtualFile> $recentFilesList;
            final /* synthetic */ long $timeStamp;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$finishedSessionData = $finishedSessionData;
                this.$foundUsageFiles = $foundUsageFiles;
                this.$recentFilesList = $recentFilesList;
                this.$timeStamp = $timeStamp;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEachIndexed$iv;
                        void $this$partition$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        long sessionId = FileRankerMlServiceImpl.access$getFinishedSessionCounter$p(this.this$0).incrementAndGet();
                        if (FileRankerMlServiceImpl.access$isSessionCorrupted(this.this$0, sessionId, this.$finishedSessionData.getQueryNames())) {
                            FileRankerMlServiceImpl.access$logInvalid(this.this$0, FileRankerMlServiceImpl.access$getActiveSessionCounter$p(this.this$0).get(), sessionId);
                            long sessionFixVal = Math.max(FileRankerMlServiceImpl.access$getActiveSessionCounter$p(this.this$0).get(), FileRankerMlServiceImpl.access$getFinishedSessionCounter$p(this.this$0).get());
                            FileRankerMlServiceImpl.access$getActiveSessionCounter$p(this.this$0).set(sessionFixVal);
                            FileRankerMlServiceImpl.access$getFinishedSessionCounter$p(this.this$0).set(sessionFixVal);
                            return Unit.INSTANCE;
                        }
                        List<VirtualFile> queryFiles = this.$finishedSessionData.queryFiles();
                        List<VirtualFile> candidateFiles = this.$finishedSessionData.candidateFiles();
                        Iterable iterable = candidateFiles;
                        Set<VirtualFile> set = this.$foundUsageFiles;
                        boolean $i$f$partition = false;
                        ArrayList<T> first$iv = new ArrayList<T>();
                        ArrayList<T> second$iv = new ArrayList<T>();
                        for (T element$iv : $this$partition$iv) {
                            VirtualFile it = (VirtualFile)element$iv;
                            boolean bl = false;
                            boolean bl2 = set.contains(it) ? first$iv.add(element$iv) : second$iv.add(element$iv);
                        }
                        Pair pair = new Pair(first$iv, second$iv);
                        List candidatesWithUsage = (List)pair.component1();
                        List candidatesNoUsage = (List)pair.component2();
                        List usageSamples = FileRankerMlServiceImplKt.access$sample(candidatesWithUsage, 75);
                        List nonUsageSamples = FileRankerMlServiceImplKt.access$sample(candidatesNoUsage, 75);
                        List allSamples = CollectionsKt.plus((Collection)usageSamples, (Iterable)nonUsageSamples);
                        Iterable iterable2 = allSamples;
                        FileRankerMlServiceImpl fileRankerMlServiceImpl = this.this$0;
                        SearchSessionData searchSessionData = this.$finishedSessionData;
                        Set<VirtualFile> set2 = this.$foundUsageFiles;
                        List<VirtualFile> list = this.$recentFilesList;
                        long l = this.$timeStamp;
                        Project project = this.$project;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (T item$iv : $this$forEachIndexed$iv) {
                            void it;
                            int n;
                            if ((n = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            VirtualFile virtualFile = (VirtualFile)item$iv;
                            int index = n;
                            boolean bl = false;
                            List<String> list2 = searchSessionData.getQueryNames();
                            boolean bl3 = set2.contains(it);
                            Integer n2 = Boxing.boxInt((int)candidatesWithUsage.size());
                            Integer n3 = Boxing.boxInt((int)candidateFiles.size());
                            Integer n4 = Boxing.boxInt((int)index);
                            Object object = project;
                            if (object == null || (object = object.getBasePath()) == null) {
                                object = "";
                            }
                            FileRankerMlServiceImpl.logFeatures$default(fileRankerMlServiceImpl, (VirtualFile)it, list2, queryFiles, bl3, list, l, sessionId, true, null, n2, n3, n4, (String)object, 256, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final boolean isSessionCorrupted(long sessionId, List<String> queryNames) {
        return this.activeSessionCounter.get() != sessionId || queryNames.isEmpty();
    }

    private final void logFeatures(VirtualFile file, List<String> queryNames, List<? extends VirtualFile> queryFiles, boolean isUsage, List<? extends VirtualFile> recentFilesList, long timeStamp, long sessionId, boolean isSearchValid, Long activeSessionId, Integer numberOfUsageFiles, Integer numberOfCandidates, Integer indexInOriginalOrder, String projectPath) {
        List<Feature> list = this.analysisProvider.provideAnalysisTargets(new FindUsagesFileRankingAnalysisInfo(sessionId, isUsage, timeStamp, isSearchValid, numberOfUsageFiles, numberOfCandidates, indexInOriginalOrder, activeSessionId, (Long)sessionId));
        Collection collection = FeatureProvider.provideFeatures$default((FeatureProvider)this.featureProvider, (Object)new FindUsagesRankingFileInfo(queryNames, queryFiles, file, recentFilesList, timeStamp, projectPath), null, (int)2, null);
        MLLogsTree tree = new MLLogsTree(collection, (Collection)list, null, 4, null);
        this.logger.log(tree);
    }

    static /* synthetic */ void logFeatures$default(FileRankerMlServiceImpl fileRankerMlServiceImpl, VirtualFile virtualFile, List list, List list2, boolean bl, List list3, long l, long l2, boolean bl2, Long l3, Integer n, Integer n2, Integer n3, String string, int n4, Object object) {
        if ((n4 & 0x100) != 0) {
            l3 = null;
        }
        if ((n4 & 0x200) != 0) {
            n = null;
        }
        if ((n4 & 0x400) != 0) {
            n2 = null;
        }
        if ((n4 & 0x800) != 0) {
            n3 = null;
        }
        fileRankerMlServiceImpl.logFeatures(virtualFile, list, list2, bl, list3, l, l2, bl2, l3, n, n2, n3, string);
    }

    private final void logInvalid(long activeSessionId, long finishedSessionId) {
        FileRankerMlServiceImpl.logFeatures$default(this, null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), false, CollectionsKt.emptyList(), System.currentTimeMillis(), finishedSessionId, false, activeSessionId, null, null, null, "", 3584, null);
    }

    private final void setFiles(List<String> queryNames, List<? extends VirtualFile> queryFiles, List<? extends VirtualFile> candidateFiles) {
        this.sessionData.set(new SearchSessionData(queryNames, queryFiles, candidateFiles));
    }

    @NotNull
    public List<VirtualFile> getFileOrder(@NotNull List<String> queryNames, @NotNull List<? extends VirtualFile> queryFiles, @NotNull List<? extends VirtualFile> candidateFiles) {
        Intrinsics.checkNotNullParameter(queryNames, (String)"queryNames");
        Intrinsics.checkNotNullParameter(queryFiles, (String)"queryFiles");
        Intrinsics.checkNotNullParameter(candidateFiles, (String)"candidateFiles");
        this.activeSessionCounter.incrementAndGet();
        this.setFiles(queryNames, queryFiles, candidateFiles);
        return candidateFiles;
    }

    public boolean isEnabled() {
        Application app = ApplicationManager.getApplication();
        return !app.isUnitTestMode() && app.isEAP() && Registry.Companion.is(IS_ENABLED_REGISTRY_KEY, false);
    }

    public boolean shouldUseOldImplementation() {
        return Registry.Companion.is(USE_OLD_IMPL_REGISTRY_KEY, false);
    }

    private final List<VirtualFile> getRecentFilesList(Project project) {
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        return EditorHistoryManager.Companion.getInstance(project).getFileList();
    }

    public static final /* synthetic */ AtomicLong access$getFinishedSessionCounter$p(FileRankerMlServiceImpl $this) {
        return $this.finishedSessionCounter;
    }

    public static final /* synthetic */ boolean access$isSessionCorrupted(FileRankerMlServiceImpl $this, long sessionId, List queryNames) {
        return $this.isSessionCorrupted(sessionId, queryNames);
    }

    public static final /* synthetic */ void access$logInvalid(FileRankerMlServiceImpl $this, long activeSessionId, long finishedSessionId) {
        $this.logInvalid(activeSessionId, finishedSessionId);
    }

    public static final /* synthetic */ AtomicLong access$getActiveSessionCounter$p(FileRankerMlServiceImpl $this) {
        return $this.activeSessionCounter;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/findUsagesMl/FileRankerMlServiceImpl$Companion;", "", "<init>", "()V", "IS_ENABLED_REGISTRY_KEY", "", "USE_OLD_IMPL_REGISTRY_KEY", "intellij.findUsagesMl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

