/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.fileTree;

import com.intellij.docker.ui.fileTree.FileSystemNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/ui/fileTree/RemoteFileSystemNodeDescriptor;", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/docker/ui/fileTree/FileSystemNode;", "parentDescriptor", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/docker/ui/fileTree/FileSystemNode;Lcom/intellij/ide/util/treeView/NodeDescriptor;)V", "update", "", "getElement", "intellij.clouds.docker"})
public final class RemoteFileSystemNodeDescriptor
extends NodeDescriptor<Object> {
    @NotNull
    private final FileSystemNode element;

    public RemoteFileSystemNodeDescriptor(@NotNull Project project, @NotNull FileSystemNode element, @Nullable NodeDescriptor<?> parentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
        super(project, parentDescriptor);
        this.element = element;
        String string = (String)this.element.getValue();
        if (string == null) {
            string = "Unknown";
        }
        this.myName = string;
    }

    public boolean update() {
        if (this.element.isDirectory()) {
            this.setIcon(AllIcons.Nodes.Folder);
        } else if (this.element.isSymLink()) {
            this.setIcon(AllIcons.Nodes.Symlink);
        } else {
            this.setIcon(FileTypeManagerEx.getInstanceEx().getFileTypeByFileName(this.element.getFileTreePath().getPath().getFileName()).getIcon());
        }
        return true;
    }

    @NotNull
    public Object getElement() {
        return this.element;
    }
}

