/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyClosurePattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleMiscContributor;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleMethodContextContributor;", "<init>", "()V", "getDelegatesToInfo", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "process", "", "methodCallInfo", "", "", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleMiscContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleMiscContributor.kt\norg/jetbrains/plugins/gradle/service/resolve/GradleMiscContributor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,109:1\n19#2:110\n*S KotlinDebug\n*F\n+ 1 GradleMiscContributor.kt\norg/jetbrains/plugins/gradle/service/resolve/GradleMiscContributor\n*L\n72#1:110\n*E\n"})
public final class GradleMiscContributor
implements GradleMethodContextContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final GroovyClosurePattern useJUnitClosure;
    @NotNull
    private static final GroovyClosurePattern testLoggingClosure;
    @NotNull
    private static final GroovyClosurePattern downloadClosure;
    @NotNull
    private static final GroovyClosurePattern domainCollectionWithTypeClosure;
    @NotNull
    private static final GroovyClosurePattern manifestClosure;
    @NotNull
    public static final String downloadSpecFqn = "de.undercouch.gradle.tasks.download.DownloadSpec";
    @NotNull
    public static final String pluginDependenciesSpecFqn = "org.gradle.plugin.use.PluginDependenciesSpec";

    @Override
    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrClosableBlock closure) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        if (useJUnitClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.tasks.testing.junit.JUnitOptions", (PsiElement)((PsiElement)closure)), 1);
        }
        if (testLoggingClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.tasks.testing.logging.TestLoggingContainer", (PsiElement)((PsiElement)closure)), 1);
        }
        if (downloadClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)downloadSpecFqn, (PsiElement)((PsiElement)closure)), 1);
        }
        if (manifestClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.java.archives.Manifest", (PsiElement)((PsiElement)closure)), 1);
        }
        PsiElement parent = closure.getParent();
        if (domainCollectionWithTypeClosure.accepts((Object)closure) && parent instanceof GrMethodCallExpression) {
            PsiElement psiElement;
            GroovyPsiElement[] groovyPsiElementArray = ((GrMethodCallExpression)parent).getArgumentList().getAllArguments();
            Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementArray, (String)"getAllArguments(...)");
            GroovyPsiElement groovyPsiElement = (GroovyPsiElement)ArraysKt.singleOrNull((Object[])groovyPsiElementArray);
            PsiElement psiElement2 = groovyPsiElement != null && (groovyPsiElement = groovyPsiElement.getReference()) != null ? groovyPsiElement.resolve() : (psiElement = null);
            if (psiElement instanceof PsiClass) {
                return new DelegatesToInfo((PsiType)TypesUtil.createType((String)((PsiClass)psiElement).getQualifiedName(), (PsiElement)((PsiElement)closure)), 1);
            }
        }
        if (parent instanceof GrMethodCall) {
            PsiType returnType;
            PsiType closureParameter;
            GroovyResolveResult $this$asSafely$iv = ((GrMethodCall)parent).advancedResolve();
            boolean $i$f$asSafely = false;
            GroovyResolveResult groovyResolveResult = $this$asSafely$iv;
            if (!(groovyResolveResult instanceof GroovyMethodResult)) {
                groovyResolveResult = null;
            }
            GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
            if (groovyMethodResult == null) {
                return null;
            }
            GroovyMethodResult methodResult = groovyMethodResult;
            GroovyMethodCandidate groovyMethodCandidate = methodResult.getCandidate();
            PsiType psiType = closureParameter = groovyMethodCandidate != null && (groovyMethodCandidate = groovyMethodCandidate.getArgumentMapping()) != null ? groovyMethodCandidate.expectedType((Argument)new ExpressionArgument((GrExpression)closure)) : null;
            boolean bl = psiType != null ? psiType.equalsToText("groovy.lang.Closure") : false;
            if (bl && !((returnType = methodResult.getSubstitutor().substitute(methodResult.getElement().getReturnType())) instanceof PsiPrimitiveType)) {
                return new DelegatesToInfo(returnType, 1);
            }
        }
        return null;
    }

    @Override
    public boolean process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter(methodCallInfo, (String)"methodCallInfo");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        boolean shouldProcessMethods = ResolveUtil.shouldProcessMethods((ElementClassHint)classHint);
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        GlobalSearchScope globalSearchScope = place.getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
        GlobalSearchScope resolveScope = globalSearchScope;
        if (shouldProcessMethods) {
            PsiElement psiElement = place.getParent();
            if ((psiElement != null ? psiElement.getParent() : null) instanceof GroovyFile && Intrinsics.areEqual((Object)place.getText(), (Object)"plugins")) {
                GrLightMethodBuilder grLightMethodBuilder;
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass(pluginDependenciesSpecFqn, resolveScope);
                if (psiClass == null) {
                    return true;
                }
                PsiClass pluginsDependenciesClass = psiClass;
                PsiClassType psiClassType = groovyPsiManager.createTypeByFQClassName(pluginDependenciesSpecFqn, resolveScope);
                if (psiClassType == null) {
                    return true;
                }
                PsiClassType returnClass = psiClassType;
                GrLightMethodBuilder $this$process_u24lambda_u240 = grLightMethodBuilder = new GrLightMethodBuilder(place.getManager(), "plugins");
                boolean bl = false;
                $this$process_u24lambda_u240.setContainingClass(pluginsDependenciesClass);
                $this$process_u24lambda_u240.setReturnType((PsiType)returnClass);
                GrLightMethodBuilder methodBuilder = grLightMethodBuilder;
                methodBuilder.addAndGetParameter("configuration", "groovy.lang.Closure").putUserData(GrDelegatesToUtilKt.DELEGATES_TO_TYPE_KEY, (Object)pluginDependenciesSpecFqn);
                if (!processor.execute((PsiElement)methodBuilder, state)) {
                    return false;
                }
            }
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)domainCollectionWithTypeClosure)).accepts((Object)place)) {
            // empty if block
        }
        return true;
    }

    static {
        String[] stringArray = new String[]{"useJUnit"};
        useJUnitClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.tasks.testing.Test", (String[])stringArray));
        stringArray = new String[]{"testLogging"};
        testLoggingClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.tasks.testing.Test", (String[])stringArray));
        stringArray = new String[]{"download"};
        downloadClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.Project", (String[])stringArray));
        stringArray = new String[]{"withType"};
        domainCollectionWithTypeClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.DomainObjectCollection", (String[])stringArray));
        stringArray = new String[]{"manifest"};
        manifestClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.jvm.tasks.Jar", (String[])stringArray));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleMiscContributor$Companion;", "", "<init>", "()V", "useJUnitClosure", "Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "getUseJUnitClosure", "()Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "testLoggingClosure", "getTestLoggingClosure", "downloadClosure", "getDownloadClosure", "domainCollectionWithTypeClosure", "getDomainCollectionWithTypeClosure", "manifestClosure", "getManifestClosure", "downloadSpecFqn", "", "pluginDependenciesSpecFqn", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GroovyClosurePattern getUseJUnitClosure() {
            return useJUnitClosure;
        }

        @NotNull
        public final GroovyClosurePattern getTestLoggingClosure() {
            return testLoggingClosure;
        }

        @NotNull
        public final GroovyClosurePattern getDownloadClosure() {
            return downloadClosure;
        }

        @NotNull
        public final GroovyClosurePattern getDomainCollectionWithTypeClosure() {
            return domainCollectionWithTypeClosure;
        }

        @NotNull
        public final GroovyClosurePattern getManifestClosure() {
            return manifestClosure;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

