/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui;

import com.intellij.jpa.jpb.model.ui.JpbColor;
import com.intellij.jpa.jpb.model.ui.entity.EntityAttributeContext;
import com.intellij.re.msg.ReBundle;
import com.intellij.re.ui.AttrMappingType;
import com.intellij.re.ui.DbColumnTreeNode;
import com.intellij.re.ui.DbColumnsTable;
import com.intellij.re.ui.MappingTypeTableCellEditor;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0016J\f\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/re/ui/MappingTypeInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "Lcom/intellij/re/ui/AttrMappingType;", "entityPackageName", "", "myContext", "Lcom/intellij/jpa/jpb/model/ui/entity/EntityAttributeContext;", "<init>", "(Ljava/lang/String;Lcom/intellij/jpa/jpb/model/ui/entity/EntityAttributeContext;)V", "getMyContext", "()Lcom/intellij/jpa/jpb/model/ui/entity/EntityAttributeContext;", "cellEditor", "Lcom/intellij/re/ui/MappingTypeTableCellEditor;", "getCellEditor", "()Lcom/intellij/re/ui/MappingTypeTableCellEditor;", "cellEditor$delegate", "Lkotlin/Lazy;", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "getColumnClass", "Ljava/lang/Class;", "getEditor", "Ljavax/swing/table/TableCellEditor;", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "intellij.javaee.reverseEngineering"})
public final class MappingTypeInfo
extends ColumnInfo<DefaultMutableTreeNode, AttrMappingType> {
    @NotNull
    private final String entityPackageName;
    @NotNull
    private final EntityAttributeContext myContext;
    @NotNull
    private final Lazy cellEditor$delegate;

    public MappingTypeInfo(@NotNull String entityPackageName, @NotNull EntityAttributeContext myContext) {
        Intrinsics.checkNotNullParameter((Object)entityPackageName, (String)"entityPackageName");
        Intrinsics.checkNotNullParameter((Object)myContext, (String)"myContext");
        super(ReBundle.message("column.name.mapping.type", new Object[0]));
        this.entityPackageName = entityPackageName;
        this.myContext = myContext;
        this.cellEditor$delegate = LazyKt.lazy(() -> MappingTypeInfo.cellEditor_delegate$lambda$0(this));
    }

    @NotNull
    public final EntityAttributeContext getMyContext() {
        return this.myContext;
    }

    private final MappingTypeTableCellEditor getCellEditor() {
        Lazy lazy = this.cellEditor$delegate;
        return (MappingTypeTableCellEditor)lazy.getValue();
    }

    @Nullable
    public AttrMappingType valueOf(@Nullable DefaultMutableTreeNode item) {
        DbColumnTreeNode dbColumnTreeNode = item instanceof DbColumnTreeNode ? (DbColumnTreeNode)((Object)item) : null;
        return dbColumnTreeNode != null ? dbColumnTreeNode.getAttrMappingType() : null;
    }

    public boolean isCellEditable(@Nullable DefaultMutableTreeNode item) {
        DbColumnTreeNode dbColumnTreeNode = item instanceof DbColumnTreeNode ? (DbColumnTreeNode)((Object)item) : null;
        return dbColumnTreeNode != null ? dbColumnTreeNode.isEnabled() : false;
    }

    public void setValue(@Nullable DefaultMutableTreeNode item, @Nullable AttrMappingType value) {
        block0: {
            DbColumnTreeNode dbColumnTreeNode = item instanceof DbColumnTreeNode ? (DbColumnTreeNode)((Object)item) : null;
            if (dbColumnTreeNode == null) break block0;
            dbColumnTreeNode.setAttrMappingType(value);
        }
    }

    @NotNull
    public Class<?> getColumnClass() {
        return AttrMappingType.class;
    }

    @NotNull
    public TableCellEditor getEditor(@Nullable DefaultMutableTreeNode item) {
        this.getCellEditor().setDbColumn(item instanceof DbColumnTreeNode ? (DbColumnTreeNode)((Object)item) : null);
        return this.getCellEditor();
    }

    @NotNull
    public TableCellRenderer getRenderer(@Nullable DefaultMutableTreeNode item) {
        return (TableCellRenderer)new ColoredTableCellRenderer(this){
            final /* synthetic */ MappingTypeInfo this$0;
            {
                this.this$0 = $receiver;
            }

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                SimpleTextAttributes simpleTextAttributes;
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                Object object = table instanceof DbColumnsTable ? (DbColumnsTable)((Object)table) : null;
                if (object == null || (object = object.getDbColumn(row)) == null) {
                    return;
                }
                Object selectedColumn = object;
                AttrMappingType attrMappingType = ((DbColumnTreeNode)((Object)selectedColumn)).getAttrMappingType();
                if (attrMappingType == AttrMappingType.Todo) {
                    simpleTextAttributes = new SimpleTextAttributes(0, JpbColor.YELLOW);
                } else {
                    SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    simpleTextAttributes = simpleTextAttributes2;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
                }
                SimpleTextAttributes textStyle = simpleTextAttributes;
                Object object2 = attrMappingType;
                if (object2 == null || (object2 = object2.toLabel(this.this$0.getMyContext().getOrmFramework())) == null) {
                    object2 = "";
                }
                this.append((String)object2, textStyle);
            }
        };
    }

    private static final MappingTypeTableCellEditor cellEditor_delegate$lambda$0(MappingTypeInfo this$0) {
        return new MappingTypeTableCellEditor(this$0.entityPackageName, this$0.myContext);
    }
}

