/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.future.ShouldBeCancelled;
import org.assertj.core.error.future.ShouldBeCompletedWithin;
import org.assertj.core.error.future.ShouldBeDone;
import org.assertj.core.error.future.ShouldHaveCompletedExceptionallyWithin;
import org.assertj.core.error.future.ShouldHaveFailedWithin;
import org.assertj.core.error.future.ShouldNotBeCancelled;
import org.assertj.core.error.future.ShouldNotBeDone;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;

public class Futures {
    private static final Futures INSTANCE = new Futures();
    Failures failures = Failures.instance();

    public static Futures instance() {
        return INSTANCE;
    }

    public void assertIsCancelled(AssertionInfo info, Future<?> actual) {
        this.assertNotNull(info, actual);
        if (!actual.isCancelled()) {
            throw this.failures.failure(info, ShouldBeCancelled.shouldBeCancelled(actual));
        }
    }

    public void assertIsNotCancelled(AssertionInfo info, Future<?> actual) {
        this.assertNotNull(info, actual);
        if (actual.isCancelled()) {
            throw this.failures.failure(info, ShouldNotBeCancelled.shouldNotBeCancelled(actual));
        }
    }

    public void assertIsDone(AssertionInfo info, Future<?> actual) {
        this.assertNotNull(info, actual);
        if (!actual.isDone()) {
            throw this.failures.failure(info, ShouldBeDone.shouldBeDone(actual));
        }
    }

    public void assertIsNotDone(AssertionInfo info, Future<?> actual) {
        this.assertNotNull(info, actual);
        if (actual.isDone()) {
            throw this.failures.failure(info, ShouldNotBeDone.shouldNotBeDone(actual));
        }
    }

    public <RESULT> RESULT assertSucceededWithin(AssertionInfo info, Future<RESULT> actual, long timeout, TimeUnit unit) {
        this.assertNotNull(info, actual);
        try {
            return actual.get(timeout, unit);
        }
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
            throw this.failures.failure(info, ShouldBeCompletedWithin.shouldBeCompletedWithin(actual, timeout, unit, e));
        }
    }

    public <RESULT> RESULT assertSucceededWithin(AssertionInfo info, Future<RESULT> actual, Duration timeout) {
        this.assertNotNull(info, actual);
        try {
            return actual.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
            throw this.failures.failure(info, ShouldBeCompletedWithin.shouldBeCompletedWithin(actual, timeout, e));
        }
    }

    public Exception assertFailedWithin(AssertionInfo info, Future<?> actual, Duration timeout) {
        this.assertNotNull(info, actual);
        try {
            actual.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
            throw this.failures.failure(info, ShouldHaveFailedWithin.shouldHaveFailedWithin(actual, timeout));
        }
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
            return e;
        }
    }

    public Exception assertFailedWithin(AssertionInfo info, Future<?> actual, long timeout, TimeUnit unit) {
        this.assertNotNull(info, actual);
        try {
            actual.get(timeout, unit);
            throw this.failures.failure(info, ShouldHaveFailedWithin.shouldHaveFailedWithin(actual, timeout, unit));
        }
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
            return e;
        }
    }

    public Exception assertCompletedExceptionallyWithin(AssertionInfo info, Future<?> actual, Duration timeout) {
        this.assertNotNull(info, actual);
        try {
            actual.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
            throw this.failures.failure(info, ShouldHaveCompletedExceptionallyWithin.shouldHaveCompletedExceptionallyWithin(actual, timeout));
        }
        catch (CancellationException | ExecutionException e) {
            return e;
        }
        catch (InterruptedException | TimeoutException e) {
            throw this.failures.failure(info, ShouldHaveCompletedExceptionallyWithin.shouldHaveCompletedExceptionallyWithin(actual, timeout));
        }
    }

    public Exception assertCompletedExceptionallyWithin(AssertionInfo info, Future<?> actual, long timeout, TimeUnit unit) {
        this.assertNotNull(info, actual);
        try {
            actual.get(timeout, unit);
            throw this.failures.failure(info, ShouldHaveCompletedExceptionallyWithin.shouldHaveCompletedExceptionallyWithin(actual, timeout, unit));
        }
        catch (CancellationException | ExecutionException e) {
            return e;
        }
        catch (InterruptedException | TimeoutException e) {
            throw this.failures.failure(info, ShouldHaveCompletedExceptionallyWithin.shouldHaveCompletedExceptionallyWithin(actual, timeout, unit));
        }
    }

    private void assertNotNull(AssertionInfo info, Future<?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }
}

