/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspSelectionRangeCustomizer;
import com.intellij.platform.lsp.api.customization.LspSelectionRangeSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SelectionRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J0\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/lsp/impl/selectWord/LspWordSelectionHandler;", "Lcom/intellij/codeInsight/editorActions/ExtendWordSelectionHandler;", "LspWordSelectionHandler", "()V", "canSelect", "", "e", "Lcom/intellij/psi/PsiElement;", "select", "", "Lcom/intellij/openapi/util/TextRange;", "editorText", "", "cursorOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "F", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "F", "document", "Lcom/intellij/openapi/editor/Document;", "selectionRange", "Lorg/eclipse/lsp4j/SelectionRange;", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspWordSelectionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspWordSelectionHandler.kt\ncom/intellij/platform/lsp/impl/selectWord/LspWordSelectionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n774#2:74\n865#2,2:75\n1374#2:77\n1460#2,5:78\n*S KotlinDebug\n*F\n+ 1 LspWordSelectionHandler.kt\ncom/intellij/platform/lsp/impl/selectWord/LspWordSelectionHandler\n*L\n39#1:74\n39#1:75,2\n45#1:77\n45#1:78,5\n*E\n"})
public final class LspWordSelectionHandler
implements ExtendWordSelectionHandler {
    public boolean canSelect(@NotNull PsiElement e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        return true;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public List<TextRange> select(@NotNull PsiElement e2, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)editorText, (String)"editorText");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiFile psiFile = e2.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 instanceof VirtualFileWindow || !virtualFile2.isInLocalFileSystem()) {
            return null;
        }
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable iterable = LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            LspServerImpl lspServerImpl = (LspServerImpl)t10;
            boolean bl3 = false;
            if (!this.F(lspServerImpl, virtualFile2)) continue;
            collection.add(t10);
        }
        List list = (List)collection;
        if (list.isEmpty()) {
            return null;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        iterable = document;
        Position position = Lsp4jUtilKt.getLsp4jPosition((Document)iterable, cursorOffset);
        iterable2 = list;
        boolean bl4 = false;
        Iterable iterable3 = iterable2;
        Collection collection2 = new ArrayList();
        boolean bl5 = false;
        for (Object e3 : iterable3) {
            Object object;
            block10: {
                block9: {
                    LspServerImpl lspServerImpl = (LspServerImpl)e3;
                    boolean bl6 = false;
                    object = lspServerImpl.getRequestExecutor().getSelectionRangeCaching$intellij_platform_lsp_impl(virtualFile2, position);
                    if (object == null) break block9;
                    SelectionRange selectionRange = object;
                    boolean bl7 = false;
                    List<TextRange> list2 = this.F((Document)iterable, selectionRange);
                    object = list2;
                    if (list2 != null) break block10;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable iterable4 = (Iterable)object;
            CollectionsKt.addAll((Collection)collection2, (Iterable)iterable4);
        }
        return (List)collection2;
    }

    private final boolean F(LspServerImpl lspServerImpl, VirtualFile virtualFile) {
        LspSelectionRangeCustomizer lspSelectionRangeCustomizer = lspServerImpl.getDescriptor().getLspCustomization().getSelectionRangeCustomizer();
        return lspSelectionRangeCustomizer instanceof LspSelectionRangeSupport && lspServerImpl.supportsSelectionRange$intellij_platform_lsp_impl(virtualFile) && ((LspSelectionRangeSupport)lspSelectionRangeCustomizer).shouldAskServerForSelectionRange(virtualFile);
    }

    private final List<TextRange> F(Document document, SelectionRange selectionRange) {
        ArrayList<TextRange> arrayList = new ArrayList<TextRange>();
        for (SelectionRange selectionRange2 = selectionRange; selectionRange2 != null; selectionRange2 = selectionRange2.getParent()) {
            Range range = selectionRange2.getRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
            TextRange textRange = Lsp4jUtilKt.getRangeInDocument(document, range);
            if (textRange == null || !arrayList.isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.last((List)arrayList), (Object)textRange)) continue;
            arrayList.add(textRange);
        }
        return arrayList;
    }
}

