/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.spring.data.jpa.SpringDateEntityUtilsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JpaEntityIdTypeMacro
extends Macro {
    @NonNls
    public String getName() {
        return "jpaEntityIdType";
    }

    public String getPresentableName() {
        return "jpaEntityIdType(entityClass)";
    }

    public Result calculateResult(Expression @NotNull [] expressions, ExpressionContext expressionContext) {
        PsiClass psiClass;
        PsiTypeResult psiTypeResult;
        PsiType psiType;
        Result result;
        if (expressions == null) {
            JpaEntityIdTypeMacro.$$$reportNull$$$0(0);
        }
        if ((result = expressions[0].calculateResult(expressionContext)) == null) {
            return null;
        }
        if (result instanceof PsiTypeResult && (psiType = (psiTypeResult = (PsiTypeResult)result).getType()) instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            psiClass = psiClassType.resolve();
            if (psiClass == null) {
                return null;
            }
            return new TextResult(JpaEntityIdTypeMacro.getIdClassFqn(psiClass));
        }
        if (result instanceof TextResult) {
            TextResult textResult = (TextResult)result;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)expressionContext.getProject());
            psiClass = psiFacade.findClass(textResult.getText(), expressionContext.getPsiElementAtStartOffset().getResolveScope());
            if (psiClass == null) {
                return null;
            }
            return new TextResult(JpaEntityIdTypeMacro.getIdClassFqn(psiClass));
        }
        return null;
    }

    private static String getIdClassFqn(PsiClass psiClass) {
        OrmEntity ormEntity = OrmSearcher.Companion.getAllForProject(psiClass.getProject()).stream().map(provider -> provider.findEntityForClass(psiClass)).filter(o -> o != null).findFirst().orElse(null);
        String idClass = SpringDateEntityUtilsKt.entityIdClass(ormEntity, psiClass);
        return idClass != null ? ((TemplateHelper)TemplateHelper.Companion.getInstance((PsiElement)psiClass)).convertType(idClass, psiClass.getProject()) : "PK";
    }

    public Result calculateQuickResult(Expression @NotNull [] expressions, ExpressionContext expressionContext) {
        if (expressions == null) {
            JpaEntityIdTypeMacro.$$$reportNull$$$0(1);
        }
        return this.calculateResult(expressions, expressionContext);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expressions";
        objectArray2[1] = "com/intellij/spring/data/jpa/template/macro/JpaEntityIdTypeMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateQuickResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

