/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.java;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.java.VelocityNamingUtil;
import com.intellij.velocity.java.reference.VtlPsiReferenceExpression;
import com.intellij.velocity.psi.VtlDirectiveHeader;
import com.intellij.velocity.psi.VtlInterpolation;
import com.intellij.velocity.psi.VtlLoopVariable;
import com.intellij.velocity.psi.VtlMethodCallExpression;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.directives.VtlAssignment;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class TypeInferenceUtil {
    @NotNull
    public static Collection<String> inferVariableType(@NotNull VtlVariable variable) {
        if (variable == null) {
            TypeInferenceUtil.$$$reportNull$$$0(0);
        }
        return TypeInferenceUtil.inferVariableType((Query<? extends PsiReference>)ReferencesSearch.search((PsiElement)variable));
    }

    @NotNull
    public static Collection<String> inferVariableType(Query<? extends PsiReference> query) {
        final Ref intersection = Ref.create(null);
        query.forEach((Processor)new Processor<PsiReference>(){
            private boolean myIterableType = false;

            public boolean process(PsiReference psiReference) {
                if (!(psiReference instanceof VtlPsiReferenceExpression)) {
                    return true;
                }
                VtlPsiReferenceExpression reference = (VtlPsiReferenceExpression)psiReference;
                VtlPsiReferenceExpression parentReference = reference.getParentReferenceExpression();
                if (!this.myIterableType && parentReference != null && StringUtil.isNotEmpty((String)parentReference.getReferenceName())) {
                    Set<String> classes = TypeInferenceUtil.suggestClassesWithMember(parentReference);
                    TypeInferenceUtil.intersect(classes, (Ref<Set<String>>)intersection);
                    return true;
                }
                PsiElement ancestor = reference.getParent();
                if (!(ancestor instanceof VtlInterpolation)) {
                    return true;
                }
                if (!((ancestor = ancestor.getParent()) instanceof VtlDirectiveHeader)) {
                    return true;
                }
                VtlLoopVariable loopVariable = ((VtlDirectiveHeader)ancestor).findChildByClass(VtlLoopVariable.class);
                if (loopVariable == null) {
                    return true;
                }
                HashSet<String> typeNames = new HashSet<String>();
                for (String typeName : TypeInferenceUtil.inferVariableType(loopVariable)) {
                    ContainerUtil.addAll(typeNames, (Object[])VtlLoopVariable.getVelocityIterables(typeName));
                }
                if (!this.myIterableType && !typeNames.isEmpty()) {
                    this.myIterableType = true;
                    if (!intersection.isNull()) {
                        intersection.set(null);
                    }
                }
                TypeInferenceUtil.intersect(typeNames, (Ref<Set<String>>)intersection);
                return true;
            }
        });
        Collection<String> collection = intersection.isNull() ? Collections.emptySet() : (Collection)intersection.get();
        if (collection == null) {
            TypeInferenceUtil.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public static Set<String> suggestClassesWithMember(VtlReferenceExpression reference) {
        String[] accessors;
        if (!(reference instanceof PsiReference)) {
            return Collections.emptySet();
        }
        PsiReference psiReference = (PsiReference)reference;
        PsiFile file = psiReference.getElement().getContainingFile();
        String referenceName = reference.getReferenceName();
        HashSet<String> classes = new HashSet<String>();
        PsiElement parent = reference.getParent();
        if (parent instanceof VtlMethodCallExpression) {
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, classes, (boolean)true, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, classes, (boolean)true, (boolean)true);
            return classes;
        }
        if (parent instanceof VtlAssignment) {
            accessors = VelocityNamingUtil.suggestSetterNames(referenceName);
        } else if (parent instanceof VtlInterpolation) {
            accessors = VelocityNamingUtil.suggestGetterNames(referenceName);
        } else {
            return classes;
        }
        for (String accessor : accessors) {
            CreateFromUsageUtils.addClassesWithMember((String)accessor, (PsiFile)file, classes, (boolean)true, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)accessor, (PsiFile)file, classes, (boolean)true, (boolean)true);
        }
        return classes;
    }

    private static void intersect(Set<String> classes, Ref<Set<String>> to) {
        if (to.isNull()) {
            to.set(classes);
        } else {
            ((Set)to.get()).retainAll(classes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/java/TypeInferenceUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/java/TypeInferenceUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "inferVariableType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferVariableType";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

