/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.tooltips;

import com.jetbrains.rd.ide.model.NotCalculatedTooltipModel;
import com.jetbrains.rd.ide.model.TooltipModel;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH&J\u0006\u0010\u0010\u001a\u00020\rJ(\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipCalculator;", "", "modelId", "", "provider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "<init>", "(JLcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;)V", "requested", "Ljava/util/concurrent/atomic/AtomicBoolean;", "tooltipTimestamp", "", "updateData", "", "tooltipModel", "Lcom/jetbrains/rd/ide/model/TooltipModel;", "calculateTooltip", "applyUpdateWithRetry", "model", "currentTimestamp", "retry", "Companion", "intellij.rd.client"})
public abstract class FrontendTooltipCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long modelId;
    @NotNull
    private final FrontendTooltipProvider provider;
    @NotNull
    private final AtomicBoolean requested;
    private int tooltipTimestamp;
    private static final int CALCULATION_RETRY_LIMIT = 10;

    public FrontendTooltipCalculator(long modelId, @NotNull FrontendTooltipProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        this.modelId = modelId;
        this.provider = provider2;
        this.requested = new AtomicBoolean();
        this.tooltipTimestamp = -1;
    }

    public abstract void updateData(@Nullable TooltipModel var1);

    public final void calculateTooltip() {
        if (this.modelId < 0L) {
            return;
        }
        int currentTimestamp = this.provider.getCurrentTimestamp();
        if (this.tooltipTimestamp == currentTimestamp) {
            return;
        }
        if (!this.requested.compareAndSet(false, true)) {
            return;
        }
        this.tooltipTimestamp = currentTimestamp;
        this.updateData(null);
        this.provider.requestTooltip(this.modelId, (Function1<? super TooltipModel, Unit>)((Function1)arg_0 -> FrontendTooltipCalculator.calculateTooltip$lambda$0(this, currentTimestamp, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyUpdateWithRetry(TooltipModel model2, FrontendTooltipProvider provider2, int currentTimestamp, int retry) {
        try {
            if (currentTimestamp == provider2.getCurrentTimestamp() && !(model2 instanceof NotCalculatedTooltipModel)) {
                this.updateData(model2);
            } else {
                if (retry <= 0) {
                    this.updateData(model2);
                    return;
                }
                this.updateData(model2);
                provider2.requestTooltip(this.modelId, (Function1<? super TooltipModel, Unit>)((Function1)arg_0 -> FrontendTooltipCalculator.applyUpdateWithRetry$lambda$0(this, model2, provider2, retry, arg_0)));
                this.tooltipTimestamp = -1;
            }
        }
        finally {
            this.requested.set(false);
        }
    }

    private static final Unit calculateTooltip$lambda$0(FrontendTooltipCalculator this$0, int $currentTimestamp, TooltipModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.applyUpdateWithRetry(it, this$0.provider, $currentTimestamp, 10);
        return Unit.INSTANCE;
    }

    private static final Unit applyUpdateWithRetry$lambda$0(FrontendTooltipCalculator this$0, TooltipModel $model, FrontendTooltipProvider $provider, int $retry, TooltipModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.applyUpdateWithRetry($model, $provider, $provider.getCurrentTimestamp(), $retry - 1);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipCalculator$Companion;", "", "<init>", "()V", "CALCULATION_RETRY_LIMIT", "", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

