/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenSettingsCache;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R-\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenRemoteRepositoriesConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "<init>", "()V", "COLLECTED_REPOSITORIES", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "beforeModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "afterModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "collectRepositoriesForMavenProjects", "project", "Lcom/intellij/openapi/project/Project;", "mavenProjects", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "applyRepositories", "mavenRepositories", "mirror", "", "id", "url", "settingsFile", "Ljava/nio/file/Path;", "Companion", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenRemoteRepositoriesConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenRemoteRepositoriesConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenRemoteRepositoriesConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class MavenRemoteRepositoriesConfigurator
implements MavenWorkspaceConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key<Set<RemoteRepositoryDescription>> COLLECTED_REPOSITORIES;
    @NotNull
    private static final Logger LOG;

    public MavenRemoteRepositoriesConfigurator() {
        Key key = Key.create((String)"COLLECTED_REPOSITORIES");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.COLLECTED_REPOSITORIES = key;
    }

    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Sequence mavenProjects = SequencesKt.map(context2.getMavenProjectsWithModules(), MavenRemoteRepositoriesConfigurator::beforeModelApplied$lambda$0);
        Set<RemoteRepositoryDescription> repositories = this.collectRepositoriesForMavenProjects(context2.getProject(), (Sequence<MavenProject>)mavenProjects);
        this.COLLECTED_REPOSITORIES.set((UserDataHolder)context2, repositories);
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Set set = (Set)this.COLLECTED_REPOSITORIES.get((UserDataHolder)context2);
            if (set == null) break block0;
            Set it = set;
            boolean bl = false;
            this.applyRepositories(context2.getProject(), it);
        }
    }

    private final Set<RemoteRepositoryDescription> collectRepositoriesForMavenProjects(Project project, Sequence<MavenProject> mavenProjects) {
        Path settingsFile = MavenSettingsCache.Companion.getInstance(project).getEffectiveUserSettingsFile();
        return SequencesKt.toHashSet((Sequence)SequencesKt.flatMap(mavenProjects, arg_0 -> MavenRemoteRepositoriesConfigurator.collectRepositoriesForMavenProjects$lambda$0(this, settingsFile, arg_0)));
    }

    private final void applyRepositories(Project project, Set<RemoteRepositoryDescription> mavenRepositories) {
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration = RemoteRepositoriesConfiguration.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)remoteRepositoriesConfiguration, (String)"getInstance(...)");
        RemoteRepositoriesConfiguration repoConfig = remoteRepositoriesConfiguration;
        List list = repoConfig.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRepositories(...)");
        mavenRepositories.addAll(list);
        repoConfig.setRepositories(CollectionsKt.toList((Iterable)mavenRepositories));
    }

    private final String mirror(String id, String url, Path settingsFile) {
        return MavenUtil.INSTANCE.getMirroredUrl(settingsFile, url, id);
    }

    private static final MavenProject beforeModelApplied$lambda$0(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMavenProject();
    }

    private static final Sequence collectRepositoriesForMavenProjects$lambda$0(MavenRemoteRepositoriesConfigurator this$0, Path $settingsFile, MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)mavenProject.getRemoteRepositories()), arg_0 -> MavenRemoteRepositoriesConfigurator.collectRepositoriesForMavenProjects$lambda$0$0(this$0, $settingsFile, mavenProject, arg_0));
    }

    private static final RemoteRepositoryDescription collectRepositoriesForMavenProjects$lambda$0$0(MavenRemoteRepositoriesConfigurator this$0, Path $settingsFile, MavenProject $mavenProject, MavenRemoteRepository repo) {
        RemoteRepositoryDescription remoteRepositoryDescription;
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        String string = repo.getId();
        String string2 = repo.getName();
        if (string2 == null) {
            String string3 = repo.getId();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        }
        String string4 = repo.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getId(...)");
        String string5 = repo.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getUrl(...)");
        RemoteRepositoryDescription it = remoteRepositoryDescription = new RemoteRepositoryDescription(string, string2, this$0.mirror(string4, string5, $settingsFile));
        boolean bl = false;
        LOG.trace("Imported remote repository from " + $mavenProject.getMavenId() + ": " + it.getId() + "/" + it.getName() + " at " + it.getUrl());
        return remoteRepositoryDescription;
    }

    static {
        Logger logger = Logger.getInstance(MavenRemoteRepositoriesConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenRemoteRepositoriesConfigurator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

