/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsGroup;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SettingsGroupedDeployable {
    public String getName();

    public void setName(@NotNull String var1);

    public boolean isSingleServer();

    public List<SettingsDeployable> getDeployables();

    public SettingsGroupedDeployable cloneGroup(@NotNull List<DeploymentConfigurableTabProvider> var1, Project var2, UserDataHolder var3);

    public void addServer(@NotNull SettingsDeployable var1);

    public boolean contains(SettingsDeployable var1);

    public boolean removeServer(@NotNull SettingsDeployable var1);

    @NotNull
    public WebServerGroupingWrap computeGroupedDeployable();

    public boolean mayChangeLevel();

    public boolean isProjectLevel();

    public void setIsProjectLevel(boolean var1);

    @NotNull
    public static SettingsGroupedDeployable wrap(@NotNull WebServerGroupingWrap deployable, @Nullable Project project) {
        if (deployable == null) {
            SettingsGroupedDeployable.$$$reportNull$$$0(0);
        }
        if (deployable.isSingleServer()) {
            WebServerConfig server = deployable.getAsSingleServer();
            return SettingsGroupedDeployable.wrapDeployable(SettingsDeployable.create(server, false, server.getOrCreateSshUiData(project)));
        }
        List<WebServerConfig> deployableServers = deployable.getServers();
        SettingsGroup group = new SettingsGroup(deployable.mayChangeLevel(), deployable.isProjectLevel());
        group.setName(deployable.getName());
        for (WebServerConfig server : deployableServers) {
            group.addServer(SettingsDeployable.create(server, true, server.getOrCreateSshUiData(project)));
        }
        SettingsGroup settingsGroup = group;
        if (settingsGroup == null) {
            SettingsGroupedDeployable.$$$reportNull$$$0(1);
        }
        return settingsGroup;
    }

    @NotNull
    public static SettingsGroupedDeployable wrapDeployable(@NotNull SettingsDeployable item) {
        if (item == null) {
            SettingsGroupedDeployable.$$$reportNull$$$0(2);
        }
        return new SingleServerGroupedDeployable(item);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/SettingsGroupedDeployable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/SettingsGroupedDeployable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrapDeployable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class SingleServerGroupedDeployable
    implements SettingsGroupedDeployable {
        private final SettingsDeployable myDeployable;

        public SingleServerGroupedDeployable(SettingsDeployable deployable) {
            this.myDeployable = deployable;
        }

        @Override
        public String getName() {
            return this.myDeployable.getName();
        }

        @Override
        public boolean isSingleServer() {
            return true;
        }

        @Override
        public List<SettingsDeployable> getDeployables() {
            return Collections.singletonList(this.myDeployable);
        }

        @Override
        public SettingsGroupedDeployable cloneGroup(@NotNull List<DeploymentConfigurableTabProvider> providers, Project project, UserDataHolder dataHolder) {
            if (providers == null) {
                SingleServerGroupedDeployable.$$$reportNull$$$0(0);
            }
            return new SingleServerGroupedDeployable(this.myDeployable.clone());
        }

        @Override
        public void addServer(@NotNull SettingsDeployable item) {
            if (item == null) {
                SingleServerGroupedDeployable.$$$reportNull$$$0(1);
            }
            throw new IllegalStateException("This is single server. Please check isSingleServer() before invoking this method");
        }

        @Override
        public boolean contains(SettingsDeployable server) {
            return this.myDeployable.equals(server);
        }

        @Override
        public boolean removeServer(@NotNull SettingsDeployable server) {
            if (server == null) {
                SingleServerGroupedDeployable.$$$reportNull$$$0(2);
            }
            throw new IllegalStateException("This is single server. Please check isSingleServer() before invoking this method");
        }

        @Override
        @NotNull
        public WebServerGroupingWrap computeGroupedDeployable() {
            WebServerGroupingWrap webServerGroupingWrap = WebServerGroupingWrap.wrap(this.myDeployable.computeWebServerConfig());
            if (webServerGroupingWrap == null) {
                SingleServerGroupedDeployable.$$$reportNull$$$0(3);
            }
            return webServerGroupingWrap;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                SingleServerGroupedDeployable.$$$reportNull$$$0(4);
            }
            throw new IllegalStateException("This is single server. Please check isSingleServer() before invoking this method");
        }

        @Override
        public boolean isProjectLevel() {
            return this.myDeployable.isProjectLevel();
        }

        @Override
        public boolean mayChangeLevel() {
            return true;
        }

        @Override
        public void setIsProjectLevel(boolean projectLevel) {
            this.myDeployable.setIsProjectLevel(projectLevel);
        }

        @NonNls
        public String toString() {
            return "SingleServerGroupedDeployable{" + this.myDeployable.getName() + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/SettingsGroupedDeployable$SingleServerGroupedDeployable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/SettingsGroupedDeployable$SingleServerGroupedDeployable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeGroupedDeployable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addServer";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeServer";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

