/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config;

import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.JSFileImportsResolver;
import com.intellij.lang.javascript.config.JSFileInclude;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.config.JSModuleResolution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSConfig {
    @NotNull
    public Collection<PsiFileSystemItem> getRootDirs();

    @NotNull
    default public Collection<VirtualFile> getRootDirsFiles() {
        Collection collection = this.getRootDirs().stream().filter(el -> el.isValid()).map(PsiFileSystemItem::getVirtualFile).collect(Collectors.toUnmodifiableSet());
        if (collection == null) {
            JSConfig.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public JSFileImportsResolver getImportResolver();

    @NotNull
    public JSImportResolveContext getResolveContext();

    @NotNull
    public JSFileInclude getInclude();

    @Deprecated(forRemoval=true)
    @NotNull
    default public Collection<JSModulePathSubstitution> getPaths() {
        List<JSModulePathSubstitution> list = Collections.emptyList();
        if (list == null) {
            JSConfig.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    default public JSModulePathMappings<JSModulePathSubstitution> getPathMappings() {
        JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings = JSModulePathMappings.build(this.getPaths());
        if (jSModulePathMappings == null) {
            JSConfig.$$$reportNull$$$0(2);
        }
        return jSModulePathMappings;
    }

    @NotNull
    default public VirtualFile getMappingRoot() {
        VirtualFile virtualFile = this.getConfigDirectory();
        if (virtualFile == null) {
            JSConfig.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    default public JSModuleResolution getResolution() {
        JSModuleResolution jSModuleResolution = this.getModuleResolution();
        if (jSModuleResolution == null) {
            JSConfig.$$$reportNull$$$0(4);
        }
        return jSModuleResolution;
    }

    @NotNull
    public JSModuleResolution getModuleResolution();

    @Deprecated(forRemoval=true)
    @NotNull
    default public JSModuleResolution getEffectiveResolution() {
        JSModuleResolution jSModuleResolution = this.getEffectiveModuleResolution();
        if (jSModuleResolution == null) {
            JSConfig.$$$reportNull$$$0(5);
        }
        return jSModuleResolution;
    }

    @NotNull
    public JSModuleResolution getEffectiveModuleResolution();

    @NotNull
    public JSFileImports getConfigImportResolveStructure();

    @Nullable
    public VirtualFile getBaseUrl();

    @NotNull
    public VirtualFile getConfigDirectory();

    public boolean isNodeResolution();

    default public boolean preserveSymlinks() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/config/JSConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirsFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolution";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveResolution";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

