/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.jasper2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class LineReader {
    private final Reader myReader;
    private boolean mySkipLF = false;

    public LineReader(InputStream stream) {
        this.myReader = new BufferedReader(new InputStreamReader(stream));
    }

    public String getNextLine() {
        try {
            return this.readLine(this.myReader);
        }
        catch (IOException e) {
            return null;
        }
    }

    private String readLine(Reader reader) throws IOException {
        int c;
        boolean first = true;
        StringBuilder buffer = new StringBuilder();
        while ((c = reader.read()) != -1) {
            first = false;
            if (c == 10) {
                if (!this.mySkipLF) break;
                this.mySkipLF = false;
                continue;
            }
            if (c == 13) {
                this.mySkipLF = true;
                break;
            }
            this.mySkipLF = false;
            buffer.append((char)c);
        }
        if (first) {
            return null;
        }
        String s = buffer.toString();
        return s;
    }
}

