/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.editing;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbTextFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ProtoBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            ProtoBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ProtoBackspaceHandler.$$$reportNull$$$0(1);
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            ProtoBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ProtoBackspaceHandler.$$$reportNull$$$0(3);
        }
        if (c == '<' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && (file instanceof PbFile || file instanceof PbTextFile)) {
            int offset = editor.getCaretModel().getOffset();
            if (offset >= editor.getDocument().getTextLength()) {
                return false;
            }
            CharSequence chars = editor.getDocument().getCharsSequence();
            char nextChar = chars.charAt(offset);
            if (nextChar != '>') {
                return false;
            }
            HighlighterIterator iterator = editor.getHighlighter().createIterator(offset);
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher((FileType)file.getFileType(), (HighlighterIterator)iterator);
            if (!braceMatcher.isLBraceToken(iterator, chars, file.getFileType()) && !braceMatcher.isRBraceToken(iterator, chars, file.getFileType())) {
                return false;
            }
            int rparenOffset = BraceMatchingUtil.findRightmostRParen((HighlighterIterator)iterator, (IElementType)iterator.getTokenType(), (CharSequence)chars, (FileType)file.getFileType());
            if (rparenOffset >= 0) {
                iterator = editor.getHighlighter().createIterator(rparenOffset);
                boolean matched = BraceMatchingUtil.matchBrace((CharSequence)chars, (FileType)file.getFileType(), (HighlighterIterator)iterator, (boolean)false);
                if (matched) {
                    return false;
                }
            }
            editor.getDocument().deleteString(offset, offset + 1);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/protobuf/ide/editing/ProtoBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

