/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.editing;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.protobuf.lang.psi.PbAggregateValue;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbTextFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class ProtoTypedHandler
extends TypedHandlerDelegate {
    private static final Logger logger = Logger.getInstance(ProtoTypedHandler.class);

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            ProtoTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ProtoTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ProtoTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            ProtoTypedHandler.$$$reportNull$$$0(3);
        }
        if (c == '>' && ProtoTypedHandler.handleFile(file) && TypedHandler.handleRParen((Editor)editor, (FileType)file.getFileType(), (char)c)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                ProtoTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            ProtoTypedHandler.$$$reportNull$$$0(5);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            ProtoTypedHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            ProtoTypedHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ProtoTypedHandler.$$$reportNull$$$0(8);
        }
        if (ProtoTypedHandler.handleFile(file)) {
            if (c == '<') {
                ProtoTypedHandler.handleAfterLParen(editor, file.getFileType(), c);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    ProtoTypedHandler.$$$reportNull$$$0(9);
                }
                return result;
            }
            if (c == '>' && ProtoTypedHandler.inTextFormat(file, editor)) {
                ProtoTypedHandler.indentBrace(project, editor, c);
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            ProtoTypedHandler.$$$reportNull$$$0(10);
        }
        return result;
    }

    private static boolean handleFile(PsiFile file) {
        return file instanceof PbFile || file instanceof PbTextFile;
    }

    private static void handleAfterLParen(Editor editor, FileType fileType, char lparenChar) {
        boolean matched;
        int lparenOffset;
        boolean atEndOfDocument;
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = editor.getHighlighter().createIterator(offset);
        boolean bl = atEndOfDocument = offset == editor.getDocument().getTextLength();
        if (!atEndOfDocument) {
            iterator.retreat();
        }
        if (iterator.atEnd()) {
            return;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher((FileType)fileType, (HighlighterIterator)iterator);
        if (iterator.atEnd()) {
            return;
        }
        IElementType braceTokenType = iterator.getTokenType();
        CharSequence fileText = editor.getDocument().getCharsSequence();
        if (!braceMatcher.isLBraceToken(iterator, fileText, fileType)) {
            return;
        }
        if (!iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && !BraceMatchingUtil.isPairedBracesAllowedBeforeTypeInFileType((IElementType)braceTokenType, (IElementType)iterator.getTokenType(), (FileType)fileType)) {
                return;
            }
            iterator.retreat();
        }
        if ((lparenOffset = BraceMatchingUtil.findLeftmostLParen((HighlighterIterator)iterator, (IElementType)braceTokenType, (CharSequence)fileText, (FileType)fileType)) < 0) {
            lparenOffset = 0;
        }
        if (!(matched = BraceMatchingUtil.matchBrace((CharSequence)fileText, (FileType)fileType, (HighlighterIterator)(iterator = editor.getHighlighter().createIterator(lparenOffset)), (boolean)true, (boolean)true))) {
            String text;
            if (lparenChar == '(') {
                text = ")";
            } else if (lparenChar == '[') {
                text = "]";
            } else if (lparenChar == '<') {
                text = ">";
            } else if (lparenChar == '{') {
                text = "}";
            } else {
                throw new AssertionError((Object)("Unknown char " + lparenChar));
            }
            editor.getDocument().insertString(offset, (CharSequence)text);
        }
    }

    private static void indentBrace(@NotNull Project project, @NotNull Editor editor, char braceChar) {
        if (project == null) {
            ProtoTypedHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            ProtoTypedHandler.$$$reportNull$$$0(12);
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset < 0 || chars.charAt(offset) != braceChar) {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(document);
            PsiFile file = documentManager.getPsiFile(document);
            if (file == null || !file.isWritable()) {
                return;
            }
            PsiElement element = file.findElementAt(offset);
            if (element == null) {
                return;
            }
            EditorHighlighter highlighter = editor.getHighlighter();
            HighlighterIterator iterator = highlighter.createIterator(offset);
            FileType fileType = file.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher((FileType)fileType, (HighlighterIterator)iterator);
            IElementType oppositeTokenType = braceMatcher.getOppositeBraceTokenType(iterator.getTokenType());
            boolean rBraceToken = braceMatcher.isRBraceToken(iterator, chars, fileType);
            boolean isBrace = braceMatcher.isLBraceToken(iterator, chars, fileType) || rBraceToken;
            int lBraceOffset = -1;
            if (CodeInsightSettings.getInstance().REFORMAT_BLOCK_ON_RBRACE && rBraceToken && braceMatcher.isStructuralBrace(iterator, chars, fileType) && offset > 0 && oppositeTokenType != null) {
                lBraceOffset = BraceMatchingUtil.findLeftLParen((HighlighterIterator)highlighter.createIterator(offset - 1), (IElementType)oppositeTokenType, (CharSequence)editor.getDocument().getCharsSequence(), (FileType)fileType);
            }
            if (element.getNode() != null && isBrace) {
                int finalLBraceOffset = lBraceOffset;
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        int newOffset;
                        if (finalLBraceOffset != -1) {
                            RangeMarker marker = document.createRangeMarker(offset, offset + 1);
                            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, finalLBraceOffset, offset, true);
                            newOffset = marker.getStartOffset();
                            marker.dispose();
                        } else {
                            newOffset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset);
                        }
                        editor.getCaretModel().moveToOffset(newOffset + 1);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().removeSelection();
                    }
                    catch (IncorrectOperationException e) {
                        logger.error((Throwable)e);
                    }
                });
            }
        }
    }

    static boolean inTextFormat(PsiFile file, Editor editor) {
        if (file instanceof PbTextFile) {
            return true;
        }
        if (file instanceof PbFile) {
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            if (element == null) {
                return false;
            }
            return PsiTreeUtil.getParentOfType((PsiElement)element, PbAggregateValue.class) != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/editing/ProtoTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/editing/ProtoTypedHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "indentBrace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 9, 10 -> new IllegalStateException(string);
        };
    }
}

