/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.jam.JamService;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.gutter.DomTargetPresentationRenderer;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.pom.SpringBeanPomTargetUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.xml.DomElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBeansPsiElementCellRenderer
extends PsiTargetPresentationRenderer<PsiElement> {
    private static final DomTargetPresentationRenderer DOM_RENDERER = new DomTargetPresentationRenderer(SpringApiBundle.message("spring.bean.with.unknown.name", new Object[0])){

        @Override
        @NotNull
        public String getElementText(@NotNull PsiElement element) {
            DomElement domElement;
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((domElement = 1.getDomElement(element)) instanceof DomSpringBean) {
                String string = SpringPresentationProvider.getSpringBeanName((DomSpringBean)domElement);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = super.getElementText(element);
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected Icon getIcon(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(3);
            }
            return SpringPresentationProvider.getSpringIcon(1.getDomElement(element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/gutter/SpringBeansPsiElementCellRenderer$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/gutter/SpringBeansPsiElementCellRenderer$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementText";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    };

    @NotNull
    public String getElementText(@NotNull PsiElement element) {
        PsiMember member;
        PsiElement psiElement;
        if (element == null) {
            SpringBeansPsiElementCellRenderer.$$$reportNull$$$0(0);
        }
        if ((psiElement = SpringBeansPsiElementCellRenderer.getElementToProcess(element)) instanceof XmlTag) {
            String string = DOM_RENDERER.getElementText(psiElement);
            if (string == null) {
                SpringBeansPsiElementCellRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }
        @Nullable JamPsiMemberSpringBean<?> springBean = psiElement instanceof PsiAnnotation ? ((member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class)) == null ? null : SpringBeansPsiElementCellRenderer.getJamBean(member)) : SpringBeanPomTargetUtils.getSpringBean(element);
        if (springBean != null) {
            String string = SpringPresentationProvider.getSpringBeanName(springBean);
            if (string == null) {
                SpringBeansPsiElementCellRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = super.getElementText(psiElement);
        if (string == null) {
            SpringBeansPsiElementCellRenderer.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static PsiElement getElementToProcess(PsiElement element) {
        PomTarget target;
        if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof PsiTarget) {
            return ((PsiTarget)target).getNavigationElement();
        }
        return element;
    }

    public String getContainerText(@NotNull PsiElement element) {
        PsiClass psiClass;
        PsiElement psiElement;
        if (element == null) {
            SpringBeansPsiElementCellRenderer.$$$reportNull$$$0(4);
        }
        if ((psiElement = SpringBeansPsiElementCellRenderer.getElementToProcess(element)) instanceof XmlTag) {
            return SpringBeansPsiElementCellRenderer.getUniqueVirtualFilePath(psiElement);
        }
        if (psiElement instanceof PsiAnnotation && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class)) != null && psiClass.getName() != null) {
            return SpringBeansPsiElementCellRenderer.getUniqueVirtualFilePath((PsiElement)psiClass);
        }
        return SpringBeansPsiElementCellRenderer.getUniqueVirtualFilePath(element);
    }

    @NlsSafe
    private static String getUniqueVirtualFilePath(PsiElement psiElement) {
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        return UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(psiElement.getProject(), virtualFile);
    }

    @Nullable
    protected Icon getIcon(@NotNull PsiElement element) {
        CommonSpringBean bean;
        PsiElement psiElement;
        if (element == null) {
            SpringBeansPsiElementCellRenderer.$$$reportNull$$$0(5);
        }
        if ((psiElement = SpringBeansPsiElementCellRenderer.getElementToProcess(element)) instanceof XmlTag) {
            return DOM_RENDERER.getIcon(psiElement);
        }
        if (psiElement instanceof PsiAnnotation) {
            JamPsiMemberSpringBean<?> springBean;
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class);
            JamPsiMemberSpringBean<?> jamPsiMemberSpringBean = springBean = member == null ? null : SpringBeansPsiElementCellRenderer.getJamBean(member);
            if (springBean != null) {
                return SpringApiIcons.SpringJavaBean;
            }
        } else if (!DumbService.isDumb((Project)element.getProject()) && (bean = SpringBeanPomTargetUtils.getSpringBean(element)) != null) {
            return SpringPresentationProvider.getSpringIcon(bean);
        }
        return super.getIcon(psiElement);
    }

    private static JamPsiMemberSpringBean<?> getJamBean(PsiMember member) {
        return (JamPsiMemberSpringBean)JamService.getJamService((Project)member.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)member);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/gutter/SpringBeansPsiElementCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/gutter/SpringBeansPsiElementCellRenderer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContainerText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

