/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import com.jetbrains.rd.platform.codeWithMe.blockmap.Chunk;
import com.jetbrains.rd.platform.codeWithMe.blockmap.FastCDCImpl;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fB\u001b\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\u000fB1\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003JA\u0010\u001e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\bH\u00d6\u0001J\t\u0010#\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/BlockMap;", "", "chunks", "", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/Chunk;", "algorithm", "", "minSize", "", "maxSize", "normalSize", "<init>", "(Ljava/util/List;Ljava/lang/String;III)V", "source", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Ljava/lang/String;)V", "(Ljava/io/InputStream;Ljava/lang/String;III)V", "getChunks", "()Ljava/util/List;", "getAlgorithm", "()Ljava/lang/String;", "getMinSize", "()I", "getMaxSize", "getNormalSize", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.split"})
public final class BlockMap {
    @NotNull
    private final List<Chunk> chunks;
    @NotNull
    private final String algorithm;
    private final int minSize;
    private final int maxSize;
    private final int normalSize;

    public BlockMap(@NotNull List<Chunk> chunks, @NotNull String algorithm, int minSize, int maxSize, int normalSize) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.chunks = chunks;
        this.algorithm = algorithm;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.normalSize = normalSize;
    }

    public /* synthetic */ BlockMap(List list, String string, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n4 & 2) != 0) {
            string = "SHA-256";
        }
        if ((n4 & 4) != 0) {
            n = 512;
        }
        if ((n4 & 8) != 0) {
            n2 = 16384;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 2048;
        }
        this(list, string, n, n2, n3);
    }

    @NotNull
    public final List<Chunk> getChunks() {
        return this.chunks;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getMinSize() {
        return this.minSize;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final int getNormalSize() {
        return this.normalSize;
    }

    public BlockMap(@NotNull InputStream source, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this(SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)new FastCDCImpl(source, algorithm, 512, 16384, 2048))), algorithm, 512, 16384, 2048);
    }

    public /* synthetic */ BlockMap(InputStream inputStream, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "SHA-256";
        }
        this(inputStream, string);
    }

    public BlockMap(@NotNull InputStream source, @NotNull String algorithm, int minSize, int maxSize, int normalSize) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this(SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)new FastCDCImpl(source, algorithm, minSize, maxSize, normalSize))), algorithm, minSize, maxSize, normalSize);
    }

    @NotNull
    public final List<Chunk> component1() {
        return this.chunks;
    }

    @NotNull
    public final String component2() {
        return this.algorithm;
    }

    public final int component3() {
        return this.minSize;
    }

    public final int component4() {
        return this.maxSize;
    }

    public final int component5() {
        return this.normalSize;
    }

    @NotNull
    public final BlockMap copy(@NotNull List<Chunk> chunks, @NotNull String algorithm, int minSize, int maxSize, int normalSize) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        return new BlockMap(chunks, algorithm, minSize, maxSize, normalSize);
    }

    public static /* synthetic */ BlockMap copy$default(BlockMap blockMap, List list, String string, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            list = blockMap.chunks;
        }
        if ((n4 & 2) != 0) {
            string = blockMap.algorithm;
        }
        if ((n4 & 4) != 0) {
            n = blockMap.minSize;
        }
        if ((n4 & 8) != 0) {
            n2 = blockMap.maxSize;
        }
        if ((n4 & 0x10) != 0) {
            n3 = blockMap.normalSize;
        }
        return blockMap.copy(list, string, n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "BlockMap(chunks=" + this.chunks + ", algorithm=" + this.algorithm + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", normalSize=" + this.normalSize + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.chunks).hashCode();
        result2 = result2 * 31 + this.algorithm.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.minSize);
        result2 = result2 * 31 + Integer.hashCode(this.maxSize);
        result2 = result2 * 31 + Integer.hashCode(this.normalSize);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BlockMap)) {
            return false;
        }
        BlockMap blockMap = (BlockMap)other;
        if (!Intrinsics.areEqual(this.chunks, blockMap.chunks)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.algorithm, (Object)blockMap.algorithm)) {
            return false;
        }
        if (this.minSize != blockMap.minSize) {
            return false;
        }
        if (this.maxSize != blockMap.maxSize) {
            return false;
        }
        return this.normalSize == blockMap.normalSize;
    }

    public BlockMap() {
        this(null, null, 0, 0, 0, 31, null);
    }
}

