/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 131521452541086L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(964019850 + 11827, -964019850 + -13453, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(964019850 + 11826, 964019850 - 2651, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 127623456655403L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.F();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1496557260 - -((char)-24874), 1496557260 - 13090, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1496557260 - -((char)-24873), 1496557260 - 26516, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1496557260 - -((char)-24872), 1496557260 - 18153, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String string;
                l2 = 122113961948392L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    string = SshAgentIpcService.F();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-548265810 - -25632, 548265810 - (char)-22039, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-548265810 - -25631, 548265810 - (char)-17905, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-548265810 - -25630, -548265810 - -((char)-31427), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-548265810 - -25621, 548265810 - (char)-17275, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-548265810 - -25620, -548265810 - -26485, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-548265810 - -25619, 548265810 - (char)-26949, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-548265810 - -25621, 548265810 - (char)-17275, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-548265810 - -25618, 548265810 - 29836, (int)l2));
            if (ActionTimestamp.F() != null) {
                SshAgentIpcService.F("XgrsSb");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 140688240197998L;
                    string = SshAgentIpcService.F();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 88353439215559L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            string = SshAgentIpcService.F();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1666948260 + 836, 1666948260 + 10183, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1666948260 + 840, -1666948260 + -10618, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1666948260 + 837, 1666948260 - 5578, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(1666948260 + 840, -1666948260 + -10618, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1666948260 + 838, 1666948260 + 11317, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1666948260 + 836, 1666948260 + 10183, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1666948260 + 840, -1666948260 + -10618, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1666948260 + 839, -1666948260 - -558, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1666948260 + 836, 1666948260 + 10183, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1666948260 + 840, -1666948260 + -10618, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1666948260 + 848, 1666948260 + 15295, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1666948260 + 840, -1666948260 + -10618, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1666948260 + 849, 1666948260 + 18826, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string3 = WindowsNamedPipeAgentIpc.b(1666948260 + 840, -1666948260 + -10618, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1666948260 + 838, 1666948260 + 11317, (int)l2) + this.state;
                throw new IllegalArgumentException(string3.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1666948260 + 836, 1666948260 + 10183, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1666948260 + 840, -1666948260 + -10618, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1666948260 + 850, -1666948260 + -20666, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 38800981187261L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-246673740 - -((char)-17256), 246673740 - (char)-23051, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 33983402695598L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1621466970 - -27064, -1621466970 - -30409, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "X:{Bi\u00a5\u00dd\u008b\u0004[N\u0005i\"}\u009d\b\u00f32\u0014\u00ed-\u00cd\u00a6\u00a4\u00fb\u0019\u00c5\u001e\u0094\u00c8({~\u00fe\u009d\u00955\u0086\u0099";
                        var4_3 = "X:{Bi\u00a5\u00dd\u008b\u0004[N\u0005i\"}\u009d\b\u00f32\u0014\u00ed-\u00cd\u00a6\u00a4\u00fb\u0019\u00c5\u001e\u0094\u00c8({~\u00fe\u009d\u00955\u0086\u0099".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 36;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 51;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 51;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 98;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 67;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 29;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 53;
                                        break;
                                    }
                                    default: {
                                        v11 = 37;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFF91F1) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 84;
                            case 1 -> 104;
                            case 2 -> 22;
                            case 3 -> 152;
                            case 4 -> 233;
                            case 5 -> 59;
                            case 6 -> 30;
                            case 7 -> 213;
                            case 8 -> 164;
                            case 9 -> 140;
                            case 10 -> 227;
                            case 11 -> 41;
                            case 12 -> 136;
                            case 13 -> 82;
                            case 14 -> 53;
                            case 15 -> 46;
                            case 16 -> 134;
                            case 17 -> 23;
                            case 18 -> 221;
                            case 19 -> 135;
                            case 20 -> 235;
                            case 21 -> 207;
                            case 22 -> 243;
                            case 23 -> 37;
                            case 24 -> 61;
                            case 25 -> 188;
                            case 26 -> 118;
                            case 27 -> 170;
                            case 28 -> 206;
                            case 29 -> 10;
                            case 30 -> 254;
                            case 31 -> 16;
                            case 32 -> 167;
                            case 33 -> 149;
                            case 34 -> 13;
                            case 35 -> 171;
                            case 36 -> 11;
                            case 37 -> 155;
                            case 38 -> 49;
                            case 39 -> 80;
                            case 40 -> 194;
                            case 41 -> 172;
                            case 42 -> 77;
                            case 43 -> 1;
                            case 44 -> 109;
                            case 45 -> 230;
                            case 46 -> 165;
                            case 47 -> 5;
                            case 48 -> 214;
                            case 49 -> 111;
                            case 50 -> 228;
                            case 51 -> 79;
                            case 52 -> 95;
                            case 53 -> 2;
                            case 54 -> 127;
                            case 55 -> 86;
                            case 56 -> 148;
                            case 57 -> 44;
                            case 58 -> 174;
                            case 59 -> 242;
                            case 60 -> 88;
                            case 61 -> 187;
                            case 62 -> 126;
                            case 63 -> 33;
                            case 64 -> 93;
                            case 65 -> 27;
                            case 66 -> 48;
                            case 67 -> 32;
                            case 68 -> 146;
                            case 69 -> 249;
                            case 70 -> 244;
                            case 71 -> 200;
                            case 72 -> 102;
                            case 73 -> 238;
                            case 74 -> 73;
                            case 75 -> 94;
                            case 76 -> 178;
                            case 77 -> 26;
                            case 78 -> 153;
                            case 79 -> 201;
                            case 80 -> 245;
                            case 81 -> 219;
                            case 82 -> 189;
                            case 83 -> 182;
                            case 84 -> 159;
                            case 85 -> 116;
                            case 86 -> 97;
                            case 87 -> 70;
                            case 88 -> 202;
                            case 89 -> 157;
                            case 90 -> 106;
                            case 91 -> 150;
                            case 92 -> 195;
                            case 93 -> 7;
                            case 94 -> 3;
                            case 95 -> 179;
                            case 96 -> 96;
                            case 97 -> 255;
                            case 98 -> 40;
                            case 99 -> 83;
                            case 100 -> 39;
                            case 101 -> 203;
                            case 102 -> 193;
                            case 103 -> 176;
                            case 104 -> 81;
                            case 105 -> 78;
                            case 106 -> 128;
                            case 107 -> 105;
                            case 108 -> 66;
                            case 109 -> 197;
                            case 110 -> 248;
                            case 111 -> 169;
                            case 112 -> 113;
                            case 113 -> 217;
                            case 114 -> 117;
                            case 115 -> 100;
                            case 116 -> 234;
                            case 117 -> 63;
                            case 118 -> 72;
                            case 119 -> 85;
                            case 120 -> 99;
                            case 121 -> 121;
                            case 122 -> 180;
                            case 123 -> 229;
                            case 124 -> 223;
                            case 125 -> 115;
                            case 126 -> 9;
                            case 127 -> 12;
                            case 128 -> 101;
                            case 129 -> 138;
                            case 130 -> 21;
                            case 131 -> 89;
                            case 132 -> 28;
                            case 133 -> 216;
                            case 134 -> 215;
                            case 135 -> 220;
                            case 136 -> 147;
                            case 137 -> 125;
                            case 138 -> 156;
                            case 139 -> 69;
                            case 140 -> 56;
                            case 141 -> 142;
                            case 142 -> 129;
                            case 143 -> 236;
                            case 144 -> 38;
                            case 145 -> 62;
                            case 146 -> 241;
                            case 147 -> 239;
                            case 148 -> 87;
                            case 149 -> 4;
                            case 150 -> 25;
                            case 151 -> 212;
                            case 152 -> 19;
                            case 153 -> 50;
                            case 154 -> 67;
                            case 155 -> 0;
                            case 156 -> 168;
                            case 157 -> 191;
                            case 158 -> 209;
                            case 159 -> 173;
                            case 160 -> 144;
                            case 161 -> 211;
                            case 162 -> 192;
                            case 163 -> 68;
                            case 164 -> 132;
                            case 165 -> 71;
                            case 166 -> 225;
                            case 167 -> 15;
                            case 168 -> 54;
                            case 169 -> 34;
                            case 170 -> 64;
                            case 171 -> 166;
                            case 172 -> 199;
                            case 173 -> 158;
                            case 174 -> 36;
                            case 175 -> 57;
                            case 176 -> 151;
                            case 177 -> 60;
                            case 178 -> 91;
                            case 179 -> 58;
                            case 180 -> 175;
                            case 181 -> 247;
                            case 182 -> 161;
                            case 183 -> 210;
                            case 184 -> 31;
                            case 185 -> 90;
                            case 186 -> 251;
                            case 187 -> 231;
                            case 188 -> 190;
                            case 189 -> 75;
                            case 190 -> 183;
                            case 191 -> 246;
                            case 192 -> 103;
                            case 193 -> 8;
                            case 194 -> 252;
                            case 195 -> 154;
                            case 196 -> 237;
                            case 197 -> 124;
                            case 198 -> 137;
                            case 199 -> 226;
                            case 200 -> 14;
                            case 201 -> 177;
                            case 202 -> 205;
                            case 203 -> 160;
                            case 204 -> 122;
                            case 205 -> 185;
                            case 206 -> 133;
                            case 207 -> 18;
                            case 208 -> 253;
                            case 209 -> 145;
                            case 210 -> 224;
                            case 211 -> 250;
                            case 212 -> 42;
                            case 213 -> 119;
                            case 214 -> 184;
                            case 215 -> 204;
                            case 216 -> 222;
                            case 217 -> 163;
                            case 218 -> 47;
                            case 219 -> 51;
                            case 220 -> 55;
                            case 221 -> 108;
                            case 222 -> 162;
                            case 223 -> 52;
                            case 224 -> 196;
                            case 225 -> 35;
                            case 226 -> 240;
                            case 227 -> 6;
                            case 228 -> 65;
                            case 229 -> 131;
                            case 230 -> 143;
                            case 231 -> 74;
                            case 232 -> 24;
                            case 233 -> 208;
                            case 234 -> 92;
                            case 235 -> 139;
                            case 236 -> 130;
                            case 237 -> 112;
                            case 238 -> 110;
                            case 239 -> 43;
                            case 240 -> 218;
                            case 241 -> 141;
                            case 242 -> 29;
                            case 243 -> 17;
                            case 244 -> 114;
                            case 245 -> 20;
                            case 246 -> 181;
                            case 247 -> 186;
                            case 248 -> 232;
                            case 249 -> 120;
                            case 250 -> 45;
                            case 251 -> 107;
                            case 252 -> 76;
                            case 253 -> 123;
                            case 254 -> 198;
                            default -> 98;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string != null) {
                ActionTimestamp.F("vjN8Gc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 85940186644310L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.F();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2108916300 + -((char)-4549), -2108916300 + -((char)-22342), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2108916300 + -((char)-4553), 2108916300 + (char)-22745, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2108916300 + -((char)-4530), 2108916300 + (char)-26889, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2108916300 + -((char)-4549), -2108916300 + -((char)-22342), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-2108916300 + -((char)-4553), 2108916300 + (char)-22745, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2108916300 + -((char)-4525), -2108916300 + -((char)-13479), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 45143261694755L;
                        String string3 = SshAgentIpcService.F();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1139522580 + -((char)-30505), -1139522580 + -18961, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1139522580 + -((char)-30506), 1139522580 + (char)-26317, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 73002684133433L;
                String string2 = SshAgentIpcService.F();
                this.assertConnectionThread();
                string = string2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31964, 1124973810 + 24227, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31968, -1124973810 + -23794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31973, -1124973810 + -22848, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31968, -1124973810 + -23794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31966, 1124973810 + 23093, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31964, 1124973810 + 24227, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31968, -1124973810 + -23794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31984, 1124973810 + (char)-32500, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31964, 1124973810 + 24227, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31968, -1124973810 + -23794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31983, 1124973810 + 30176, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31964, 1124973810 + 24227, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31968, -1124973810 + -23794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1124973810 + (char)-31986, -1124973810 + -17324, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 34706057097896L;
                    Object object = this.lock;
                    string = SshAgentIpcService.F();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1573626420 + -23365, -1573626420 + -1224, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1573626420 + -23369, 1573626420 + 601, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1573626420 + -23356, 1573626420 - 8120, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1573626420 + -23349, -1573626420 + -11750, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1573626420 + -23365, -1573626420 + -1224, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1573626420 + -23369, 1573626420 + 601, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1573626420 + -23350, -1573626420 + -5457, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1573626420 + -23365, -1573626420 + -1224, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1573626420 + -23369, 1573626420 + 601, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1573626420 + -23351, 1573626420 + 15287, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1573626420 + -23365, -1573626420 + -1224, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1573626420 + -23369, 1573626420 + 601, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1573626420 + -23352, 1573626420 - 6009, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1573626420 + -23365, -1573626420 + -1224, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1573626420 + -23369, 1573626420 + 601, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1573626420 + -23329, -1573626420 + -3618, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1573626420 + -23330, -1573626420 + -23109, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "F\u0010+\u0080\u00f0\u00fa\u0013\u0007\u0014\u00e3=\u00a7\u00c2\u009f:Q\u0005N\u00b8e\u0081%\u009aC\bpr\u0089\u008c\u0006\u00e6!?\u00a6\u0018\u007f\u00184\u0097=\u00a7NSi\u00e8\u0081x\u0093\u00e9\u009dh\u0006\u00d4q\u0080\u0087On\u00fe\u00b3\u00c6\tS\u001cOgk\u00d4\u00d5P*\u0005\u00e6\u00ef?\u007f\u0002\b\u009e\u00b20\u00a5\u00c1x3\u00b5\u0014\u0099*\u0090\u00bb\u0014\u001d\u0015v\u00a8\u000b\u0012C\u0081al\u009a\u0087\u00f3\u008e\u00fe\u0005\u00e2d\u00bf\u000e\u0012\u001ej\u0093\u00bb\u0094\u000f\u00f1\u00e3\u00c6u\u00a9FTk\u00ffzB\u001f\u00c3\u0098\u00d3!BV\u009c1\u00a0\u00fbdL\u00d3\u0010~i\u00dd\u000e\u0094\u0090f\u0013\u00b8\u00a1r\u00a8\u00eb5\u00c5\u0084\t9\u00e3\u00d4\u0089K.\u00f7\u0090\u0080\u0010*\u00e7W\u00df\u00c5\u00aaLT\u00fdI\u00da\u00b5\u00fe\u0096g\u00f0?42x\u00a0z~\u00c8[a\u00cb\u0081\u00e3,\u00ff\u00af{`\u0081\n^\u00fd\u00a1\u00b6\u0086=\u000bw\u00a5\u00ea\u00bd7B\u00ffU\u0094\u00b7\u00e0\u00f0\u00cc\u0086TX=\u00ae+U\u0012?\u00c3\u0001\u00df\u00e32\u00b8\u00b9d\u0090\u00f4\u00afA\u00c0B\u00fc\bQ\u0012\u00c9\u00b1\u00fe\u00fa\u00d4\u00e5\f\u0092\u009f\u00a1\u001b\u00ee\u00cd8\u0004Z\u000b|\u00f9F\u00ba]\u00a4CN\u00c6,e\u00d8+&9N\u00ac\u00fc7\u00f6o\u00d8,\u00b5\u00bd\u00bc7J\u0016j\r\u00f6\u0081\u008e\u00f9\u00f4\u00947\u00aeN\u009e\u00b2\u008f\bl=\u00d3\u00f5\u007f\u009d\u0007\u00d5\u00fe{\u00b6I\u0084\u00c0\u00f8 \u0013/\u0001\u00e3#\u00c4\u00f3P70\u00dcn\u0099\u001f\u00d8r\u00ed\u00a8\u00c5v\u00ba6^\u00b7#\u0097\u00c7\u009a\u00e4_\u00b7\u0088\u00f0p\u00e7\u00b6Y\u00a9\u00b1\u00d6\u00fcf\u00b1bd\u000b\u00adOF\u0001\u0012\u008e\u00a7l\u00a9\n\b\u0015\u00a5>G,5C\u00af\u00a8\u0096r'\u00e4\u00f9X>Q\u0017\u00dd9\u00a3\u00e8)\u00b4\u00be`1tE\u008cP\u0098{\u00fb\u000e\u00d8\u00a3\u0099}GD5N\u00af\t\u0096F'b\u00f9\u0088>K\u0017\u009e9\u00dd\u00e8\n\u00ab\u0017\u0085\u0017M\u0007\u00cf\u00e3\u0005\u0080\u00fc.\u0006\u00074\u00aa\u001e\u00c5xi\u0080(\u00cc\u00f7#9\u00ac.a\u001aU\u00e5h\u00eb\u0089\u009e\u00f1YMm\u00da(3\u00fbj\u00d3(l\u00ae2\u00e3|wa\u00ceI\u00885\u001d\u008d\u00c0\u00b7\u000ft\u00f4zpok\u00bcq\u009b\u0005\u0010\u00a6&c\u009a\"[\u00fe\u009d9\u00cbD{pf\u007f$\u008e \u00bf\u00e20\u00c3\u00c4/\u001c\u0006C\u0003_\u0006\u0015\u0010\u00b8'\u007f\u0096\u001f'\u001e\u000e\u00e2T\u00a8d5\u00e9\u00f7!\u00f2\u000f=\u00e7\u008fA\u001b\u008d\u00abB\u009e\u0093\u0003\u00b6 \u008d\u00a8_\u0012\u0093\u00c9\u00b2\u00e8au\u00c6\u00b6\u0000\"\u00b0\u00d5;)\u00e2\nn\u0003\u00fa\u008c\u0090\u00a5\u0005\u00deP\u0015\u0018\u008fb\u0002\u00aa\u009a9\u00b69\u0093B^\u00d0\n\u00c2}\u00a8\u00ef|\u00c0\u00ee\u00b8b\u00fc\u008e)\u00e0^\u00ea-%\u00c6\u00a6 \u00dduS\u00cf\u00c9\u0092$ \u008e\u009a\u00d3PI\u00da\u00030\u00e0>\u009c\u00ef\u00c1\u00fbS\u0019\u0094\u00f3\u0088[y\u0019\u00df\u00d6\u0006\t\u00d1\u00b6\u00c9=\u00e2w\u0094\u00e0Q";
                var4_3 = "F\u0010+\u0080\u00f0\u00fa\u0013\u0007\u0014\u00e3=\u00a7\u00c2\u009f:Q\u0005N\u00b8e\u0081%\u009aC\bpr\u0089\u008c\u0006\u00e6!?\u00a6\u0018\u007f\u00184\u0097=\u00a7NSi\u00e8\u0081x\u0093\u00e9\u009dh\u0006\u00d4q\u0080\u0087On\u00fe\u00b3\u00c6\tS\u001cOgk\u00d4\u00d5P*\u0005\u00e6\u00ef?\u007f\u0002\b\u009e\u00b20\u00a5\u00c1x3\u00b5\u0014\u0099*\u0090\u00bb\u0014\u001d\u0015v\u00a8\u000b\u0012C\u0081al\u009a\u0087\u00f3\u008e\u00fe\u0005\u00e2d\u00bf\u000e\u0012\u001ej\u0093\u00bb\u0094\u000f\u00f1\u00e3\u00c6u\u00a9FTk\u00ffzB\u001f\u00c3\u0098\u00d3!BV\u009c1\u00a0\u00fbdL\u00d3\u0010~i\u00dd\u000e\u0094\u0090f\u0013\u00b8\u00a1r\u00a8\u00eb5\u00c5\u0084\t9\u00e3\u00d4\u0089K.\u00f7\u0090\u0080\u0010*\u00e7W\u00df\u00c5\u00aaLT\u00fdI\u00da\u00b5\u00fe\u0096g\u00f0?42x\u00a0z~\u00c8[a\u00cb\u0081\u00e3,\u00ff\u00af{`\u0081\n^\u00fd\u00a1\u00b6\u0086=\u000bw\u00a5\u00ea\u00bd7B\u00ffU\u0094\u00b7\u00e0\u00f0\u00cc\u0086TX=\u00ae+U\u0012?\u00c3\u0001\u00df\u00e32\u00b8\u00b9d\u0090\u00f4\u00afA\u00c0B\u00fc\bQ\u0012\u00c9\u00b1\u00fe\u00fa\u00d4\u00e5\f\u0092\u009f\u00a1\u001b\u00ee\u00cd8\u0004Z\u000b|\u00f9F\u00ba]\u00a4CN\u00c6,e\u00d8+&9N\u00ac\u00fc7\u00f6o\u00d8,\u00b5\u00bd\u00bc7J\u0016j\r\u00f6\u0081\u008e\u00f9\u00f4\u00947\u00aeN\u009e\u00b2\u008f\bl=\u00d3\u00f5\u007f\u009d\u0007\u00d5\u00fe{\u00b6I\u0084\u00c0\u00f8 \u0013/\u0001\u00e3#\u00c4\u00f3P70\u00dcn\u0099\u001f\u00d8r\u00ed\u00a8\u00c5v\u00ba6^\u00b7#\u0097\u00c7\u009a\u00e4_\u00b7\u0088\u00f0p\u00e7\u00b6Y\u00a9\u00b1\u00d6\u00fcf\u00b1bd\u000b\u00adOF\u0001\u0012\u008e\u00a7l\u00a9\n\b\u0015\u00a5>G,5C\u00af\u00a8\u0096r'\u00e4\u00f9X>Q\u0017\u00dd9\u00a3\u00e8)\u00b4\u00be`1tE\u008cP\u0098{\u00fb\u000e\u00d8\u00a3\u0099}GD5N\u00af\t\u0096F'b\u00f9\u0088>K\u0017\u009e9\u00dd\u00e8\n\u00ab\u0017\u0085\u0017M\u0007\u00cf\u00e3\u0005\u0080\u00fc.\u0006\u00074\u00aa\u001e\u00c5xi\u0080(\u00cc\u00f7#9\u00ac.a\u001aU\u00e5h\u00eb\u0089\u009e\u00f1YMm\u00da(3\u00fbj\u00d3(l\u00ae2\u00e3|wa\u00ceI\u00885\u001d\u008d\u00c0\u00b7\u000ft\u00f4zpok\u00bcq\u009b\u0005\u0010\u00a6&c\u009a\"[\u00fe\u009d9\u00cbD{pf\u007f$\u008e \u00bf\u00e20\u00c3\u00c4/\u001c\u0006C\u0003_\u0006\u0015\u0010\u00b8'\u007f\u0096\u001f'\u001e\u000e\u00e2T\u00a8d5\u00e9\u00f7!\u00f2\u000f=\u00e7\u008fA\u001b\u008d\u00abB\u009e\u0093\u0003\u00b6 \u008d\u00a8_\u0012\u0093\u00c9\u00b2\u00e8au\u00c6\u00b6\u0000\"\u00b0\u00d5;)\u00e2\nn\u0003\u00fa\u008c\u0090\u00a5\u0005\u00deP\u0015\u0018\u008fb\u0002\u00aa\u009a9\u00b69\u0093B^\u00d0\n\u00c2}\u00a8\u00ef|\u00c0\u00ee\u00b8b\u00fc\u008e)\u00e0^\u00ea-%\u00c6\u00a6 \u00dduS\u00cf\u00c9\u0092$ \u008e\u009a\u00d3PI\u00da\u00030\u00e0>\u009c\u00ef\u00c1\u00fbS\u0019\u0094\u00f3\u0088[y\u0019\u00df\u00d6\u0006\t\u00d1\u00b6\u00c9=\u00e2w\u0094\u00e0Q".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 20;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00d6\u00d7L|\u0091\u008cP\tc0\u00e4\u0007_\u00eb\u0096o\u00b8\u001f%\u0004\u00a2\u000f\u00ed4\u00f6\u00c2\u00afUW\u0014[\u00c2\u00d0]\u0011\u00a9\u00e0\u0017\u0018\u009a\u00cf\u00a5\u0010~\u0085\u00f4\u00c8\u008d\u00fe\u0013";
                    var4_3 = "\u00d6\u00d7L|\u0091\u008cP\tc0\u00e4\u0007_\u00eb\u0096o\u00b8\u001f%\u0004\u00a2\u000f\u00ed4\u00f6\u00c2\u00afUW\u0014[\u00c2\u00d0]\u0011\u00a9\u00e0\u0017\u0018\u009a\u00cf\u00a5\u0010~\u0085\u00f4\u00c8\u008d\u00fe\u0013".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 93;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 9;
                            break;
                        }
                        case 1: {
                            v15 = 89;
                            break;
                        }
                        case 2: {
                            v15 = 90;
                            break;
                        }
                        case 3: {
                            v15 = 30;
                            break;
                        }
                        case 4: {
                            v15 = 102;
                            break;
                        }
                        case 5: {
                            v15 = 23;
                            break;
                        }
                        default: {
                            v15 = 121;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x7023) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 218;
                case 1 -> 154;
                case 2 -> 207;
                case 3 -> 21;
                case 4 -> 209;
                case 5 -> 67;
                case 6 -> 188;
                case 7 -> 34;
                case 8 -> 66;
                case 9 -> 22;
                case 10 -> 139;
                case 11 -> 146;
                case 12 -> 142;
                case 13 -> 55;
                case 14 -> 220;
                case 15 -> 233;
                case 16 -> 148;
                case 17 -> 226;
                case 18 -> 135;
                case 19 -> 198;
                case 20 -> 114;
                case 21 -> 65;
                case 22 -> 159;
                case 23 -> 95;
                case 24 -> 35;
                case 25 -> 27;
                case 26 -> 175;
                case 27 -> 216;
                case 28 -> 128;
                case 29 -> 177;
                case 30 -> 56;
                case 31 -> 84;
                case 32 -> 113;
                case 33 -> 230;
                case 34 -> 249;
                case 35 -> 18;
                case 36 -> 16;
                case 37 -> 222;
                case 38 -> 232;
                case 39 -> 48;
                case 40 -> 244;
                case 41 -> 10;
                case 42 -> 31;
                case 43 -> 32;
                case 44 -> 155;
                case 45 -> 58;
                case 46 -> 189;
                case 47 -> 26;
                case 48 -> 62;
                case 49 -> 64;
                case 50 -> 3;
                case 51 -> 208;
                case 52 -> 75;
                case 53 -> 231;
                case 54 -> 109;
                case 55 -> 92;
                case 56 -> 110;
                case 57 -> 0;
                case 58 -> 186;
                case 59 -> 195;
                case 60 -> 245;
                case 61 -> 73;
                case 62 -> 115;
                case 63 -> 252;
                case 64 -> 206;
                case 65 -> 129;
                case 66 -> 151;
                case 67 -> 248;
                case 68 -> 182;
                case 69 -> 89;
                case 70 -> 111;
                case 71 -> 61;
                case 72 -> 240;
                case 73 -> 145;
                case 74 -> 184;
                case 75 -> 47;
                case 76 -> 168;
                case 77 -> 5;
                case 78 -> 102;
                case 79 -> 2;
                case 80 -> 197;
                case 81 -> 41;
                case 82 -> 63;
                case 83 -> 100;
                case 84 -> 156;
                case 85 -> 40;
                case 86 -> 24;
                case 87 -> 215;
                case 88 -> 183;
                case 89 -> 225;
                case 90 -> 144;
                case 91 -> 76;
                case 92 -> 228;
                case 93 -> 99;
                case 94 -> 174;
                case 95 -> 69;
                case 96 -> 20;
                case 97 -> 141;
                case 98 -> 39;
                case 99 -> 123;
                case 100 -> 170;
                case 101 -> 46;
                case 102 -> 90;
                case 103 -> 104;
                case 104 -> 172;
                case 105 -> 116;
                case 106 -> 17;
                case 107 -> 94;
                case 108 -> 181;
                case 109 -> 23;
                case 110 -> 193;
                case 111 -> 12;
                case 112 -> 203;
                case 113 -> 194;
                case 114 -> 33;
                case 115 -> 239;
                case 116 -> 176;
                case 117 -> 59;
                case 118 -> 87;
                case 119 -> 126;
                case 120 -> 36;
                case 121 -> 19;
                case 122 -> 38;
                case 123 -> 13;
                case 124 -> 119;
                case 125 -> 253;
                case 126 -> 1;
                case 127 -> 229;
                case 128 -> 140;
                case 129 -> 45;
                case 130 -> 74;
                case 131 -> 242;
                case 132 -> 60;
                case 133 -> 173;
                case 134 -> 167;
                case 135 -> 213;
                case 136 -> 178;
                case 137 -> 130;
                case 138 -> 85;
                case 139 -> 149;
                case 140 -> 214;
                case 141 -> 108;
                case 142 -> 251;
                case 143 -> 152;
                case 144 -> 42;
                case 145 -> 143;
                case 146 -> 43;
                case 147 -> 127;
                case 148 -> 81;
                case 149 -> 120;
                case 150 -> 83;
                case 151 -> 227;
                case 152 -> 185;
                case 153 -> 49;
                case 154 -> 158;
                case 155 -> 161;
                case 156 -> 28;
                case 157 -> 52;
                case 158 -> 4;
                case 159 -> 118;
                case 160 -> 79;
                case 161 -> 131;
                case 162 -> 179;
                case 163 -> 199;
                case 164 -> 97;
                case 165 -> 101;
                case 166 -> 247;
                case 167 -> 7;
                case 168 -> 202;
                case 169 -> 122;
                case 170 -> 241;
                case 171 -> 210;
                case 172 -> 254;
                case 173 -> 204;
                case 174 -> 191;
                case 175 -> 137;
                case 176 -> 219;
                case 177 -> 51;
                case 178 -> 8;
                case 179 -> 169;
                case 180 -> 217;
                case 181 -> 71;
                case 182 -> 134;
                case 183 -> 200;
                case 184 -> 147;
                case 185 -> 133;
                case 186 -> 157;
                case 187 -> 236;
                case 188 -> 91;
                case 189 -> 88;
                case 190 -> 11;
                case 191 -> 192;
                case 192 -> 221;
                case 193 -> 50;
                case 194 -> 15;
                case 195 -> 93;
                case 196 -> 9;
                case 197 -> 234;
                case 198 -> 103;
                case 199 -> 77;
                case 200 -> 187;
                case 201 -> 190;
                case 202 -> 164;
                case 203 -> 54;
                case 204 -> 29;
                case 205 -> 223;
                case 206 -> 112;
                case 207 -> 196;
                case 208 -> 166;
                case 209 -> 6;
                case 210 -> 86;
                case 211 -> 224;
                case 212 -> 78;
                case 213 -> 153;
                case 214 -> 125;
                case 215 -> 171;
                case 216 -> 160;
                case 217 -> 136;
                case 218 -> 98;
                case 219 -> 44;
                case 220 -> 211;
                case 221 -> 14;
                case 222 -> 30;
                case 223 -> 107;
                case 224 -> 212;
                case 225 -> 243;
                case 226 -> 25;
                case 227 -> 121;
                case 228 -> 80;
                case 229 -> 163;
                case 230 -> 37;
                case 231 -> 255;
                case 232 -> 53;
                case 233 -> 237;
                case 234 -> 205;
                case 235 -> 70;
                case 236 -> 201;
                case 237 -> 72;
                case 238 -> 235;
                case 239 -> 82;
                case 240 -> 132;
                case 241 -> 138;
                case 242 -> 165;
                case 243 -> 105;
                case 244 -> 238;
                case 245 -> 180;
                case 246 -> 106;
                case 247 -> 117;
                case 248 -> 162;
                case 249 -> 57;
                case 250 -> 96;
                case 251 -> 246;
                case 252 -> 68;
                case 253 -> 124;
                case 254 -> 250;
                default -> 150;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 41027339574724L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1811911680 + (char)-18121, -1811911680 + -((char)-11453), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 99510330643331L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.F();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(233304600 + (char)-11943, 233304600 + (char)-2009, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(233304600 + (char)-11942, -233304600 + -((char)-7056), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(233304600 + (char)-11941, -233304600 + -((char)-27833), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "F\u0094v\u00c3\u00f5\u0017\u009a/\u0010\u0004\u00f2\u00cf\u00aex\u0001\u00d2\u00b4|\b93\u0007o\u00cd\u009d";
                    var4_3 = "F\u0094v\u00c3\u00f5\u0017\u009a/\u0010\u0004\u00f2\u00cf\u00aex\u0001\u00d2\u00b4|\b93\u0007o\u00cd\u009d".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 1;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ce\u00a1\u0080\u0082\u00bc5\u00b0TXPu\u0000\u008c\u00d8'\u00d9'.\u00d4\u00c1U%\u009b\u00b7\u00abk\u001b\u00f0sB\u00d0u\u00b7\u008e\u0010]\u0003-\u00ccf8\u00e2\u0005\u00ca\u0000\u00e3\u001f\u0015\u00b1ZU\u0014f\u00e77\u009e\u00e7\u008fD";
                        var4_3 = "\u00ce\u00a1\u0080\u0082\u00bc5\u00b0TXPu\u0000\u008c\u00d8'\u00d9'.\u00d4\u00c1U%\u009b\u00b7\u00abk\u001b\u00f0sB\u00d0u\u00b7\u008e\u0010]\u0003-\u00ccf8\u00e2\u0005\u00ca\u0000\u00e3\u001f\u0015\u00b1ZU\u0014f\u00e77\u009e\u00e7\u008fD".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 6;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 77;
                                break;
                            }
                            case 1: {
                                v15 = 58;
                                break;
                            }
                            case 2: {
                                v15 = 56;
                                break;
                            }
                            case 3: {
                                v15 = 22;
                                break;
                            }
                            case 4: {
                                v15 = 51;
                                break;
                            }
                            case 5: {
                                v15 = 36;
                                break;
                            }
                            default: {
                                v15 = 77;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x10F3) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 66;
                    case 1 -> 176;
                    case 2 -> 175;
                    case 3 -> 190;
                    case 4 -> 12;
                    case 5 -> 226;
                    case 6 -> 120;
                    case 7 -> 98;
                    case 8 -> 152;
                    case 9 -> 72;
                    case 10 -> 255;
                    case 11 -> 219;
                    case 12 -> 29;
                    case 13 -> 42;
                    case 14 -> 140;
                    case 15 -> 145;
                    case 16 -> 159;
                    case 17 -> 113;
                    case 18 -> 111;
                    case 19 -> 209;
                    case 20 -> 53;
                    case 21 -> 166;
                    case 22 -> 48;
                    case 23 -> 236;
                    case 24 -> 35;
                    case 25 -> 171;
                    case 26 -> 11;
                    case 27 -> 27;
                    case 28 -> 233;
                    case 29 -> 224;
                    case 30 -> 49;
                    case 31 -> 137;
                    case 32 -> 70;
                    case 33 -> 211;
                    case 34 -> 144;
                    case 35 -> 155;
                    case 36 -> 47;
                    case 37 -> 89;
                    case 38 -> 235;
                    case 39 -> 124;
                    case 40 -> 80;
                    case 41 -> 91;
                    case 42 -> 147;
                    case 43 -> 153;
                    case 44 -> 132;
                    case 45 -> 102;
                    case 46 -> 198;
                    case 47 -> 165;
                    case 48 -> 127;
                    case 49 -> 110;
                    case 50 -> 93;
                    case 51 -> 60;
                    case 52 -> 50;
                    case 53 -> 188;
                    case 54 -> 9;
                    case 55 -> 96;
                    case 56 -> 59;
                    case 57 -> 10;
                    case 58 -> 64;
                    case 59 -> 62;
                    case 60 -> 168;
                    case 61 -> 183;
                    case 62 -> 37;
                    case 63 -> 191;
                    case 64 -> 13;
                    case 65 -> 5;
                    case 66 -> 225;
                    case 67 -> 142;
                    case 68 -> 17;
                    case 69 -> 178;
                    case 70 -> 0;
                    case 71 -> 104;
                    case 72 -> 141;
                    case 73 -> 156;
                    case 74 -> 194;
                    case 75 -> 31;
                    case 76 -> 83;
                    case 77 -> 103;
                    case 78 -> 239;
                    case 79 -> 88;
                    case 80 -> 101;
                    case 81 -> 197;
                    case 82 -> 231;
                    case 83 -> 221;
                    case 84 -> 157;
                    case 85 -> 95;
                    case 86 -> 55;
                    case 87 -> 4;
                    case 88 -> 32;
                    case 89 -> 241;
                    case 90 -> 68;
                    case 91 -> 46;
                    case 92 -> 218;
                    case 93 -> 125;
                    case 94 -> 174;
                    case 95 -> 77;
                    case 96 -> 121;
                    case 97 -> 14;
                    case 98 -> 119;
                    case 99 -> 36;
                    case 100 -> 163;
                    case 101 -> 67;
                    case 102 -> 202;
                    case 103 -> 69;
                    case 104 -> 172;
                    case 105 -> 107;
                    case 106 -> 173;
                    case 107 -> 106;
                    case 108 -> 109;
                    case 109 -> 78;
                    case 110 -> 61;
                    case 111 -> 24;
                    case 112 -> 229;
                    case 113 -> 185;
                    case 114 -> 148;
                    case 115 -> 23;
                    case 116 -> 99;
                    case 117 -> 207;
                    case 118 -> 30;
                    case 119 -> 86;
                    case 120 -> 90;
                    case 121 -> 84;
                    case 122 -> 2;
                    case 123 -> 75;
                    case 124 -> 100;
                    case 125 -> 65;
                    case 126 -> 200;
                    case 127 -> 220;
                    case 128 -> 39;
                    case 129 -> 28;
                    case 130 -> 214;
                    case 131 -> 250;
                    case 132 -> 169;
                    case 133 -> 6;
                    case 134 -> 184;
                    case 135 -> 249;
                    case 136 -> 128;
                    case 137 -> 227;
                    case 138 -> 105;
                    case 139 -> 247;
                    case 140 -> 136;
                    case 141 -> 114;
                    case 142 -> 16;
                    case 143 -> 138;
                    case 144 -> 201;
                    case 145 -> 133;
                    case 146 -> 34;
                    case 147 -> 117;
                    case 148 -> 143;
                    case 149 -> 230;
                    case 150 -> 108;
                    case 151 -> 112;
                    case 152 -> 240;
                    case 153 -> 25;
                    case 154 -> 21;
                    case 155 -> 115;
                    case 156 -> 181;
                    case 157 -> 164;
                    case 158 -> 44;
                    case 159 -> 199;
                    case 160 -> 139;
                    case 161 -> 38;
                    case 162 -> 170;
                    case 163 -> 54;
                    case 164 -> 251;
                    case 165 -> 193;
                    case 166 -> 76;
                    case 167 -> 160;
                    case 168 -> 186;
                    case 169 -> 150;
                    case 170 -> 130;
                    case 171 -> 245;
                    case 172 -> 40;
                    case 173 -> 234;
                    case 174 -> 208;
                    case 175 -> 213;
                    case 176 -> 26;
                    case 177 -> 82;
                    case 178 -> 151;
                    case 179 -> 192;
                    case 180 -> 131;
                    case 181 -> 248;
                    case 182 -> 33;
                    case 183 -> 167;
                    case 184 -> 196;
                    case 185 -> 187;
                    case 186 -> 161;
                    case 187 -> 63;
                    case 188 -> 87;
                    case 189 -> 3;
                    case 190 -> 22;
                    case 191 -> 179;
                    case 192 -> 180;
                    case 193 -> 232;
                    case 194 -> 242;
                    case 195 -> 129;
                    case 196 -> 244;
                    case 197 -> 123;
                    case 198 -> 195;
                    case 199 -> 254;
                    case 200 -> 158;
                    case 201 -> 243;
                    case 202 -> 210;
                    case 203 -> 118;
                    case 204 -> 149;
                    case 205 -> 74;
                    case 206 -> 146;
                    case 207 -> 252;
                    case 208 -> 122;
                    case 209 -> 237;
                    case 210 -> 228;
                    case 211 -> 18;
                    case 212 -> 73;
                    case 213 -> 81;
                    case 214 -> 177;
                    case 215 -> 238;
                    case 216 -> 217;
                    case 217 -> 223;
                    case 218 -> 222;
                    case 219 -> 162;
                    case 220 -> 92;
                    case 221 -> 58;
                    case 222 -> 126;
                    case 223 -> 205;
                    case 224 -> 85;
                    case 225 -> 154;
                    case 226 -> 246;
                    case 227 -> 19;
                    case 228 -> 51;
                    case 229 -> 216;
                    case 230 -> 206;
                    case 231 -> 52;
                    case 232 -> 134;
                    case 233 -> 204;
                    case 234 -> 8;
                    case 235 -> 253;
                    case 236 -> 71;
                    case 237 -> 94;
                    case 238 -> 189;
                    case 239 -> 45;
                    case 240 -> 15;
                    case 241 -> 1;
                    case 242 -> 57;
                    case 243 -> 41;
                    case 244 -> 116;
                    case 245 -> 203;
                    case 246 -> 20;
                    case 247 -> 135;
                    case 248 -> 182;
                    case 249 -> 43;
                    case 250 -> 212;
                    case 251 -> 97;
                    case 252 -> 56;
                    case 253 -> 215;
                    case 254 -> 7;
                    default -> 79;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 111325852467008L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "6}id$qmo\t1wzni3ps1";
                    var5_4 = "6}id$qmo\t1wzni3ps1".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 104;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 53;
                                    break;
                                }
                                case 1: {
                                    v11 = 112;
                                    break;
                                }
                                case 2: {
                                    v11 = 115;
                                    break;
                                }
                                case 3: {
                                    v11 = 98;
                                    break;
                                }
                                case 4: {
                                    v11 = 41;
                                    break;
                                }
                                case 5: {
                                    v11 = 117;
                                    break;
                                }
                                default: {
                                    v11 = 54;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 102031217363331L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "Z:.lF?k\u0004\\$\"v\nP;)vJ=sz: \tP;)vJ=sv0\rW=4{@0iv73qA9";
                    var5_4 = "Z:.lF?k\u0004\\$\"v\nP;)vJ=sz: \tP;)vJ=sv0\rW=4{@0iv73qA9".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 118;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "c\u000b\u001bXu\u0003S\u0006c\u000b\u001bXy\t";
                        var5_4 = "c\u000b\u001bXu\u0003S\u0006c\u000b\u001bXy\t".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 69;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 101;
                                break;
                            }
                            case 1: {
                                v15 = 34;
                                break;
                            }
                            case 2: {
                                v15 = 49;
                                break;
                            }
                            case 3: {
                                v15 = 110;
                                break;
                            }
                            case 4: {
                                v15 = 89;
                                break;
                            }
                            case 5: {
                                v15 = 40;
                                break;
                            }
                            default: {
                                v15 = 113;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 13816347212448L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-562552440 + -((char)-32535), -562552440 + -((char)-25636), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 5351627479185L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0000\u00f7\u000f\u00b5@\u0003\u00ac-.\u0005\u008c\u0018\u00b8\u008cU\rR\u00d5U\u007f\u001d\u00a03\u00e0\u00ca\u0091\u00d2D\u0092\u0010|\u00aaW{b\u00b5\u00f7\u007f\u009b\u00e6\u001b\u00e7M\u0093\u00d9A\u0005/\u0085\u00cc?\u00db3\u00c6\u008d\u00e0IA\u00b7\u00a3+l\u0091n %:\u00f8kn\\\u008c\u00ff\u00d9\u00de\u00e9\u007fq\u00a3\u0083\u0083\u0092\u00ec\u001c\u007f\u0000c\u00c0\u0093D\u00d6\u00a1\u0084_\"\u0012* QH\u008c\u00fay\n";
                    var4_3 = "\u0000\u00f7\u000f\u00b5@\u0003\u00ac-.\u0005\u008c\u0018\u00b8\u008cU\rR\u00d5U\u007f\u001d\u00a03\u00e0\u00ca\u0091\u00d2D\u0092\u0010|\u00aaW{b\u00b5\u00f7\u007f\u009b\u00e6\u001b\u00e7M\u0093\u00d9A\u0005/\u0085\u00cc?\u00db3\u00c6\u008d\u00e0IA\u00b7\u00a3+l\u0091n %:\u00f8kn\\\u008c\u00ff\u00d9\u00de\u00e9\u007fq\u00a3\u0083\u0083\u0092\u00ec\u001c\u007f\u0000c\u00c0\u0093D\u00d6\u00a1\u0084_\"\u0012* QH\u008c\u00fay\n".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 110;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0003\u009c?:\u00e8\u001a!\r\u00c6/7YO\u00c3\u001e\u00ccLtP&i\u00e1\u00b8n7\u00a6\u00fb\u0097zU)\u00ce\u00e8*z|J(\u008bz\u00f0\u00a7>\u00fbq\u00e0|:\u0085SU\\\u00ceb$\u00d8;\u00c1\u00af\u0089a\u00c1a85\u0081\u00fd\n\u0080--\u00a9\u00ec\u00d9\u00a7\u0004\u0098\u00a1\r\u00b0\f=\u0085\u00ed\u00cbp\u00e4<\u0081\u009bhG\u009f";
                        var4_3 = "\u0003\u009c?:\u00e8\u001a!\r\u00c6/7YO\u00c3\u001e\u00ccLtP&i\u00e1\u00b8n7\u00a6\u00fb\u0097zU)\u00ce\u00e8*z|J(\u008bz\u00f0\u00a7>\u00fbq\u00e0|:\u0085SU\\\u00ceb$\u00d8;\u00c1\u00af\u0089a\u00c1a85\u0081\u00fd\n\u0080--\u00a9\u00ec\u00d9\u00a7\u0004\u0098\u00a1\r\u00b0\f=\u0085\u00ed\u00cbp\u00e4<\u0081\u009bhG\u009f".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 32;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 86;
                                break;
                            }
                            case 1: {
                                v15 = 114;
                                break;
                            }
                            case 2: {
                                v15 = 78;
                                break;
                            }
                            case 3: {
                                v15 = 67;
                                break;
                            }
                            case 4: {
                                v15 = 118;
                                break;
                            }
                            case 5: {
                                v15 = 2;
                                break;
                            }
                            default: {
                                v15 = 1;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x1A3F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 75;
                    case 1 -> 114;
                    case 2 -> 26;
                    case 3 -> 175;
                    case 4 -> 235;
                    case 5 -> 83;
                    case 6 -> 85;
                    case 7 -> 52;
                    case 8 -> 138;
                    case 9 -> 53;
                    case 10 -> 240;
                    case 11 -> 45;
                    case 12 -> 184;
                    case 13 -> 127;
                    case 14 -> 80;
                    case 15 -> 159;
                    case 16 -> 207;
                    case 17 -> 54;
                    case 18 -> 192;
                    case 19 -> 65;
                    case 20 -> 12;
                    case 21 -> 71;
                    case 22 -> 103;
                    case 23 -> 49;
                    case 24 -> 199;
                    case 25 -> 78;
                    case 26 -> 160;
                    case 27 -> 243;
                    case 28 -> 161;
                    case 29 -> 110;
                    case 30 -> 70;
                    case 31 -> 36;
                    case 32 -> 63;
                    case 33 -> 99;
                    case 34 -> 50;
                    case 35 -> 82;
                    case 36 -> 6;
                    case 37 -> 163;
                    case 38 -> 216;
                    case 39 -> 232;
                    case 40 -> 255;
                    case 41 -> 5;
                    case 42 -> 109;
                    case 43 -> 128;
                    case 44 -> 208;
                    case 45 -> 2;
                    case 46 -> 62;
                    case 47 -> 108;
                    case 48 -> 115;
                    case 49 -> 61;
                    case 50 -> 56;
                    case 51 -> 150;
                    case 52 -> 135;
                    case 53 -> 91;
                    case 54 -> 215;
                    case 55 -> 25;
                    case 56 -> 179;
                    case 57 -> 154;
                    case 58 -> 48;
                    case 59 -> 24;
                    case 60 -> 203;
                    case 61 -> 242;
                    case 62 -> 244;
                    case 63 -> 225;
                    case 64 -> 69;
                    case 65 -> 211;
                    case 66 -> 18;
                    case 67 -> 191;
                    case 68 -> 193;
                    case 69 -> 147;
                    case 70 -> 136;
                    case 71 -> 213;
                    case 72 -> 121;
                    case 73 -> 139;
                    case 74 -> 92;
                    case 75 -> 43;
                    case 76 -> 107;
                    case 77 -> 168;
                    case 78 -> 209;
                    case 79 -> 217;
                    case 80 -> 228;
                    case 81 -> 212;
                    case 82 -> 40;
                    case 83 -> 90;
                    case 84 -> 16;
                    case 85 -> 153;
                    case 86 -> 38;
                    case 87 -> 142;
                    case 88 -> 93;
                    case 89 -> 129;
                    case 90 -> 206;
                    case 91 -> 94;
                    case 92 -> 100;
                    case 93 -> 219;
                    case 94 -> 72;
                    case 95 -> 79;
                    case 96 -> 177;
                    case 97 -> 88;
                    case 98 -> 197;
                    case 99 -> 246;
                    case 100 -> 51;
                    case 101 -> 102;
                    case 102 -> 166;
                    case 103 -> 152;
                    case 104 -> 123;
                    case 105 -> 198;
                    case 106 -> 178;
                    case 107 -> 189;
                    case 108 -> 8;
                    case 109 -> 227;
                    case 110 -> 60;
                    case 111 -> 134;
                    case 112 -> 57;
                    case 113 -> 185;
                    case 114 -> 224;
                    case 115 -> 131;
                    case 116 -> 230;
                    case 117 -> 126;
                    case 118 -> 33;
                    case 119 -> 218;
                    case 120 -> 141;
                    case 121 -> 180;
                    case 122 -> 124;
                    case 123 -> 31;
                    case 124 -> 220;
                    case 125 -> 145;
                    case 126 -> 195;
                    case 127 -> 140;
                    case 128 -> 132;
                    case 129 -> 112;
                    case 130 -> 32;
                    case 131 -> 155;
                    case 132 -> 125;
                    case 133 -> 118;
                    case 134 -> 188;
                    case 135 -> 149;
                    case 136 -> 67;
                    case 137 -> 1;
                    case 138 -> 252;
                    case 139 -> 35;
                    case 140 -> 176;
                    case 141 -> 73;
                    case 142 -> 174;
                    case 143 -> 58;
                    case 144 -> 14;
                    case 145 -> 77;
                    case 146 -> 96;
                    case 147 -> 15;
                    case 148 -> 68;
                    case 149 -> 196;
                    case 150 -> 81;
                    case 151 -> 87;
                    case 152 -> 214;
                    case 153 -> 226;
                    case 154 -> 29;
                    case 155 -> 241;
                    case 156 -> 119;
                    case 157 -> 234;
                    case 158 -> 17;
                    case 159 -> 183;
                    case 160 -> 221;
                    case 161 -> 0;
                    case 162 -> 164;
                    case 163 -> 200;
                    case 164 -> 120;
                    case 165 -> 210;
                    case 166 -> 251;
                    case 167 -> 133;
                    case 168 -> 222;
                    case 169 -> 74;
                    case 170 -> 170;
                    case 171 -> 190;
                    case 172 -> 231;
                    case 173 -> 254;
                    case 174 -> 143;
                    case 175 -> 76;
                    case 176 -> 182;
                    case 177 -> 187;
                    case 178 -> 47;
                    case 179 -> 233;
                    case 180 -> 23;
                    case 181 -> 247;
                    case 182 -> 151;
                    case 183 -> 27;
                    case 184 -> 171;
                    case 185 -> 7;
                    case 186 -> 194;
                    case 187 -> 89;
                    case 188 -> 186;
                    case 189 -> 39;
                    case 190 -> 98;
                    case 191 -> 21;
                    case 192 -> 204;
                    case 193 -> 9;
                    case 194 -> 157;
                    case 195 -> 104;
                    case 196 -> 42;
                    case 197 -> 137;
                    case 198 -> 229;
                    case 199 -> 97;
                    case 200 -> 55;
                    case 201 -> 46;
                    case 202 -> 19;
                    case 203 -> 101;
                    case 204 -> 117;
                    case 205 -> 122;
                    case 206 -> 169;
                    case 207 -> 205;
                    case 208 -> 158;
                    case 209 -> 201;
                    case 210 -> 44;
                    case 211 -> 111;
                    case 212 -> 202;
                    case 213 -> 20;
                    case 214 -> 59;
                    case 215 -> 86;
                    case 216 -> 30;
                    case 217 -> 4;
                    case 218 -> 167;
                    case 219 -> 144;
                    case 220 -> 239;
                    case 221 -> 146;
                    case 222 -> 64;
                    case 223 -> 172;
                    case 224 -> 162;
                    case 225 -> 106;
                    case 226 -> 116;
                    case 227 -> 173;
                    case 228 -> 28;
                    case 229 -> 238;
                    case 230 -> 245;
                    case 231 -> 249;
                    case 232 -> 66;
                    case 233 -> 10;
                    case 234 -> 11;
                    case 235 -> 181;
                    case 236 -> 105;
                    case 237 -> 3;
                    case 238 -> 148;
                    case 239 -> 41;
                    case 240 -> 248;
                    case 241 -> 95;
                    case 242 -> 223;
                    case 243 -> 156;
                    case 244 -> 13;
                    case 245 -> 237;
                    case 246 -> 253;
                    case 247 -> 34;
                    case 248 -> 236;
                    case 249 -> 113;
                    case 250 -> 37;
                    case 251 -> 250;
                    case 252 -> 84;
                    case 253 -> 165;
                    case 254 -> 22;
                    default -> 130;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 78851907128739L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(602528790 + 11269, 602528790 + (char)-24612, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 63317426462593L;
                    String string = SshAgentIpcService.F();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1018544970 + (char)-26898, -1018544970 + -28182, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 88689754496564L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "X4\u00c5\u00ecW\u0003\u00bb{\u00ef";
                var4_3 = "X4\u00c5\u00ecW\u0003\u00bb{\u00ef".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 76;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 122;
                                break;
                            }
                            case 1: {
                                v11 = 43;
                                break;
                            }
                            case 2: {
                                v11 = 108;
                                break;
                            }
                            case 3: {
                                v11 = 47;
                                break;
                            }
                            case 4: {
                                v11 = 26;
                                break;
                            }
                            case 5: {
                                v11 = 111;
                                break;
                            }
                            default: {
                                v11 = 5;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x5B8) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 251;
                    case 1 -> 200;
                    case 2 -> 113;
                    case 3 -> 40;
                    case 4 -> 137;
                    case 5 -> 34;
                    case 6 -> 159;
                    case 7 -> 70;
                    case 8 -> 140;
                    case 9 -> 247;
                    case 10 -> 82;
                    case 11 -> 106;
                    case 12 -> 102;
                    case 13 -> 6;
                    case 14 -> 59;
                    case 15 -> 48;
                    case 16 -> 253;
                    case 17 -> 214;
                    case 18 -> 47;
                    case 19 -> 177;
                    case 20 -> 72;
                    case 21 -> 76;
                    case 22 -> 255;
                    case 23 -> 84;
                    case 24 -> 227;
                    case 25 -> 58;
                    case 26 -> 12;
                    case 27 -> 27;
                    case 28 -> 206;
                    case 29 -> 125;
                    case 30 -> 85;
                    case 31 -> 211;
                    case 32 -> 250;
                    case 33 -> 130;
                    case 34 -> 213;
                    case 35 -> 216;
                    case 36 -> 32;
                    case 37 -> 44;
                    case 38 -> 239;
                    case 39 -> 107;
                    case 40 -> 51;
                    case 41 -> 228;
                    case 42 -> 118;
                    case 43 -> 188;
                    case 44 -> 21;
                    case 45 -> 186;
                    case 46 -> 138;
                    case 47 -> 191;
                    case 48 -> 170;
                    case 49 -> 123;
                    case 50 -> 78;
                    case 51 -> 245;
                    case 52 -> 109;
                    case 53 -> 175;
                    case 54 -> 172;
                    case 55 -> 164;
                    case 56 -> 23;
                    case 57 -> 252;
                    case 58 -> 86;
                    case 59 -> 36;
                    case 60 -> 246;
                    case 61 -> 181;
                    case 62 -> 80;
                    case 63 -> 9;
                    case 64 -> 17;
                    case 65 -> 87;
                    case 66 -> 210;
                    case 67 -> 173;
                    case 68 -> 129;
                    case 69 -> 28;
                    case 70 -> 53;
                    case 71 -> 45;
                    case 72 -> 151;
                    case 73 -> 203;
                    case 74 -> 1;
                    case 75 -> 112;
                    case 76 -> 147;
                    case 77 -> 198;
                    case 78 -> 146;
                    case 79 -> 144;
                    case 80 -> 230;
                    case 81 -> 4;
                    case 82 -> 81;
                    case 83 -> 202;
                    case 84 -> 232;
                    case 85 -> 95;
                    case 86 -> 220;
                    case 87 -> 79;
                    case 88 -> 169;
                    case 89 -> 176;
                    case 90 -> 185;
                    case 91 -> 155;
                    case 92 -> 166;
                    case 93 -> 148;
                    case 94 -> 221;
                    case 95 -> 122;
                    case 96 -> 64;
                    case 97 -> 29;
                    case 98 -> 195;
                    case 99 -> 93;
                    case 100 -> 133;
                    case 101 -> 96;
                    case 102 -> 65;
                    case 103 -> 15;
                    case 104 -> 248;
                    case 105 -> 209;
                    case 106 -> 104;
                    case 107 -> 162;
                    case 108 -> 99;
                    case 109 -> 39;
                    case 110 -> 66;
                    case 111 -> 141;
                    case 112 -> 19;
                    case 113 -> 116;
                    case 114 -> 30;
                    case 115 -> 10;
                    case 116 -> 3;
                    case 117 -> 55;
                    case 118 -> 25;
                    case 119 -> 233;
                    case 120 -> 153;
                    case 121 -> 98;
                    case 122 -> 189;
                    case 123 -> 249;
                    case 124 -> 235;
                    case 125 -> 222;
                    case 126 -> 94;
                    case 127 -> 105;
                    case 128 -> 117;
                    case 129 -> 0;
                    case 130 -> 63;
                    case 131 -> 150;
                    case 132 -> 161;
                    case 133 -> 103;
                    case 134 -> 26;
                    case 135 -> 142;
                    case 136 -> 207;
                    case 137 -> 108;
                    case 138 -> 8;
                    case 139 -> 62;
                    case 140 -> 68;
                    case 141 -> 35;
                    case 142 -> 33;
                    case 143 -> 163;
                    case 144 -> 83;
                    case 145 -> 154;
                    case 146 -> 218;
                    case 147 -> 31;
                    case 148 -> 199;
                    case 149 -> 67;
                    case 150 -> 212;
                    case 151 -> 226;
                    case 152 -> 201;
                    case 153 -> 121;
                    case 154 -> 160;
                    case 155 -> 91;
                    case 156 -> 237;
                    case 157 -> 219;
                    case 158 -> 238;
                    case 159 -> 71;
                    case 160 -> 231;
                    case 161 -> 101;
                    case 162 -> 61;
                    case 163 -> 205;
                    case 164 -> 42;
                    case 165 -> 165;
                    case 166 -> 229;
                    case 167 -> 22;
                    case 168 -> 49;
                    case 169 -> 208;
                    case 170 -> 158;
                    case 171 -> 178;
                    case 172 -> 197;
                    case 173 -> 243;
                    case 174 -> 97;
                    case 175 -> 52;
                    case 176 -> 111;
                    case 177 -> 88;
                    case 178 -> 240;
                    case 179 -> 46;
                    case 180 -> 143;
                    case 181 -> 234;
                    case 182 -> 126;
                    case 183 -> 119;
                    case 184 -> 225;
                    case 185 -> 92;
                    case 186 -> 2;
                    case 187 -> 134;
                    case 188 -> 132;
                    case 189 -> 190;
                    case 190 -> 217;
                    case 191 -> 73;
                    case 192 -> 128;
                    case 193 -> 24;
                    case 194 -> 192;
                    case 195 -> 7;
                    case 196 -> 89;
                    case 197 -> 184;
                    case 198 -> 43;
                    case 199 -> 156;
                    case 200 -> 60;
                    case 201 -> 152;
                    case 202 -> 11;
                    case 203 -> 241;
                    case 204 -> 180;
                    case 205 -> 114;
                    case 206 -> 145;
                    case 207 -> 37;
                    case 208 -> 215;
                    case 209 -> 139;
                    case 210 -> 100;
                    case 211 -> 136;
                    case 212 -> 174;
                    case 213 -> 5;
                    case 214 -> 18;
                    case 215 -> 179;
                    case 216 -> 131;
                    case 217 -> 74;
                    case 218 -> 50;
                    case 219 -> 236;
                    case 220 -> 193;
                    case 221 -> 20;
                    case 222 -> 41;
                    case 223 -> 254;
                    case 224 -> 244;
                    case 225 -> 16;
                    case 226 -> 57;
                    case 227 -> 204;
                    case 228 -> 183;
                    case 229 -> 242;
                    case 230 -> 167;
                    case 231 -> 149;
                    case 232 -> 187;
                    case 233 -> 157;
                    case 234 -> 124;
                    case 235 -> 120;
                    case 236 -> 13;
                    case 237 -> 196;
                    case 238 -> 38;
                    case 239 -> 224;
                    case 240 -> 54;
                    case 241 -> 14;
                    case 242 -> 110;
                    case 243 -> 168;
                    case 244 -> 223;
                    case 245 -> 194;
                    case 246 -> 69;
                    case 247 -> 56;
                    case 248 -> 77;
                    case 249 -> 171;
                    case 250 -> 115;
                    case 251 -> 90;
                    case 252 -> 127;
                    case 253 -> 182;
                    case 254 -> 135;
                    default -> 75;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

