/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/jpa/jpb/model/util/FileTypeUtil;", "", "<init>", "()V", "isSqlFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isLiquibaseChangeLog", "psiFile", "intellij.javaee.jpa.jpb.model"})
public final class FileTypeUtil {
    @NotNull
    public static final FileTypeUtil INSTANCE = new FileTypeUtil();

    private FileTypeUtil() {
    }

    @JvmStatic
    public static final boolean isSqlFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile vf = file.getVirtualFile();
        return vf != null && Intrinsics.areEqual((Object)"sql", (Object)vf.getExtension());
    }

    @JvmStatic
    public static final boolean isLiquibaseChangeLog(@Nullable PsiFile psiFile) {
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        XmlTag xmlTag = ((XmlFile)psiFile).getRootTag();
        if (xmlTag == null) {
            return false;
        }
        XmlTag rootTag = xmlTag;
        return Intrinsics.areEqual((Object)rootTag.getLocalName(), (Object)"databaseChangeLog") && Intrinsics.areEqual((Object)rootTag.getNamespace(), (Object)"http://www.liquibase.org/xml/ns/dbchangelog");
    }
}

