/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chat.completion.context;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.summary.ChatSummaryStateWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0006J\b\u0010\r\u001a\u00020\tH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/chat/completion/context/ChatSummaryCache;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "Lcom/intellij/ml/llm/core/chat/session/summary/ChatSummaryStateWrapper;", "cacheSummary", "", "chatSession", "summaryState", "getCachedSummary", "dispose", "Companion", "intellij.ml.llm.chat.completion"})
public final class ChatSummaryCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<ChatSession, ChatSummaryStateWrapper> cache;
    private static final long CACHE_SIZE = 10L;
    private static final long CACHE_TTL = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES);

    public ChatSummaryCache() {
        Cache cache = Caffeine.newBuilder().maximumSize(10L).expireAfterAccess(Duration.getInWholeMinutes-impl((long)CACHE_TTL), TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    public final void cacheSummary(@NotNull ChatSession chatSession, @NotNull ChatSummaryStateWrapper summaryState) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        Intrinsics.checkNotNullParameter((Object)summaryState, (String)"summaryState");
        this.cache.put((Object)chatSession, (Object)summaryState);
    }

    @Nullable
    public final ChatSummaryStateWrapper getCachedSummary(@NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        return (ChatSummaryStateWrapper)this.cache.getIfPresent((Object)chatSession);
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/chat/completion/context/ChatSummaryCache$Companion;", "", "<init>", "()V", "CACHE_SIZE", "", "CACHE_TTL", "Lkotlin/time/Duration;", "J", "getInstance", "Lcom/intellij/ml/llm/chat/completion/context/ChatSummaryCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.chat.completion"})
    @SourceDebugExtension(value={"SMAP\nChatSummaryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatSummaryCache.kt\ncom/intellij/ml/llm/chat/completion/context/ChatSummaryCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,44:1\n30#2,2:45\n*S KotlinDebug\n*F\n+ 1 ChatSummaryCache.kt\ncom/intellij/ml/llm/chat/completion/context/ChatSummaryCache$Companion\n*L\n42#1:45,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChatSummaryCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ChatSummaryCache> serviceClass$iv = ChatSummaryCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ChatSummaryCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

