/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.field.WithByFieldProcessor;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WithByProcessor
extends AbstractClassProcessor {
    public WithByProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.WithBy");
    }

    private static WithByFieldProcessor getFieldProcessor() {
        return LombokProcessorManager.getInstance().getWithByFieldProcessor();
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            WithByProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            WithByProcessor.$$$reportNull$$$0(1);
        }
        ArrayList<String> result = new ArrayList<String>();
        Collection<PsiField> psiFields = this.filterWithByElements(psiClass);
        if (!psiFields.isEmpty()) {
            AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
            for (PsiField psiField : psiFields) {
                AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField, classAccessorsValues);
                result.add(LombokUtils.getWithByName((PsiVariable)psiField, accessorsInfo));
            }
        }
        return result;
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            WithByProcessor.$$$reportNull$$$0(2);
        }
        if (psiClass == null) {
            WithByProcessor.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            WithByProcessor.$$$reportNull$$$0(4);
        }
        WithByProcessor.validateAnnotationOnRightType(psiClass, builder);
        WithByProcessor.validateVisibility(psiAnnotation, builder);
        WithByProcessor.validateOnX(psiAnnotation, builder);
        return builder.success();
    }

    private static void validateOnX(@NotNull PsiAnnotation psiAnnotation, @NotNull ProblemSink builder) {
        Iterable<String> onXAnnotations;
        if (psiAnnotation == null) {
            WithByProcessor.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            WithByProcessor.$$$reportNull$$$0(6);
        }
        if ((onXAnnotations = LombokProcessorUtil.getOnX(psiAnnotation, "onMethod")).iterator().hasNext()) {
            builder.addErrorMessage("inspection.message.withby.onmethod.not.supported.on.class.type", new Object[0]);
            builder.markFailed();
        }
    }

    private static void validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            WithByProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            WithByProcessor.$$$reportNull$$$0(8);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            builder.addErrorMessage("inspection.message.withby.only.supported.on.class.or.field.type", new Object[0]);
            builder.markFailed();
        }
    }

    private static void validateVisibility(@NotNull PsiAnnotation psiAnnotation, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            WithByProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            WithByProcessor.$$$reportNull$$$0(10);
        }
        if (null == LombokProcessorUtil.getMethodModifier(psiAnnotation)) {
            builder.markFailed();
        }
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        String methodVisibility;
        if (psiClass == null) {
            WithByProcessor.$$$reportNull$$$0(11);
        }
        if (psiAnnotation == null) {
            WithByProcessor.$$$reportNull$$$0(12);
        }
        if (target == null) {
            WithByProcessor.$$$reportNull$$$0(13);
        }
        if ((methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null) {
            target.addAll(this.createFieldWithBys(psiClass, methodVisibility, nameHint));
        }
    }

    @NotNull
    private Collection<PsiMethod> createFieldWithBys(@NotNull PsiClass psiClass, @NotNull String methodModifier, @Nullable String nameHint) {
        if (psiClass == null) {
            WithByProcessor.$$$reportNull$$$0(14);
        }
        if (methodModifier == null) {
            WithByProcessor.$$$reportNull$$$0(15);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Collection<PsiField> psiFields = this.filterWithByElements(psiClass);
        if (!psiFields.isEmpty()) {
            AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
            for (PsiField psiField : psiFields) {
                AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField, classAccessorsValues);
                ContainerUtil.addIfNotNull(result, (Object)WithByProcessor.getFieldProcessor().createWithByMethod(psiField, methodModifier, accessorsInfo, nameHint));
            }
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            WithByProcessor.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private Collection<PsiField> filterWithByElements(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WithByProcessor.$$$reportNull$$$0(17);
        }
        ArrayList<PsiField> psiElements = new ArrayList<PsiField>();
        Collection<PsiField> psiFields = psiClass.isRecord() ? Arrays.asList(psiClass.getFields()) : PsiClassUtil.collectClassFieldsIntern(psiClass);
        for (PsiField psiField : psiFields) {
            if (!WithByProcessor.shouldCreateWithBy(psiField)) continue;
            psiElements.add(psiField);
        }
        ArrayList<PsiField> arrayList = psiElements;
        if (arrayList == null) {
            WithByProcessor.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static boolean shouldCreateWithBy(@NotNull PsiField psiField) {
        if (psiField == null) {
            WithByProcessor.$$$reportNull$$$0(19);
        }
        boolean createWithBy = !psiField.hasModifierProperty("static");
        createWithBy &= !psiField.getName().startsWith("$");
        createWithBy &= PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiField, "lombok.experimental.WithBy");
        return createWithBy &= !psiField.hasModifierProperty("final") || !psiField.hasInitializer();
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            WithByProcessor.$$$reportNull$$$0(20);
        }
        if (psiAnnotation == null) {
            WithByProcessor.$$$reportNull$$$0(21);
        }
        if (WithByProcessor.shouldCreateWithBy(psiField)) {
            return LombokPsiElementUsage.READ_WRITE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/WithByProcessor";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/WithByProcessor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldWithBys";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterWithByElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateOnX";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFieldWithBys";
                break;
            }
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterWithByElements";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateWithBy";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 18 -> new IllegalStateException(string);
        };
    }
}

