/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.coverage;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.coverage.xml.XMLReportEngine;
import com.intellij.coverage.xml.XMLReportSuite;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.report.XMLProjectData;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KotlinLightMethodUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.coverage.CoverageLanguage;
import org.jetbrains.qodana.jvm.coverage.JvmCoverageInspectionKt;
import org.jetbrains.qodana.jvm.coverage.MethodType;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageInspectionBase;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageStatisticsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.UtilsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.Xml_mergerKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverageData.CoverageStatisticsData;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.stat.CoverageFeatureEventsCollector;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.UastAnonymousClassUtil;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001aH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase;", "<init>", "()V", "languages", "", "", "loadCoverage", "", "globalContext", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "loadReportForIncrementalAnalysis", "processReportData", "data", "Lcom/intellij/rt/coverage/data/ProjectData;", "checker", "file", "Lcom/intellij/psi/PsiFile;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "validateFileType", "", "cleanup", "computeXmlCoverageData", "Lcom/intellij/rt/coverage/report/XMLProjectData;", "engineType", "Lkotlin/reflect/KClass;", "Lcom/intellij/coverage/CoverageEngine;", "Companion", "JVMDefVisitor", "intellij.qodana.jvm.coverage"})
@SourceDebugExtension(value={"SMAP\nJvmCoverageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCoverageInspection.kt\norg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,340:1\n1761#2,3:341\n774#2:344\n865#2,2:345\n1869#2,2:347\n1761#2,3:378\n1#3:349\n1#3:372\n536#4:350\n521#4,6:351\n216#5,2:357\n10468#6:359\n10890#6,2:360\n11879#6,9:362\n13805#6:371\n13806#6:373\n11888#6:374\n10892#6,3:375\n*S KotlinDebug\n*F\n+ 1 JvmCoverageInspection.kt\norg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection\n*L\n71#1:341,3\n74#1:344\n74#1:345,2\n86#1:347,2\n82#1:378,3\n77#1:372\n97#1:350\n97#1:351,6\n101#1:357,2\n76#1:359\n76#1:360,2\n77#1:362,9\n77#1:371\n77#1:373\n77#1:374\n76#1:375,3\n*E\n"})
public final class JvmCoverageInspection
extends CoverageInspectionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> languages;
    @NotNull
    private static final Key<Lazy<ProjectData>> javacov;
    @NotNull
    private static final Key<Lazy<XMLProjectData>> xmlcov;

    public JvmCoverageInspection() {
        Object[] objectArray = new String[]{"Java", "Kotlin"};
        this.languages = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public void loadCoverage(@NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        globalContext.putUserData(javacov, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> JvmCoverageInspection.loadCoverage$lambda$0(this, globalContext)));
        globalContext.putUserData(xmlcov, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> JvmCoverageInspection.loadCoverage$lambda$1(this, globalContext)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadReportForIncrementalAnalysis(@NotNull QodanaGlobalInspectionContext globalContext) {
        block8: {
            Lazy lazy;
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
                Collection collection = Language.getRegisteredLanguages();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Language it = (Language)element$iv;
                        boolean bl2 = false;
                        if (!this.languages.contains(it.getDisplayName())) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (!bl) break block8;
            CoverageStatisticsData stat = globalContext.getCoverageStatisticsData();
            Lazy lazy2 = (Lazy)globalContext.getUserData(xmlcov);
            Object xmlReport = lazy2 != null ? (XMLProjectData)lazy2.getValue() : null;
            Object object = xmlReport;
            if (object != null && (object = object.getFiles()) != null) {
                void $this$forEach$iv;
                Iterator $this$filterTo$iv$iv;
                Iterable $this$filter$iv = (Iterable)object;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    XMLProjectData.FileInfo fileInfo = (XMLProjectData.FileInfo)element$iv$iv;
                    boolean bl3 = false;
                    if (!((Boolean)ActionsKt.runReadAction(() -> JvmCoverageInspection.loadReportForIncrementalAnalysis$lambda$1$0(globalContext, fileInfo))).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    XMLProjectData.FileInfo x = (XMLProjectData.FileInfo)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)x);
                    CoverageStatisticsKt.processReportXmlData(stat, x);
                }
            }
            if ((lazy = (Lazy)globalContext.getUserData(javacov)) != null && (lazy = (ProjectData)lazy.getValue()) != null) {
                Lazy it = lazy;
                boolean bl5 = false;
                this.loadReportData(globalContext, (ProjectData)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processReportData(@NotNull ProjectData data, @NotNull QodanaGlobalInspectionContext globalContext) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        CoverageStatisticsData stat = globalContext.getCoverageStatisticsData();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)globalContext.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        Map map2 = data.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getClasses(...)");
        Map $this$filter$iv = map2;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Boolean)ActionsKt.runReadAction(() -> JvmCoverageInspection.processReportData$lambda$0$0(globalContext, it, searchScope))).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry x = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            Object v = x.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            CoverageStatisticsKt.processReportClassData(stat, (ClassData)v);
        }
    }

    @Override
    public void checker(@NotNull PsiFile file2, @NotNull ProblemsHolder problemsHolder, @NotNull QodanaGlobalInspectionContext globalContext) {
        XMLProjectData xmlReport;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Lazy lazy = (Lazy)globalContext.getUserData(javacov);
        ProjectData report2 = lazy != null ? (ProjectData)lazy.getValue() : null;
        Lazy lazy2 = (Lazy)globalContext.getUserData(xmlcov);
        Object object = xmlReport = lazy2 != null ? (XMLProjectData)lazy2.getValue() : null;
        if (report2 == null && xmlReport == null) {
            return;
        }
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UClass.class, UMethod.class};
        UtilsKt.iterateContents(file2, UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new JVMDefVisitor(globalContext, problemsHolder, this.getMethodThreshold(), this.getClassThreshold(), this.getWarnMissingCoverage(), report2, xmlReport, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>((Object)this){

            public final PsiElement invoke(PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JvmCoverageInspection.access$highlightedElement((JvmCoverageInspection)((Object)this.receiver), p0);
            }
        })), classArray, true));
    }

    @Override
    public boolean validateFileType(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.languages.contains(file2.getLanguage().getDisplayName());
    }

    @Override
    public void cleanup(@NotNull QodanaGlobalInspectionContext globalContext) {
        ProjectData data;
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Lazy lazy = (Lazy)globalContext.getUserData(javacov);
        Object object = data = lazy != null ? (ProjectData)lazy.getValue() : null;
        if (data != null) {
            String string = JavaCoverageEngine.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            this.saveCoverageData(globalContext, string, data);
        }
        globalContext.putUserData(javacov, null);
        globalContext.putUserData(xmlcov, null);
    }

    private final XMLProjectData computeXmlCoverageData(QodanaGlobalInspectionContext globalContext, KClass<? extends CoverageEngine> engineType) {
        List<File> coverageFiles = this.provideCoverageFiles(globalContext);
        JvmCoverageInspectionKt.getLogger().info("Coverage for " + JvmClassMappingKt.getJavaClass(engineType).getSimpleName() + " - provided " + coverageFiles.size() + " files");
        if (coverageFiles.isEmpty()) {
            return null;
        }
        CoverageEngine engine = (CoverageEngine)CoverageEngine.EP_NAME.findExtensionOrFail(JvmClassMappingKt.getJavaClass(engineType));
        Project project = globalContext.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<CoverageSuite> suites = UtilsKt.computeSuites(engine, coverageFiles, project);
        if (CollectionsKt.any((Iterable)suites)) {
            CoverageSuite firstSuite = (CoverageSuite)CollectionsKt.first(suites);
            XMLReportSuite xMLReportSuite = firstSuite instanceof XMLReportSuite ? (XMLReportSuite)firstSuite : null;
            if (xMLReportSuite == null || (xMLReportSuite = xMLReportSuite.getReportData()) == null) {
                throw new QodanaException("JaCoCo suite " + firstSuite.getPresentableName() + " is missing report data");
            }
            XMLReportSuite report2 = xMLReportSuite;
            for (CoverageSuite suite2 : CollectionsKt.drop((Iterable)suites, (int)1)) {
                XMLReportSuite xMLReportSuite2 = suite2 instanceof XMLReportSuite ? (XMLReportSuite)suite2 : null;
                if (xMLReportSuite2 == null || (xMLReportSuite2 = xMLReportSuite2.getReportData()) == null) {
                    throw new QodanaException("JaCoCo suite " + suite2.getPresentableName() + " is missing report data");
                }
                XMLReportSuite add2 = xMLReportSuite2;
                Xml_mergerKt.merge((XMLProjectData)report2, (XMLProjectData)add2);
            }
            return report2;
        }
        return null;
    }

    private static final ProjectData loadCoverage$lambda$0(JvmCoverageInspection this$0, QodanaGlobalInspectionContext $globalContext) {
        return this$0.computeCoverageData($globalContext, (KClass<? extends CoverageEngine>)Reflection.getOrCreateKotlinClass(JavaCoverageEngine.class));
    }

    private static final XMLProjectData loadCoverage$lambda$1(JvmCoverageInspection this$0, QodanaGlobalInspectionContext $globalContext) {
        XMLProjectData data = this$0.computeXmlCoverageData($globalContext, (KClass<? extends CoverageEngine>)Reflection.getOrCreateKotlinClass(XMLReportEngine.class));
        if (data != null) {
            EventPair[] eventPairArray = new EventPair[]{CoverageFeatureEventsCollector.INSTANCE.getCOVERAGE_LANGUAGE_FIELD().with((Object)CoverageLanguage.JVM)};
            CoverageFeatureEventsCollector.INPUT_COVERAGE_LOADED.log($globalContext.getProject(), eventPairArray);
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean loadReportForIncrementalAnalysis$lambda$1$0(QodanaGlobalInspectionContext $globalContext, XMLProjectData.FileInfo $fileInfo) {
        boolean bl;
        block7: {
            void $this$flatMapTo$iv$iv;
            Project project = $globalContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Module[] $this$flatMap$iv = ModuleManager.Companion.getInstance(project).getModules();
            boolean $i$f$flatMap = false;
            Module[] moduleArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void $this$mapNotNullTo$iv$iv;
                void element$iv$iv;
                void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl2 = false;
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)it).getSourceRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
                Object[] $this$mapNotNull$iv = virtualFileArray;
                boolean $i$f$mapNotNull = false;
                Object[] objectArray = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n2 = ((void)$this$forEach$iv$iv$iv).length;
                for (int j = 0; j < n2; ++j) {
                    VirtualFile virtualFile;
                    Path filePath;
                    void element$iv$iv$iv;
                    void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                    boolean bl3 = false;
                    VirtualFile root2 = (VirtualFile)element$iv$iv2;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)root2);
                    Path path = VirtualFileUtil.toNioPathOrNull((VirtualFile)root2);
                    Path path2 = filePath = path != null ? path.resolve($fileInfo.path) : null;
                    if (filePath != null) {
                        boolean bl5 = false;
                        virtualFile = VirtualFileManager.getInstance().findFileByNioPath(filePath);
                    } else {
                        virtualFile = null;
                    }
                    if (virtualFile == null) continue;
                    VirtualFile it$iv$iv = virtualFile;
                    boolean bl6 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List possibleFiles = (List)destination$iv$iv;
            Iterable $this$any$iv = possibleFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile file2 = (VirtualFile)element$iv;
                    boolean bl7 = false;
                    if (!GlobalSearchScope.allScope((Project)$globalContext.getProject()).contains(file2)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean processReportData$lambda$0$0(QodanaGlobalInspectionContext $globalContext, Map.Entry $it, GlobalSearchScope $searchScope) {
        return JavaPsiFacade.getInstance((Project)$globalContext.getProject()).findClass(((ClassData)$it.getValue()).getName(), $searchScope) != null;
    }

    public static final /* synthetic */ PsiElement access$highlightedElement(JvmCoverageInspection $this, PsiElement element) {
        return $this.highlightedElement(element);
    }

    static {
        Key key = Key.create((String)"qodana.javacov.coverage");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        javacov = key;
        Key key2 = Key.create((String)"qodana.xml.coverage");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        xmlcov = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R1\u0010\u0004\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0007 \b*\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\n\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000b \b*\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection$Companion;", "", "<init>", "()V", "javacov", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Lazy;", "Lcom/intellij/rt/coverage/data/ProjectData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "xmlcov", "Lcom/intellij/rt/coverage/report/XMLProjectData;", "intellij.qodana.jvm.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\"\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0011H\u0002J \u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.\u0018\u00010-*\u00020/H\u0002J2\u00100\u001a\u00020\n2\b\u0010'\u001a\u0004\u0018\u00010!2\u0006\u00101\u001a\u00020/2\u0006\u0010*\u001a\u00020+2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0007H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010.2\u0006\u00106\u001a\u00020\u0016H\u0002J\u0018\u00107\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J \u0010;\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020<2\u0006\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection$JVMDefVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "globalContext", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "methodThreshold", "", "classThreshold", "warnMissingCoverage", "", "report", "Lcom/intellij/rt/coverage/data/ProjectData;", "xmlReport", "Lcom/intellij/rt/coverage/report/XMLProjectData;", "highlightedElement", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;Lcom/intellij/codeInspection/ProblemsHolder;IIZLcom/intellij/rt/coverage/data/ProjectData;Lcom/intellij/rt/coverage/report/XMLProjectData;Lkotlin/jvm/functions/Function1;)V", "anonymousClasses", "", "Lorg/jetbrains/uast/UClass;", "visitedMethods", "Lorg/jetbrains/uast/UMethod;", "xmlFileDataLoaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "visitClass", "node", "visitMethod", "loadXmlFileData", "", "fileInfo", "Lcom/intellij/rt/coverage/report/XMLProjectData$FileInfo;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "reportMethodCoverage", "sourcePsi", "computeXmlCoverage", "data", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "packageAndFileName", "Lkotlin/Pair;", "", "Lcom/intellij/psi/PsiFile;", "issueWithXmlMethodCoverage", "psiFile", "project", "Lcom/intellij/openapi/project/Project;", "threshold", "getUClassFqn", "uClass", "methodNameForReports", "methodType", "Lorg/jetbrains/qodana/jvm/coverage/MethodType;", "classNameForReports", "computeName", "Lorg/jetbrains/uast/UDeclaration;", "type", "file", "intellij.qodana.jvm.coverage"})
    @SourceDebugExtension(value={"SMAP\nJvmCoverageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCoverageInspection.kt\norg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection$JVMDefVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,340:1\n808#2,11:341\n295#2,2:352\n*S KotlinDebug\n*F\n+ 1 JvmCoverageInspection.kt\norg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection$JVMDefVisitor\n*L\n168#1:341,11\n252#1:352,2\n*E\n"})
    private static final class JVMDefVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final QodanaGlobalInspectionContext globalContext;
        @NotNull
        private final ProblemsHolder problemsHolder;
        private final int methodThreshold;
        private final int classThreshold;
        private final boolean warnMissingCoverage;
        @Nullable
        private final ProjectData report;
        @Nullable
        private final XMLProjectData xmlReport;
        @NotNull
        private final Function1<PsiElement, PsiElement> highlightedElement;
        @NotNull
        private final Set<UClass> anonymousClasses;
        @NotNull
        private final Set<UMethod> visitedMethods;
        @NotNull
        private final AtomicBoolean xmlFileDataLoaded;

        public JVMDefVisitor(@NotNull QodanaGlobalInspectionContext globalContext, @NotNull ProblemsHolder problemsHolder, int methodThreshold, int classThreshold, boolean warnMissingCoverage, @Nullable ProjectData report2, @Nullable XMLProjectData xmlReport, @NotNull Function1<? super PsiElement, ? extends PsiElement> highlightedElement) {
            Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
            Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
            Intrinsics.checkNotNullParameter(highlightedElement, (String)"highlightedElement");
            this.globalContext = globalContext;
            this.problemsHolder = problemsHolder;
            this.methodThreshold = methodThreshold;
            this.classThreshold = classThreshold;
            this.warnMissingCoverage = warnMissingCoverage;
            this.report = report2;
            this.xmlReport = xmlReport;
            this.highlightedElement = highlightedElement;
            this.anonymousClasses = new LinkedHashSet();
            this.visitedMethods = new LinkedHashSet();
            this.xmlFileDataLoaded = new AtomicBoolean(false);
        }

        /*
         * WARNING - void declaration
         */
        public boolean visitClass(@NotNull UClass node) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable fileData;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null) {
                return true;
            }
            PsiElement sourcePsi = psiElement;
            String string = this.getUClassFqn(node);
            if (string == null) {
                return true;
            }
            String fqn = string;
            if (this.report != null) {
                ClassData data = this.report.getClassData(fqn);
                PsiFile file2 = sourcePsi.getContainingFile();
                VirtualFile virtualFile = file2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                UtilsKt.loadClassData(data, virtualFile, this.globalContext);
                if (UtilsKt.reportProblemsNeeded(this.globalContext)) {
                    Intrinsics.checkNotNull((Object)file2);
                    TextRange textRange = file2.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    Project project = this.problemsHolder.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    if (UtilsKt.issueWithCoverage$default(data, file2, textRange, project, this.classThreshold, this.warnMissingCoverage, false, 64, null)) {
                        PsiElement psiElement2 = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                        Object[] objectArray = new Object[]{this.classNameForReports(node), this.classThreshold};
                        String string2 = QodanaBundle.message("class.coverage.below.threshold", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        UtilsKt.reportElement(this.problemsHolder, psiElement2, string2);
                    }
                }
            } else if (this.xmlReport != null) {
                XMLProjectData.ClassInfo data;
                PsiFile psiFile2 = sourcePsi.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                Pair<String, String> pair = this.packageAndFileName(psiFile2);
                if (pair == null) {
                    return true;
                }
                Pair<String, String> pair2 = pair;
                String packageName = (String)pair2.component1();
                String fileName = (String)pair2.component2();
                fileData = this.xmlReport.getFile(XMLReportSuite.Companion.getPath(packageName, fileName));
                VirtualFile virtualFile = sourcePsi.getContainingFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                this.loadXmlFileData((XMLProjectData.FileInfo)fileData, virtualFile, this.globalContext);
                if (UtilsKt.reportProblemsNeeded(this.globalContext) && ((data = this.xmlReport.getClass(fqn)) == null && this.warnMissingCoverage || data != null && data.coveredLines + data.missedLines != 0 && data.coveredLines * 100 / (data.coveredLines + data.missedLines) < this.classThreshold)) {
                    PsiElement psiElement3 = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                    Object[] objectArray = new Object[]{this.classNameForReports(node), this.classThreshold};
                    String string3 = QodanaBundle.message("class.coverage.below.threshold", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    UtilsKt.reportElement(this.problemsHolder, psiElement3, string3);
                }
            }
            Iterable $this$filterIsInstance$iv = node.getUastDeclarations();
            boolean $i$f$filterIsInstance = false;
            fileData = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof UMethod)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (UMethod method : (List)destination$iv$iv) {
                if (!method.getJavaPsi().isPhysical() && !method.isConstructor()) continue;
                this.visitMethod(method);
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!this.visitedMethods.add(node)) {
                return true;
            }
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null) {
                return true;
            }
            PsiElement sourcePsi = psiElement;
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
            if (uClass == null) {
                return true;
            }
            UClass containingClass = uClass;
            String string = this.getUClassFqn(containingClass);
            if (string == null) {
                return true;
            }
            String fqn = string;
            if (this.report != null) {
                ClassData data = this.report.getClassData(fqn);
                if (containingClass.getSourcePsi() == null && this.anonymousClasses.add(containingClass)) {
                    VirtualFile virtualFile = sourcePsi.getContainingFile().getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                    UtilsKt.loadClassData(data, virtualFile, this.globalContext);
                }
                if (data == null) {
                    Project project = this.problemsHolder.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    TextRange textRange = sourcePsi.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    PsiFile psiFile2 = sourcePsi.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                    if (!UtilsKt.loadMissingData(project, textRange, psiFile2, this.warnMissingCoverage, this.globalContext)) return true;
                }
                boolean bl = true;
                boolean isDataLoaded = bl;
                if (!isDataLoaded) {
                    return true;
                }
                if (!UtilsKt.reportProblemsNeeded(this.globalContext)) return true;
                PsiFile psiFile3 = sourcePsi.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"getContainingFile(...)");
                TextRange textRange = sourcePsi.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                Project project = this.problemsHolder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!UtilsKt.issueWithCoverage$default(data, psiFile3, textRange, project, this.methodThreshold, this.warnMissingCoverage, false, 64, null)) return true;
                this.reportMethodCoverage(node, sourcePsi);
                return true;
            } else {
                if (this.xmlReport == null) return true;
                PsiFile psiFile4 = sourcePsi.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"getContainingFile(...)");
                Pair<String, String> pair = this.packageAndFileName(psiFile4);
                if (pair == null) {
                    return true;
                }
                Pair<String, String> pair2 = pair;
                String packageName = (String)pair2.component1();
                String fileName = (String)pair2.component2();
                XMLProjectData.FileInfo data = this.xmlReport.getFile(XMLReportSuite.Companion.getPath(packageName, fileName));
                VirtualFile virtualFile = sourcePsi.getContainingFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                this.loadXmlFileData(data, virtualFile, this.globalContext);
                if (data == null) {
                    Project project = this.problemsHolder.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    TextRange textRange = sourcePsi.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    PsiFile psiFile5 = sourcePsi.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile5, (String)"getContainingFile(...)");
                    if (!UtilsKt.loadMissingData(project, textRange, psiFile5, this.warnMissingCoverage, this.globalContext)) return true;
                }
                boolean bl = true;
                boolean isDataLoaded = bl;
                if (!isDataLoaded) {
                    return true;
                }
                if (!UtilsKt.reportProblemsNeeded(this.globalContext)) return true;
                PsiFile psiFile6 = sourcePsi.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile6, (String)"getContainingFile(...)");
                TextRange textRange = sourcePsi.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                Project project = this.problemsHolder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!this.issueWithXmlMethodCoverage(data, psiFile6, textRange, project, this.methodThreshold)) return true;
                this.reportMethodCoverage(node, sourcePsi);
            }
            return true;
        }

        private final void loadXmlFileData(XMLProjectData.FileInfo fileInfo, VirtualFile virtualFile, QodanaGlobalInspectionContext globalContext) {
            if (fileInfo == null) {
                return;
            }
            if (this.xmlFileDataLoaded.getAndSet(true)) {
                return;
            }
            CoverageStatisticsKt.loadXmlLineData(globalContext.getCoverageStatisticsData(), fileInfo, virtualFile);
        }

        private final void reportMethodCoverage(UMethod node, PsiElement sourcePsi) {
            if (node.isConstructor()) {
                String signature = this.methodNameForReports(node, MethodType.CONSTRUCTOR);
                PsiElement psiElement = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                Object[] objectArray = new Object[]{signature, this.methodThreshold};
                String string = QodanaBundle.message("constructor.coverage.below.threshold", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                UtilsKt.reportElement(this.problemsHolder, psiElement, string);
            } else {
                PsiMethod psiMethod = node.getJavaPsi();
                KtLightMethod ktLightMethod = psiMethod instanceof KtLightMethod ? (KtLightMethod)psiMethod : null;
                boolean bl = ktLightMethod != null ? KotlinLightMethodUtilsKt.isSetter((KtLightMethod)ktLightMethod) : false;
                if (bl) {
                    String signature = this.methodNameForReports(node, MethodType.PROPERTY);
                    PsiElement psiElement = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                    Object[] objectArray = new Object[]{signature, this.methodThreshold};
                    String string = QodanaBundle.message("property.setter.coverage.below.threshold", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    UtilsKt.reportElement(this.problemsHolder, psiElement, string);
                } else {
                    psiMethod = node.getJavaPsi();
                    KtLightMethod ktLightMethod2 = psiMethod instanceof KtLightMethod ? (KtLightMethod)psiMethod : null;
                    boolean bl2 = ktLightMethod2 != null ? KotlinLightMethodUtilsKt.isGetter((KtLightMethod)ktLightMethod2) : false;
                    if (bl2) {
                        String signature = this.methodNameForReports(node, MethodType.PROPERTY);
                        PsiElement psiElement = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                        Object[] objectArray = new Object[]{signature, this.methodThreshold};
                        String string = QodanaBundle.message("property.getter.coverage.below.threshold", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        UtilsKt.reportElement(this.problemsHolder, psiElement, string);
                    } else {
                        String signature = this.methodNameForReports(node, MethodType.METHOD);
                        PsiElement psiElement = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                        Object[] objectArray = new Object[]{signature, this.methodThreshold};
                        String string = QodanaBundle.message("method.coverage.below.threshold", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        UtilsKt.reportElement(this.problemsHolder, psiElement, string);
                    }
                }
            }
        }

        private final int computeXmlCoverage(XMLProjectData.FileInfo data, Document document, TextRange textRange) {
            int startOffset = textRange.getStartOffset();
            int endOffset = textRange.getEndOffset();
            int startLineNumber = document.getLineNumber(startOffset) + 1;
            int endLineNumber = document.getLineNumber(endOffset) + 1;
            int totalLines = 0;
            int coveredLines = 0;
            int i = startLineNumber;
            if (i <= endLineNumber) {
                while (true) {
                    Object v1;
                    block6: {
                        List list2 = data.lines;
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"lines");
                        Iterable $this$firstOrNull$iv = list2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            XMLProjectData.LineInfo it = (XMLProjectData.LineInfo)element$iv;
                            boolean bl = false;
                            if (!(it.lineNumber == i)) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    XMLProjectData.LineInfo lineData = v1;
                    if (lineData != null) {
                        ++totalLines;
                        if (lineData.coveredInstructions != 0 || lineData.coveredBranches != 0) {
                            ++coveredLines;
                        }
                    }
                    if (i == endLineNumber) break;
                    ++i;
                }
            }
            if (totalLines == 0) {
                return 100;
            }
            return coveredLines * 100 / totalLines;
        }

        private final Pair<String, String> packageAndFileName(PsiFile $this$packageAndFileName) {
            if (!($this$packageAndFileName instanceof PsiClassOwner)) {
                return null;
            }
            String string = (String)ActionsKt.runReadAction(() -> JVMDefVisitor.packageAndFileName$lambda$0($this$packageAndFileName));
            if (string == null) {
                return null;
            }
            String packageName = string;
            return TuplesKt.to((Object)packageName, (Object)((PsiClassOwner)$this$packageAndFileName).getName());
        }

        private final boolean issueWithXmlMethodCoverage(XMLProjectData.FileInfo data, PsiFile psiFile2, TextRange textRange, Project project, int threshold) {
            if (data == null) {
                return this.warnMissingCoverage;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
            if (document == null) {
                return false;
            }
            Document doc = document;
            return this.computeXmlCoverage(data, doc, textRange) < threshold;
        }

        private final String getUClassFqn(UClass uClass) {
            if (uClass instanceof UAnonymousClass) {
                PsiClass psiClass = uClass.getJavaPsi();
                Intrinsics.checkNotNull((Object)psiClass, (String)"null cannot be cast to non-null type com.intellij.psi.PsiAnonymousClass");
                String anonymousName = UastAnonymousClassUtil.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
                UClass uClass2 = UastUtils.getContainingUClass((UElement)((UElement)uClass));
                if (uClass2 == null) {
                    return anonymousName;
                }
                UClass containingClass = uClass2;
                String parentName = this.getUClassFqn(containingClass);
                return parentName + anonymousName;
            }
            String name = uClass.getQualifiedName();
            if (name != null && StringsKt.endsWith$default((String)name, (String)".Companion", (boolean)false, (int)2, null)) {
                PsiIdentifier psiIdentifier = uClass.getJavaPsi().getNameIdentifier();
                boolean bl = psiIdentifier != null && (psiIdentifier = psiIdentifier.getTextRange()) != null ? psiIdentifier.isEmpty() : false;
                if (bl) {
                    return StringsKt.removeSuffix((String)name, (CharSequence)".Companion") + "$Companion";
                }
            }
            return name;
        }

        private final String methodNameForReports(UMethod node, MethodType methodType) {
            UDeclaration uDeclaration = (UDeclaration)node;
            String string = methodType.getPrintName();
            PsiFile psiFile2 = node.getJavaPsi().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
            return this.computeName(uDeclaration, string, psiFile2);
        }

        private final String classNameForReports(UClass node) {
            UDeclaration uDeclaration = (UDeclaration)node;
            PsiFile psiFile2 = node.getJavaPsi().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
            return this.computeName(uDeclaration, "class", psiFile2);
        }

        private final String computeName(UDeclaration node, String type2, PsiFile file2) {
            String psiName;
            PsiElement psiElement = node.getJavaPsi();
            PsiNameIdentifierOwner psiNameIdentifierOwner = psiElement instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)psiElement : null;
            String string = psiName = psiNameIdentifierOwner != null ? psiNameIdentifierOwner.getName() : null;
            if (psiName != null) {
                return String.valueOf(psiName);
            }
            UClass currentClass = UastUtils.getContainingUClass((UElement)((UElement)node));
            while (currentClass != null) {
                PsiNameIdentifierOwner nameOwner;
                PsiClass psiClass = currentClass.getJavaPsi();
                PsiNameIdentifierOwner psiNameIdentifierOwner2 = nameOwner = psiClass instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)psiClass : null;
                if ((psiNameIdentifierOwner2 != null ? psiNameIdentifierOwner2.getName() : null) != null) {
                    return "(anonymous " + type2 + " in " + nameOwner.getName() + ")";
                }
                currentClass = UastUtils.getContainingUClass((UElement)((UElement)currentClass));
            }
            return "(anonymous " + type2 + " in " + file2.getName() + ")";
        }

        private static final String packageAndFileName$lambda$0(PsiFile $this_packageAndFileName) {
            return ((PsiClassOwner)$this_packageAndFileName).getPackageName();
        }
    }
}

