/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\b*\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0003J4\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/settings/QueryFilesConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "toPathSafely", "Ljava/nio/file/Path;", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getNameExample", "dataSourceName", "configureTextField", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "Lcom/intellij/ui/dsl/builder/Row;", "getter", "Lkotlin/Function0;", "setter", "Lkotlin/Function1;", "", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nQueryFilesConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryFilesConfigurable.kt\ncom/intellij/database/settings/QueryFilesConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class QueryFilesConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;

    public QueryFilesConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = IdeBundle.message((String)"configurable.DatabaseSettingsConfigurable.sql.files.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "preferences.sql.files.settings", null, 4, null);
        this.project = project;
    }

    private final Path toPathSafely(String $this$toPathSafely) {
        Object object;
        Object object2 = $this$toPathSafely;
        try {
            String $this$toPathSafely_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Paths.get($this$toPathSafely_u24lambda_u240, new String[0]));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @NotNull
    public DialogPanel createPanel() {
        DialogPanel panel2;
        block0: {
            QueryFileSettings settings = QueryFileSettings.Companion.getInstance(this.project);
            panel2 = BuilderKt.panel(arg_0 -> QueryFilesConfigurable.createPanel$lambda$0(this, settings, arg_0));
            Disposable disposable = this.getDisposable();
            if (disposable == null) break block0;
            Disposable it = disposable;
            boolean bl = false;
            panel2.registerValidators(it);
        }
        return panel2;
    }

    @NlsSafe
    private final String getNameExample(String $this$getNameExample, String dataSourceName) {
        return "<html><b>" + QueryFileSettings.Companion.getNameForQueryFile($this$getNameExample, dataSourceName) + "_1.sql</b></html>";
    }

    /*
     * WARNING - void declaration
     */
    private final Cell<TextFieldWithBrowseButton> configureTextField(Row $this$configureTextField, Function0<String> getter, Function1<? super String, Unit> setter) {
        void it;
        FileChooserDescriptor fileChooserDescriptor;
        Function1 validator = arg_0 -> QueryFilesConfigurable.configureTextField$lambda$0(this, arg_0);
        FileChooserDescriptor fileChooserDescriptor2 = fileChooserDescriptor = FileChooserDescriptorFactory.singleDir();
        Row row = $this$configureTextField;
        boolean bl = false;
        it.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, (Object)false);
        FileChooserDescriptor fileChooserDescriptor3 = fileChooserDescriptor;
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor3, (String)"also(...)");
        return TextFieldWithBrowseButtonKt.columns((Cell)TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)row, (FileChooserDescriptor)fileChooserDescriptor3, null, null, (int)6, null), getter, setter).validationOnInput((arg_0, arg_1) -> QueryFilesConfigurable.configureTextField$lambda$2(validator, arg_0, arg_1)).validationOnApply((arg_0, arg_1) -> QueryFilesConfigurable.configureTextField$lambda$3(validator, arg_0, arg_1)), (int)36);
    }

    private static final Unit createPanel$lambda$0(QueryFilesConfigurable this$0, QueryFileSettings $settings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message((String)"settings.query.files.location", (Object[])new Object[0]), (boolean)false, arg_0 -> QueryFilesConfigurable.createPanel$lambda$0$0(this$0, $settings, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message((String)"settings.query.files.file.name", (Object[])new Object[0]), (boolean)false, arg_0 -> QueryFilesConfigurable.createPanel$lambda$0$1($settings, this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message((String)"settings.query.files.presentation", (Object[])new Object[0]), (boolean)false, arg_0 -> QueryFilesConfigurable.createPanel$lambda$0$2($settings, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(QueryFilesConfigurable this$0, QueryFileSettings $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        String string = DatabaseBundle.message((String)"settings.default.query.path", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row(string, arg_0 -> QueryFilesConfigurable.createPanel$lambda$0$0$0(this$0, $settings, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$0(QueryFilesConfigurable this$0, QueryFileSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.configureTextField($this$row, (Function0<String>)((Function0)() -> QueryFilesConfigurable.createPanel$lambda$0$0$0$0($settings)), (Function1<? super String, Unit>)((Function1)arg_0 -> QueryFilesConfigurable.createPanel$lambda$0$0$0$1($settings, this$0, arg_0))).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$0$0$0$0(QueryFileSettings $settings) {
        Object object = $settings.getQueriesDirectory();
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        return object;
    }

    private static final Unit createPanel$lambda$0$0$0$1(QueryFileSettings $settings, QueryFilesConfigurable this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $settings.setQueriesDirectory(this$0.toPathSafely(it));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(QueryFileSettings $settings, QueryFilesConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        String string = DatabaseBundle.message((String)"settings.default.files.names.example.ds", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String exampleDs = string;
        Ref.ObjectRef label = new Ref.ObjectRef();
        String string2 = DatabaseBundle.message((String)"settings.default.files.names.template", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$group.row(string2, arg_0 -> QueryFilesConfigurable.createPanel$lambda$0$1$0($settings, label, this$0, exampleDs, arg_0));
        String string3 = DatabaseBundle.message((String)"settings.default.files.names.example", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$group.row(string3, arg_0 -> QueryFilesConfigurable.createPanel$lambda$0$1$1(this$0, $settings, exampleDs, label, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$0(QueryFileSettings $settings, Ref.ObjectRef $label, QueryFilesConfigurable this$0, String $exampleDs, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Function1 validator = QueryFilesConfigurable::createPanel$lambda$0$1$0$0;
        Object[] objectArray = new Object[]{"$DATA_SOURCE$"};
        Object[] it = objectArray = Cell.comment$default((Cell)TextFieldKt.bindText((Cell)$this$row.textField(), () -> QueryFilesConfigurable.createPanel$lambda$0$1$0$1($settings), arg_0 -> QueryFilesConfigurable.createPanel$lambda$0$1$0$2($settings, arg_0)).validationOnInput((arg_0, arg_1) -> QueryFilesConfigurable.createPanel$lambda$0$1$0$3(validator, arg_0, arg_1)).validationOnApply((arg_0, arg_1) -> QueryFilesConfigurable.createPanel$lambda$0$1$0$4(validator, arg_0, arg_1)), (String)DatabaseBundle.message((String)"settings.query.file.template.description", (Object[])objectArray), (int)50, null, (int)4, null).align((Align)AlignX.FILL.INSTANCE);
        boolean bl = false;
        ((JBTextField)it.getComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((Ref.ObjectRef<JLabel>)$label, this$0, (Cell<? extends JBTextField>)it, $exampleDs){
            final /* synthetic */ Ref.ObjectRef<JLabel> $label;
            final /* synthetic */ QueryFilesConfigurable this$0;
            final /* synthetic */ Cell<JBTextField> $it;
            final /* synthetic */ String $exampleDs;
            {
                this.$label = $label;
                this.this$0 = $receiver;
                this.$it = $it;
                this.$exampleDs = $exampleDs;
            }

            protected void textChanged(DocumentEvent e) {
                JLabel jLabel;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$label.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"label");
                    jLabel = null;
                } else {
                    jLabel = (JLabel)this.$label.element;
                }
                String string = ((JBTextField)this.$it.getComponent()).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                jLabel.setText(QueryFilesConfigurable.access$getNameExample(this.this$0, string, this.$exampleDs));
            }
        });
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createPanel$lambda$0$1$0$0(JTextField textField) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        String text = textField.getText();
        if (QueryFileSettings.Companion.getValidFileNameOrNull(text) == null) {
            ValidationInfo validationInfo2;
            ValidationInfo $this$createPanel_u24lambda_u240_u241_u240_u240_u240 = validationInfo2 = new ValidationInfo(DatabaseBundle.message((String)"settings.default.files.names.validation.error", (Object[])new Object[0]), (JComponent)textField);
            boolean bl = false;
            $this$createPanel_u24lambda_u240_u241_u240_u240_u240.okEnabled = true;
            validationInfo = validationInfo2;
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final String createPanel$lambda$0$1$0$1(QueryFileSettings $settings) {
        return $settings.getFileNameTemplate();
    }

    private static final Unit createPanel$lambda$0$1$0$2(QueryFileSettings $settings, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $settings.setFileNameTemplate(it);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createPanel$lambda$0$1$0$3(Function1 $validator, ValidationInfoBuilder $this$validationOnInput, JBTextField textField) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        return (ValidationInfo)$validator.invoke((Object)textField);
    }

    private static final ValidationInfo createPanel$lambda$0$1$0$4(Function1 $validator, ValidationInfoBuilder $this$validationOnApply, JBTextField textField) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        return (ValidationInfo)$validator.invoke((Object)textField);
    }

    private static final Unit createPanel$lambda$0$1$1(QueryFilesConfigurable this$0, QueryFileSettings $settings, String $exampleDs, Ref.ObjectRef $label, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell it = cell = $this$row.label(this$0.getNameExample($settings.getFileNameTemplate(), $exampleDs));
        boolean bl = false;
        $label.element = it.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(QueryFileSettings $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> QueryFilesConfigurable.createPanel$lambda$0$2$0($settings, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$0(QueryFileSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.query.files.show.data.source.name.in.tab.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((QueryFileSettings)this.receiver).getShowDataSourceInTabs();
            }

            public void set(Object value) {
                ((QueryFileSettings)this.receiver).setShowDataSourceInTabs(((Boolean)value).booleanValue());
            }
        }));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo configureTextField$lambda$0(QueryFilesConfigurable this$0, TextFieldWithBrowseButton textFieldWithBrowseButton) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)textFieldWithBrowseButton, (String)"textFieldWithBrowseButton");
        String text = textFieldWithBrowseButton.getTextField().getText();
        Intrinsics.checkNotNull((Object)text);
        Path path = this$0.toPathSafely(text);
        if (StringsKt.isBlank((CharSequence)text) || !Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)text)).toString(), (Object)text) || QueryFileSettings.Companion.getValidPathOrNull(path) == null) {
            ValidationInfo validationInfo2;
            ValidationInfo $this$configureTextField_u24lambda_u240_u240 = validationInfo2 = new ValidationInfo(DatabaseBundle.message((String)"settings.default.query.path.validation.error", (Object[])new Object[0]), (JComponent)textFieldWithBrowseButton);
            boolean bl = false;
            $this$configureTextField_u24lambda_u240_u240.okEnabled = false;
            validationInfo = validationInfo2;
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final ValidationInfo configureTextField$lambda$2(Function1 $validator, ValidationInfoBuilder $this$validationOnInput, TextFieldWithBrowseButton textFieldWithBrowseButton) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)textFieldWithBrowseButton, (String)"textFieldWithBrowseButton");
        return (ValidationInfo)$validator.invoke((Object)textFieldWithBrowseButton);
    }

    private static final ValidationInfo configureTextField$lambda$3(Function1 $validator, ValidationInfoBuilder $this$validationOnApply, TextFieldWithBrowseButton textFieldWithBrowseButton) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)textFieldWithBrowseButton, (String)"textFieldWithBrowseButton");
        return (ValidationInfo)$validator.invoke((Object)textFieldWithBrowseButton);
    }

    public static final /* synthetic */ String access$getNameExample(QueryFilesConfigurable $this, String $receiver, String dataSourceName) {
        return $this.getNameExample($receiver, dataSourceName);
    }
}

