/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.indexer;

import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;

public class MavenServerSideCancelledThrottler
implements MavenServerProgressIndicator {
    private static final long CHECK_PERIOD = 2000L;
    private final AtomicLong lastTime = new AtomicLong(System.currentTimeMillis());
    private final MavenServerProgressIndicator myIndicator;
    private volatile boolean cancelled = false;

    public MavenServerSideCancelledThrottler(MavenServerProgressIndicator indicator) {
        this.myIndicator = indicator;
    }

    public void setText(String text) throws RemoteException {
        this.myIndicator.setText(text);
    }

    public void setText2(String text) throws RemoteException {
        this.myIndicator.setText2(text);
    }

    public boolean isCanceled() throws RemoteException {
        if (this.cancelled) {
            return true;
        }
        if (this.lastTime.get() + 2000L > System.currentTimeMillis()) {
            return false;
        }
        this.lastTime.set(System.currentTimeMillis());
        this.cancelled = this.myIndicator.isCanceled();
        return this.cancelled;
    }

    public void setIndeterminate(boolean value) throws RemoteException {
        this.myIndicator.setIndeterminate(value);
    }

    public void setFraction(double fraction) throws RemoteException {
        this.myIndicator.setFraction(fraction);
    }
}

