/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ssh.ui.unified.SshExtendedCredentialsForm;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SshEntityConfigurable
extends NamedConfigurable<SshUiData> {
    private final SshExtendedCredentialsForm myForm;
    @NotNull
    private final SshUiData myItem;
    @NlsSafe
    private String myCustomName;
    private final Disposable myDisposable;
    private boolean myRequestFocusOnSelection;

    SshEntityConfigurable(@NotNull SshUiData item, boolean isNameEditable, @Nullable Runnable updateTree, boolean showOnlyAppLevel) {
        if (item == null) {
            SshEntityConfigurable.s(0);
        }
        super(isNameEditable, updateTree);
        this.myDisposable = Disposer.newDisposable((String)"SshEntityConfigurable");
        this.myItem = item;
        this.myForm = SshEntityConfigurable.s(this.myItem, showOnlyAppLevel, updateTree, this.myDisposable);
    }

    @NotNull
    private static SshExtendedCredentialsForm s(SshUiData sshUiData, boolean bl, @Nullable Runnable runnable, @NotNull Disposable disposable) {
        if (disposable == null) {
            SshEntityConfigurable.s(1);
        }
        return new SshExtendedCredentialsForm(sshUiData, bl, runnable, disposable);
    }

    @NotNull
    public JComponent createOptionsPanel() {
        JBScrollPane jBScrollPane = new JBScrollPane((Component)this.myForm.getPanel());
        jBScrollPane.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBInsets.emptyInsets()));
        JBScrollPane jBScrollPane2 = jBScrollPane;
        if (jBScrollPane2 == null) {
            SshEntityConfigurable.s(2);
        }
        return jBScrollPane2;
    }

    @NotNull
    public SshUiData getEditableObject() {
        SshUiData sshUiData = this.myItem;
        if (sshUiData == null) {
            SshEntityConfigurable.s(3);
        }
        return sshUiData;
    }

    public String getBannerSlogan() {
        return this.myItem.getConfig().getPresentableFullName();
    }

    public String getDisplayName() {
        return this.myCustomName != null ? this.myCustomName : this.myItem.getConfig().getPresentableFullName();
    }

    public void setDisplayName(String name) {
        throw new IllegalStateException("Ssh configs are not designed to rename");
    }

    public boolean isModified() {
        return this.myForm.isModified() || this.myCustomName != null && !this.myCustomName.equals(this.myItem.getName());
    }

    public void apply() {
        this.myForm.apply();
        if (this.myCustomName != null) {
            this.myItem.getConfig().setCustomName(this.myCustomName);
            this.myCustomName = null;
        }
    }

    public void reset() {
        this.myForm.reset();
        this.myCustomName = null;
    }

    void setCustomName(@Nullable String customName) {
        this.myCustomName = customName;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myForm.getPreferredFocusedComponent();
        if (jComponent == null) {
            SshEntityConfigurable.s(4);
        }
        return jComponent;
    }

    @NotNull
    public SshUiData applyToNewDefaultSshDataIfPossible(boolean isUiInitialized) {
        SshUiData sshUiData = this.myItem.clone();
        if (isUiInitialized) {
            this.myForm.applyTo(sshUiData);
            if (this.myCustomName != null) {
                sshUiData.getConfig().setCustomName(this.myCustomName);
            }
        }
        SshUiData sshUiData2 = sshUiData;
        if (sshUiData2 == null) {
            SshEntityConfigurable.s(5);
        }
        return sshUiData2;
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    boolean isRequestFocusOnSelection() {
        return this.myRequestFocusOnSelection;
    }

    void setRequestFocusOnSelection(boolean requestFocusOnSelection) {
        this.myRequestFocusOnSelection = requestFocusOnSelection;
    }

    private static /* synthetic */ void s(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshEntityConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshEntityConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToNewDefaultSshDataIfPossible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFormConfigurable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

