/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.util;

import java.util.Objects;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;

public final class ParserToolkit {
    private ParserToolkit() {
        throw new Error("Don't");
    }

    public static <T> T get(T[] elements2, int index) throws InvalidJfrFileException {
        if (index < 0 || index >= elements2.length) {
            throw new InvalidJfrFileException();
        }
        return elements2[index];
    }

    public static void assertValue(long value, long accepted) throws InvalidJfrFileException {
        if (value != accepted) {
            throw new InvalidJfrFileException(value + " is not the expected value " + accepted);
        }
    }

    public static void assertValue(Object value, Object accepted) throws InvalidJfrFileException {
        if (!Objects.equals(value, accepted)) {
            throw new InvalidJfrFileException(value + " is not the expected value " + accepted);
        }
    }

    public static void assertValue(Object value, Object ... accepted) throws InvalidJfrFileException {
        for (Object a : accepted) {
            if (!Objects.equals(a, value)) continue;
            return;
        }
        throw new InvalidJfrFileException(value + " is not among the expected values");
    }

    public static IMCFrame.Type parseFrameType(String type) {
        switch (type) {
            case "Interpreted": {
                return IMCFrame.Type.INTERPRETED;
            }
            case "JIT compiled": {
                return IMCFrame.Type.JIT_COMPILED;
            }
            case "Inlined": {
                return IMCFrame.Type.INLINED;
            }
            case "Native": {
                return IMCFrame.Type.NATIVE;
            }
            case "C++": {
                return IMCFrame.Type.CPP;
            }
            case "Kernel": {
                return IMCFrame.Type.KERNEL;
            }
        }
        return IMCFrame.Type.UNKNOWN;
    }
}

