/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.utils.TruncatedLogger;
import com.intellij.openapi.diagnostic.Logger;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/utils/LoggedOutputStream;", "Ljava/io/OutputStream;", "originalOutputStream", "processId", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Ljava/io/OutputStream;Ljava/lang/String;Lcom/intellij/openapi/diagnostic/Logger;)V", "myTruncatedLogger", "Lcom/intellij/docker/utils/TruncatedLogger;", "write", "", "b", "", "", "off", "len", "flush", "close", "log", "s", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nLoggedProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggedProcess.kt\ncom/intellij/docker/utils/LoggedOutputStream\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,179:1\n67#2,4:180\n*S KotlinDebug\n*F\n+ 1 LoggedProcess.kt\ncom/intellij/docker/utils/LoggedOutputStream\n*L\n131#1:180,4\n*E\n"})
final class LoggedOutputStream
extends OutputStream {
    @NotNull
    private final OutputStream originalOutputStream;
    @NotNull
    private final String processId;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TruncatedLogger myTruncatedLogger;

    public LoggedOutputStream(@NotNull OutputStream originalOutputStream, @NotNull String processId, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)originalOutputStream, (String)"originalOutputStream");
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.originalOutputStream = originalOutputStream;
        this.processId = processId;
        this.logger = logger;
        this.myTruncatedLogger = new TruncatedLogger((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                LoggedOutputStream.access$log((LoggedOutputStream)this.receiver, p0);
            }
        }));
    }

    @Override
    public void write(int b) {
        Unit unit;
        this.originalOutputStream.write(b);
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        this.myTruncatedLogger.logSingleByteWrite(b);
    }

    @Override
    public void write(@NotNull byte[] b) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.originalOutputStream.write(b);
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        TruncatedLogger.logBytes$default(this.myTruncatedLogger, b, 0, 0, 6, null);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.originalOutputStream.write(b, off, len);
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        this.myTruncatedLogger.logBytes(b, off, len);
    }

    @Override
    public void flush() {
        this.originalOutputStream.flush();
    }

    @Override
    public void close() {
        this.originalOutputStream.close();
    }

    private final void log(String s) {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[" + this.processId + "] STDIN: " + s);
        }
    }

    public static final /* synthetic */ void access$log(LoggedOutputStream $this, String s) {
        $this.log(s);
    }
}

