/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCommentVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescription;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescriptionProcessor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedData;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedDataBuilder;
import com.intellij.lang.javascript.psi.stubs.JSDocCommentStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSDocCommentImpl
extends JSImplicitElementProviderImpl<JSDocCommentStub>
implements JSDocComment {
    @Nullable
    private JSDocCommentCachedData myCachedData;
    private static final Key<ParameterizedCachedValue<PsiReference[], JSDocCommentImpl>> REFERENCES_KEY = Key.create((String)"js.doc.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSDocCommentImpl> REFERENCES_PROVIDER = param -> CachedValueProvider.Result.create((Object)ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)param), (Object[])new Object[]{param});

    public JSDocCommentImpl(ASTNode node) {
        super(node);
    }

    public JSDocCommentImpl(JSDocCommentStub stub, IElementType signature) {
        super(stub, signature);
    }

    @NotNull
    public IElementType getTokenType() {
        IElementType iElementType = this.getNode().getElementType();
        if (iElementType == null) {
            JSDocCommentImpl.$$$reportNull$$$0(0);
        }
        return iElementType;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDocCommentImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocComment(this);
        } else {
            visitor.visitComment((PsiComment)this);
        }
    }

    @Override
    public JSDocTag @NotNull [] getTags() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof JSDocComment) {
            JSDocTag[] jSDocTagArray = ((JSDocComment)firstChild).getTags();
            if (jSDocTagArray == null) {
                JSDocCommentImpl.$$$reportNull$$$0(2);
            }
            return jSDocTagArray;
        }
        JSDocTag[] jSDocTagArray = (JSDocTag[])this.findChildrenByType(JSDocTokenTypes.DOC_TAG, JSDocTag.class);
        if (jSDocTagArray == null) {
            JSDocCommentImpl.$$$reportNull$$$0(3);
        }
        return jSDocTagArray;
    }

    @Override
    public @Unmodifiable @NotNull List<JSDocTag> findTags(@NotNull String name) {
        if (name == null) {
            JSDocCommentImpl.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.filter((Object[])this.getTags(), it -> it.is(name));
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public @Unmodifiable @NotNull List<JSDocTag> findTags(@NotNull JSDocTagDefinition tag) {
        if (tag == null) {
            JSDocCommentImpl.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.filter((Object[])this.getTags(), it -> it.is(tag));
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    public JSDocDescription getDescription() {
        return (JSDocDescription)this.findChildByClass(JSDocDescription.class);
    }

    @Override
    @NotNull
    public String getDescriptionText(@NotNull JSDocDescriptionProcessor descriptionProcessor) {
        JSDocDescription description;
        if (descriptionProcessor == null) {
            JSDocCommentImpl.$$$reportNull$$$0(8);
        }
        return (description = this.getDescription()) != null ? description.getDescriptionText(descriptionProcessor) : "";
    }

    @Override
    public void acceptChildren(@NotNull JSDocCommentVisitor visitor) {
        JSDocTag[] tags;
        JSDocDescription description;
        if (visitor == null) {
            JSDocCommentImpl.$$$reportNull$$$0(9);
        }
        if ((description = this.getDescription()) != null) {
            visitor.visitDescription(description);
        }
        for (JSDocTag tag : tags = this.getTags()) {
            JSDocBlockTags.visitTag$intellij_javascript_psi_impl(tag, visitor);
        }
        visitor.finishVisiting(tags.length > 0 ? tags[tags.length - 1] : null);
    }

    public PsiElement getOwner() {
        PsiElement associatedElement = JSDocumentationUtils.findAssociatedElement(this);
        return associatedElement != null ? associatedElement : this;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            JSDocCommentImpl.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public @NotNull List<Pair<@NotNull String, @Nullable String>> getGenericParameters() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            List<Pair<String, String>> list = stub.getGenericParameters();
            if (list == null) {
                JSDocCommentImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<Pair<String, String>> list = this.getCachedData().getGenericParameters();
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @Nullable
    public JSAttributeList.AccessType getAccessType() {
        return this.getCachedData().getAccessType();
    }

    @Override
    @Nullable
    public String getExplicitName() {
        JSDocCommentCachedData cachedData = this.getCachedData();
        JSQualifiedName className = cachedData.getClassName();
        return className != null ? className.getName() : cachedData.getExplicitName();
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        return this.getCachedData().getNamespace();
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getCachedData().isNamespaceExplicitlyDeclared();
    }

    @Override
    @Nullable
    public String getType() {
        return this.getCachedData().getType();
    }

    @Override
    @Nullable
    public Map<JSQualifiedName, String> getProperties() {
        return this.getCachedData().getProperties();
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSDocCommentImpl.$$$reportNull$$$0(13);
            }
            return jSContext;
        }
        JSContext jSContext = this.getCachedData().getContext();
        if (jSContext == null) {
            JSDocCommentImpl.$$$reportNull$$$0(14);
        }
        return jSContext;
    }

    @Override
    public boolean isClassExplicitly() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.isClassExplicitly();
        }
        return this.getCachedData().isClassExplicitly();
    }

    @Override
    public boolean hasInterfaceTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasInterfaceTag();
        }
        return this.getCachedData().isInterface();
    }

    @Override
    public boolean hasDeprecatedTag() {
        return this.getCachedData().hasDeprecatedTag();
    }

    @Override
    @Nullable
    public String getDeprecationMessage() {
        return this.getCachedData().getDeprecationMessage();
    }

    @Override
    @Nullable
    public String getSinceMessage() {
        return this.getCachedData().getSinceMessage();
    }

    @Override
    public boolean hasConstructsTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasConstructsTag();
        }
        return this.getCachedData().hasConstructsTag();
    }

    @Override
    public boolean hasConstructorLikeTag() {
        return this.getCachedData().hasConstructorLikeTag();
    }

    @Override
    @NotNull
    public JSDocComment.BrowserFamily getBrowserFamily() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            JSDocComment.BrowserFamily browserFamily = stub.getBrowserFamily();
            if (browserFamily == null) {
                JSDocCommentImpl.$$$reportNull$$$0(15);
            }
            return browserFamily;
        }
        JSDocComment.BrowserFamily browserFamily = this.getCachedData().getBrowserFamily();
        if (browserFamily == null) {
            JSDocCommentImpl.$$$reportNull$$$0(16);
        }
        return browserFamily;
    }

    @Override
    public boolean hasNamespaceTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasNamespaceTag();
        }
        return this.getCachedData().hasNamespaceTag();
    }

    @Override
    public boolean hasAbstractTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasAbstractTag();
        }
        return this.getCachedData().hasAbstractTag();
    }

    @Override
    @Nullable
    public String getDefaultValue(@NotNull JSQualifiedName parameterName) {
        if (parameterName == null) {
            JSDocCommentImpl.$$$reportNull$$$0(17);
        }
        return this.getCachedData().getDefaultValue(parameterName);
    }

    public static boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    private JSDocCommentCachedData calculateCachedData(ASTNode node) {
        JSDocCommentCachedData cachedData = new JSDocCommentCachedData();
        JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)this, node, new JSDocCommentCachedDataBuilder(cachedData));
        return cachedData;
    }

    @NotNull
    public JSDocCommentCachedData getCachedData() {
        JSDocCommentCachedData cachedData = this.myCachedData;
        if (cachedData != null) {
            JSDocCommentCachedData jSDocCommentCachedData = cachedData;
            if (jSDocCommentCachedData == null) {
                JSDocCommentImpl.$$$reportNull$$$0(18);
            }
            return jSDocCommentCachedData;
        }
        cachedData = this.calculateCachedData(this.getNode());
        List<Pair<String, String>> typedefs = cachedData.getTypedefs();
        for (int i = 0; i < typedefs.size(); ++i) {
            Pair<String, String> typedef = typedefs.get(i);
            String typedefName = (String)typedef.first;
            String typedefType = (String)typedef.second;
            Map<JSQualifiedName, String> properties = cachedData.getProperties();
            HashMap<String, String> genericParameters = new HashMap<String, String>();
            for (Pair<String, String> pair : cachedData.getGenericParameters()) {
                genericParameters.put((String)pair.getFirst(), (String)pair.getSecond());
            }
            if (properties != null && !properties.isEmpty()) {
                JSType newType = JSTypeUtils.buildRecordTypeFromProperties(this.getProject(), properties, cachedData.getOptionals(), JSTypeSource.EMPTY);
                assert (newType != null);
                JSType typedefJSType = JSTypeParser.createTypeFromJSDoc(this.getProject(), typedefType, JSTypeSource.EMPTY);
                if (!(typedefJSType instanceof JSObjectType) && typedefJSType != null) {
                    newType = JSTypeUtils.createExtendsType(newType, typedefJSType);
                }
                newType = JSTypeUtils.addJSGenericParameters(this.getProject(), newType, genericParameters);
                typedefType = JSTypeUtils.serializeType(newType);
                cachedData.clearProperties();
            } else if (cachedData.seemsToBeFunction() && typedefs.size() == 1) {
                SmartList decorators = new SmartList();
                List preparedParameters = (List)ObjectUtils.coalesce(cachedData.getParameters(), Collections.emptyList());
                for (Pair pair : preparedParameters) {
                    JSParameterTypeDecorator decorator = JSTypeParser.createParameterType(this.getProject(), (String)pair.second, JSTypeSource.EXPLICITLY_DECLARED);
                    if (decorator != null && !genericParameters.isEmpty()) {
                        decorator = new JSParameterTypeDecoratorImpl(JSTypeUtils.addJSGenericParameters(this.getProject(), decorator.getSimpleType(), genericParameters), decorator.isOptional(), decorator.isRest(), decorator.isExplicitlyDeclared());
                    }
                    if (decorator == null) {
                        decorator = JSParameterTypeDecoratorImpl.EMPTY;
                    }
                    if (pair.first != null) {
                        decorator = JSParameterTypeDecoratorImpl.withName(decorator, (String)pair.first);
                    }
                    decorators.add(decorator);
                }
                JSType returnType = JSTypeParser.createType(this.getProject(), cachedData.getReturnType(), JSTypeSource.EMPTY);
                returnType = JSTypeUtils.addJSGenericParameters(this.getProject(), returnType, genericParameters);
                if (!decorators.isEmpty() || returnType != null) {
                    JSFunctionTypeImpl functionType = new JSFunctionTypeImpl(JSTypeSource.EMPTY, (List<? extends JSParameterTypeDecorator>)decorators, returnType);
                    typedefType = JSTypeUtils.serializeType(functionType);
                }
            }
            typedefs.set(i, (Pair<String, String>)Pair.create((Object)typedefName, (Object)(typedefType != null ? typedefType : "*")));
        }
        this.myCachedData = cachedData;
        JSDocCommentCachedData jSDocCommentCachedData = cachedData;
        if (jSDocCommentCachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(19);
        }
        return jSDocCommentCachedData;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedData = null;
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String newText) {
        ASTNode newTree;
        if (newText == null) {
            JSDocCommentImpl.$$$reportNull$$$0(20);
        }
        return (newTree = JSChangeUtil.createJSTreeFromText(this.getProject(), newText)).getElementType() == JSElementTypes.DOC_COMMENT ? (JSDocComment)newTree.getPsi() : this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            JSDocCommentImpl.$$$reportNull$$$0(21);
        }
        return literalTextEscaper;
    }

    @Override
    @Nullable
    public String getThisType() {
        return this.getCachedData().getThisType();
    }

    @Override
    public boolean hasConstTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasConstTag();
        }
        return this.getCachedData().hasConstTag();
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getTypedefs() {
        List<Pair<String, String>> list = this.getCachedData().getTypedefs();
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Override
    @Nullable
    public String getEnumType() {
        return this.getCachedData().getEnumType();
    }

    @Override
    @Nullable
    public String findNameOfClassAppliedTo() {
        return this.findNameOfClassAppliedTo(this.getCachedData());
    }

    @Nullable
    private String findNameOfClassAppliedTo(@NotNull JSDocCommentCachedData cachedData) {
        PsiElement namedElement;
        JSQualifiedName qName;
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(23);
        }
        if ((qName = cachedData.getClassName()) == null) {
            String explicitName = cachedData.getExplicitName();
            JSQualifiedName jSQualifiedName = qName = explicitName != null ? JSQualifiedNameImpl.create(explicitName, cachedData.getNamespace()) : null;
        }
        if ((namedElement = JSDocumentationUtils.findAttachedElementFromComment(this)) instanceof JSFunction && ((JSFunction)namedElement).isConstructor() && namedElement.getContext() instanceof JSClass) {
            namedElement = namedElement.getContext();
        }
        String codeName = JSDocumentationUtils.getQualifiedNameFromPsi(namedElement);
        return qName == null || codeName != null && codeName.endsWith(qName.getQualifiedName()) ? codeName : JSQualifiedNameImpl.toString(qName);
    }

    @Override
    @Nullable
    public String getReturnType() {
        return this.getCachedData().getReturnType();
    }

    @Override
    public boolean hasInstanceTag() {
        return this.getCachedData().hasInstanceTag();
    }

    @Override
    @Nullable
    public String getAlias() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.getAlias();
        }
        return this.getCachedData().getAlias();
    }

    @Override
    @Nullable
    public String getLendsTagValue() {
        return this.getCachedData().getLendsTagValue();
    }

    @Override
    @Nullable
    public List<Pair<JSQualifiedName, String>> getParametersWithOptions() {
        return this.getCachedData().getParametersWithOptions();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 6, 8, 9, 17, 20, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionProcessor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findTags";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericParameters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserFamily";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedData";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedefs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTags";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findNameOfClassAppliedTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 6, 8, 9, 17, 20, 23 -> new IllegalArgumentException(string);
        };
    }
}

