/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import java.util.Set;

public final class DeclarationUtils {
    private DeclarationUtils() {
    }

    public static void calculateVariablesDeclared(JSStatement statement, Set<String> variablesDeclaredAtTopLevel, Set<String> variablesDeclaredAtLowerLevels, boolean isTopLevel) {
        if (statement == null) {
            return;
        }
        if (!(statement instanceof JSBreakStatement || statement instanceof JSExpressionStatement || statement instanceof JSContinueStatement || statement instanceof JSFunctionExitPoint)) {
            if (statement instanceof JSVarStatement) {
                DeclarationUtils.calculateVariablesDeclared((JSVarStatement)statement, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, isTopLevel);
            } else if (statement instanceof JSForStatement) {
                JSForStatement loopStatement = (JSForStatement)statement;
                DeclarationUtils.calculateVariablesDeclared(loopStatement.getVarDeclaration(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                DeclarationUtils.calculateVariablesDeclared(loopStatement.getBody(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof JSWhileStatement) {
                JSWhileStatement loopStatement = (JSWhileStatement)statement;
                DeclarationUtils.calculateVariablesDeclared(loopStatement.getBody(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof JSDoWhileStatement) {
                JSDoWhileStatement loopStatement = (JSDoWhileStatement)statement;
                DeclarationUtils.calculateVariablesDeclared(loopStatement.getBody(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof JSBlockStatement) {
                JSBlockStatement block = (JSBlockStatement)statement;
                DeclarationUtils.calculateVariablesDeclared(block.getStatementListItems(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof JSLabeledStatement) {
                JSLabeledStatement labeledStatement = (JSLabeledStatement)statement;
                DeclarationUtils.calculateVariablesDeclared(labeledStatement.getStatement(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)statement;
                JSStatement thenBranch = (JSStatement)ifStatement.getThenBranch();
                JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
                DeclarationUtils.calculateVariablesDeclared(thenBranch, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                DeclarationUtils.calculateVariablesDeclared(elseBranch, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof JSTryStatement) {
                JSTryStatement tryStatement = (JSTryStatement)statement;
                DeclarationUtils.calculateVariablesDeclared(tryStatement.getStatement(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                DeclarationUtils.calculateVariablesDeclared(tryStatement.getFinallyStatement(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                JSCatchBlock catchBlock = tryStatement.getCatchBlock();
                if (catchBlock != null) {
                    DeclarationUtils.calculateVariablesDeclared(catchBlock.getStatement(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                }
            } else if (statement instanceof JSSwitchStatement) {
                JSSwitchStatement switchStatement = (JSSwitchStatement)statement;
                for (JSCaseClause caseClause : switchStatement.getCaseClauses()) {
                    DeclarationUtils.calculateVariablesDeclared(caseClause.getStatementListItems(), variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                }
            }
        }
    }

    private static void calculateVariablesDeclared(JSVarStatement statement, Set<String> variablesDeclaredAtTopLevel, Set<String> variablesDeclaredAtLowerLevels, boolean isTopLevel) {
        for (JSVariable variable : statement.getVariables()) {
            String variableName = variable.getName();
            if (isTopLevel) {
                variablesDeclaredAtTopLevel.add(variableName);
                continue;
            }
            variablesDeclaredAtLowerLevels.add(variableName);
        }
    }

    private static void calculateVariablesDeclared(JSSourceElement[] statements, Set<String> variablesDeclaredAtTopLevel, Set<String> variablesDeclaredAtLowerLevels, boolean isTopLevel) {
        if (statements != null) {
            for (JSSourceElement statement : statements) {
                if (!(statement instanceof JSStatement)) continue;
                DeclarationUtils.calculateVariablesDeclared((JSStatement)statement, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, isTopLevel);
            }
        }
    }
}

