/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.core.free;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.code.SpringImplicitUsageProviderBase;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class SpringImplicitUsageFreeProvider
extends SpringImplicitUsageProviderBase
implements ImplicitUsageProvider {
    private static final List<String> COMPONENT_ANNOTATIONS = List.of("org.springframework.stereotype.Service", "org.springframework.stereotype.Component", "org.springframework.stereotype.Repository", "org.springframework.stereotype.Controller", "org.springframework.test.context.bean.override.mockito.MockitoBean");
    private static final List<String> FREE_MODE_ENTRY_POINTS_ANNOTATIONS = List.of("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.PostMapping", "org.springframework.web.bind.annotation.GetMapping", "org.springframework.web.bind.annotation.PutMapping", "org.springframework.web.bind.annotation.DeleteMapping", "org.springframework.web.bind.annotation.PatchMapping", "org.springframework.test.context.bean.override.mockito.MockitoBean");
    private static final List<String> FREE_MODE_GRAPHQL_ENTRY_POINTS_ANNOTATIONS = List.of(SpringAnnotationsConstants.GRAPHQL_MAPPINGS);

    SpringImplicitUsageFreeProvider() {
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageFreeProvider.$$$reportNull$$$0(0);
        }
        return SpringImplicitUsageFreeProvider.isFreeMode() && (super.isImplicitUsage(element) || SpringImplicitUsageFreeProvider.isTestingImplicitUsage(element));
    }

    private static boolean isTestingImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageFreeProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierList modifierList = ((PsiModifierListOwner)element).getModifierList();
        if (modifierList == null || modifierList.getAnnotations().length == 0) {
            return false;
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), List.of("org.springframework.test.context.bean.override.mockito.MockitoBean", "org.springframework.test.context.bean.override.mockito.MockitoSpyBean", "org.springframework.test.context.bean.override.convention.TestBean"));
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageFreeProvider.$$$reportNull$$$0(2);
        }
        return SpringImplicitUsageFreeProvider.isFreeMode() && (super.isImplicitRead(element) || SpringImplicitUsageFreeProvider.isTestingImplicitUsage(element));
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageFreeProvider.$$$reportNull$$$0(3);
        }
        return SpringImplicitUsageFreeProvider.isFreeMode() && (super.isImplicitWrite(element) || SpringImplicitUsageFreeProvider.isTestingImplicitUsage(element));
    }

    protected boolean isBeanClassOrConstructor(PsiElement element) {
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.isInterface()) {
                return false;
            }
            return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiClass, COMPONENT_ANNOTATIONS);
        }
        return false;
    }

    @NotNull
    protected List<String> getEntryPoints() {
        ArrayList<String> entryPoints = new ArrayList<String>();
        entryPoints.addAll(super.getEntryPoints());
        entryPoints.addAll(FREE_MODE_ENTRY_POINTS_ANNOTATIONS);
        entryPoints.addAll(FREE_MODE_GRAPHQL_ENTRY_POINTS_ANNOTATIONS);
        ArrayList<String> arrayList = entryPoints;
        if (arrayList == null) {
            SpringImplicitUsageFreeProvider.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static boolean isFreeMode() {
        return PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
    }

    protected boolean isSpringConfigured(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageFreeProvider.$$$reportNull$$$0(5);
        }
        return SpringLibraryUtil.hasSpringLibrary((Project)element.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/core/free/SpringImplicitUsageFreeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/core/free/SpringImplicitUsageFreeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTestingImplicitUsage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitRead";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSpringConfigured";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

