/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa;

import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.text.NameUtilCore;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0000\u001a!\u0010\u0005\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0017\u0010\u0005\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"findMatchedEntity", "", "repositoryClassName", "values", "", "entityIdClass", "Lcom/intellij/openapi/util/NlsSafe;", "ormEntity", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "entityClass", "Lcom/intellij/psi/PsiClass;", "ormEntityIdClass", "intellij.spring.data.jpa"})
@SourceDebugExtension(value={"SMAP\nSpringDateEntityUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDateEntityUtils.kt\ncom/intellij/spring/data/jpa/SpringDateEntityUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1#2:39\n295#3,2:40\n*S KotlinDebug\n*F\n+ 1 SpringDateEntityUtils.kt\ncom/intellij/spring/data/jpa/SpringDateEntityUtilsKt\n*L\n36#1:40,2\n*E\n"})
public final class SpringDateEntityUtilsKt {
    @Nullable
    public static final String findMatchedEntity(@NotNull String repositoryClassName, @NotNull List<String> values) {
        Intrinsics.checkNotNullParameter((Object)repositoryClassName, (String)"repositoryClassName");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Object[] objectArray = NameUtilCore.splitNameIntoWords((String)repositoryClassName);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"splitNameIntoWords(...)");
        Object[] splitWords = objectArray;
        if (splitWords.length == 0) {
            return null;
        }
        String entity = null;
        List entityWordsWithoutLast = ArraysKt.take((Object[])splitWords, (int)(splitWords.length - 1));
        while (!((Collection)entityWordsWithoutLast).isEmpty()) {
            Object v1;
            block3: {
                String entityName = CollectionsKt.joinToString$default((Iterable)entityWordsWithoutLast, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                Iterable iterable = values;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it, (String)entityName, (boolean)true)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            entity = v1;
            if (entity != null) break;
            entityWordsWithoutLast = CollectionsKt.dropLast((List)entityWordsWithoutLast, (int)1);
        }
        return entity;
    }

    @Nullable
    public static final String entityIdClass(@Nullable OrmEntity ormEntity, @NotNull PsiClass entityClass) {
        Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
        String string = SpringDateEntityUtilsKt.entityIdClass(entityClass);
        if (string == null && (string = SpringDateEntityUtilsKt.ormEntityIdClass(ormEntity)) == null) {
            return null;
        }
        String idTypeFqn = string;
        Datatypes.BasicDatatype idAttributeType = Datatypes.BasicDatatype.getInstanceStrict((String)idTypeFqn);
        Datatypes.BasicDatatype unboxedType = (Datatypes.BasicDatatype)Datatypes.BasicDatatype.PRIMITIVE_TO_BOXED.get(idAttributeType);
        Object object = unboxedType;
        if (object == null || (object = object.getFqn()) == null) {
            object = idTypeFqn;
        }
        return object;
    }

    private static final String ormEntityIdClass(OrmEntity ormEntity) {
        String string;
        block3: {
            for (OrmEntity it : SequencesKt.generateSequence((Object)ormEntity, SpringDateEntityUtilsKt::ormEntityIdClass$lambda$0)) {
                OrmEntityAttribute ormEntityAttribute;
                String string2;
                Object v0;
                block2: {
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = it.getAttributes();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        OrmEntityAttribute it2 = (OrmEntityAttribute)element$iv;
                        boolean bl2 = false;
                        if (!it2.isId()) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((string2 = (ormEntityAttribute = (OrmEntityAttribute)v0) != null && (ormEntityAttribute = ormEntityAttribute.getTypeFqn()) != null ? ormEntityAttribute.getName(true) : null) == null) continue;
                string = string2;
                break block3;
            }
            string = null;
        }
        return string;
    }

    private static final String entityIdClass(PsiClass entityClass) {
        EntityImpl entityImpl = (EntityImpl)EntityImpl.ENTITY_META.getJamElement((PsiModifierListOwner)entityClass);
        return entityImpl != null && (entityImpl = entityImpl.getIdClassValue()) != null && (entityImpl = entityImpl.getValue()) != null ? entityImpl.getQualifiedName() : null;
    }

    private static final OrmEntity ormEntityIdClass$lambda$0(OrmEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

