/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 135465851995371L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1711512060 - (char)-28808, -1711512060 - -21976, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1711512060 - (char)-28809, 1711512060 - (char)-30852, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 130858007062469L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.s();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1056555270 - (char)-26786, -1056555270 - -18364, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1056555270 - (char)-26787, -1056555270 - -((char)-22163), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1056555270 - (char)-26792, 1056555270 - 23999, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String[] stringArray;
                l2 = 69144680393427L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    stringArray = SshAgentIpcService.s();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1834980 + -((char)-9373), 1834980 + (char)-17697, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1834980 + -((char)-9374), 1834980 + (char)-16609, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1834980 + -((char)-9375), 1834980 + (char)-17889, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1834980 + -((char)-9368), 1834980 + (char)-28865, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1834980 + -((char)-9369), -1834980 + -((char)-23393), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1834980 + -((char)-9370), 1834980 + (char)-22226, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1834980 + -((char)-9368), 1834980 + (char)-28865, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1834980 + -((char)-9371), -1834980 + -((char)-25964), (int)l2));
            if (ActionTimestamp.s() != null) {
                SshAgentIpcService.s(new String[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 126425025289418L;
                    stringArray = SshAgentIpcService.s();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block27: {
            block28: {
                l2 = 58037035929953L;
                String[] stringArray2 = SshAgentIpcService.s();
                this.assertConnectionThread();
                stringArray = stringArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(857197800 - (char)-4634, 857197800 - (char)-4796, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(857197800 - (char)-4638, -857066730 + -((char)-16763), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(857197800 - (char)-4635, -857197800 - -((char)-10588), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(857197800 - (char)-4638, -857066730 + -((char)-16763), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(857197800 - (char)-4632, -857066730 + -((char)-4582), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(857197800 - (char)-4634, 857197800 - (char)-4796, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(857197800 - (char)-4638, -857066730 + -((char)-16763), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(857197800 - (char)-4633, 857066730 + (char)-7047, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(857197800 - (char)-4634, 857197800 - (char)-4796, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(857197800 - (char)-4638, -857066730 + -((char)-16763), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(857197800 - (char)-4662, 857197800 - (char)-7515, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(857197800 - (char)-4638, -857066730 + -((char)-16763), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(857197800 - (char)-4663, 857197800 - (char)-11728, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(857197800 - (char)-4638, -857066730 + -((char)-16763), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(857197800 - (char)-4632, -857066730 + -((char)-4582), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(857197800 - (char)-4634, 857197800 - (char)-4796, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(857197800 - (char)-4638, -857066730 + -((char)-16763), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(857197800 - (char)-4660, 857066730 + (char)-16403, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 52565284725364L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-819973920 + -18179, -819973920 + -((char)-25216), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 35629762888522L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1285796700 + -17346, -1285796700 + -5534, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "}ya\u00dea\u00e2)!\u00da\u00b0a3X\u0011\u0019\u00bb:\u00c3?\u0014bc\u0082\u009b\u0006\u0088\u00b8\u00e9j\u00af\u00b2\u0004\u00e0\u000e\u00cf\u00d3\r\b\u00de\u00ea";
                        var4_3 = "}ya\u00dea\u00e2)!\u00da\u00b0a3X\u0011\u0019\u00bb:\u00c3?\u0014bc\u0082\u009b\u0006\u0088\u00b8\u00e9j\u00af\u00b2\u0004\u00e0\u000e\u00cf\u00d3\r\b\u00de\u00ea".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 66;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 121;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 27;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 63;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 24;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 87;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 32;
                                        break;
                                    }
                                    default: {
                                        v11 = 51;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x4BA9) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 8;
                            case 1 -> 230;
                            case 2 -> 4;
                            case 3 -> 98;
                            case 4 -> 239;
                            case 5 -> 224;
                            case 6 -> 123;
                            case 7 -> 73;
                            case 8 -> 121;
                            case 9 -> 170;
                            case 10 -> 20;
                            case 11 -> 198;
                            case 12 -> 124;
                            case 13 -> 54;
                            case 14 -> 101;
                            case 15 -> 178;
                            case 16 -> 250;
                            case 17 -> 185;
                            case 18 -> 40;
                            case 19 -> 14;
                            case 20 -> 215;
                            case 21 -> 212;
                            case 22 -> 151;
                            case 23 -> 196;
                            case 24 -> 183;
                            case 25 -> 145;
                            case 26 -> 175;
                            case 27 -> 99;
                            case 28 -> 194;
                            case 29 -> 154;
                            case 30 -> 67;
                            case 31 -> 22;
                            case 32 -> 149;
                            case 33 -> 229;
                            case 34 -> 254;
                            case 35 -> 207;
                            case 36 -> 17;
                            case 37 -> 39;
                            case 38 -> 93;
                            case 39 -> 177;
                            case 40 -> 36;
                            case 41 -> 83;
                            case 42 -> 255;
                            case 43 -> 92;
                            case 44 -> 56;
                            case 45 -> 108;
                            case 46 -> 163;
                            case 47 -> 50;
                            case 48 -> 64;
                            case 49 -> 102;
                            case 50 -> 249;
                            case 51 -> 90;
                            case 52 -> 133;
                            case 53 -> 150;
                            case 54 -> 96;
                            case 55 -> 213;
                            case 56 -> 100;
                            case 57 -> 226;
                            case 58 -> 59;
                            case 59 -> 232;
                            case 60 -> 16;
                            case 61 -> 103;
                            case 62 -> 87;
                            case 63 -> 58;
                            case 64 -> 33;
                            case 65 -> 11;
                            case 66 -> 51;
                            case 67 -> 197;
                            case 68 -> 243;
                            case 69 -> 128;
                            case 70 -> 236;
                            case 71 -> 148;
                            case 72 -> 179;
                            case 73 -> 19;
                            case 74 -> 42;
                            case 75 -> 81;
                            case 76 -> 94;
                            case 77 -> 242;
                            case 78 -> 109;
                            case 79 -> 60;
                            case 80 -> 5;
                            case 81 -> 113;
                            case 82 -> 141;
                            case 83 -> 206;
                            case 84 -> 158;
                            case 85 -> 235;
                            case 86 -> 146;
                            case 87 -> 2;
                            case 88 -> 46;
                            case 89 -> 21;
                            case 90 -> 205;
                            case 91 -> 95;
                            case 92 -> 155;
                            case 93 -> 37;
                            case 94 -> 49;
                            case 95 -> 147;
                            case 96 -> 144;
                            case 97 -> 44;
                            case 98 -> 85;
                            case 99 -> 130;
                            case 100 -> 106;
                            case 101 -> 251;
                            case 102 -> 225;
                            case 103 -> 208;
                            case 104 -> 112;
                            case 105 -> 119;
                            case 106 -> 66;
                            case 107 -> 210;
                            case 108 -> 202;
                            case 109 -> 143;
                            case 110 -> 86;
                            case 111 -> 180;
                            case 112 -> 161;
                            case 113 -> 0;
                            case 114 -> 23;
                            case 115 -> 31;
                            case 116 -> 61;
                            case 117 -> 29;
                            case 118 -> 221;
                            case 119 -> 222;
                            case 120 -> 79;
                            case 121 -> 91;
                            case 122 -> 126;
                            case 123 -> 187;
                            case 124 -> 168;
                            case 125 -> 164;
                            case 126 -> 125;
                            case 127 -> 200;
                            case 128 -> 247;
                            case 129 -> 32;
                            case 130 -> 227;
                            case 131 -> 214;
                            case 132 -> 172;
                            case 133 -> 65;
                            case 134 -> 166;
                            case 135 -> 218;
                            case 136 -> 190;
                            case 137 -> 55;
                            case 138 -> 68;
                            case 139 -> 137;
                            case 140 -> 160;
                            case 141 -> 135;
                            case 142 -> 89;
                            case 143 -> 234;
                            case 144 -> 162;
                            case 145 -> 28;
                            case 146 -> 26;
                            case 147 -> 116;
                            case 148 -> 74;
                            case 149 -> 1;
                            case 150 -> 38;
                            case 151 -> 131;
                            case 152 -> 76;
                            case 153 -> 171;
                            case 154 -> 63;
                            case 155 -> 117;
                            case 156 -> 30;
                            case 157 -> 199;
                            case 158 -> 188;
                            case 159 -> 136;
                            case 160 -> 204;
                            case 161 -> 223;
                            case 162 -> 157;
                            case 163 -> 203;
                            case 164 -> 142;
                            case 165 -> 153;
                            case 166 -> 152;
                            case 167 -> 240;
                            case 168 -> 246;
                            case 169 -> 97;
                            case 170 -> 241;
                            case 171 -> 115;
                            case 172 -> 238;
                            case 173 -> 82;
                            case 174 -> 140;
                            case 175 -> 18;
                            case 176 -> 220;
                            case 177 -> 169;
                            case 178 -> 228;
                            case 179 -> 48;
                            case 180 -> 189;
                            case 181 -> 122;
                            case 182 -> 173;
                            case 183 -> 88;
                            case 184 -> 80;
                            case 185 -> 71;
                            case 186 -> 253;
                            case 187 -> 114;
                            case 188 -> 181;
                            case 189 -> 107;
                            case 190 -> 165;
                            case 191 -> 110;
                            case 192 -> 233;
                            case 193 -> 118;
                            case 194 -> 211;
                            case 195 -> 139;
                            case 196 -> 52;
                            case 197 -> 62;
                            case 198 -> 167;
                            case 199 -> 182;
                            case 200 -> 6;
                            case 201 -> 69;
                            case 202 -> 248;
                            case 203 -> 13;
                            case 204 -> 219;
                            case 205 -> 77;
                            case 206 -> 41;
                            case 207 -> 231;
                            case 208 -> 244;
                            case 209 -> 127;
                            case 210 -> 34;
                            case 211 -> 252;
                            case 212 -> 129;
                            case 213 -> 47;
                            case 214 -> 216;
                            case 215 -> 132;
                            case 216 -> 45;
                            case 217 -> 15;
                            case 218 -> 43;
                            case 219 -> 84;
                            case 220 -> 176;
                            case 221 -> 201;
                            case 222 -> 120;
                            case 223 -> 57;
                            case 224 -> 186;
                            case 225 -> 104;
                            case 226 -> 53;
                            case 227 -> 25;
                            case 228 -> 159;
                            case 229 -> 111;
                            case 230 -> 174;
                            case 231 -> 35;
                            case 232 -> 156;
                            case 233 -> 105;
                            case 234 -> 9;
                            case 235 -> 27;
                            case 236 -> 78;
                            case 237 -> 191;
                            case 238 -> 237;
                            case 239 -> 245;
                            case 240 -> 12;
                            case 241 -> 3;
                            case 242 -> 10;
                            case 243 -> 75;
                            case 244 -> 217;
                            case 245 -> 7;
                            case 246 -> 195;
                            case 247 -> 138;
                            case 248 -> 184;
                            case 249 -> 192;
                            case 250 -> 24;
                            case 251 -> 209;
                            case 252 -> 70;
                            case 253 -> 134;
                            case 254 -> 193;
                            default -> 72;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (stringArray == null) {
                ActionTimestamp.s(new String[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 70191495681396L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.s();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1154857770 - 24595, 1154857770 - 24441, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1154857770 - 24599, -1154857770 - -((char)-21586), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1154857770 - 24610, -1154857770 - -23109, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1154857770 - 24595, 1154857770 - 24441, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1154857770 - 24599, -1154857770 - -((char)-21586), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1154857770 - 24603, 1154857770 - (char)-20517, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 112053046170832L;
                        String[] stringArray2 = SshAgentIpcService.s();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1644404220 - -14502, -1644404220 - -25087, (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1644404220 - -14501, 1644404220 - (char)-29867, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 128417752833589L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    stringArray = SshAgentIpcService.s();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1769313930 - 1588, 1769313930 - 1434, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1769313930 - 1592, -1769313930 + -11697, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1769313930 - 1597, -1769313930 - -5414, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1769313930 - 1592, -1769313930 + -11697, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1769313930 - 1590, -1769313930 + -24014, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1769313930 - 1588, 1769313930 - 1434, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1769313930 - 1592, -1769313930 + -11697, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1769313930 - 1608, 1769313930 + 21544, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1769313930 - 1588, 1769313930 - 1434, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1769313930 - 1592, -1769313930 + -11697, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1769313930 - 1607, 1769313930 + 16012, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1769313930 - 1588, 1769313930 - 1434, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1769313930 - 1592, -1769313930 + -11697, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1769313930 - 1610, -1769313930 + -21098, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 81212776877509L;
                    Object object = this.lock;
                    stringArray = SshAgentIpcService.s();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(759681720 + 28910, 759681720 + 28744, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(759681720 + 28906, -759681720 + -17683, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(759681720 + 28921, 759681720 + 21953, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(759681720 + 28926, -759681720 + -16816, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(759681720 + 28910, 759681720 + 28744, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(759681720 + 28906, -759681720 + -17683, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(759681720 + 28927, -759681720 + -((char)-27087), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(759681720 + 28910, 759681720 + 28744, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(759681720 + 28906, -759681720 + -17683, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(759681720 + 28924, 759681720 + (char)-23620, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(759681720 + 28910, 759681720 + 28744, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(759681720 + 28906, -759681720 + -17683, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(759681720 + 28925, 759681720 + (char)-27804, (int)l2));
                    if (stringArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(759681720 + 28910, 759681720 + 28744, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(759681720 + 28906, -759681720 + -17683, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(759681720 + 28882, 759681720 + (char)-21308, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(759681720 + 28883, 759681720 + (char)-27826, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\rP\u00dc\u00ae\u00d6\u00a8%\u00f6\u0014i\u00d9hx\u00be\u00fa\u0087\u00a6\u00baR\u00dd\u0004\u00a5\u00d8\u00e8n\u009b\u0098,F\u0006 +y\u00c1\b\u0004\u0018dJ\u00a9:\u0004w\u00d2\u00d7\u00d8\u0001\u009e\u001e\u00abd{{@Sy\u00a2C\u00f88\u0098\t\u0085\u0087\u000b2;\u00e9-L\u001b\u0005\u0007R\u009d\u00ee\u008e\b\u00a1<IR6\u0011?#\u0014x\u00c52`\u0098\u00f1vP\u00eaQ|\u00d0\u00db\u00e1\u009c\u00a4\u0007\u0012FU\u0005|\u0094\u00f26c\u001e\u000e\u001b\u00a9\u00a3\u0095\u0080BSo\u0085#\tP\u00a6\u00a6G\u001aE\u00e0\u0094\u00dc\u0011\u00c7h%\u00e6\u00ee^U\u00ba\u0010\u00b88\u009b\u0002\u0084\u0086\u0096j\u0088\u0010RFx\u001a\fO\t\u00f0\u00d2s\u0089g\u00b9\u0080\u00d9@\u0010\u00b5\u0082:U\u00b0l\u00107X\u00bbH3;\u00b4d\u009a?\u008bP\u0011\u00ca\u008f\u00a4\u0084\u00bb\u00c6ISk\u00e1\u001c\u00ad)\u00be\u00ed\tDoY\u00ca\u0007\u0094\u00e3\u00d5J\u0005nT\u001eKI\u00f0\u008fBi\u00bem\u008d\u00d7\u00bdq\u00a5\u0088\u001b\u0013\u0010?\u008b\u00ba\u009eK\u00bb\u00e8kKN\u0090$\u00ef\u0092\b\u0006H\u00bd\u00dc\u00a8\u00c0\u00ec\u0019\fe\u00d1\u00c1\u00f4:\u00a7P\u00f2yK>)F\u00e9\u0010P\u00cc\b\u00a0\u0016\u0012\u00b1[-\u00ef\u00b8\u0084\u0099\u001c\u00c4,F\u00d3\u0094\u00f9\u00b6!-\f\u0011\u00bc\"\u0099\u008a\u00dc\u00ac\u00a7\u00ces_\u00bb\u00b6\u00f3\u001f\u0011dR@i\u00f3R\u00ea\u00ef\u00b2\nV\u00cb\u00b4\u00e3\u0015^\u0017\u008e<E\u00cd\u0084_G\u00f7\n\u0001\u00b1\u001fL4\u00e1F\u009c<c\u00c4Kw\u00a7W\u00c0p\u00bf,B\u00c0\u0096\u00ee\u00d9\u00de\u00b0:\u00aa|\b\u00c1\u0094\u00b8^\u000bVo\u00a7#\u00f6]\u00c9\u00adJ\u00acR\u0015C\u00a8\u0005\u00d8\u00a5JO2\u00a4\u00bfG\u0085b\u0086\u00f6\u00a4\u0090E\u0011'\u001f)\u00e2\u009742&\u00b24\u0015\u00a1M\u00fa\u0010o\u0092\u00d4upc\u000b=\u009a\u00dc\u001eb\u0010>\u0088\u00f1\u00abJ;\u0098d\u008a\u00b1[\u00ae\u00a3\u0003Y\n\u0007\u00f4\u00bf\u00fc-\u001b\f\b\u0007\u009bXu\u00bd\u00cd\u00f1\u00c4(S\u009fN\u0012\u00d9\u00dc=\u00ff\u00f0\u00c7\u00fawL\u00ff\u00f2[\u00b3\u000b\u00dds!+\u0006W\u0083$L\u00c9\u0004-\u0015mZ_\u00e8L?<\u00a2Y\u000f\u0017\u00f6\u0088\u0016\u00e90\u009e\u00a1\u00f1\u0081{\u00ee\u00dc\u0098~\"\u00d7i\u0092\u00ed\u00f2I\u00aej\u00f2\u00a2\u0090\u00ed!!y\u00cd.]J\u00b8Xl\u00e6$\u009c\u00a2\u00d4\u00bc\u0004\u00d1l\u00ec\u00a0\u00f7\u000e\u00d3\u00d5\u0010r\u00fa\u00bc\u00fc0\u00bd\u00b3\u00f2\u00a8\u00e1Z\u001b\u00d0\u00efw0\u00edA\u008b\u00d3\u0004HH\u00d6\u00e6\u00a3\u00a7\u008b]?\u0099h\u0019B\u00bdG\u00bc\u00a3\u0085\n)2\u008c\u008c\u008625\u0097x\u00a2\u0018\u00bfq\u009a\u00eeQ&=a\u00cc\u00d7\u0093\u00ba$}\u0003q\u00bea2\u00da\u0014_G\u00b7)K\u00e7\u0001<\u0080s\u00e0-;J\u00a9\u00f0\u0001\u0087\u0086\u00acD-R1\u008bMu\\\bk\u0016\u00b7+\u00de\u0090\u009b44n\u0018\u008b\u00ef\u00a7\u00d0\u009e\tL4\u00e4K\u009f.\u00c9p\u00d4";
                var4_3 = "\rP\u00dc\u00ae\u00d6\u00a8%\u00f6\u0014i\u00d9hx\u00be\u00fa\u0087\u00a6\u00baR\u00dd\u0004\u00a5\u00d8\u00e8n\u009b\u0098,F\u0006 +y\u00c1\b\u0004\u0018dJ\u00a9:\u0004w\u00d2\u00d7\u00d8\u0001\u009e\u001e\u00abd{{@Sy\u00a2C\u00f88\u0098\t\u0085\u0087\u000b2;\u00e9-L\u001b\u0005\u0007R\u009d\u00ee\u008e\b\u00a1<IR6\u0011?#\u0014x\u00c52`\u0098\u00f1vP\u00eaQ|\u00d0\u00db\u00e1\u009c\u00a4\u0007\u0012FU\u0005|\u0094\u00f26c\u001e\u000e\u001b\u00a9\u00a3\u0095\u0080BSo\u0085#\tP\u00a6\u00a6G\u001aE\u00e0\u0094\u00dc\u0011\u00c7h%\u00e6\u00ee^U\u00ba\u0010\u00b88\u009b\u0002\u0084\u0086\u0096j\u0088\u0010RFx\u001a\fO\t\u00f0\u00d2s\u0089g\u00b9\u0080\u00d9@\u0010\u00b5\u0082:U\u00b0l\u00107X\u00bbH3;\u00b4d\u009a?\u008bP\u0011\u00ca\u008f\u00a4\u0084\u00bb\u00c6ISk\u00e1\u001c\u00ad)\u00be\u00ed\tDoY\u00ca\u0007\u0094\u00e3\u00d5J\u0005nT\u001eKI\u00f0\u008fBi\u00bem\u008d\u00d7\u00bdq\u00a5\u0088\u001b\u0013\u0010?\u008b\u00ba\u009eK\u00bb\u00e8kKN\u0090$\u00ef\u0092\b\u0006H\u00bd\u00dc\u00a8\u00c0\u00ec\u0019\fe\u00d1\u00c1\u00f4:\u00a7P\u00f2yK>)F\u00e9\u0010P\u00cc\b\u00a0\u0016\u0012\u00b1[-\u00ef\u00b8\u0084\u0099\u001c\u00c4,F\u00d3\u0094\u00f9\u00b6!-\f\u0011\u00bc\"\u0099\u008a\u00dc\u00ac\u00a7\u00ces_\u00bb\u00b6\u00f3\u001f\u0011dR@i\u00f3R\u00ea\u00ef\u00b2\nV\u00cb\u00b4\u00e3\u0015^\u0017\u008e<E\u00cd\u0084_G\u00f7\n\u0001\u00b1\u001fL4\u00e1F\u009c<c\u00c4Kw\u00a7W\u00c0p\u00bf,B\u00c0\u0096\u00ee\u00d9\u00de\u00b0:\u00aa|\b\u00c1\u0094\u00b8^\u000bVo\u00a7#\u00f6]\u00c9\u00adJ\u00acR\u0015C\u00a8\u0005\u00d8\u00a5JO2\u00a4\u00bfG\u0085b\u0086\u00f6\u00a4\u0090E\u0011'\u001f)\u00e2\u009742&\u00b24\u0015\u00a1M\u00fa\u0010o\u0092\u00d4upc\u000b=\u009a\u00dc\u001eb\u0010>\u0088\u00f1\u00abJ;\u0098d\u008a\u00b1[\u00ae\u00a3\u0003Y\n\u0007\u00f4\u00bf\u00fc-\u001b\f\b\u0007\u009bXu\u00bd\u00cd\u00f1\u00c4(S\u009fN\u0012\u00d9\u00dc=\u00ff\u00f0\u00c7\u00fawL\u00ff\u00f2[\u00b3\u000b\u00dds!+\u0006W\u0083$L\u00c9\u0004-\u0015mZ_\u00e8L?<\u00a2Y\u000f\u0017\u00f6\u0088\u0016\u00e90\u009e\u00a1\u00f1\u0081{\u00ee\u00dc\u0098~\"\u00d7i\u0092\u00ed\u00f2I\u00aej\u00f2\u00a2\u0090\u00ed!!y\u00cd.]J\u00b8Xl\u00e6$\u009c\u00a2\u00d4\u00bc\u0004\u00d1l\u00ec\u00a0\u00f7\u000e\u00d3\u00d5\u0010r\u00fa\u00bc\u00fc0\u00bd\u00b3\u00f2\u00a8\u00e1Z\u001b\u00d0\u00efw0\u00edA\u008b\u00d3\u0004HH\u00d6\u00e6\u00a3\u00a7\u008b]?\u0099h\u0019B\u00bdG\u00bc\u00a3\u0085\n)2\u008c\u008c\u008625\u0097x\u00a2\u0018\u00bfq\u009a\u00eeQ&=a\u00cc\u00d7\u0093\u00ba$}\u0003q\u00bea2\u00da\u0014_G\u00b7)K\u00e7\u0001<\u0080s\u00e0-;J\u00a9\u00f0\u0001\u0087\u0086\u00acD-R1\u008bMu\\\bk\u0016\u00b7+\u00de\u0090\u009b44n\u0018\u008b\u00ef\u00a7\u00d0\u009e\tL4\u00e4K\u009f.\u00c9p\u00d4".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 105;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "t;\u00b6\u00f7&ZdX\u00fb\u00b4\u00e1\u007fX&\u00fd\u00c8{\u00fd\u00b5\u00ffr\u00fb\u00e9\u0004`,\u00daJr\u0014\u009f\u00ac\u00e6\u0086?u\u00e7\u0007\u00e66\u0006\u00d8\u008e\u0013\u00ddGm\u00ed\u00a2\u00b8";
                    var4_3 = "t;\u00b6\u00f7&ZdX\u00fb\u00b4\u00e1\u007fX&\u00fd\u00c8{\u00fd\u00b5\u00ffr\u00fb\u00e9\u0004`,\u00daJr\u0014\u009f\u00ac\u00e6\u0086?u\u00e7\u0007\u00e66\u0006\u00d8\u008e\u0013\u00ddGm\u00ed\u00a2\u00b8".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 123;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 33;
                            break;
                        }
                        case 1: {
                            v15 = 45;
                            break;
                        }
                        case 2: {
                            v15 = 19;
                            break;
                        }
                        case 3: {
                            v15 = 100;
                            break;
                        }
                        case 4: {
                            v15 = 69;
                            break;
                        }
                        case 5: {
                            v15 = 29;
                            break;
                        }
                        default: {
                            v15 = 61;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFCE6F) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 29;
                case 1 -> 20;
                case 2 -> 15;
                case 3 -> 120;
                case 4 -> 155;
                case 5 -> 176;
                case 6 -> 132;
                case 7 -> 230;
                case 8 -> 195;
                case 9 -> 255;
                case 10 -> 207;
                case 11 -> 62;
                case 12 -> 113;
                case 13 -> 51;
                case 14 -> 187;
                case 15 -> 210;
                case 16 -> 201;
                case 17 -> 31;
                case 18 -> 159;
                case 19 -> 233;
                case 20 -> 133;
                case 21 -> 192;
                case 22 -> 72;
                case 23 -> 247;
                case 24 -> 204;
                case 25 -> 136;
                case 26 -> 160;
                case 27 -> 110;
                case 28 -> 77;
                case 29 -> 158;
                case 30 -> 146;
                case 31 -> 38;
                case 32 -> 144;
                case 33 -> 3;
                case 34 -> 232;
                case 35 -> 186;
                case 36 -> 22;
                case 37 -> 89;
                case 38 -> 154;
                case 39 -> 248;
                case 40 -> 178;
                case 41 -> 239;
                case 42 -> 145;
                case 43 -> 149;
                case 44 -> 150;
                case 45 -> 235;
                case 46 -> 165;
                case 47 -> 100;
                case 48 -> 93;
                case 49 -> 95;
                case 50 -> 54;
                case 51 -> 175;
                case 52 -> 172;
                case 53 -> 222;
                case 54 -> 27;
                case 55 -> 57;
                case 56 -> 237;
                case 57 -> 131;
                case 58 -> 177;
                case 59 -> 116;
                case 60 -> 200;
                case 61 -> 0;
                case 62 -> 254;
                case 63 -> 251;
                case 64 -> 168;
                case 65 -> 156;
                case 66 -> 49;
                case 67 -> 245;
                case 68 -> 40;
                case 69 -> 2;
                case 70 -> 50;
                case 71 -> 4;
                case 72 -> 180;
                case 73 -> 13;
                case 74 -> 220;
                case 75 -> 143;
                case 76 -> 109;
                case 77 -> 53;
                case 78 -> 41;
                case 79 -> 209;
                case 80 -> 118;
                case 81 -> 1;
                case 82 -> 56;
                case 83 -> 169;
                case 84 -> 208;
                case 85 -> 184;
                case 86 -> 244;
                case 87 -> 52;
                case 88 -> 130;
                case 89 -> 194;
                case 90 -> 88;
                case 91 -> 137;
                case 92 -> 134;
                case 93 -> 14;
                case 94 -> 45;
                case 95 -> 34;
                case 96 -> 21;
                case 97 -> 16;
                case 98 -> 249;
                case 99 -> 25;
                case 100 -> 231;
                case 101 -> 241;
                case 102 -> 119;
                case 103 -> 183;
                case 104 -> 91;
                case 105 -> 108;
                case 106 -> 242;
                case 107 -> 127;
                case 108 -> 30;
                case 109 -> 92;
                case 110 -> 226;
                case 111 -> 193;
                case 112 -> 19;
                case 113 -> 191;
                case 114 -> 80;
                case 115 -> 105;
                case 116 -> 243;
                case 117 -> 163;
                case 118 -> 205;
                case 119 -> 73;
                case 120 -> 197;
                case 121 -> 85;
                case 122 -> 44;
                case 123 -> 167;
                case 124 -> 70;
                case 125 -> 164;
                case 126 -> 138;
                case 127 -> 121;
                case 128 -> 227;
                case 129 -> 188;
                case 130 -> 39;
                case 131 -> 107;
                case 132 -> 33;
                case 133 -> 79;
                case 134 -> 221;
                case 135 -> 202;
                case 136 -> 229;
                case 137 -> 206;
                case 138 -> 67;
                case 139 -> 112;
                case 140 -> 236;
                case 141 -> 103;
                case 142 -> 203;
                case 143 -> 96;
                case 144 -> 76;
                case 145 -> 87;
                case 146 -> 141;
                case 147 -> 196;
                case 148 -> 147;
                case 149 -> 66;
                case 150 -> 122;
                case 151 -> 142;
                case 152 -> 26;
                case 153 -> 129;
                case 154 -> 28;
                case 155 -> 152;
                case 156 -> 174;
                case 157 -> 170;
                case 158 -> 114;
                case 159 -> 126;
                case 160 -> 182;
                case 161 -> 135;
                case 162 -> 63;
                case 163 -> 9;
                case 164 -> 86;
                case 165 -> 117;
                case 166 -> 82;
                case 167 -> 59;
                case 168 -> 234;
                case 169 -> 190;
                case 170 -> 171;
                case 171 -> 246;
                case 172 -> 61;
                case 173 -> 104;
                case 174 -> 48;
                case 175 -> 8;
                case 176 -> 224;
                case 177 -> 102;
                case 178 -> 216;
                case 179 -> 238;
                case 180 -> 124;
                case 181 -> 225;
                case 182 -> 106;
                case 183 -> 219;
                case 184 -> 217;
                case 185 -> 97;
                case 186 -> 11;
                case 187 -> 17;
                case 188 -> 7;
                case 189 -> 125;
                case 190 -> 64;
                case 191 -> 139;
                case 192 -> 74;
                case 193 -> 47;
                case 194 -> 58;
                case 195 -> 228;
                case 196 -> 71;
                case 197 -> 55;
                case 198 -> 179;
                case 199 -> 148;
                case 200 -> 83;
                case 201 -> 162;
                case 202 -> 10;
                case 203 -> 173;
                case 204 -> 252;
                case 205 -> 161;
                case 206 -> 151;
                case 207 -> 101;
                case 208 -> 166;
                case 209 -> 214;
                case 210 -> 153;
                case 211 -> 215;
                case 212 -> 32;
                case 213 -> 12;
                case 214 -> 240;
                case 215 -> 60;
                case 216 -> 211;
                case 217 -> 81;
                case 218 -> 212;
                case 219 -> 46;
                case 220 -> 36;
                case 221 -> 250;
                case 222 -> 199;
                case 223 -> 18;
                case 224 -> 218;
                case 225 -> 84;
                case 226 -> 213;
                case 227 -> 94;
                case 228 -> 223;
                case 229 -> 181;
                case 230 -> 123;
                case 231 -> 75;
                case 232 -> 157;
                case 233 -> 253;
                case 234 -> 24;
                case 235 -> 23;
                case 236 -> 35;
                case 237 -> 98;
                case 238 -> 99;
                case 239 -> 65;
                case 240 -> 42;
                case 241 -> 90;
                case 242 -> 198;
                case 243 -> 111;
                case 244 -> 78;
                case 245 -> 115;
                case 246 -> 69;
                case 247 -> 5;
                case 248 -> 189;
                case 249 -> 185;
                case 250 -> 6;
                case 251 -> 128;
                case 252 -> 37;
                case 253 -> 43;
                case 254 -> 140;
                default -> 68;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 124912917489092L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1911262740 + -((char)-1625), -1911393810 - -((char)-22445), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 100472217983921L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.s();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(47971620 + (char)-30451, 47971620 + (char)-4609, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(47971620 + (char)-30450, -47971620 + -((char)-29298), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(47971620 + (char)-30449, -47971620 + -((char)-27739), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "$:u\u0097\u00b1\u008b\u00aa4\u0010\u00c3*x4\u00aaD0\u0094zCx~9~\u0082\u00e5";
                    var4_3 = "$:u\u0097\u00b1\u008b\u00aa4\u0010\u00c3*x4\u00aaD0\u0094zCx~9~\u0082\u00e5".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 77;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0092\u0091\u00de\u009f\u00c95-L>H\u0007\u008f\u00e0;jp\u0095\u00a5\u000e\u0092\u001c\u008fg\u00f9\u008a.\u001dJs\u00c0\u00cb\u009bXq\u00ffb+\u00d1wum\u0092o\u0011V&Y\u008fk\u00c9\u00db}\tF\u00f8\u00b8\u00de\u009ex";
                        var4_3 = "\u0092\u0091\u00de\u009f\u00c95-L>H\u0007\u008f\u00e0;jp\u0095\u00a5\u000e\u0092\u001c\u008fg\u00f9\u008a.\u001dJs\u00c0\u00cb\u009bXq\u00ffb+\u00d1wum\u0092o\u0011V&Y\u008fk\u00c9\u00db}\tF\u00f8\u00b8\u00de\u009ex".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 119;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 99;
                                break;
                            }
                            case 1: {
                                v15 = 42;
                                break;
                            }
                            case 2: {
                                v15 = 119;
                                break;
                            }
                            case 3: {
                                v15 = 80;
                                break;
                            }
                            case 4: {
                                v15 = 59;
                                break;
                            }
                            case 5: {
                                v15 = 63;
                                break;
                            }
                            default: {
                                v15 = 49;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x5D81) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 40;
                    case 1 -> 193;
                    case 2 -> 3;
                    case 3 -> 13;
                    case 4 -> 76;
                    case 5 -> 80;
                    case 6 -> 182;
                    case 7 -> 6;
                    case 8 -> 135;
                    case 9 -> 110;
                    case 10 -> 11;
                    case 11 -> 113;
                    case 12 -> 198;
                    case 13 -> 216;
                    case 14 -> 15;
                    case 15 -> 160;
                    case 16 -> 253;
                    case 17 -> 70;
                    case 18 -> 231;
                    case 19 -> 225;
                    case 20 -> 39;
                    case 21 -> 141;
                    case 22 -> 177;
                    case 23 -> 187;
                    case 24 -> 71;
                    case 25 -> 139;
                    case 26 -> 111;
                    case 27 -> 185;
                    case 28 -> 180;
                    case 29 -> 29;
                    case 30 -> 84;
                    case 31 -> 239;
                    case 32 -> 120;
                    case 33 -> 241;
                    case 34 -> 93;
                    case 35 -> 118;
                    case 36 -> 37;
                    case 37 -> 210;
                    case 38 -> 249;
                    case 39 -> 130;
                    case 40 -> 50;
                    case 41 -> 85;
                    case 42 -> 172;
                    case 43 -> 226;
                    case 44 -> 166;
                    case 45 -> 56;
                    case 46 -> 145;
                    case 47 -> 221;
                    case 48 -> 248;
                    case 49 -> 49;
                    case 50 -> 72;
                    case 51 -> 86;
                    case 52 -> 27;
                    case 53 -> 95;
                    case 54 -> 236;
                    case 55 -> 189;
                    case 56 -> 18;
                    case 57 -> 131;
                    case 58 -> 163;
                    case 59 -> 191;
                    case 60 -> 205;
                    case 61 -> 173;
                    case 62 -> 92;
                    case 63 -> 228;
                    case 64 -> 115;
                    case 65 -> 119;
                    case 66 -> 255;
                    case 67 -> 123;
                    case 68 -> 100;
                    case 69 -> 144;
                    case 70 -> 168;
                    case 71 -> 209;
                    case 72 -> 121;
                    case 73 -> 211;
                    case 74 -> 83;
                    case 75 -> 112;
                    case 76 -> 146;
                    case 77 -> 196;
                    case 78 -> 197;
                    case 79 -> 64;
                    case 80 -> 206;
                    case 81 -> 124;
                    case 82 -> 194;
                    case 83 -> 45;
                    case 84 -> 244;
                    case 85 -> 89;
                    case 86 -> 235;
                    case 87 -> 81;
                    case 88 -> 106;
                    case 89 -> 233;
                    case 90 -> 203;
                    case 91 -> 20;
                    case 92 -> 245;
                    case 93 -> 101;
                    case 94 -> 138;
                    case 95 -> 133;
                    case 96 -> 200;
                    case 97 -> 30;
                    case 98 -> 73;
                    case 99 -> 220;
                    case 100 -> 164;
                    case 101 -> 218;
                    case 102 -> 98;
                    case 103 -> 67;
                    case 104 -> 134;
                    case 105 -> 246;
                    case 106 -> 41;
                    case 107 -> 126;
                    case 108 -> 181;
                    case 109 -> 1;
                    case 110 -> 174;
                    case 111 -> 176;
                    case 112 -> 195;
                    case 113 -> 143;
                    case 114 -> 58;
                    case 115 -> 242;
                    case 116 -> 184;
                    case 117 -> 127;
                    case 118 -> 79;
                    case 119 -> 153;
                    case 120 -> 252;
                    case 121 -> 12;
                    case 122 -> 208;
                    case 123 -> 140;
                    case 124 -> 156;
                    case 125 -> 254;
                    case 126 -> 75;
                    case 127 -> 59;
                    case 128 -> 179;
                    case 129 -> 107;
                    case 130 -> 165;
                    case 131 -> 154;
                    case 132 -> 99;
                    case 133 -> 223;
                    case 134 -> 9;
                    case 135 -> 169;
                    case 136 -> 102;
                    case 137 -> 61;
                    case 138 -> 32;
                    case 139 -> 227;
                    case 140 -> 116;
                    case 141 -> 21;
                    case 142 -> 108;
                    case 143 -> 43;
                    case 144 -> 109;
                    case 145 -> 96;
                    case 146 -> 150;
                    case 147 -> 137;
                    case 148 -> 222;
                    case 149 -> 51;
                    case 150 -> 33;
                    case 151 -> 157;
                    case 152 -> 22;
                    case 153 -> 4;
                    case 154 -> 229;
                    case 155 -> 23;
                    case 156 -> 87;
                    case 157 -> 97;
                    case 158 -> 104;
                    case 159 -> 170;
                    case 160 -> 31;
                    case 161 -> 60;
                    case 162 -> 68;
                    case 163 -> 74;
                    case 164 -> 103;
                    case 165 -> 82;
                    case 166 -> 183;
                    case 167 -> 186;
                    case 168 -> 247;
                    case 169 -> 38;
                    case 170 -> 142;
                    case 171 -> 88;
                    case 172 -> 152;
                    case 173 -> 42;
                    case 174 -> 35;
                    case 175 -> 132;
                    case 176 -> 78;
                    case 177 -> 16;
                    case 178 -> 28;
                    case 179 -> 0;
                    case 180 -> 232;
                    case 181 -> 136;
                    case 182 -> 167;
                    case 183 -> 117;
                    case 184 -> 155;
                    case 185 -> 243;
                    case 186 -> 105;
                    case 187 -> 114;
                    case 188 -> 47;
                    case 189 -> 36;
                    case 190 -> 190;
                    case 191 -> 24;
                    case 192 -> 238;
                    case 193 -> 52;
                    case 194 -> 63;
                    case 195 -> 66;
                    case 196 -> 213;
                    case 197 -> 207;
                    case 198 -> 26;
                    case 199 -> 159;
                    case 200 -> 46;
                    case 201 -> 161;
                    case 202 -> 14;
                    case 203 -> 204;
                    case 204 -> 122;
                    case 205 -> 34;
                    case 206 -> 188;
                    case 207 -> 148;
                    case 208 -> 237;
                    case 209 -> 69;
                    case 210 -> 162;
                    case 211 -> 151;
                    case 212 -> 214;
                    case 213 -> 55;
                    case 214 -> 192;
                    case 215 -> 202;
                    case 216 -> 17;
                    case 217 -> 10;
                    case 218 -> 219;
                    case 219 -> 57;
                    case 220 -> 129;
                    case 221 -> 65;
                    case 222 -> 62;
                    case 223 -> 250;
                    case 224 -> 44;
                    case 225 -> 178;
                    case 226 -> 91;
                    case 227 -> 240;
                    case 228 -> 54;
                    case 229 -> 5;
                    case 230 -> 171;
                    case 231 -> 199;
                    case 232 -> 175;
                    case 233 -> 25;
                    case 234 -> 90;
                    case 235 -> 48;
                    case 236 -> 147;
                    case 237 -> 8;
                    case 238 -> 149;
                    case 239 -> 251;
                    case 240 -> 53;
                    case 241 -> 201;
                    case 242 -> 2;
                    case 243 -> 224;
                    case 244 -> 77;
                    case 245 -> 217;
                    case 246 -> 19;
                    case 247 -> 158;
                    case 248 -> 234;
                    case 249 -> 212;
                    case 250 -> 128;
                    case 251 -> 7;
                    case 252 -> 230;
                    case 253 -> 215;
                    case 254 -> 125;
                    default -> 94;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 61477584467026L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "9\u0019\u0001|8\u0010N`\t>\u0013\u0012vuRS|U";
                    var5_4 = "9\u0019\u0001|8\u0010N`\t>\u0013\u0012vuRS|U".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 15;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 93;
                                    break;
                                }
                                case 1: {
                                    v11 = 115;
                                    break;
                                }
                                case 2: {
                                    v11 = 124;
                                    break;
                                }
                                case 3: {
                                    v11 = 29;
                                    break;
                                }
                                case 4: {
                                    v11 = 82;
                                    break;
                                }
                                case 5: {
                                    v11 = 115;
                                    break;
                                }
                                default: {
                                    v11 = 114;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 11469881652430L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "B&\u0004!\u0002)\f\u0004D8\b;\nH'\u0003;\u000e+\u0014b&\n\tH'\u0003;\u000e+\u0014n,\rO!\u001e6\u0004&\u000en+\u0019<\u0005/";
                    var5_4 = "B&\u0004!\u0002)\f\u0004D8\b;\nH'\u0003;\u000e+\u0014b&\n\tH'\u0003;\u000e+\u0014n,\rO!\u001e6\u0004&\u000en+\u0019<\u0005/".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 102;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "J&\u0000$\u0000$\u0005\u0006J&\u0000$\f.";
                        var5_4 = "J&\u0000$\u0000$\u0005\u0006J&\u0000$\f.".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 100;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 109;
                                break;
                            }
                            case 1: {
                                v15 = 46;
                                break;
                            }
                            case 2: {
                                v15 = 11;
                                break;
                            }
                            case 3: {
                                v15 = 51;
                                break;
                            }
                            case 4: {
                                v15 = 13;
                                break;
                            }
                            case 5: {
                                v15 = 46;
                                break;
                            }
                            default: {
                                v15 = 6;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 133623356036270L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1666423980 + 31926, -1666423980 + -((char)-10088), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 24424467294765L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00110\u0000\u0084e\u0003\u00d5D,\u00052\u00ffB\u00b9\u00ce\rIk\u001ba\u00108h\u00d5\u00a9\u001aw\u00f1}\u0010:\u0005\u00b2G\u001ai\u0002\u00c2-|\u0004p\u00f5\u009b\u00e8H\u0005<\u00f1\u0083x\u00f63\u00e6/\u00c9\u00d4\u00a0_e\u0010\u00bc\u00db\u00bd\u00ad\u0004q\u00fa\n\u0003\u00b9\u00e5\u0018\u000e\u0004\u001b\t\u00e6\u00a9*8\u0081\u0093SY-\u00fc\u009fF\u00a7A\u0014\u00b2\u00b2\u001e\u0089\u00a5~iG\u00d0\u00e1\u00d4a";
                    var4_3 = "\u00110\u0000\u0084e\u0003\u00d5D,\u00052\u00ffB\u00b9\u00ce\rIk\u001ba\u00108h\u00d5\u00a9\u001aw\u00f1}\u0010:\u0005\u00b2G\u001ai\u0002\u00c2-|\u0004p\u00f5\u009b\u00e8H\u0005<\u00f1\u0083x\u00f63\u00e6/\u00c9\u00d4\u00a0_e\u0010\u00bc\u00db\u00bd\u00ad\u0004q\u00fa\n\u0003\u00b9\u00e5\u0018\u000e\u0004\u001b\t\u00e6\u00a9*8\u0081\u0093SY-\u00fc\u009fF\u00a7A\u0014\u00b2\u00b2\u001e\u0089\u00a5~iG\u00d0\u00e1\u00d4a".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 31;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00e2\u00a7\u008287\u00ad\u008cq\u00d7!p\u00f0P\u00a0w\u0004L\u008bgX\u00eaF?\u00ccMV5\u00ec\u00cb\u00cdIW@\u0098\nB\u00b3\u00b9>\u00ec\u00c7\u0010\u00b0\u00fa\u00f6J(\u00eej\u00a1_T\u0005\u00c7\u00dc\tL\f\u0017\u00ba\u00d2&r\u00ac\u00a0E\u00c56\u0006\u00cf\u0095\u0002\u00ad&+zl\u0006d\u0012\u00ab\u00cd\u00f0\u0096\r\u00e8j\u00a5\u00f4)\u00a3y\u0011";
                        var4_3 = "\u00e2\u00a7\u008287\u00ad\u008cq\u00d7!p\u00f0P\u00a0w\u0004L\u008bgX\u00eaF?\u00ccMV5\u00ec\u00cb\u00cdIW@\u0098\nB\u00b3\u00b9>\u00ec\u00c7\u0010\u00b0\u00fa\u00f6J(\u00eej\u00a1_T\u0005\u00c7\u00dc\tL\f\u0017\u00ba\u00d2&r\u00ac\u00a0E\u00c56\u0006\u00cf\u0095\u0002\u00ad&+zl\u0006d\u0012\u00ab\u00cd\u00f0\u0096\r\u00e8j\u00a5\u00f4)\u00a3y\u0011".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 92;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 110;
                                break;
                            }
                            case 1: {
                                v15 = 69;
                                break;
                            }
                            case 2: {
                                v15 = 59;
                                break;
                            }
                            case 3: {
                                v15 = 51;
                                break;
                            }
                            case 4: {
                                v15 = 67;
                                break;
                            }
                            case 5: {
                                v15 = 8;
                                break;
                            }
                            default: {
                                v15 = 2;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8DCC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 50;
                    case 1 -> 2;
                    case 2 -> 53;
                    case 3 -> 133;
                    case 4 -> 38;
                    case 5 -> 148;
                    case 6 -> 98;
                    case 7 -> 4;
                    case 8 -> 194;
                    case 9 -> 211;
                    case 10 -> 36;
                    case 11 -> 22;
                    case 12 -> 134;
                    case 13 -> 93;
                    case 14 -> 239;
                    case 15 -> 75;
                    case 16 -> 47;
                    case 17 -> 150;
                    case 18 -> 185;
                    case 19 -> 141;
                    case 20 -> 92;
                    case 21 -> 26;
                    case 22 -> 165;
                    case 23 -> 0;
                    case 24 -> 166;
                    case 25 -> 34;
                    case 26 -> 19;
                    case 27 -> 24;
                    case 28 -> 146;
                    case 29 -> 103;
                    case 30 -> 113;
                    case 31 -> 247;
                    case 32 -> 91;
                    case 33 -> 244;
                    case 34 -> 59;
                    case 35 -> 200;
                    case 36 -> 184;
                    case 37 -> 169;
                    case 38 -> 236;
                    case 39 -> 37;
                    case 40 -> 220;
                    case 41 -> 172;
                    case 42 -> 181;
                    case 43 -> 72;
                    case 44 -> 83;
                    case 45 -> 33;
                    case 46 -> 229;
                    case 47 -> 117;
                    case 48 -> 100;
                    case 49 -> 137;
                    case 50 -> 183;
                    case 51 -> 140;
                    case 52 -> 111;
                    case 53 -> 44;
                    case 54 -> 127;
                    case 55 -> 159;
                    case 56 -> 222;
                    case 57 -> 177;
                    case 58 -> 238;
                    case 59 -> 41;
                    case 60 -> 118;
                    case 61 -> 151;
                    case 62 -> 87;
                    case 63 -> 48;
                    case 64 -> 209;
                    case 65 -> 217;
                    case 66 -> 69;
                    case 67 -> 128;
                    case 68 -> 77;
                    case 69 -> 64;
                    case 70 -> 232;
                    case 71 -> 196;
                    case 72 -> 39;
                    case 73 -> 62;
                    case 74 -> 218;
                    case 75 -> 78;
                    case 76 -> 12;
                    case 77 -> 175;
                    case 78 -> 191;
                    case 79 -> 122;
                    case 80 -> 88;
                    case 81 -> 178;
                    case 82 -> 189;
                    case 83 -> 21;
                    case 84 -> 138;
                    case 85 -> 147;
                    case 86 -> 68;
                    case 87 -> 55;
                    case 88 -> 171;
                    case 89 -> 235;
                    case 90 -> 162;
                    case 91 -> 73;
                    case 92 -> 154;
                    case 93 -> 254;
                    case 94 -> 227;
                    case 95 -> 101;
                    case 96 -> 17;
                    case 97 -> 43;
                    case 98 -> 58;
                    case 99 -> 70;
                    case 100 -> 74;
                    case 101 -> 153;
                    case 102 -> 164;
                    case 103 -> 104;
                    case 104 -> 81;
                    case 105 -> 142;
                    case 106 -> 205;
                    case 107 -> 241;
                    case 108 -> 86;
                    case 109 -> 242;
                    case 110 -> 31;
                    case 111 -> 85;
                    case 112 -> 109;
                    case 113 -> 94;
                    case 114 -> 207;
                    case 115 -> 54;
                    case 116 -> 223;
                    case 117 -> 215;
                    case 118 -> 6;
                    case 119 -> 143;
                    case 120 -> 80;
                    case 121 -> 123;
                    case 122 -> 206;
                    case 123 -> 108;
                    case 124 -> 221;
                    case 125 -> 35;
                    case 126 -> 60;
                    case 127 -> 250;
                    case 128 -> 114;
                    case 129 -> 116;
                    case 130 -> 61;
                    case 131 -> 130;
                    case 132 -> 234;
                    case 133 -> 135;
                    case 134 -> 243;
                    case 135 -> 190;
                    case 136 -> 89;
                    case 137 -> 105;
                    case 138 -> 157;
                    case 139 -> 204;
                    case 140 -> 212;
                    case 141 -> 124;
                    case 142 -> 170;
                    case 143 -> 131;
                    case 144 -> 139;
                    case 145 -> 214;
                    case 146 -> 76;
                    case 147 -> 99;
                    case 148 -> 202;
                    case 149 -> 231;
                    case 150 -> 102;
                    case 151 -> 52;
                    case 152 -> 216;
                    case 153 -> 79;
                    case 154 -> 107;
                    case 155 -> 30;
                    case 156 -> 208;
                    case 157 -> 14;
                    case 158 -> 176;
                    case 159 -> 23;
                    case 160 -> 115;
                    case 161 -> 161;
                    case 162 -> 158;
                    case 163 -> 7;
                    case 164 -> 32;
                    case 165 -> 3;
                    case 166 -> 10;
                    case 167 -> 228;
                    case 168 -> 224;
                    case 169 -> 16;
                    case 170 -> 253;
                    case 171 -> 25;
                    case 172 -> 203;
                    case 173 -> 249;
                    case 174 -> 65;
                    case 175 -> 132;
                    case 176 -> 67;
                    case 177 -> 156;
                    case 178 -> 144;
                    case 179 -> 112;
                    case 180 -> 152;
                    case 181 -> 230;
                    case 182 -> 193;
                    case 183 -> 160;
                    case 184 -> 213;
                    case 185 -> 149;
                    case 186 -> 63;
                    case 187 -> 226;
                    case 188 -> 95;
                    case 189 -> 225;
                    case 190 -> 106;
                    case 191 -> 82;
                    case 192 -> 192;
                    case 193 -> 13;
                    case 194 -> 11;
                    case 195 -> 186;
                    case 196 -> 97;
                    case 197 -> 237;
                    case 198 -> 119;
                    case 199 -> 182;
                    case 200 -> 245;
                    case 201 -> 1;
                    case 202 -> 248;
                    case 203 -> 201;
                    case 204 -> 210;
                    case 205 -> 173;
                    case 206 -> 255;
                    case 207 -> 180;
                    case 208 -> 136;
                    case 209 -> 42;
                    case 210 -> 49;
                    case 211 -> 145;
                    case 212 -> 27;
                    case 213 -> 71;
                    case 214 -> 84;
                    case 215 -> 110;
                    case 216 -> 28;
                    case 217 -> 195;
                    case 218 -> 252;
                    case 219 -> 90;
                    case 220 -> 57;
                    case 221 -> 240;
                    case 222 -> 29;
                    case 223 -> 251;
                    case 224 -> 167;
                    case 225 -> 40;
                    case 226 -> 188;
                    case 227 -> 233;
                    case 228 -> 219;
                    case 229 -> 51;
                    case 230 -> 125;
                    case 231 -> 121;
                    case 232 -> 15;
                    case 233 -> 168;
                    case 234 -> 20;
                    case 235 -> 179;
                    case 236 -> 9;
                    case 237 -> 187;
                    case 238 -> 8;
                    case 239 -> 126;
                    case 240 -> 46;
                    case 241 -> 66;
                    case 242 -> 199;
                    case 243 -> 197;
                    case 244 -> 5;
                    case 245 -> 120;
                    case 246 -> 56;
                    case 247 -> 18;
                    case 248 -> 246;
                    case 249 -> 163;
                    case 250 -> 198;
                    case 251 -> 129;
                    case 252 -> 174;
                    case 253 -> 96;
                    case 254 -> 155;
                    default -> 45;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 106382132583278L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(87685830 - (char)-26238, -87685830 - -((char)-28521), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 136979340703788L;
                    String[] stringArray = SshAgentIpcService.s();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-51248370 + -16647, -51248370 + -31490, (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 131449844174418L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "M+\"2\u00bf\u0003X\u00fa\u00d6";
                var4_3 = "M+\"2\u00bf\u0003X\u00fa\u00d6".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 64;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 30;
                                break;
                            }
                            case 1: {
                                v11 = 77;
                                break;
                            }
                            case 2: {
                                v11 = 40;
                                break;
                            }
                            case 3: {
                                v11 = 83;
                                break;
                            }
                            case 4: {
                                v11 = 11;
                                break;
                            }
                            case 5: {
                                v11 = 23;
                                break;
                            }
                            default: {
                                v11 = 46;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7A2A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 173;
                    case 1 -> 163;
                    case 2 -> 26;
                    case 3 -> 62;
                    case 4 -> 14;
                    case 5 -> 83;
                    case 6 -> 171;
                    case 7 -> 137;
                    case 8 -> 91;
                    case 9 -> 197;
                    case 10 -> 111;
                    case 11 -> 46;
                    case 12 -> 103;
                    case 13 -> 221;
                    case 14 -> 253;
                    case 15 -> 132;
                    case 16 -> 41;
                    case 17 -> 9;
                    case 18 -> 191;
                    case 19 -> 77;
                    case 20 -> 52;
                    case 21 -> 31;
                    case 22 -> 135;
                    case 23 -> 16;
                    case 24 -> 86;
                    case 25 -> 240;
                    case 26 -> 238;
                    case 27 -> 174;
                    case 28 -> 74;
                    case 29 -> 57;
                    case 30 -> 28;
                    case 31 -> 159;
                    case 32 -> 217;
                    case 33 -> 73;
                    case 34 -> 18;
                    case 35 -> 69;
                    case 36 -> 233;
                    case 37 -> 203;
                    case 38 -> 144;
                    case 39 -> 38;
                    case 40 -> 107;
                    case 41 -> 109;
                    case 42 -> 23;
                    case 43 -> 242;
                    case 44 -> 84;
                    case 45 -> 160;
                    case 46 -> 25;
                    case 47 -> 124;
                    case 48 -> 64;
                    case 49 -> 113;
                    case 50 -> 126;
                    case 51 -> 178;
                    case 52 -> 162;
                    case 53 -> 96;
                    case 54 -> 158;
                    case 55 -> 43;
                    case 56 -> 224;
                    case 57 -> 249;
                    case 58 -> 53;
                    case 59 -> 255;
                    case 60 -> 89;
                    case 61 -> 121;
                    case 62 -> 70;
                    case 63 -> 63;
                    case 64 -> 118;
                    case 65 -> 150;
                    case 66 -> 157;
                    case 67 -> 105;
                    case 68 -> 54;
                    case 69 -> 161;
                    case 70 -> 250;
                    case 71 -> 39;
                    case 72 -> 230;
                    case 73 -> 104;
                    case 74 -> 50;
                    case 75 -> 75;
                    case 76 -> 123;
                    case 77 -> 13;
                    case 78 -> 72;
                    case 79 -> 246;
                    case 80 -> 169;
                    case 81 -> 204;
                    case 82 -> 147;
                    case 83 -> 142;
                    case 84 -> 181;
                    case 85 -> 5;
                    case 86 -> 130;
                    case 87 -> 177;
                    case 88 -> 2;
                    case 89 -> 87;
                    case 90 -> 200;
                    case 91 -> 213;
                    case 92 -> 59;
                    case 93 -> 254;
                    case 94 -> 225;
                    case 95 -> 212;
                    case 96 -> 243;
                    case 97 -> 88;
                    case 98 -> 149;
                    case 99 -> 58;
                    case 100 -> 102;
                    case 101 -> 207;
                    case 102 -> 30;
                    case 103 -> 115;
                    case 104 -> 108;
                    case 105 -> 136;
                    case 106 -> 216;
                    case 107 -> 148;
                    case 108 -> 208;
                    case 109 -> 45;
                    case 110 -> 182;
                    case 111 -> 32;
                    case 112 -> 37;
                    case 113 -> 33;
                    case 114 -> 211;
                    case 115 -> 232;
                    case 116 -> 184;
                    case 117 -> 55;
                    case 118 -> 196;
                    case 119 -> 140;
                    case 120 -> 244;
                    case 121 -> 110;
                    case 122 -> 134;
                    case 123 -> 165;
                    case 124 -> 116;
                    case 125 -> 42;
                    case 126 -> 36;
                    case 127 -> 1;
                    case 128 -> 231;
                    case 129 -> 10;
                    case 130 -> 60;
                    case 131 -> 92;
                    case 132 -> 127;
                    case 133 -> 215;
                    case 134 -> 190;
                    case 135 -> 199;
                    case 136 -> 90;
                    case 137 -> 247;
                    case 138 -> 65;
                    case 139 -> 6;
                    case 140 -> 141;
                    case 141 -> 66;
                    case 142 -> 3;
                    case 143 -> 194;
                    case 144 -> 209;
                    case 145 -> 155;
                    case 146 -> 164;
                    case 147 -> 11;
                    case 148 -> 228;
                    case 149 -> 51;
                    case 150 -> 21;
                    case 151 -> 78;
                    case 152 -> 189;
                    case 153 -> 241;
                    case 154 -> 80;
                    case 155 -> 168;
                    case 156 -> 27;
                    case 157 -> 202;
                    case 158 -> 188;
                    case 159 -> 94;
                    case 160 -> 131;
                    case 161 -> 24;
                    case 162 -> 101;
                    case 163 -> 154;
                    case 164 -> 122;
                    case 165 -> 151;
                    case 166 -> 234;
                    case 167 -> 95;
                    case 168 -> 133;
                    case 169 -> 185;
                    case 170 -> 71;
                    case 171 -> 34;
                    case 172 -> 205;
                    case 173 -> 120;
                    case 174 -> 237;
                    case 175 -> 20;
                    case 176 -> 186;
                    case 177 -> 214;
                    case 178 -> 8;
                    case 179 -> 143;
                    case 180 -> 176;
                    case 181 -> 145;
                    case 182 -> 85;
                    case 183 -> 172;
                    case 184 -> 44;
                    case 185 -> 226;
                    case 186 -> 4;
                    case 187 -> 152;
                    case 188 -> 220;
                    case 189 -> 68;
                    case 190 -> 22;
                    case 191 -> 81;
                    case 192 -> 222;
                    case 193 -> 114;
                    case 194 -> 193;
                    case 195 -> 79;
                    case 196 -> 156;
                    case 197 -> 106;
                    case 198 -> 192;
                    case 199 -> 35;
                    case 200 -> 170;
                    case 201 -> 47;
                    case 202 -> 235;
                    case 203 -> 252;
                    case 204 -> 201;
                    case 205 -> 61;
                    case 206 -> 166;
                    case 207 -> 82;
                    case 208 -> 40;
                    case 209 -> 175;
                    case 210 -> 15;
                    case 211 -> 218;
                    case 212 -> 0;
                    case 213 -> 97;
                    case 214 -> 227;
                    case 215 -> 138;
                    case 216 -> 198;
                    case 217 -> 153;
                    case 218 -> 112;
                    case 219 -> 183;
                    case 220 -> 210;
                    case 221 -> 195;
                    case 222 -> 98;
                    case 223 -> 245;
                    case 224 -> 167;
                    case 225 -> 19;
                    case 226 -> 179;
                    case 227 -> 219;
                    case 228 -> 49;
                    case 229 -> 48;
                    case 230 -> 248;
                    case 231 -> 29;
                    case 232 -> 100;
                    case 233 -> 125;
                    case 234 -> 236;
                    case 235 -> 76;
                    case 236 -> 99;
                    case 237 -> 56;
                    case 238 -> 129;
                    case 239 -> 119;
                    case 240 -> 12;
                    case 241 -> 139;
                    case 242 -> 67;
                    case 243 -> 206;
                    case 244 -> 128;
                    case 245 -> 117;
                    case 246 -> 251;
                    case 247 -> 146;
                    case 248 -> 93;
                    case 249 -> 7;
                    case 250 -> 223;
                    case 251 -> 239;
                    case 252 -> 180;
                    case 253 -> 229;
                    case 254 -> 17;
                    default -> 187;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

