/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.state.DiagramEdgeIdentity;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramEdgeBase<T>
extends UserDataHolderBase
implements DiagramEdge<T> {
    @NotNull
    protected final DiagramNode<T> mySource;
    @NotNull
    protected final DiagramNode<T> myTarget;
    @NotNull
    protected final DiagramRelationshipInfo myRelationship;
    @Nullable
    private Object mySourceAnchor;
    @Nullable
    private Object myTargetAnchor;
    @Nullable
    private Color myAnchorColor;
    @NotNull
    private final NotNullLazyValue<String> myDebugInfo;

    public DiagramEdgeBase(@NotNull DiagramNode<T> source, @NotNull DiagramNode<T> target, @NotNull DiagramRelationshipInfo relationship) {
        if (source == null) {
            DiagramEdgeBase.$$$reportNull$$$0(0);
        }
        if (target == null) {
            DiagramEdgeBase.$$$reportNull$$$0(1);
        }
        if (relationship == null) {
            DiagramEdgeBase.$$$reportNull$$$0(2);
        }
        this.mySourceAnchor = null;
        this.myTargetAnchor = null;
        this.myAnchorColor = null;
        this.myDebugInfo = NotNullLazyValue.lazy(this::computeDebugInfo);
        this.mySource = source;
        this.myTarget = target;
        this.myRelationship = relationship;
    }

    @NotNull
    @NonNls
    private String computeDebugInfo() {
        if (this.mySource instanceof DiagramNodeBase && this.myTarget instanceof DiagramNodeBase) {
            String fqn1 = this.mySource instanceof DiagramNoteNode ? "Note" : ((DiagramNodeBase)this.mySource).getFQN();
            String fqn2 = this.myTarget instanceof DiagramNoteNode ? "Note" : ((DiagramNodeBase)this.myTarget).getFQN();
            String string = fqn1 + " -> " + fqn2 + " (" + String.valueOf(this.myRelationship) + ")";
            if (string == null) {
                DiagramEdgeBase.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.toString();
        if (string == null) {
            DiagramEdgeBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public DiagramNode<T> getSource() {
        DiagramNode<T> diagramNode = this.mySource;
        if (diagramNode == null) {
            DiagramEdgeBase.$$$reportNull$$$0(5);
        }
        return diagramNode;
    }

    @Override
    @NotNull
    public DiagramNode<T> getTarget() {
        DiagramNode<T> diagramNode = this.myTarget;
        if (diagramNode == null) {
            DiagramEdgeBase.$$$reportNull$$$0(6);
        }
        return diagramNode;
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    @NotNull
    public T getIdentifyingElement() {
        T t = this.getSource().getIdentifyingElement();
        if (t == null) {
            DiagramEdgeBase.$$$reportNull$$$0(7);
        }
        return t;
    }

    @Override
    @NotNull
    public DiagramRelationshipInfo getRelationship() {
        DiagramRelationshipInfo diagramRelationshipInfo = this.myRelationship;
        if (diagramRelationshipInfo == null) {
            DiagramEdgeBase.$$$reportNull$$$0(8);
        }
        return diagramRelationshipInfo;
    }

    @Override
    @Nullable
    public Object getSourceAnchor() {
        return this.mySourceAnchor;
    }

    public void setSourceAnchor(@Nullable Object sourceAnchor) {
        this.mySourceAnchor = sourceAnchor;
    }

    @Override
    @Nullable
    public Object getTargetAnchor() {
        return this.myTargetAnchor;
    }

    public void setTargetAnchor(@Nullable Object targetAnchor) {
        this.myTargetAnchor = targetAnchor;
    }

    @Override
    @Nullable
    public Color getAnchorColor() {
        return this.myAnchorColor;
    }

    public void setAnchorColor(@Nullable Color anchorColor) {
        this.myAnchorColor = anchorColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramEdgeBase base = (DiagramEdgeBase)o;
        return DiagramEdgeIdentity.of(this).equals(DiagramEdgeIdentity.of(base));
    }

    public int hashCode() {
        return DiagramEdgeIdentity.of(this).hashCode();
    }

    @NotNull
    public String toString() {
        String string = (String)this.myDebugInfo.getValue();
        if (string == null) {
            DiagramEdgeBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationship";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramEdgeBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramEdgeBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDebugInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifyingElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationship";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

