/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.markdown.latex;

import com.intellij.jupyter.core.jupyter.editor.markdown.latex.TeXIconWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.scilab.forge.jlatexmath.TeXIcon;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J3\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/LatexView;", "Ljavax/swing/text/View;", "element", "Ljavax/swing/text/Element;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Ljavax/swing/text/Element;Lcom/intellij/openapi/editor/Editor;)V", "teXIconWrapper", "Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/TeXIconWrapper;", "getAlignment", "", "axis", "", "getPreferredSpan", "paint", "", "g", "Ljava/awt/Graphics;", "allocation", "Ljava/awt/Shape;", "modelToView", "pos", "a", "b", "Ljavax/swing/text/Position$Bias;", "viewToModel", "x", "y", "biasReturn", "", "(FFLjava/awt/Shape;[Ljavax/swing/text/Position$Bias;)I", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nLatexView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatexView.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/latex/LatexView\n+ 2 NotebookVisualizationUiUtil.kt\ncom/intellij/notebooks/visualization/NotebookVisualizationUiUtilKt\n*L\n1#1,51:1\n24#2,8:52\n*S KotlinDebug\n*F\n+ 1 LatexView.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/latex/LatexView\n*L\n22#1:52,8\n*E\n"})
public final class LatexView
extends View {
    @NotNull
    private final TeXIconWrapper teXIconWrapper;

    public LatexView(@NotNull Element element, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(element);
        this.teXIconWrapper = TeXIconWrapper.Companion.getFromUserDataHolder((UserDataHolder)editor, element);
    }

    @Override
    public float getAlignment(int axis) {
        return axis == 1 ? this.teXIconWrapper.getIcon().getBaseLine() : super.getAlignment(axis);
    }

    @Override
    public float getPreferredSpan(int axis) {
        TeXIcon icon = this.teXIconWrapper.getIcon();
        return axis == 0 ? icon.getIconWidth() : icon.getIconHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics g, @NotNull Shape allocation) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
        Graphics $this$useG2D$iv = g;
        boolean $i$f$useG2D = false;
        Graphics graphics = $this$useG2D$iv.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d$iv = (Graphics2D)graphics;
        try {
            Graphics2D g2d = g2d$iv;
            boolean bl = false;
            TeXIcon icon = this.teXIconWrapper.getIcon();
            icon.paintIcon(this.getContainer(), g2d, allocation.getBounds().x, allocation.getBounds().y);
        }
        finally {
            g2d$iv.dispose();
        }
    }

    @Override
    @Nullable
    public Shape modelToView(int pos, @NotNull Shape a, @NotNull Position.Bias b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        boolean bl = p0 <= pos ? pos <= p1 : false;
        if (bl) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        return null;
    }

    @Override
    public int viewToModel(float x, float y, @NotNull Shape a, @NotNull Position.Bias[] biasReturn) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)biasReturn, (String)"biasReturn");
        Rectangle alloc = (Rectangle)a;
        if (x < (float)(alloc.x + alloc.width)) {
            Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Forward, (String)"Forward");
            return this.getStartOffset();
        }
        Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Backward, (String)"Backward");
        return this.getEndOffset();
    }
}

