/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.CreateElementQuickFixProvider;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GenericSpringBeanResolveQuickFixProvider
implements SpringBeanResolveQuickFixProvider {
    GenericSpringBeanResolveQuickFixProvider() {
    }

    @Override
    @NotNull
    public List<LocalQuickFix> getQuickFixes(ConvertContext context, @NotNull Beans beans, @Nullable String beanId, List<PsiClassType> requiredClasses) {
        if (beans == null) {
            GenericSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(0);
        }
        LocalQuickFix[] fixes = new CreateGenericBeanQuickFix(beans, beanId).getQuickFixes((GenericDomValue)context.getInvocationElement());
        List<LocalQuickFix> list = Arrays.asList(fixes);
        if (list == null) {
            GenericSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class CreateGenericBeanQuickFix
    extends CreateElementQuickFixProvider<SpringBeanPointer<?>> {
        private final Beans beans;
        @Nullable
        private final String beanId;

        private CreateGenericBeanQuickFix(Beans beans, @Nullable String beanId) {
            this.beans = beans;
            this.beanId = beanId;
        }

        @Override
        @Nullable
        protected String getElementName(@NotNull GenericDomValue<SpringBeanPointer<?>> value) {
            if (value == null) {
                CreateGenericBeanQuickFix.$$$reportNull$$$0(0);
            }
            return this.beanId != null ? this.beanId : super.getElementName(value);
        }

        @Override
        @Nullable
        public LocalQuickFix getQuickFix(GenericDomValue<SpringBeanPointer<?>> value) {
            PsiClassType classType;
            final String beanName = this.getElementName(value);
            if (!this.isAvailable(beanName, value)) {
                return null;
            }
            final Ref beanClass = new Ref(null);
            DomElement parent = value.getParent();
            if (parent instanceof SpringInjection && (classType = TypeHolderUtil.getRequiredClassType((TypeHolder)((SpringInjection)parent))) != null) {
                beanClass.set((Object)classType.getCanonicalText());
            }
            final GenericDomValue copy = (GenericDomValue)value.createStableCopy();
            return new LocalQuickFix(){

                @NotNull
                public String getName() {
                    String string = this.getFixName(beanName);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = SpringBundle.message("model.bean.quickfix.message.family.name", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.apply(beanName, (GenericDomValue<SpringBeanPointer<?>>)copy);
                }

                @NotNull
                public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
                    if (project == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (previewDescriptor == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    String className = beanClass.isNull() ? "java.lang.String" : (String)beanClass.get();
                    return new IntentionPreviewInfo.CustomDiff((FileType)XmlFileType.INSTANCE, "", "<bean id=\"" + beanName + "\" class=\"" + className + "\"/>");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 2, 3, 4, 5 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider$CreateGenericBeanQuickFix$1";
                            break;
                        }
                        case 2: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "previewDescriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider$CreateGenericBeanQuickFix$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray;
                            objectArray[2] = "generatePreview";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 2, 3, 4, 5 -> new IllegalArgumentException(string);
                    };
                }
            };
        }

        @Override
        protected void apply(String elementName, GenericDomValue<SpringBeanPointer<?>> value) {
            PsiClass psiClass;
            PsiClassType classType;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.beans.getXmlElement())) {
                return;
            }
            SpringBean springBean = this.beans.addBean();
            springBean.setName(elementName);
            DomElement parent = value.getParent();
            if (parent instanceof SpringInjection && (classType = TypeHolderUtil.getRequiredClassType((TypeHolder)((SpringInjection)parent))) != null && (psiClass = classType.resolve()) != null) {
                GenericAttributeValue clazzAttribute = springBean.getClazz();
                if (psiClass.isInterface()) {
                    clazzAttribute.setStringValue("");
                    PsiNavigateUtil.navigate((PsiElement)clazzAttribute.getXmlAttributeValue());
                    return;
                }
                clazzAttribute.setStringValue(psiClass.getQualifiedName());
            }
        }

        @Override
        @NotNull
        protected String getFixName(String elementName) {
            String string = SpringBundle.message("model.bean.quickfix.message", elementName);
            if (string == null) {
                CreateGenericBeanQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider$CreateGenericBeanQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider$CreateGenericBeanQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

