/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation;

import com.intellij.jpa.jpb.model.model.SourceLanguage;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationInfo {
    private String annotationFqn;
    private AnnotationAttribute[] attributes;

    public AnnotationInfo(String annotationFqn, AnnotationAttribute ... attributes) {
        this.annotationFqn = annotationFqn;
        this.attributes = attributes;
    }

    public String getAnnotationFqn() {
        return this.annotationFqn;
    }

    public AnnotationAttribute[] getAttributes() {
        return this.attributes;
    }

    public String getText(SourceLanguage sourceLanguage) {
        return this.attributes.length == 0 ? "@" + this.annotationFqn : StreamEx.of((Object[])this.attributes).map(it -> it.getText(sourceLanguage, false)).joining((CharSequence)",\n", (CharSequence)("@" + this.annotationFqn + "("), (CharSequence)")");
    }

    public String toString() {
        return this.getText(SourceLanguage.JAVA);
    }

    public static abstract class AnnotationAttribute {
        public final String name;

        public AnnotationAttribute(@Nullable String name) {
            this.name = name;
        }

        public abstract String getValueText(SourceLanguage var1);

        public String getText(SourceLanguage sourceLanguage, boolean singleDefaultAttribute) {
            return this.name == null || singleDefaultAttribute ? this.getValueText(sourceLanguage) : this.name + " = " + this.getValueText(sourceLanguage);
        }

        public String toString() {
            return this.getText(SourceLanguage.JAVA, false);
        }
    }

    public static class ArrayValueAttribute
    extends AnnotationAttribute {
        private Object[] value;

        public ArrayValueAttribute(@NotNull Object[] value) {
            if (value == null) {
                ArrayValueAttribute.$$$reportNull$$$0(0);
            }
            super(null);
            this.value = value;
        }

        public ArrayValueAttribute(@Nullable String name, @NotNull Object[] value) {
            if (value == null) {
                ArrayValueAttribute.$$$reportNull$$$0(1);
            }
            super(name);
            this.value = value;
        }

        @Override
        public String getText(SourceLanguage sourceLanguage, boolean singleDefaultAttribute) {
            if (sourceLanguage == SourceLanguage.KOTLIN && singleDefaultAttribute) {
                return StreamEx.of((Object[])this.value).map(it -> {
                    String string;
                    if (it instanceof AnnotationAttribute) {
                        AnnotationAttribute a = (AnnotationAttribute)it;
                        string = a.getValueText(sourceLanguage);
                    } else {
                        string = it.toString();
                    }
                    return string;
                }).joining((CharSequence)",\n");
            }
            return super.getText(sourceLanguage, singleDefaultAttribute);
        }

        @Override
        public String getValueText(SourceLanguage sourceLanguage) {
            String suffix;
            Object prefix = sourceLanguage == SourceLanguage.KOTLIN ? "[" : "{";
            String string = suffix = sourceLanguage == SourceLanguage.KOTLIN ? "]" : "}";
            if (this.value.length > 1) {
                prefix = (String)prefix + "\n";
            }
            return StreamEx.of((Object[])this.value).map(it -> {
                String string;
                if (it instanceof AnnotationAttribute) {
                    AnnotationAttribute innerAnnotation = (AnnotationAttribute)it;
                    string = innerAnnotation.getValueText(sourceLanguage);
                } else {
                    string = it.toString();
                }
                return string;
            }).joining((CharSequence)",\n", (CharSequence)prefix, (CharSequence)suffix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationInfo$ArrayValueAttribute", "<init>"));
        }
    }

    public static class AnnotationValueAttribute
    extends AnnotationAttribute {
        private AnnotationInfo value;

        public AnnotationValueAttribute(@NotNull AnnotationInfo value) {
            if (value == null) {
                AnnotationValueAttribute.$$$reportNull$$$0(0);
            }
            super(null);
            this.value = value;
        }

        public AnnotationValueAttribute(@Nullable String name, @NotNull AnnotationInfo value) {
            if (value == null) {
                AnnotationValueAttribute.$$$reportNull$$$0(1);
            }
            super(name);
            this.value = value;
        }

        @Override
        public String getValueText(SourceLanguage sourceLanguage) {
            String result = this.value.getText(sourceLanguage);
            if (sourceLanguage == SourceLanguage.KOTLIN && result.startsWith("@")) {
                return result.substring(1);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationInfo$AnnotationValueAttribute", "<init>"));
        }
    }

    public static class ClassValueAttribute
    extends AnnotationAttribute {
        private String value;

        public ClassValueAttribute(@NotNull String value) {
            if (value == null) {
                ClassValueAttribute.$$$reportNull$$$0(0);
            }
            super(null);
            this.value = value;
        }

        public ClassValueAttribute(@Nullable String name, @NotNull String value) {
            if (value == null) {
                ClassValueAttribute.$$$reportNull$$$0(1);
            }
            super(name);
            this.value = value;
        }

        @Override
        public String getValueText(SourceLanguage sourceLanguage) {
            if (this.value.endsWith("class")) {
                return this.value;
            }
            if (sourceLanguage == SourceLanguage.KOTLIN) {
                return this.value + "::class";
            }
            return this.value + ".class";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationInfo$ClassValueAttribute", "<init>"));
        }
    }

    public static class RowValueAttribute
    extends AnnotationAttribute {
        private String value;

        public RowValueAttribute(String value) {
            super(null);
            this.value = value;
        }

        public RowValueAttribute(@Nullable String name, String value) {
            super(name);
            this.value = value;
        }

        @Override
        public String getValueText(SourceLanguage sourceLanguage) {
            return String.valueOf(this.value);
        }
    }

    public static class BooleanValueAttribute
    extends AnnotationAttribute {
        private boolean value;

        public BooleanValueAttribute(boolean value) {
            super(null);
            this.value = value;
        }

        public BooleanValueAttribute(@Nullable String name, boolean value) {
            super(name);
            this.value = value;
        }

        @Override
        public String getValueText(SourceLanguage sourceLanguage) {
            return String.valueOf(this.value);
        }
    }

    public static class StringValueAttribute
    extends AnnotationAttribute {
        protected final String value;

        public StringValueAttribute(@NotNull String value) {
            if (value == null) {
                StringValueAttribute.$$$reportNull$$$0(0);
            }
            super(null);
            this.value = value;
        }

        public StringValueAttribute(@Nullable String name, @NotNull String value) {
            if (value == null) {
                StringValueAttribute.$$$reportNull$$$0(1);
            }
            super(name);
            this.value = value;
        }

        @Override
        public String getValueText(SourceLanguage sourceLanguage) {
            return "\"" + this.value + "\"";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationInfo$StringValueAttribute", "<init>"));
        }
    }
}

