/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSStringLiteralEscaper<T extends PsiLanguageInjectionHost>
extends LiteralTextEscaper<T> {
    private SourceOffsets mySourceOffsets;

    public JSStringLiteralEscaper(T host) {
        super(host);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            JSStringLiteralEscaper.$$$reportNull$$$0(0);
        }
        if (outChars == null) {
            JSStringLiteralEscaper.$$$reportNull$$$0(1);
        }
        String subText = rangeInsideHost.substring(this.myHost.getText());
        SourceOffsets sourceOffsets = new SourceOffsets();
        boolean result = JSStringLiteralEscaper.parseStringCharacters(subText, outChars, sourceOffsets, this.isRegExpLiteral(), !this.isOneLine());
        this.mySourceOffsets = sourceOffsets;
        return result;
    }

    protected abstract boolean isRegExpLiteral();

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result;
        if (rangeInsideHost == null) {
            JSStringLiteralEscaper.$$$reportNull$$$0(2);
        }
        if ((result = this.mySourceOffsets.getOffsetInHost(offsetInDecoded)) == -1) {
            return -1;
        }
        return Math.min(result, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable SourceOffsets outSourceOffsets, boolean regExp, boolean escapeBacktick) {
        if (chars == null) {
            JSStringLiteralEscaper.$$$reportNull$$$0(3);
        }
        if (outChars == null) {
            JSStringLiteralEscaper.$$$reportNull$$$0(4);
        }
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (outSourceOffsets != null) {
                outSourceOffsets.lengthIfNoShifts = chars.length();
            }
            return true;
        }
        int[] sourceOffsets = new int[chars.length() + 1];
        int index = 0;
        int outOffset = outChars.length();
        boolean result = true;
        int iteration = 0;
        block20: while (index < chars.length()) {
            if (iteration++ % 1000 == 0) {
                ProgressManager.checkCanceled();
            }
            char c = chars.charAt(index++);
            sourceOffsets[outChars.length() - outOffset] = index - 1;
            sourceOffsets[outChars.length() + 1 - outOffset] = index;
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                result = false;
                break;
            }
            c = chars.charAt(index++);
            if (escapeBacktick && c == '`') {
                outChars.append(c);
            } else if (regExp) {
                if (c != '/') {
                    outChars.append('\\');
                }
                outChars.append(c);
            } else {
                switch (c) {
                    case 'b': {
                        outChars.append('\b');
                        break;
                    }
                    case 't': {
                        outChars.append('\t');
                        break;
                    }
                    case '\n': 
                    case 'n': {
                        outChars.append('\n');
                        break;
                    }
                    case 'f': {
                        outChars.append('\f');
                        break;
                    }
                    case 'r': {
                        outChars.append('\r');
                        break;
                    }
                    case '\"': {
                        outChars.append('\"');
                        break;
                    }
                    case '/': {
                        outChars.append('/');
                        break;
                    }
                    case '\'': {
                        outChars.append('\'');
                        break;
                    }
                    case '\\': {
                        outChars.append('\\');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char startC = c;
                        int v2 = c - 48;
                        if (index < chars.length()) {
                            if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                v2 <<= 3;
                                v2 += c - 48;
                                if (startC <= '3' && index < chars.length()) {
                                    if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                        v2 <<= 3;
                                        v2 += c - 48;
                                    }
                                }
                            } else {
                                --index;
                            }
                        }
                        outChars.append((char)v2);
                        break;
                    }
                    case 'x': {
                        int v;
                        if (index + 2 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars, index, index + 2, 16);
                                outChars.append((char)v);
                                index += 2;
                                break;
                            }
                            catch (Exception e) {
                                result = false;
                                break block20;
                            }
                        }
                        result = false;
                        break block20;
                    }
                    case 'u': {
                        int v;
                        int v2;
                        if (index + 3 <= chars.length() && chars.charAt(index) == '{') {
                            int end = chars.indexOf(125, index + 1);
                            if (end < 0) {
                                result = false;
                                break block20;
                            }
                            try {
                                v2 = Integer.parseInt(chars, index + 1, end, 16);
                                c = chars.charAt(index + 1);
                                if (c == '+' || c == '-') {
                                    result = false;
                                    break block20;
                                }
                                outChars.appendCodePoint(v2);
                                index = end + 1;
                                break;
                            }
                            catch (Exception e) {
                                result = false;
                                break block20;
                            }
                        }
                        if (index + 4 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars, index, index + 4, 16);
                                c = chars.charAt(index);
                                if (c == '+' || c == '-') {
                                    result = false;
                                    break block20;
                                }
                                outChars.append((char)v);
                                index += 4;
                                break;
                            }
                            catch (Exception e) {
                                result = false;
                                break block20;
                            }
                        }
                        result = false;
                        break block20;
                    }
                    default: {
                        outChars.append(c);
                    }
                }
            }
            sourceOffsets[outChars.length() - outOffset] = --index;
        }
        sourceOffsets[outChars.length() - outOffset] = chars.length();
        if (outSourceOffsets != null) {
            outSourceOffsets.sourceOffsets = Arrays.copyOf(sourceOffsets, outChars.length() - outOffset + 1);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/psi/impl/JSStringLiteralEscaper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOffsetInHost";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStringCharacters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SourceOffsets {
        public int[] sourceOffsets;
        public int lengthIfNoShifts = -1;

        public int[] toOffsetArray() {
            int[] offsets = this.sourceOffsets;
            return offsets != null ? offsets : IntStream.range(0, this.lengthIfNoShifts + 1).toArray();
        }

        public int getOffsetInHost(int offsetInDecoded) {
            if (this.lengthIfNoShifts >= 0) {
                return offsetInDecoded <= this.lengthIfNoShifts ? offsetInDecoded : -1;
            }
            return offsetInDecoded < this.sourceOffsets.length ? this.sourceOffsets[offsetInDecoded] : -1;
        }
    }
}

