/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CassErrorHandler
extends BaseDatabaseErrorHandler {
    private final Pattern myErrorOffsetPattern = Pattern.compile("line (\\d+):(\\d+)");

    @NotNull
    protected ErrorInfo getErrorInfo(@NotNull Project project, @Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (project == null) {
            CassErrorHandler.$$$reportNull$$$0(0);
        }
        if (original == null) {
            CassErrorHandler.$$$reportNull$$$0(1);
        }
        if (cause == null) {
            CassErrorHandler.$$$reportNull$$$0(2);
        }
        if (CassErrorHandler.findByClassNamePrefix((Throwable)cause, (String)"com.datastax") != null) {
            return new CassNativeErrorInfo(dataSource, original, cause);
        }
        ErrorInfo errorInfo = super.getErrorInfo(project, dataSource, original, cause);
        if (errorInfo == null) {
            CassErrorHandler.$$$reportNull$$$0(3);
        }
        return errorInfo;
    }

    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText) {
        Matcher matcher;
        if (project == null) {
            CassErrorHandler.$$$reportNull$$$0(4);
        }
        if (errorInfo == null) {
            CassErrorHandler.$$$reportNull$$$0(5);
        }
        if (queryText == null) {
            CassErrorHandler.$$$reportNull$$$0(6);
        }
        if (!(matcher = this.myErrorOffsetPattern.matcher(errorInfo.getMessage())).find()) {
            return -1;
        }
        int line = StringUtil.parseInt((String)matcher.group(1), (int)0) - 1;
        int column = StringUtil.parseInt((String)matcher.group(2), (int)-1);
        if (line == -1 || column == -1) {
            return -1;
        }
        return StringUtil.lineColToOffset((CharSequence)queryText, (int)line, (int)column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/cassandra/CassErrorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/cassandra/CassErrorHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class CassNativeErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        CassNativeErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                CassNativeErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                CassNativeErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                CassNativeErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                CassNativeErrorInfo.$$$reportNull$$$0(3);
            }
            CassNativeErrorInfo.appendGenericMessage((Throwable)this.myOriginal, (StringBuilder)sb);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/cassandra/CassErrorHandler$CassNativeErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

