/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.linux;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.OK;
import com.intellij.profiler.linux.VariableValidationResult;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B1\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014R$\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\u0019\u001a\u00070\u0013\u00a2\u0006\u0002\b\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/linux/InfoDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "validationResult", "", "Lcom/intellij/profiler/linux/KernelVariable;", "Lcom/intellij/profiler/linux/VariableValidationResult;", "Lcom/intellij/profiler/linux/AllVariablesValidationResult;", "project", "Lcom/intellij/openapi/project/Project;", "showDoNotAskAgain", "", "<init>", "(Ljava/util/Map;Lcom/intellij/openapi/project/Project;Z)V", "getValidationResult", "()Ljava/util/Map;", "getProject", "()Lcom/intellij/openapi/project/Project;", "echoLines", "", "", "getEchoLines", "()Ljava/util/List;", "profilerName", "getProfilerName", "()Ljava/lang/String;", "infoString", "Lorg/jetbrains/annotations/Nls;", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nKernelVariablesValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelVariablesValidator.kt\ncom/intellij/profiler/linux/InfoDialog\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n504#2,7:159\n1563#3:166\n1634#3,3:167\n*S KotlinDebug\n*F\n+ 1 KernelVariablesValidator.kt\ncom/intellij/profiler/linux/InfoDialog\n*L\n61#1:159,7\n61#1:166\n61#1:167,3\n*E\n"})
class InfoDialog
extends DialogWrapper {
    @NotNull
    private final Map<KernelVariable, VariableValidationResult> validationResult;
    @NotNull
    private final Project project;
    @NotNull
    private final List<String> echoLines;
    @NotNull
    private final String profilerName;
    @Nls
    @NotNull
    private final String infoString;

    /*
     * WARNING - void declaration
     */
    public InfoDialog(@NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult, @NotNull Project project, boolean showDoNotAskAgain) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$filterValues$iv;
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false);
        this.validationResult = validationResult;
        this.project = project;
        Object[] objectArray = this.validationResult;
        InfoDialog infoDialog = this;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            VariableValidationResult it = (VariableValidationResult)entry$iv.getValue();
            boolean bl = false;
            if (!(!(it instanceof OK))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KernelVariable kernelVariable = (KernelVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("echo " + it.getRequiredValue() + " > " + it.getPath());
        }
        infoDialog.echoLines = (List)destination$iv$iv;
        this.profilerName = PlatformUtils.isCidr() ? "Perf" : "async-profiler";
        objectArray = new Object[]{this.profilerName};
        this.infoString = CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.change", objectArray);
        this.setTitle(CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.title", new Object[0]));
        if (showDoNotAskAgain) {
            super.setDoNotAskOption((DoNotAskOption)new DoNotAskOption.Adapter(){

                public String getDoNotShowMessage() {
                    return CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.doNotShow", new Object[0]);
                }

                public void rememberChoice(boolean isSelected, int exitCode) {
                    if (isSelected) {
                        Registry.Companion.get("linux.kernel.variables.validate.every.time").setValue(false);
                    }
                }
            });
        }
        super.setResizable(false);
        super.init();
    }

    public /* synthetic */ InfoDialog(Map map, Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(map, project, bl);
    }

    @NotNull
    protected final Map<KernelVariable, VariableValidationResult> getValidationResult() {
        return this.validationResult;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final List<String> getEchoLines() {
        return this.echoLines;
    }

    @NotNull
    protected final String getProfilerName() {
        return this.profilerName;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JTextArea jTextArea;
        String text = CollectionsKt.joinToString$default((Iterable)this.echoLines, (CharSequence)"\n", null, null, (int)0, null, InfoDialog::createCenterPanel$lambda$0, (int)30, null);
        JTextArea $this$createCenterPanel_u24lambda_u241 = jTextArea = new JTextArea(text);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u241.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        $this$createCenterPanel_u24lambda_u241.setFont(EditorUtil.getEditorFont());
        $this$createCenterPanel_u24lambda_u241.setEditable(false);
        $this$createCenterPanel_u24lambda_u241.setBorder(JBUI.Borders.empty((int)5));
        $this$createCenterPanel_u24lambda_u241.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
        JTextArea textArea = jTextArea;
        return (JComponent)BuilderKt.panel(arg_0 -> InfoDialog.createCenterPanel$lambda$2(this, textArea, arg_0));
    }

    private static final CharSequence createCenterPanel$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "sudo sh -c '" + it + "'";
    }

    private static final Unit createCenterPanel$lambda$2(InfoDialog this$0, JTextArea $textArea, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> InfoDialog.createCenterPanel$lambda$2$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> InfoDialog.createCenterPanel$lambda$2$1($textArea, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, InfoDialog::createCenterPanel$lambda$2$2, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$2$0(InfoDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.infoString);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$2$1(JTextArea $textArea, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$textArea).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$2$2(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.browserLink(CommonProfilerBundleKt.profilerMessage("profiler.documentation.kernel.vars", new Object[0]), "https://www.kernel.org/doc/Documentation/sysctl/kernel.txt");
        return Unit.INSTANCE;
    }
}

