/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.util;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LaTexExport {
    private static final Pattern specialChars = Pattern.compile("[&%$#_{}~^\\\\]");

    public static String escape(String str) {
        StringBuffer escapedString = new StringBuffer();
        Matcher m = specialChars.matcher(str);
        while (m.find()) {
            m.appendReplacement(escapedString, switch (str.charAt(m.start())) {
                case '&' -> "\\\\&";
                case '%' -> "\\\\%";
                case '$' -> "\\\\\\$";
                case '#' -> "\\\\#";
                case '_' -> "\\\\_";
                case '{' -> "\\\\{";
                case '}' -> "\\\\}";
                case '~' -> "\\\\textasciitilde ";
                case '^' -> "\\\\textasciicircum ";
                case '\\' -> "\\\\textbackslash ";
                default -> throw CompilerDirectives.shouldNotReachHere();
            });
        }
        m.appendTail(escapedString);
        return escapedString.toString();
    }
}

